/**************************************************

	64kb Intro Generation Tool
	Base structure

 **************************************************/

//#include <gl\gl.h>
#include <malloc.h>
#include <gl\glaux.h>

#include "base3d.h"


/**************************************************
	Librear memoria de una escena
 **************************************************/
void igtFreeScene(igtScene *Scene)
{

	int i;

	DDEBUG_Write("igtFreeScene: 0x%p", Scene);

	if (Scene->NumObjects > 0)
	{

		for (i=0 ; i<Scene->NumObjects ; i++)
		{
			DDEBUG_Write("Liberando objeto %d (vertices: 0x%p, normales: 0x%p, UV: 0x%p)", i, Scene->Object[i].Vertex,Scene->Object[i].Normal, Scene->Object[i].TexCoord);

			// BUG: Esto hace que pete el editor al liberar memoria!!! Memory leak?...
			if (Scene->Object[i].Vertex != NULL) { free(Scene->Object[i].Vertex); }
			if (Scene->Object[i].Normal != NULL) { free(Scene->Object[i].Normal); }
			if (Scene->Object[i].TexCoord != NULL) { free(Scene->Object[i].TexCoord); }		
		}

		if (Scene->Object != NULL) 
		{ 
			DDEBUG_Write("Liberando array objetos");
			free(Scene->Object); 
		}

		Scene->NumObjects = 0;
	}

	if (Scene->NumCameras > 0) 
	{ 
		if (Scene->Camera != NULL) 
		{ 
			DDEBUG_Write("Liberando array camaras");
			free(Scene->Camera); 
		}

		Scene->NumCameras = 0;
	}

	DDEBUG_Write("igtFreeScene: OK");
}

/**************************************************
	Generadores de objetos
 **************************************************/
void igtGenSphere(igtObject *Obj, float radio, WORD stacks, WORD slices)
{
  
  int i, j, x;
  float sine1, cosine1, sine2, cosine2;
  float *vert, *norm, *tex;

  if (stacks<2) stacks=2;
  if (slices<3) slices=3;

  // Reservamos memoria
  Obj->Vertex = (igtVector3 *)malloc(sizeof(igtVector3));
  Obj->Normal = (igtVector3 *)malloc(sizeof(igtVector3));
  Obj->TexCoord = (igtVector2 *)malloc(sizeof(igtVector2));
  Obj->Faces = (int *)malloc(6*sizeof(int)); // minimo 2 polis (6 vertices/indices)

  long index=0;

  for (i=0; i<stacks+1; i++)
  {
    for (j=0; j<slices+1; j++)
    {

		sine1=sin(M_PI*((float)i/stacks));
		cosine1=cos(M_PI*((float)i/stacks));
		sine2=sin(M_2PI*(float)j/slices);
		cosine2=cos(M_2PI*(float)j/slices);

		/*		
		// Normal
		Obj->Normal[index].x = sine1*sine2;
		Obj->Normal[index].y = sine1*cosine2;
		Obj->Normal[index].z = cosine1;		    
	  
		// UV
		Obj->TexCoord[index].x = j*(1.0/slices);
		Obj->TexCoord[index].y = i*(1.0/stacks);

		// Vertice
		Obj->Vertex[index].x = radio*sine1*sine2;
		Obj->Vertex[index].y = radio*sine1*cosine2;
		Obj->Vertex[index].z = radio*cosine1;
		*/

		// Normal
		Obj->Normal[index].x = sine1*sine2;
		Obj->Normal[index].y = cosine1;
		Obj->Normal[index].z = sine1*cosine2;		    
	  
		// UV
		Obj->TexCoord[index].x = j*(1.0/slices);
		Obj->TexCoord[index].y = i*(1.0/stacks);

		// Vertice
		Obj->Vertex[index].x = radio*sine1*sine2;
		Obj->Vertex[index].y = radio*cosine1;
		Obj->Vertex[index].z = radio*sine1*cosine2;

		// Incrementos y memoria
		index++;

		Obj->Vertex = (igtVector3 *)realloc(Obj->Vertex, (index+1)*sizeof(igtVector3));
		Obj->Normal = (igtVector3 *)realloc(Obj->Normal, (index+1)*sizeof(igtVector3));
		Obj->TexCoord = (igtVector2 *)realloc(Obj->TexCoord, (index+1)*sizeof(igtVector2));
    }
  }

  Obj->NumVertex = index; // Numero total de vertices (es el mismo numero para coords UV y normales)


	// Facetas
	index=0;	
	for (i=0; i<stacks; i++)
	{
		for (j=0; j<slices; j++)
		{

			x=6*(i*slices+j);

			Obj->Faces[x  ] = i*(slices+1)+j;
			Obj->Faces[x+1] = i*(slices+1)+j+1;
			Obj->Faces[x+2] = (i+1)*(slices+1)+j;
			Obj->Faces[x+5] = (i+1)*(slices+1)+j;
			Obj->Faces[x+3] = i*(slices+1)+j+1;
			Obj->Faces[x+4] = (i+1)*(slices+1)+j+1;

			index += 6;
			Obj->Faces = (int *)realloc(Obj->Faces, (index*2)*sizeof(int));

		}
	}

	Obj->NumFaces = index;	

}

void igtGenTorus(igtObject *Obj, double a, double c, WORD slices, WORD stacks)
{

  int i, j, x, y;
  double sine1, cosine1, sine2, cosine2;
  double *vert, *tex, *norm;

  if (slices<3) slices=3;
  if (stacks<3) stacks=3;

  // Reservamos memoria
  Obj->Vertex = (igtVector3 *)malloc(sizeof(igtVector3));
  Obj->Normal = (igtVector3 *)malloc(sizeof(igtVector3));
  Obj->TexCoord = (igtVector2 *)malloc(sizeof(igtVector2));
  Obj->Faces = (int *)malloc(6*sizeof(int)); // minimo 2 polis (6 vertices/indices)

  long index=0;

  for (i=0; i<stacks+1; i++)
  {
    for (j=0; j<slices+1; j++)
    {
		sine1=sin(M_2PI*(double)i/stacks);
		cosine1=cos(M_2PI*(double)i/stacks);
		sine2=sin(M_2PI*(double)j/slices);
		cosine2=cos(M_2PI*(double)j/slices);

		// Normal
		Obj->Normal[index].x = sine2*cosine1;
		Obj->Normal[index].y = sine2*sine1;
		Obj->Normal[index].z = cosine2;		    

		// UV
		Obj->TexCoord[index].x = j*(1.0/slices);
		Obj->TexCoord[index].y = i*(1.0/stacks);

		// Vertice
		Obj->Vertex[index].x = (a+c*sine2)*cosine1;
		Obj->Vertex[index].y = (a+c*sine2)*sine1;
		Obj->Vertex[index].z = c*cosine2;

		// Incrementos y memoria
		index++;

		Obj->Vertex = (igtVector3 *)realloc(Obj->Vertex, (index+1)*sizeof(igtVector3));
		Obj->Normal = (igtVector3 *)realloc(Obj->Normal, (index+1)*sizeof(igtVector3));
		Obj->TexCoord = (igtVector2 *)realloc(Obj->TexCoord, (index+1)*sizeof(igtVector2));

    }
  }

  Obj->NumVertex = index; // Numero total de vertices (es el mismo numero para coords UV y normales)

  index=0;
	for (y=0; y<stacks; y++)
	{
	  for (x=0; x<slices; x++)
	  {
		i=6*(y*slices+x);
		Obj->Faces[i  ] = y*(slices+1)+x;
		Obj->Faces[i+1] = y*(slices+1)+x+1;
		Obj->Faces[i+2] = (y+1)*(slices+1)+x;
		Obj->Faces[i+5] = (y+1)*(slices+1)+x;
		Obj->Faces[i+3] = y*(slices+1)+x+1;
		Obj->Faces[i+4] = (y+1)*(slices+1)+x+1;

		index += 6;
		Obj->Faces = (int *)realloc(Obj->Faces, (index*2)*sizeof(int));
	  }
	}

	Obj->NumFaces = index;	

}

void igtGenCone(igtObject *Obj, double radio, double alto, WORD stacks, WORD slices)
{
  double nk;
  int x, y, i;
  double sine, cosine;

  if (stacks<1) stacks=1;
  if (slices<3) slices=3;

  nk=alto/sqrt(alto*alto+radio*radio);

  // Reservamos memoria
  Obj->Vertex = (igtVector3 *)malloc(sizeof(igtVector3));
  Obj->Normal = (igtVector3 *)malloc(sizeof(igtVector3));
  Obj->TexCoord = (igtVector2 *)malloc(sizeof(igtVector2));
  Obj->Faces = (int *)malloc(6*sizeof(int)); // minimo 2 polis (6 vertices/indices)

  long index=0;

  for (y=0; y<stacks+1; y++)
  {
    for (x=0; x<slices+1; x++)
    {
      sine = sin(M_2PI*(double)x/slices);
      cosine = cos(M_2PI*(double)x/slices);

	  /*
		// Normal
		Obj->Normal[index].x = sine*nk;
		Obj->Normal[index].y = sine*nk;
		Obj->Normal[index].z = nk;
	  */

		// Normal
		Obj->Normal[index].x = sine*nk;
		Obj->Normal[index].y = nk;
		Obj->Normal[index].z = sine*nk;

		// UV
		Obj->TexCoord[index].x = x*(1.0/slices);
		Obj->TexCoord[index].y = y*(1.0/stacks);
/*
		// Vertice
		Obj->Vertex[index].x = (1.0-(double)y/stacks)*(radio*cosine);
		Obj->Vertex[index].y = (1.0-(double)y/stacks)*(radio*sine);
		Obj->Vertex[index].z = -(alto/2)+y*(alto/stacks);
*/

		// Vertice
		Obj->Vertex[index].x = (1.0-(double)y/stacks)*(radio*cosine);
		Obj->Vertex[index].y = -(alto/2)+y*(alto/stacks);
		Obj->Vertex[index].z = (1.0-(double)y/stacks)*(radio*sine);

		// Incrementos y memoria
		index++;

		Obj->Vertex = (igtVector3 *)realloc(Obj->Vertex, (index+1)*sizeof(igtVector3));
		Obj->Normal = (igtVector3 *)realloc(Obj->Normal, (index+1)*sizeof(igtVector3));
		Obj->TexCoord = (igtVector2 *)realloc(Obj->TexCoord, (index+1)*sizeof(igtVector2));

    }
  }

  Obj->NumVertex = index; // Numero total de vertices (es el mismo numero para coords UV y normales)


  index=0;
    for (y=0; y<stacks; y++)
    {
      for (x=0; x<slices; x++)
      {
        i=6*(y*slices+x);

        Obj->Faces[i  ] = y*(slices+1)+x;
        Obj->Faces[i+1] = y*(slices+1)+x+1;
        Obj->Faces[i+2] = (y+1)*(slices+1)+x;
        Obj->Faces[i+5] = (y+1)*(slices+1)+x;
		Obj->Faces[i+3] = y*(slices+1)+x+1;
        Obj->Faces[i+4] = (y+1)*(slices+1)+x+1;

		index += 6;
		Obj->Faces = (int *)realloc(Obj->Faces, (index*2)*sizeof(int));
      }
    }

	Obj->NumFaces = index;	

}

void igtGenDisc(igtObject *Obj, double radio, WORD slices)
{
	/* BUG BUG BUG BUG BUG BUG BUG BUG BUG BUG BUG BUG 
  double sine, cosine;
  int i, j;

  if (slices<3) slices=3;

  // Reservamos memoria
  Obj->Vertex = (igtVector3 *)malloc(sizeof(igtVector3));
  Obj->Normal = (igtVector3 *)malloc(sizeof(igtVector3));
  Obj->TexCoord = (igtVector2 *)malloc(sizeof(igtVector2));
  Obj->Faces = (int *)malloc(6*sizeof(int)); // minimo 2 polis (6 vertices/indices)

  long index=0;
  int vertices=0;

  FILE *out = fopen("disc.txt", "w+");

	fprintf(out, "Disco\n");

  for (i=0; i<slices; i++)
  {
    sine=sin(M_2PI*(double)i/slices);
    cosine=cos(M_2PI*(double)i/slices);

	// UV
	Obj->TexCoord[index].x = 0.5*sine+0.5;
	Obj->TexCoord[index].y = 0.5*cosine+0.5;

	fprintf(out, "UV:\n");

	// Vertice
	Obj->Vertex[index].x = radio*sine;
	Obj->Vertex[index].y = radio*cosine;
	Obj->Vertex[index].z = 0;

	fprintf(out, "Vertice:\n");

	// Incrementos y memoria
	index++;
	vertices++;

	Obj->Vertex = (igtVector3 *)realloc(Obj->Vertex, (index+1)*sizeof(igtVector3));	
	Obj->TexCoord = (igtVector2 *)realloc(Obj->TexCoord, (index+1)*sizeof(igtVector2));

	fflush(out);

  }

  Obj->NumVertex = index; // Numero total de vertices (es el mismo numero para coords UV y normales)

  fprintf(out, "fix1\n");

  // Vertice central
  Obj->Vertex[0].x = 0;
  Obj->Vertex[0].y = 0;
  Obj->Vertex[0].z = 0;

  fprintf(out, "fix2\n");
  // UV centrales
  Obj->TexCoord[0].x = 0.5;
  Obj->TexCoord[1].y = 0.5;

  fprintf(out, "normales\n");

	// Normales
	for (i=0 ; i<vertices+1; i++)
	{
		Obj->Normal[index].x = 0;
		Obj->Normal[index].y = 0;
		Obj->Normal[index].z = 1;

		Obj->Normal = (igtVector3 *)realloc(Obj->Normal, (i+1)*sizeof(igtVector3));
	}


	// Facetas
	index=0;
	for (i=0; i<slices; i++)
	{
		j=3*i;

		Obj->Faces[j] = i+1;

		if (i==slices-1)
		{
			Obj->Faces[j] = 0;
		}

		Obj->Faces[j+1] = i;
		Obj->Faces[j+2] = vertices-1;

		index+=3;
		Obj->Faces = (int *)realloc(Obj->Faces, (index)*sizeof(int));
	}

	Obj->NumFaces = index;

	fclose(out);
*/
}

void igtGenCylinder(igtObject *Obj, double radio, double altura, WORD stacks, WORD slices)
{
  int i, x, y;
  double sine, cosine;

  if (stacks<1) stacks=1;
  if (slices<3) slices=3;

  // Reservamos memoria
  Obj->Vertex = (igtVector3 *)malloc(sizeof(igtVector3));
  Obj->Normal = (igtVector3 *)malloc(sizeof(igtVector3));
  Obj->TexCoord = (igtVector2 *)malloc(sizeof(igtVector2));
  Obj->Faces = (int *)malloc(6*sizeof(int)); // minimo 2 polis (6 vertices/indices)

  long index=0;

  for (y=0; y<stacks+1 ; y++)
  {
    for (x=0 ; x<slices+1 ; x++)
    {
		sine = sin(M_2PI*(double)x/slices);
		cosine = cos(M_2PI*(double)x/slices);

		// Normal
		Obj->Normal[index].x = sine;
		Obj->Normal[index].y = 0;
		Obj->Normal[index].z = cosine;

		// UV
		Obj->TexCoord[index].x = x*(1.0/slices);
		Obj->TexCoord[index].y = y*(1.0/stacks);

		// Vertice
		Obj->Vertex[index].x = radio*sine;
		Obj->Vertex[index].y = -(altura/2)+y*(altura/stacks);
		Obj->Vertex[index].z = radio*cosine;

		// Incrementos y memoria
		index++;

		Obj->Vertex = (igtVector3 *)realloc(Obj->Vertex, (index+1)*sizeof(igtVector3));
		Obj->Normal = (igtVector3 *)realloc(Obj->Normal, (index+1)*sizeof(igtVector3));
		Obj->TexCoord = (igtVector2 *)realloc(Obj->TexCoord, (index+1)*sizeof(igtVector2));

    }
  }

  Obj->NumVertex = index; // Numero total de vertices (es el mismo numero para coords UV y normales)


  index=0;
    for (y=0; y<stacks; y++)
    {
      for (x=0; x<slices; x++)
      {
        i=6*(y*slices+x);

        Obj->Faces[i  ] = y*(slices+1)+x;
        Obj->Faces[i+1] = y*(slices+1)+x+1;
        Obj->Faces[i+2] = (y+1)*(slices+1)+x;
        Obj->Faces[i+5] = (y+1)*(slices+1)+x;
		Obj->Faces[i+3] = y*(slices+1)+x+1;
        Obj->Faces[i+4] = (y+1)*(slices+1)+x+1;

		index += 6;
		Obj->Faces = (int *)realloc(Obj->Faces, (index*2)*sizeof(int));
      }
    }

	Obj->NumFaces = index;	
  
}

void igtGenCube(igtObject *Obj, double ancho, double alto, double largo)
{
  int i, x, y;
  double sine, cosine;

  // Reservamos memoria
  Obj->Vertex = (igtVector3 *)malloc(sizeof(igtVector3)*8);
  Obj->Normal = (igtVector3 *)malloc(sizeof(igtVector3)*12);
  Obj->TexCoord = (igtVector2 *)malloc(sizeof(igtVector2)*36);
  Obj->Faces = (int *)malloc(12*sizeof(int)); // minimo 2 polis (6 vertices/indices)

  Obj->NumVertex = 12;

  // 4 superiores
  Obj->TexCoord[0].x = 0;
  Obj->TexCoord[0].y = 0;
  Obj->Vertex[0].x = -1;
  Obj->Vertex[0].y = -1;
  Obj->Vertex[0].z = -1;

  Obj->TexCoord[1].x = 1;
  Obj->TexCoord[1].y = 0;
  Obj->Vertex[1].x = 1;
  Obj->Vertex[1].y = -1;
  Obj->Vertex[1].z = -1;

  Obj->TexCoord[2].x = 0;
  Obj->TexCoord[2].y = 0;
  Obj->Vertex[2].x = -1;
  Obj->Vertex[2].y = -1;
  Obj->Vertex[2].z = 1;

  Obj->TexCoord[3].x = 1;
  Obj->TexCoord[3].y = 0;
  Obj->Vertex[3].x = 1;
  Obj->Vertex[3].y = -1;
  Obj->Vertex[3].z = 1;

  // 4 inferiores
  Obj->TexCoord[4].x = 0;
  Obj->TexCoord[4].y = 1;
  Obj->Vertex[4].x = -1;
  Obj->Vertex[4].y = 1;
  Obj->Vertex[4].z = -1;

  Obj->TexCoord[5].x = 1;
  Obj->TexCoord[5].y = 1;
  Obj->Vertex[5].x = 1;
  Obj->Vertex[5].y = 1;
  Obj->Vertex[5].z = -1;

  Obj->TexCoord[6].x = 0;
  Obj->TexCoord[6].y = 1;
  Obj->Vertex[6].x = -1;
  Obj->Vertex[6].y = 1;
  Obj->Vertex[6].z = 1;

  Obj->TexCoord[7].x = 1;
  Obj->TexCoord[7].y = 1;
  Obj->Vertex[7].x = 1;
  Obj->Vertex[7].y = 1;
  Obj->Vertex[7].z = 1;

  // *** Facetas
  Obj->NumFaces = 12;

  Obj->Faces[ 0] = 0; // Delante
  Obj->Faces[ 1] = 4;
  Obj->Faces[ 2] = 5;

  Obj->Faces[ 3] = 0;
  Obj->Faces[ 4] = 5;
  Obj->Faces[ 5] = 1;

  Obj->Faces[ 6] = 1; // Derecha
  Obj->Faces[ 7] = 5;
  Obj->Faces[ 8] = 6;

  Obj->Faces[ 9] = 1;
  Obj->Faces[10] = 6;
  Obj->Faces[11] = 2;

  Obj->Faces[12] = 1; // Detras
  Obj->Faces[13] = 5;
  Obj->Faces[14] = 6;

  Obj->Faces[15] = 1;
  Obj->Faces[16] = 6;
  Obj->Faces[17] = 2;

}

/**************************************************
	Generacion de escena
 **************************************************/

bool igtReallocObjectMemory(igtScene *Scene)
{

	DDEBUG_Write("igtReallocObjectMemory: 0x%p (%ld bytes)", Scene, (Scene->NumObjects+1)*sizeof(igtObject));

	if (!Scene->NumObjects)
	{		
		Scene->NumObjects=1;
		if ( (Scene->Object = (igtObject *)malloc(sizeof(igtObject))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}
	else
	{
		Scene->NumObjects++;
		if ( (Scene->Object = (igtObject *)realloc(Scene->Object, Scene->NumObjects*sizeof(igtObject))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}

	DDEBUG_Write("igtReallocObjectMemory: OK");

	return false;
}

bool igtReallocCameraMemory(igtScene *Scene)
{

	DDEBUG_Write("igtReallocCameraMemory: 0x%p", Scene);

	if (!Scene->NumCameras)
	{		
		DDEBUG_Write("igtReallocCameraMemory: primera camara");
		Scene->NumCameras=1;
		if ( (Scene->Camera = (igtCamera *)malloc(sizeof(igtCamera))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}
	else
	{
		DDEBUG_Write("igtReallocCameraMemory: camara %d", Scene->NumCameras);
		Scene->NumCameras++;
		if ( (Scene->Camera = (igtCamera *)realloc(Scene->Camera, Scene->NumCameras*sizeof(igtCamera))) == NULL)
		{
			MessageBox(GetForegroundWindow(), "No memory!", "IGT", MB_OK);
			return false;
		}
	}

	DDEBUG_Write("igtReallocCameraMemory: OK");

	return false;
}

bool igtAddSphere(igtScene *Scene, float radio, char segmentos_alto, char segmentos_ancho)
{

	DDEBUG_Write("igtAddSphere:");

	igtReallocObjectMemory(Scene);
	igtGenSphere(&Scene->Object[Scene->NumObjects-1], radio, segmentos_alto, segmentos_ancho);
	
	Scene->Object[Scene->NumObjects-1].Posicion.x = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.y = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.z = 0;

	Scene->Object[Scene->NumObjects-1].Rotacion.x = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.y = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.z = 0;

	Scene->Object[Scene->NumObjects-1].type = IGT_OBJTYPE_SPHERE;
	
	DDEBUG_Write("igtAddSphere: OK - Objetos: %d", Scene->NumObjects);

	return true;

}

bool igtRegenerateSphere(igtScene *Scene, int ObjIndex, float radio, char segmentos_alto, char segmentos_ancho)
{	

	// Reseteamos el objeto
	free(Scene->Object[ObjIndex].Normal);
	free(Scene->Object[ObjIndex].TexCoord);	
	free(Scene->Object[ObjIndex].Vertex);	

	// Volvemos a generar el objeto con lo snuevos parametros
	igtGenSphere(&Scene->Object[ObjIndex], radio, segmentos_alto, segmentos_ancho);	

	return true;

}

bool igtAddTorus(igtScene *Scene, float radio_interior, float radio_exterior, char segmentos_alto, char segmentos_ancho)
{

	igtReallocObjectMemory(Scene);	
	igtGenTorus(&Scene->Object[Scene->NumObjects-1], radio_interior, radio_exterior, segmentos_alto, segmentos_ancho);

	Scene->Object[Scene->NumObjects-1].Posicion.x = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.y = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.z = 0;

	Scene->Object[Scene->NumObjects-1].Rotacion.x = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.y = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.z = 0;

	Scene->Object[Scene->NumObjects-1].type = IGT_OBJTYPE_TORUS;

	return true;

}

bool igtRegenerateTorus(igtScene *Scene, int ObjIndex, float radio_interior, float radio_exterior, char segmentos_alto, char segmentos_ancho)
{	

	// Reseteamos el objeto
	free(Scene->Object[ObjIndex].Normal);
	free(Scene->Object[ObjIndex].TexCoord);	
	free(Scene->Object[ObjIndex].Vertex);	

	// Volvemos a generar el objeto con lo snuevos parametros
	igtGenTorus(&Scene->Object[Scene->NumObjects-1], radio_interior, radio_exterior, segmentos_alto, segmentos_ancho);	

	return true;

}

bool igtAddCone(igtScene *Scene, float radio, float alto, char segmentos_alto, char segmentos_ancho)
{

	igtReallocObjectMemory(Scene);		
	igtGenCone(&Scene->Object[Scene->NumObjects-1], radio, alto, segmentos_alto, segmentos_ancho);

	Scene->Object[Scene->NumObjects-1].Posicion.x = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.y = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.z = 0;

	Scene->Object[Scene->NumObjects-1].Rotacion.x = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.y = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.z = 0;

	Scene->Object[Scene->NumObjects-1].type = IGT_OBJTYPE_CONE;

	return true;

}

bool igtRegenerateCone(igtScene *Scene, int ObjIndex, float radio, float alto, char segmentos_alto, char segmentos_ancho)
{	

	// Reseteamos el objeto
	free(Scene->Object[ObjIndex].Normal);
	free(Scene->Object[ObjIndex].TexCoord);	
	free(Scene->Object[ObjIndex].Vertex);	

	// Volvemos a generar el objeto con lo snuevos parametros	
	igtGenCone(&Scene->Object[Scene->NumObjects-1], radio, alto, segmentos_alto, segmentos_ancho);

	return true;

}

bool igtAddDisc(igtScene *Scene, float radio, char lonchas)
{

	igtReallocObjectMemory(Scene);		
	igtGenDisc(&Scene->Object[Scene->NumObjects-1], radio, lonchas);

	Scene->Object[Scene->NumObjects-1].Posicion.x = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.y = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.z = 0;

	Scene->Object[Scene->NumObjects-1].Rotacion.x = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.y = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.z = 0;

	Scene->Object[Scene->NumObjects-1].type = IGT_OBJTYPE_DISC;

	return true;

}

bool igtAddCylinder(igtScene *Scene, float radio, float alto, char segmentos_alto, char segmentos_ancho)
{

	igtReallocObjectMemory(Scene);		
	igtGenCylinder(&Scene->Object[Scene->NumObjects-1], radio, alto, segmentos_alto, segmentos_ancho);

	Scene->Object[Scene->NumObjects-1].Posicion.x = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.y = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.z = 0;

	Scene->Object[Scene->NumObjects-1].Rotacion.x = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.y = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.z = 0;

	Scene->Object[Scene->NumObjects-1].type = IGT_OBJTYPE_CYLINDER;

	return true;

}

bool igtRegenerateCylinder(igtScene *Scene, int ObjIndex, float radio, float alto, char segmentos_alto, char segmentos_ancho)
{	

	// Reseteamos el objeto
	free(Scene->Object[ObjIndex].Normal);
	free(Scene->Object[ObjIndex].TexCoord);	
	free(Scene->Object[ObjIndex].Vertex);	

	// Volvemos a generar el objeto con lo snuevos parametros	
	igtGenCylinder(&Scene->Object[Scene->NumObjects-1], radio, alto, segmentos_alto, segmentos_ancho);

	return true;

}

bool igtAddCube(igtScene *Scene, float ancho, float alto, char largo)
{

	igtReallocObjectMemory(Scene);		
	igtGenCube(&Scene->Object[Scene->NumObjects-1], ancho, alto, largo);

	Scene->Object[Scene->NumObjects-1].Posicion.x = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.y = 0;
	Scene->Object[Scene->NumObjects-1].Posicion.z = 0;

	Scene->Object[Scene->NumObjects-1].Rotacion.x = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.y = 0;
	Scene->Object[Scene->NumObjects-1].Rotacion.z = 0;

	Scene->Object[Scene->NumObjects-1].type = IGT_OBJTYPE_CUBE;

	return true;

}

bool igtAddCamera(igtScene *Scene, igtVector3 Position, igtVector3 Target)
{

	DDEBUG_Write("igtAddCamera");
	
	igtReallocCameraMemory(Scene);

	DDEBUG_Write("Camera Position: %f, %f, %f", Position.x, Position.y, Position.z);
	Scene->Camera[Scene->NumCameras-1].Position.x = Position.x;
	Scene->Camera[Scene->NumCameras-1].Position.y = Position.y;
	Scene->Camera[Scene->NumCameras-1].Position.z = Position.z;

	DDEBUG_Write("Camera Target: %f, %f, %f", Target.x, Target.y, Target.z);
	Scene->Camera[Scene->NumCameras-1].Target.x = Target.x;
	Scene->Camera[Scene->NumCameras-1].Target.y = Target.y;
	Scene->Camera[Scene->NumCameras-1].Target.z = Target.z;

	return true;

}

// Manejo de la clase spline
CSpline::CSpline()	// Constructor
{
	numKeys=0;
	curvePoints=0;

	key = NULL;
	curve = NULL;
}

CSpline::~CSpline() // Destructor
{

	if (numKeys) { free(key); }
	if (curvePoints) { free(curve); }

}

int CSpline::GetCurveCount()
{
	return curvePoints;
}

int CSpline::GetKeyCount()
{
	return numKeys;
}

igtKeyframe3 CSpline::GetKey(int index)
{
	igtKeyframe3	k;

	if (index > numKeys)
	{
		k.time = 0;
		k.v.x = 0; k.v.y = 0; k.v.z = 0;
		return k;
	}

	return key[index];
}

igtVector3 CSpline::GetCurve(int index)
{
	igtVector3 v;

	if (index > curvePoints) 
	{  
		v.x = 0; v.y = 0; v.z = 0;
		return v;
	}

	return curve[index].v;
}

bool CSpline::AddKey(DWORD uTime, igtVector3 p)
{
	if (numKeys == 0)
	{
		numKeys=1;
		key = (igtKeyframe3 *)malloc(sizeof(igtKeyframe3));
		if (key == NULL) { return false; }
	}
	else
	{
		numKeys++;
		key = (igtKeyframe3 *)realloc(key, numKeys*sizeof(igtKeyframe3));
		if (key == NULL) { return false; }
	}

	key[numKeys-1].time = uTime;
	key[numKeys-1].v = p;

	DDEBUG_Write("Add key: %d: %f %f %f", key[numKeys-1].time, key[numKeys-1].v.x, key[numKeys-1].v.y, key[numKeys-1].v.z);

	return true;
}

void CSpline::ModifyKey(DWORD uTime, igtVector3 v)
{
	// Find the key
	for (int i=0 ; i<numKeys ; i++)
	{
		if (key[i].time == uTime)
		{
			key[i].v = v;
			DDEBUG_Write("Modify key: %d: %f %f %f", uTime, v.x, v.y, v.z);
		}
	}
}

int CSpline::GenerateCurve(int DivFactor)
{

	if (curvePoints) { free(curve); }

	curvePoints = numKeys*DivFactor;	
	curve = (igtKeyframe3 *)malloc(curvePoints*sizeof(igtKeyframe3));
/*
	for (int h=0 ; h<numKeys ; h++)
	{
		DDEBUG_Write("keys.x: %f", key[h].x);
	}
*/
	int c=0;
	for (int i=0 ; i<(numKeys-1) ; i++)
	{
		for (int n=0 ; n<DivFactor ; n++)
		{
			curve[c].v.x = Interpolate((float)key[i].v.x, (float)key[i+1].v.x, (float)n/DivFactor);
			curve[c].v.y = Interpolate(key[i].v.y, key[i+1].v.y, (float)n/DivFactor);
			curve[c].v.z = Interpolate(key[i].v.z, key[i+1].v.z, (float)n/DivFactor);

			//DDEBUG_Write("curve.x: %f", curve[c].x);

			c++;
		}
	}

	return 0;
}

float CSpline::Interpolate(float a, float b, float x)
{
	return  (float)a*(1-x) + (b*x); // Linear
}
