import java.io.*;
import java.util.*;
import java.awt.*;

public class TransObj {

  public static class Point3D {
	float x,y,z;
	Point3D(float x,float y,float z) {
		this.x = x;
		this.y = y;
		this.z = z;
	}
  }

  public static Vector faces = new Vector();
  public static Vector vertices = new Vector();
  public static String path;
  public static String tx[] = null;
  private static Hashtable textures = new Hashtable();
  public static Hashtable colors = new Hashtable();
  public static Vector colset = new Vector();

  public static void main(String args[]) throws Exception {
    if (args[0].endsWith(".obj")) fromWaveFront(args[0]);
    if (args[0].endsWith(".rsd")) fromRSD(args[0]);
    float zoom = args.length>2 ? Float.valueOf(args[2]).floatValue():1f;
    String ptype = args.length>3 ? args[3] : "F";
    String ltype = args.length>4 ? args[4] : "";
    save(args[1],zoom,ptype,ltype);
  }

  public static void fromWaveFront(String fname) throws Exception {
      colset.addElement(Color.red);
      colset.addElement(Color.green);
      colset.addElement(Color.blue);
      colset.addElement(Color.yellow);
      colset.addElement(Color.cyan);
      colset.addElement(Color.magenta);
      colset.addElement(Color.orange);
      colset.addElement(Color.white);
      Reader r = new BufferedReader(new FileReader(fname));
      StreamTokenizer st = new StreamTokenizer(r);
      st.eolIsSignificant(true);
      st.commentChar('#');
      Integer curColor = null;
scan:
      while (true) {
          switch (st.nextToken()) {
            default:
              break scan;
            case StreamTokenizer.TT_EOL:
              break;
            case StreamTokenizer.TT_WORD:
              if ("v".equals(st.sval)) {
                 double x = 0, y = 0, z = 0;
                 if (st.nextToken() == StreamTokenizer.TT_NUMBER) {
                    x = st.nval;
                    if (st.nextToken() == StreamTokenizer.TT_NUMBER) {
                       y = st.nval;
                       if (st.nextToken() == StreamTokenizer.TT_NUMBER)
                          z = st.nval;
                    }
                 }
                 vertices.add(new TransObj.Point3D((float)x,(float)y,(float)z));
                 while (st.ttype != StreamTokenizer.TT_EOL && st.ttype != StreamTokenizer.TT_EOF)
                   st.nextToken();
              } else if ("f".equals(st.sval) || "fo".equals(st.sval) || "l".equals(st.sval)) {
                 Vector face = new Vector();
                 while (true) {
                     if (st.nextToken() == StreamTokenizer.TT_NUMBER) {
                        face.insertElementAt(new Integer(((int) st.nval)-1),0);
                     } else if (st.ttype == '/') st.nextToken();
                     else break;
                 }
                 face.addElement(curColor);
                 faces.addElement(face);
                 if (st.ttype != StreamTokenizer.TT_EOL)
                    break scan;
                 } else if ("g".equals(st.sval)) {
                     while (st.nextToken() != StreamTokenizer.TT_EOL && st.ttype != StreamTokenizer.TT_EOF && st.ttype != StreamTokenizer.TT_NUMBER) ;
                     if (st.ttype == StreamTokenizer.TT_NUMBER) {
                        curColor=new Integer((int)st.nval);
                     }
                 } else {
                    while (st.nextToken() != StreamTokenizer.TT_EOL && st.ttype != StreamTokenizer.TT_EOF);
                 }
          }
      }
      r.close();
      if (st.ttype != StreamTokenizer.TT_EOF) throw new IOException(st.toString());
  }

  public static void fromRSD(String fileName) {
    fromRSD(new File(fileName));
  }

  public static void fromRSD(File file) {
    try {
       String s = file.getAbsolutePath();
       setWorkDir(s.substring(0,s.lastIndexOf(File.separator)+1));
       fromRSD(new FileInputStream(file));
    } catch(Exception e) { e.printStackTrace(); }
  }

  public static void setWorkDir(String path) {
    TransObj.path = path;
  }

  public static void fromRSD(InputStream is) throws Exception {
    LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
    String l,ply=null,mat = null;
    while ((l=lnr.readLine())!=null) {
        l = l.trim();
        if (l.startsWith("PLY=")) {
           ply = l.substring(4);
        } else if (l.startsWith("MAT=")) {
           mat = l.substring(4);
        } else if (l.startsWith("GRP=")) {
        } else if (l.startsWith("NTEX=")) {
           int nbt = Integer.valueOf(l.substring(5)).intValue();
           if (nbt>0) tx = new String[nbt];
        } else if (l.startsWith("TEX[")) {
           String tim = l.substring(l.indexOf("=")+1);
           tx[Integer.valueOf(l.substring(4,l.indexOf("]"))).intValue()] = tim.substring(0,tim.indexOf(".")).toLowerCase();
        }
    }
    is.close();
    loadMat(new FileInputStream(new File(path+mat)));
    loadPly(new FileInputStream(new File(path+ply)));
  }

  public static String readString(InputStream is) throws Exception {
    StringBuffer sb = new StringBuffer();
    int c;
    while ((c=is.read())!=-1) sb.append((char)c);
    return sb.toString();
  }

  public static void loadMat(InputStream is) throws IOException {
    LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
    String line;
    boolean first=true;
    int nmat = 0, nm = 0;
    while ((line = lnr.readLine())!=null) {
        if (line.startsWith("#")||line.startsWith("@")) continue;
        StringTokenizer st = new StringTokenizer(line);
        if (first) {
           nmat = Integer.valueOf(st.nextElement().toString()).intValue();
           first = false;
           continue;
        }
        if (nm < nmat) {
           String num = st.nextElement().toString();
           int flag = Integer.valueOf(st.nextElement().toString()).intValue();
           char shading = st.nextElement().toString().charAt(0);
           char type = st.nextElement().toString().charAt(0);
           if (type=='C') {
              int r = Integer.valueOf(st.nextElement().toString()).intValue();
              int g = Integer.valueOf(st.nextElement().toString()).intValue();
              int b = Integer.valueOf(st.nextElement().toString()).intValue();
              Color c = new Color(r,g,b);
              if (!colset.contains(c))
                 colset.addElement(c);
              colors.put(num,new Integer(colset.indexOf(c)));
           } else {
              Vector v = new Vector();
              v.addElement(st.nextElement().toString()); // num image
              while (st.hasMoreElements())
                  v.addElement(Integer.valueOf(st.nextElement().toString())); // u,v
              textures.put(num,v);
           }
           nm++;
        }
    }
  }

  public static void loadPly(InputStream is) throws IOException {
    LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
    int numCol = 1,nv = 0,np = 0, nn = 0,nvert = 0,npoly = 0,nnorm = 0;
    boolean first=true;
    String line;
    while ((line = lnr.readLine())!=null) {
        if (line.startsWith("#")||line.startsWith("@")) continue;
        StringTokenizer st = new StringTokenizer(line);
        if (first) {
           nvert = Integer.valueOf(st.nextElement().toString()).intValue();
           nnorm = Integer.valueOf(st.nextElement().toString()).intValue();
           npoly = Integer.valueOf(st.nextElement().toString()).intValue();
           first = false;
        } else if (nv < nvert) {
           double x = Double.valueOf(st.nextElement().toString()).doubleValue();
           double y = Double.valueOf(st.nextElement().toString()).doubleValue();
           double z = Double.valueOf(st.nextElement().toString()).doubleValue();
           vertices.add(new Point3D((float)x,(float)y,(float)z));
           nv++;
        } else if (nn < nnorm) {
           nn++;
        } else if (np < npoly) {
           int flag = Integer.valueOf(st.nextElement().toString()).intValue();
           int p1 = Integer.valueOf(st.nextElement().toString()).intValue();
           int p2 = Integer.valueOf(st.nextElement().toString()).intValue();
           int p3 = Integer.valueOf(st.nextElement().toString()).intValue();
           int p4 = Integer.valueOf(st.nextElement().toString()).intValue();
           Vector face = new Vector();
           face.add(new Integer(p1));
           face.add(new Integer(p2));
           face.add(new Integer(p3));
           if (flag==1) face.add(new Integer(p4));
           faces.add(face);
           np++;
       }
    }
    is.close();
  }

  public static void save(String out,float zoom,String ptype,String ltype) throws Exception {
      //**************
      //* Write to .c
      //**************

      String name = out;
      String uname = name.toUpperCase();
      FileWriter fw = new FileWriter(name+".c");
      PrintWriter pw = new PrintWriter(fw);

      // Header
      pw.println("#ifndef _"+uname);
      pw.println("#define _"+uname);
      pw.println();
      pw.println("#include \"o3d.h\"");
      pw.println();

      // Textures
      pw.println("#define "+uname+"_NBTEX "+(tx==null?0:tx.length));
      pw.println();
      if (tx!=null) {
         for (int i=0;i<tx.length;i++)
             pw.println("extern u_long "+tx[i]+";");
         pw.println();
         pw.println("u_long *"+name+"_tex["+uname+"_NBTEX] = {");
         for (int i=0;i<tx.length;i++)
             pw.println("\t&"+tx[i]+(i+1<tx.length?",":""));
         pw.println("\t};");
         pw.println();
         pw.println("u_short "+name+"_texID["+uname+"_NBTEX];");
         pw.println();
      }

      // Vertices
      pw.println("#define "+uname+"_NBVERTS "+vertices.size());
      pw.println();
      pw.println("SVECTOR "+name+"_vert["+uname+"_NBVERTS] = {");
      int l = vertices.size();
      for (int i=0;i<l;i++) {
          TransObj.Point3D p = (TransObj.Point3D)vertices.elementAt(i);
          pw.println("\t{"+((int)(p.x*zoom))+","+((int)(p.y*zoom))+","+((int)(p.z*zoom))+"}"+(i==l-1?"":","));
      }
      pw.println("};");
      pw.println();

      // Polygones
      pw.println("#define "+uname+"_NBPOLYS "+faces.size());
      pw.println();
      l = faces.size();
      for (int i=0;i<l;i++) {
          Vector f = (Vector)faces.elementAt(i);
          int ll = f.size();
          pw.print("u_short "+name+"_poly"+i+"["+ll+"] = {");
          for (int j=0;j<ll;j++) pw.print(f.elementAt(j).toString()+(j==ll-1?"":","));
          pw.println("};");
      }
      pw.println();
      pw.println("u_short *"+name+"_polys["+uname+"_NBPOLYS] = {");
      for (int i=0;i<l;i++) pw.println("\t"+name+"_poly"+i+(i==l-1?"":","));
      pw.println("};");
      pw.println();
      pw.println("u_char "+name+"_pdim["+uname+"_NBPOLYS] = {");
      for (int i=0;i<l;i++) pw.println("\t"+((Vector)faces.elementAt(i)).size()+(i==l-1?"":","));
      pw.println("};");
      pw.println();
      pw.println("u_char "+name+"_ptype["+uname+"_NBPOLYS] = {");
      for (int i=0;i<l;i++) pw.println("\tTYPE_"+ptype+(textures.get(""+i)!=null?"T":"")+ltype+(i==l-1?"":",")); //  voir : TYPE_G
      pw.println("};");
      pw.println();
      for (int i=0;i<colset.size();i++) {
          Color col = (Color)colset.elementAt(i);
          String cc = "{"+col.getRed()+","+col.getGreen()+","+col.getBlue()+"}";
          if (ptype.equals("G"))
             pw.println("Color "+name+"_color"+i+"[4] = {"+cc+","+cc+","+cc+","+cc+"};");
          else
             pw.println("Color "+name+"_color"+i+" = "+cc+";");
      }
      pw.println();
      if (textures.size()>0) {
         if (ptype.equals("G"))
            pw.println("Color "+name+"_color_tex[4] = {{127,127,127},{127,127,127},{127,127,127},{127,127,127}};");
         else
            pw.println("Color "+name+"_color_tex = {127,127,127};");
         pw.println();
         for (Enumeration enum = textures.keys();enum.hasMoreElements();) {
             String num = (String)enum.nextElement();
             Vector data = (Vector)textures.get(num);
             int n = Integer.valueOf(num).intValue();
             int d = ((Vector)faces.elementAt(n)).size();
             String u = "u_char "+name+"_data"+n+"_u["+d+"] = {";
             String v = "u_char "+name+"_data"+n+"_v["+d+"] = {";
             for (int i=0;i<d;i++) {
                 u+=((Integer)data.elementAt(i*2+1)).intValue()+(i+1<d?",":"");
                 v+=((Integer)data.elementAt(i*2+2)).intValue()+(i+1<d?",":"");
             }
             pw.println(u+"};");
             pw.println(v+"};");
             pw.println("TPolyData "+name+"_data"+n+" = {0,"+name+"_data"+n+"_u,"+name+"_data"+n+"_v,&"+name+"_color_tex};");
         }
      }
      pw.println();
      pw.println("void *"+name+"_data["+uname+"_NBPOLYS] = {");
      for (int i=0;i<l;i++) {
           if (textures.get(""+i)!=null)
              pw.println("\t&"+name+"_data"+i+(i==l-1?"":","));
           else
              pw.println("\t&"+name+"_color"+colors.get(""+i)+(i==l-1?"":","));
      }
      pw.println("};");
      pw.println();
      pw.println("SVECTOR "+name+"_f_normals["+uname+"_NBPOLYS];");
      pw.println("SVECTOR "+name+"_v_normals["+uname+"_NBVERTS];");
      pw.println();
      pw.println("SObject "+name+"_sobj;");
      pw.println("Object3D "+name+"_o3d = {0,&"+name+"_sobj,0};");
      pw.println();
      pw.println("Object3D* "+name+"_object() {");
      pw.println("\t"+name+"_sobj.nbv = "+uname+"_NBVERTS;");
      pw.println("\t"+name+"_sobj.vert = "+name+"_vert;");
      pw.println("\t"+name+"_sobj.nbp = "+uname+"_NBPOLYS;");
      pw.println("\t"+name+"_sobj.polys = "+name+"_polys;");
      pw.println("\t"+name+"_sobj.pdim = "+name+"_pdim;");
      pw.println("\t"+name+"_sobj.ptype = "+name+"_ptype;");
      pw.println("\t"+name+"_sobj.data = "+name+"_data;");
      pw.println("\t"+name+"_sobj.nbt = "+uname+"_NBTEX;");
      pw.println("\t"+name+"_sobj.tex = "+(tx==null?"0":name+"_tex")+";");
      pw.println("\t"+name+"_sobj.texID = "+(tx==null?"0":name+"_texID")+";");
      pw.println("\t"+name+"_sobj.f_normals = "+name+"_f_normals;");
      pw.println("\t"+name+"_sobj.v_normals = "+name+"_v_normals;");
      pw.println("\tInitSObject(&"+name+"_o3d);");
      pw.println("\treturn &"+name+"_o3d;");
      pw.println("}");

      // Foot
      pw.println();
      pw.println("#endif // _"+name.toUpperCase());
      pw.flush();
      fw.close();
  }
}

