#ifndef _REGTEX_H

#define _REGTEX_H

#include <sys/types.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>

#define MAX_TEX 50

#ifdef _REGTEX_C

// State vars
int	nbtex = 0;
u_long*	tex_addr[MAX_TEX];
GsIMAGE	texInfo[MAX_TEX];
u_short	tpages[MAX_TEX];
u_short	cluts[MAX_TEX];
u_short	modes[MAX_TEX];

#else

// Texture registration

extern	u_short getDivMode	(u_short mode);
extern	u_short	regTex		(u_long *texture);		// Register a texture and return a texID
extern	u_short regTexTC	(u_short texID,int x,int y);
extern	u_short	regTPage	(u_short textID);		// Return the tPage ID for the registered texture
extern	u_short	regClut		(u_short textID);		// Return the clut ID for the registered texture
extern	u_short	regMode		(u_short textID);		// Return the absisse divider (4 : 4bits, 2 : 8bits, 1 : 16bits)
extern	void	regRect		(u_short textID,RECT *rect);	// Return the rect for the registered texture
extern	void	regDrawTPage	(u_short texID,DR_TPAGE *dm);	// Set the drawing mode primitive to a registered texture

#endif // _REGTEX_C

#endif // _REGTEX_H
