#include <sys/types.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>

#include "constants.h"
#include "o3d.h"
#include "sincos.h"
#include "msg.h"
#include "music/hitmod.h"

/*
 * Define structure to deal BG
 */

typedef struct {
	DRAWENV		draw;		/* drawing environment: */
	DISPENV		disp;		/* display environment: */
	u_long		ot[OTSIZE];	/* OT: */
} DB;

void InitPrim(DB *db,int dr_x, int dr_y, int ds_x, int ds_y, int w, int h);
void InitSystem(int x, int y, int z);
void ReadPad();
void InitScene();
void ScrollText();
void RollText();
void ChooseMode();
void InitMusic(u_char* musptr);
void InitBack();

extern Object3D *ribbon_object();

#define NB_OBJECTS 7
extern Object3D *cube_object();
extern Object3D *ship_object();
extern Object3D *axe_object();
extern Object3D *hammer_object();
extern Object3D *glaive_object();

extern long music1;
extern long music2;
extern long music3;
extern long back;
extern long test;
extern long test2;
extern long logo256;

ObjPos list_o3d_1[2],list_o3d_2[1],list_o3d_3[8];
Object3D scene,ribbon_scene,conik_scene;
Object3D* list_obj[NB_OBJECTS+1];
Object3D* list_obj[NB_OBJECTS+1];
int list_nb[NB_OBJECTS+1];
int list_flags[NB_OBJECTS+1];
int list_idx = 1,cpt = 0, conik = 0,next;
SVECTOR light;
ObjPos objpos;

DB	db[2];	/* double buffer: */
DB	*cdb;	/* current buffer: */

DR_MOVE drmv[4];
int nbmv = 0;
int ids = 0;
DR_TPAGE dm[32];
SPRT sprt[5*4];
int tex = 0,tcpt = 0,mus = 0,cmus=0;
u_long *musix[] = {&music1,&music2,&music3};

extern int min;
extern u_char used[OTSIZE];
extern int max;

char *msg_scroll,*msg_roll;

int lim_min = 3000;
int lim_max = 30000;

main()
{
	int	i,j, zoom = 0, old,tmp;
	long	lang = 0;
	SObject	*o;
	if (*((char *)0xbfc7ff52)=='E')
		SetVideoMode(1);
	else
		SetVideoMode(0);

	InitSystem(SCR_W/2, SCR_H/2, SCR_Z);	/* initialize GTE: */
	InitPrim(&db[0], 0,     0, 0, SCR_H, SCR_W, SCR_H);
	InitPrim(&db[1], 0, SCR_H, 0,     0, SCR_W, SCR_H);

	SetDispMask(1);	/* enable to screen: */

	InitMusic((u_char*)musix[(mus++)%2]);
	ChooseMode();
	MOD_Stop();
	MOD_Free();

	Init3DPrims();
	setZTex(10);

	InitBack();

	list_obj[0] = ribbon_object();
	o = list_obj[0]->o.single;

	list_obj[1] = ship_object();
	list_flags[1] = FLAG_S | FLAG_MB;
	list_nb[1] = 1;

	list_obj[2] = axe_object();
	list_nb[2] = 1;
	list_flags[2] = 0;

	list_obj[3] = cube_object();
	list_nb[3] = 1;
	list_flags[3] = FLAG_MB;

	list_obj[4] = glaive_object();
	list_nb[4] = 1;
	list_flags[4] = 0;

	list_obj[5] = list_obj[1];
	list_nb[5] = 2;
	list_flags[5] = 0;

	list_obj[6] = hammer_object();
	list_nb[6] = 1;
	list_flags[6] = FLAG_S;

	list_obj[7] = list_obj[3];
	list_nb[7] = 3;
	list_flags[7] = FLAG_S;


	InitScene();

	InitMusic((u_char*)musix[(mus++)%3]);

	msg_scroll = msg_thor;
	msg_roll = msg_madx;

	cdb = db;

	do {
		cdb = (cdb==db)? db+1: db;	

		if (cpt>0) {
			cpt--;
			if (cpt!=20) {
				list_o3d_1[1].pos.vx += next < 0 ? -40 : 40;
			} else if (cpt==20) {
				int i;
				list_o3d_1[1].pos.vx = next < 0 ? 800 : -800;
				list_idx = (next < 0 ? -next : next) - 1;
				conik_scene.type = list_nb[1+list_idx];
				list_obj[1+list_idx]->flags = (list_obj[1+list_idx]->flags & (255-FLAG_MB)) | (list_flags[1+list_idx] & FLAG_MB);
				conik_scene.flags &= (255-FLAG_S);
				for (i=0;i<conik_scene.type;i++)
					InitObjPos(&list_o3d_3[i],list_obj[1+list_idx],0,0,0,0,0,0,ONE-i*512);
			}
		}
		if (tcpt>0) tcpt--;
		if (cmus>0) cmus--;
		ReadPad();

		ClearOTag(cdb->ot, OTSIZE);
		light.vx = (800*tcos[lang%PRECISION])/MULT;
		light.vy = -600;
		light.vz = (800*tsin[lang%PRECISION])/MULT;
		lang++;

		for (i=0;i<conik_scene.type;i++) {
			int j = (i*96+conik);
			list_o3d_3[i].pos.vx = (200*(2*tcos[j%PRECISION]-tsin[j%PRECISION]))/MULT;
			list_o3d_3[i].pos.vy = (100*(tsin[j%PRECISION]+tcos[(2*j)%PRECISION]))/MULT;
			list_o3d_3[i].pos.vz = i*128;
			list_o3d_3[i].ang.vx += 10;
			list_o3d_3[i].ang.vy -= 8;
			list_o3d_3[i].ang.vz += 4;
		}
		conik+=5;

		list_o3d_1[0].pos.vz = -400+(200*(tsin[zoom%PRECISION]+2*tcos[(2*zoom)%PRECISION]))/MULT;
		zoom+=5;

		nbmv = 0;

		ScrollText();
		RollText();

		tmp = o->nbp-2;
		for (i=0;i<tmp;i++) {
			o->vert[i].vy += (tsin[(conik*8+i*40)%PRECISION]*10)/MULT;
			o->vert[i+tmp].vy -= (tsin[(conik*8+i*40)%PRECISION]*10)/MULT;
		}
		
		Draw3D(&objpos,&light,cdb->ot);

		for (i=0;i<tmp;i++) {
			o->vert[i].vy -= (tsin[(conik*8+i*40)%PRECISION]*10)/MULT;
			o->vert[i+tmp].vy += (tsin[(conik*8+i*40)%PRECISION]*10)/MULT;
		}

		tmp = (ids%2)*64;
		j = (ids/8)*64;
		for (i=0;i<20;i++) {
			setUV0(&sprt[i],tmp,j);
			AddPrim(&cdb->ot[0],&sprt[i]);
		}
		AddPrim(&cdb->ot[0],&dm[ids]);
		ids=(ids+(cdb==db))%32;

		for (i=nbmv-1;i>=0;i--)
			AddPrim(&cdb->ot[0],&drmv[i]);

		tmp = VSync(1);
		if (tmp<65000) old = tmp;
		tmp=0;
		for (i=0;i<OTSIZE;i++) tmp+=used[i];
#ifdef DEBUG
		FntPrint("sync %d %d %d %d %d",old,min,max,tmp,list_o3d_1[1].pos.vz);
		FntFlush(-1);
#endif

		VSync(0);

		/* swap double buffer draw: */
		PutDrawEnv(&cdb->draw);
		PutDispEnv(&cdb->disp);
		DrawOTag(cdb->ot);
	} while(1);
}

void InitSystem(int x, int y, int z)
{
	RECT r;
	
	/* reset graphic subsystem */
	ResetGraph(0);

	r.x = 0;
	r.y = 0;
	r.w = 2048;
	r.h = 512;
	ClearImage(&r,0,0,0);

	FntLoad(960, 256);
	SetDumpFnt(FntOpen(32, 32, 320, 64, 0, 512));
	
	/* set debug mode (0:off, 1:monitor, 2:dump) */
	SetGraphDebug(0);

	/* initialize geometry subsystem */
	InitGeom();
	
	/* set geometry origin as (160, 120) */
	SetGeomOffset(x, y);
	
	/* distance to veiwing-screen: */
	SetGeomScreen(z);

	SetFogNearFar(z/2,65535,z);
	SetFarColor(0,0,0);
}

void InitPrim(DB *db,int dr_x, int dr_y, int ds_x, int ds_y, int w, int h) {

	/* set double buffer: */
	SetDefDrawEnv(&db->draw, dr_x, dr_y, w, h);
	SetDefDispEnv(&db->disp, ds_x, ds_y, w, h);

	db->disp.screen.x = 6;
	db->disp.screen.y = 16;
	db->disp.screen.w = SCR_W;
	db->disp.screen.h = SCR_H;

	/* set auto clear mode for background : */
	db->draw.isbg = 1;
	setRGB0(&db->draw, 0, 0, 0);
}

void InitScene() {
	int i;

	scene.o.scene = list_o3d_1;
	scene.type = 2;

	InitObjPos(&list_o3d_1[0],&ribbon_scene,0,GetVideoMode()==MODE_PAL?0:-8,100,0,0,0,ONE);
	InitObjPos(&list_o3d_1[1],&conik_scene,0,0,4000,0,0,0,ONE);

	ribbon_scene.o.scene = list_o3d_2;
	ribbon_scene.type = 1;
	InitObjPos(&list_o3d_2[0],list_obj[0],0,0,0,0,0,0,ONE);

	conik_scene.o.scene = list_o3d_3;
	conik_scene.type = list_nb[list_idx+1];
	for (i=0;i<conik_scene.type;i++)
		InitObjPos(&list_o3d_3[i],list_obj[list_idx+1],0,0,0,0,0,0,ONE-i*512);

	InitObjPos(&objpos,&scene,0,0,SCR_Z,0,0,0,ONE);
}

void InitBack() {
	RECT	r,rr;
	int b = regTex(&back), a, c = PRECISION/32,i;
	for (i=0;i<20;i++) {
		sprt[i].w = 64;
		sprt[i].h = 64;
		setXY0(&sprt[i],(i%5)*64,(i/5)*64);
		setRGB0(&sprt[i],127,127,127);
		sprt[i].clut = regClut(b);
		SetSprt(&sprt[i]);
	}

	regRect(b,&r);
	MoveImage(&r,r.x+r.w,r.y);
	MoveImage(&r,r.x+r.w,r.y+r.h);
	MoveImage(&r,r.x,r.y+r.h);
	while (DrawSync(1));

	for (a=0;a<32;a++) {
		int dx = r.x+128+(a%8)*32;
		int dy = (a/8)*64;
		SetDrawTPage(&dm[a],0,0,GetTPage(1,0,dx,dy));
		rr.x = r.x;
		rr.y = 0;
		rr.w = 64;
		rr.h = 1;
		b = a*c;
		for (i=0;i<80;i++) {
			MoveImage(&rr,r.x+(tsin[b%PRECISION]*8)/MULT+8,80+i);
			rr.y++;
			b+=c/2;
		}

		while (DrawSync(1));

		b = a*c;
		rr.w = 1;
		rr.h = 64;
		rr.x = r.x+16;
		for (i=0;i<32;i++) {
			rr.y = 80+(tsin[b%PRECISION]*8)/MULT+8;
			rr.x++;
			MoveImage(&rr,dx+i,dy);
			b+=c;
		}
		while (DrawSync(1));
	}
}

void ReadPad() {
	u_long	padd;
	
	padd = PadRead(1);

	if (padd & PADLup) list_o3d_1[1].ang.vz-=8;
	else if (padd & PADLdown) list_o3d_1[1].ang.vz+=8;
	else {
		if (list_o3d_1[1].ang.vz<0) list_o3d_1[1].ang.vz+=4;
		if (list_o3d_1[1].ang.vz>0) list_o3d_1[1].ang.vz-=4;
	}

	if (padd & PADLleft) list_o3d_1[1].ang.vy-=8;
	else if (padd & PADLright) list_o3d_1[1].ang.vy+=8;
	else {
		if (list_o3d_1[1].ang.vy<0) list_o3d_1[1].ang.vy+=4;
		if (list_o3d_1[1].ang.vy>0) list_o3d_1[1].ang.vy-=4;
	}

	if ((padd & PADRup)||(padd & PADRdown)) {
		if (cpt==0) {
			cpt=40;
			if (padd & PADRup) next=1+(list_idx+1)%NB_OBJECTS;
			else next=-(1+(list_idx+NB_OBJECTS-1)%NB_OBJECTS);
		}
	}

	if ((padd & PADRleft)&&(list_o3d_1[1].pos.vz>lim_min)) list_o3d_1[1].pos.vz-=50;
	else if ((padd & PADRright)&&(list_o3d_1[1].pos.vz<lim_max)) list_o3d_1[1].pos.vz+=50;

	if (padd & PADL2)
	{
		if (list_o3d_2[0].ang.vy+10<1000)
			list_o3d_2[0].ang.vy+=10;
	} else if (padd & PADR2)
	{
		if (list_o3d_2[0].ang.vy-10>-1000)
			list_o3d_2[0].ang.vy-=10;
	} else {
		if (list_o3d_2[0].ang.vy<0) list_o3d_2[0].ang.vy+=5;
		if (list_o3d_2[0].ang.vy>0) list_o3d_2[0].ang.vy-=5;
	}
	if (padd & PADL1) {
		if (list_o3d_2[0].ang.vz+10<2048)
			list_o3d_2[0].ang.vz+=10;
	} else if (padd & PADR1) {
		if (list_o3d_2[0].ang.vz-10>-2048)
			list_o3d_2[0].ang.vz-=10;
	} else {
		if (list_o3d_2[0].ang.vz<0) list_o3d_2[0].ang.vz+=5;
		if (list_o3d_2[0].ang.vz>0) list_o3d_2[0].ang.vz-=5;
	}

	if (padd & PADselect) {
		if (tcpt==0) {
			if (list_obj[list_idx+1]==list_obj[7]) {
				SObject *sobj = ((Object3D*)list_obj[7])->o.single;
				int i;
                        	tex = (tex+1)%sobj->nbt;
				for (i=0;i<sobj->nbp;i++) ChangeTex(sobj,i,tex);
			}
			tcpt=20;
			conik_scene.flags = (conik_scene.flags^FLAG_S)&((255-FLAG_S)+(list_flags[1+list_idx]&FLAG_S));
		}
	}

	if (padd & PADstart) {
		if (cmus==0) {
			MOD_Stop();
			MOD_Free();
			cmus = 20;
#ifdef DEBUG
			ResetGraph(0);
			PadStop();
			(*((void (*)()) 0xBFC00000))();
#else
			InitMusic((u_char*)musix[(mus++)%3]);
#endif	
		}
	}
}

int numscroll = 0,dxscroll = 32;

void ScrollText() {
	RECT r;
	char ch;

	r.x = SCR_W+1;
	r.y = 318;
	r.w = 255;
	r.h = 62;
	SetDrawMove(&drmv[nbmv++],&r,SCR_W,318);
	if (--dxscroll!=0) return;
	dxscroll = 32;
	ch = msg_scroll[numscroll++];
        if (numscroll%SWAP_MSG == 0) msg_scroll = msg_scroll == msg_thor ? msg_madx : msg_thor;
	if (msg_scroll[numscroll]==0) numscroll = 0;

	if (ch=='.') ch = 'Z'+4;
	else if (ch=='-') ch = 'Z'+5;
	else if (ch=='@') ch = 'G'+1;
	else if (ch==' ') ch = 'N'+2;
        else ch += (ch-'A')/7;
	ch -= 'A';
	regRect(regTex(&test2),&r);
	r.w = 32;
	r.x += (ch%8)*32;
	r.h = 62;
	r.y += (ch/8)*62;
	SetDrawMove(&drmv[nbmv++],&r,SCR_W+224,318);
}

int numroll = 0,dxroll = 32;

void RollText() {
	RECT r;
	char ch;

	r.x = SCR_W+1;
	r.y = 256;
	r.w = 255;
	r.h = 62;
	SetDrawMove(&drmv[nbmv++],&r,SCR_W,256);
	if (--dxroll!=0) return;
	dxroll = 32;
	ch = msg_roll[numroll++];
        if (numroll%SWAP_MSG == 0) msg_roll = msg_roll == msg_thor ? msg_madx : msg_thor;
	if (msg_roll[numroll]==0) numroll = 0;

	if (ch=='.') ch = 'Z'+4;
	else if (ch=='-') ch = 'Z'+5;
	else if (ch=='@') ch = 'G'+1;
	else if (ch==' ') ch = 'N'+2;
        else ch += (ch-'A')/7;
	ch -= 'A';
	regRect(regTex(&test),&r);
	r.w = 32;
	r.x += (ch%8)*32;
	r.h = 62;
	r.y += (ch/8)*62;
	SetDrawMove(&drmv[nbmv++],&r,SCR_W+224,256);
}

void ChooseMode() {
	u_long	padd,n = 600,i=0;
	static char* mess[] = {"","WAKE UP!","ARE YOU ASLEEP ?","DO YOU LIKE THE MUSIC ?","THE INTRO IS BEYONG THIS SCREEN !"};
	int l = regTex(&logo256);
	RECT r;

	PadInit(0);		

	regRect(l,&r);
	sprt[0].w = r.w*2;
	sprt[0].h = r.h;
	setXY0(&sprt[0],32,120-r.h/2);
	setRGB0(&sprt[0],127,127,127);
	sprt[0].clut = regClut(l);
	setUV0(&sprt[0],0,r.y%256);
	SetSprt(&sprt[0]);
	regDrawTPage(l,&dm[0]);

	while (1) {
		cdb = (cdb==db)? db+1: db;	

		padd = PadRead(1);

		ClearOTag(cdb->ot, OTSIZE);
		AddPrim(&cdb->ot[0],&sprt[0]);
		AddPrim(&cdb->ot[0],&dm[0]);
		FntPrint("X : PAL\nO : NTSC (BUGS ARE LESS VISIBLE)\n\n%s",mess[i]);
		if (n>0) n--;
		else {
			i = (i+1)%5;
			n = 300;
		}
		FntFlush(-1);
		DrawSync(0);
		VSync(0);
	
		/* swap double buffer draw: */
		PutDrawEnv(&cdb->draw);
		PutDispEnv(&cdb->disp);
		DrawOTag(cdb->ot);

		if (padd & PADRdown) {
			if (GetVideoMode()!=MODE_PAL) SetVideoMode(MODE_PAL);
			lim_max = 10000;
			lim_min = 3500;
			return;
		} else if (padd & PADRright) {
			if (GetVideoMode()!=MODE_NTSC) SetVideoMode(MODE_NTSC);
			return;
		}
	}
}

void InitMusic(u_char* musptr)
{
	MOD_Init();
	MOD_Load(musptr);
	MOD_Start();
}
