#include "orb.h"

#define C0  0.4829629131445341
#define C1  0.8365163037378079
#define C2  0.2241438680420134
#define C3 -0.1294095225512604

char pal[768];
char pic[200][320];

void vidmode(int x)
{
	union REGS regs;
	regs.w.ax=x;
	int386(0x10,&regs,&regs);
}

int clip(int i)
{
	if (i<0) i=0;
	if (i>255) i=255;
	return i;
}

void wstep(float *in, int n, int inverse)
{
	static float out[1024];
	int nh=n>>1;
	int i,j;
	if (!inverse)
	{
		for (i=0,j=0;j<n-3;j+=2,i++)
		{
			out[i]=C0*in[j]+C1*in[j+1]+C2*in[j+2]+C3*in[j+3];
			out[i+nh]=C3*in[j]-C2*in[j+1]+C1*in[j+2]+C0*in[j+3];
		}
		out[i]=C0*in[n-2]+C1*in[n-1]+C2*in[0]+C3*in[1];
		out[i+nh]=C3*in[n-2]-C2*in[n-1]+C1*in[0]+C0*in[1];
	}
	else
	{
		out[0]=C2*in[nh-1]+C1*in[n-1]+C0*in[0]+C3*in[nh];
		out[1]=C3*in[nh-1]-C0*in[n-1]+C1*in[0]-C2*in[nh];
		for (i=0,j=2;i<nh-1;i++)
		{
			out[j++]=C2*in[i]+C1*in[i+nh]+C0*in[i+1]+C3*in[i+nh+1];
			out[j++]=C3*in[i]-C0*in[i+nh]+C1*in[i+1]+C2*in[i+nh+1];
		}
	}
	memcpy(in,out,n*4);
}



void wt(float *in, int n, int inverse=0)
{
	int nn;
	if (inverse)
	{
		for (nn=4;nn<=n;nn<<=1) wstep(in,nn,inverse);
	}
	else
	{
		for (nn=n;nn>=4;nn>>=1) wstep(in,nn,inverse);
	}
}

int main(int argc, char *argv[])
{
	vidmode(0x13);

	FILE *fi=fopen("data\\square.raw","rb");
	fread(pal,1,768,fi);
	fread(pic,320,200,fi);
	fclose(fi);

	int x,y,c1;
//WIN32TODO 	outp(0x3c8,0);
//WIN32TODO 	for (c1=0;c1<768;c1++) outp(0x3c9,pal[c1]);
	// WIN32DONE
	{
		for (int c1=0;c1<256;c1++)
		{
			winpal[c1][2]=pal[c1*3+0]*4;
			winpal[c1][1]=pal[c1*3+1]*4;
			winpal[c1][0]=pal[c1*3+2]*4;
		}
	}


	float temp[320];
	for (y=0;y<200;y++)
	{
		for (x=0;x<256;x++) temp[x]=pic[y][x];
		wt(temp,256);
		//wt(temp,256,1);
		for (x=0;x<256;x++) pic[y][x]=clip(temp[x]);
	}
	//WIN32TODO
	memcpy((char*)0xa0000,pic,320*200);
	getch();
	vidmode(3);

	return 1;
}
