Dim ScaleX(320)
Dim ScaleY(240)
Dim Pallette(256)



Function LoadMap()
	fire=CreateBank(320*240)
	IMG=LoadImage("greetzmap.png")
	SetBuffer ImageBuffer(IMG)
	LockBuffer 
	i=0
		For y=0 To 239
			For x=0 To 319
				RGB=ReadPixelFast(x,y)
				R=(RGB Shr 16)And$FF : G=(RGB Shr 8)And$FF : B=(RGB)And$FF
				COL=(R+G+B)/3.0
				PokeByte(fire,i,col)
				i=i+1
			Next
		Next
	UnlockBuffer
	FreeImage IMG
	Return fire
End Function
	
Function ScreenUpdate(BNK)
	offs=0
	For y=0 To 239
		For x=0 To 319
			COL=PeekByte(BNK,offs)
			WritePixelFast x,y,Pallette(COL)
			offs=offs+1
		Next
	Next
End Function

Function Rescale(SRC,DST)
	offs=0
	For j=0 To 239
		For i=0 To 319
			PokeByte(DST,offs,PeekByte(SRC,(ScaleY(j)*320)+ScaleX(i)))
			offs=offs+1
		Next
	Next
End Function

Function Blur(SRC,DST)
	offs=320
	For j=1 To 238
	 	PokeByte(DST,offs,0)
		offs=offs+1
		For i=1 To 318
			B=PeekByte(SRC,offs-321)+PeekByte(SRC,offs-320)+PeekByte(SRC,offs-319)
			B=B+PeekByte(SRC,offs-1)+PeekByte(SRC,offs+1)
			B=B+PeekByte(SRC,offs+321)+PeekByte(SRC,offs+320)+PeekByte(SRC,offs+319)
			B=B Shr 3
			If B>16 B=B-16 Else B=0
	;		B=PeekByte(SRC,offs)
			PokeByte(DST,offs,B)
			offs=offs+1
		Next
		PokeByte(DST,offs,0)
		offs=offs+1
	Next
End Function

Function PhongPalletteForZoom(sr#,sg#,sb#,dr#,dg#,db#,spr#,spg#,spb#,n)
	For i#=0 To 255
		ang#=(90.00/255.00)*(255-i#)
		R=(sr#+Cos(ang#)*dr#+Cos(ang#)^n*spr#)
		If R>255 R=255
		G=(sg#+Cos(ang#)*dg#+Cos(ang#)^n*spg#)
		If G>255 G=255
		B=(sb#+Cos(ang#)*db#+Cos(ang#)^n*spb#)
		If B>255 B=255
		Pallette(255-(Int i))=(R Shl 16)+(G Shl 8)+B
	Next
End Function


	

	
	