{Ŀ}
{  IVS_VESA.PAS - VESA BIOS Driver Main Unit                              }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - GO32V2                                                  }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}
{$INCLUDE IVS_SET.INC}
{$ASMMODE INTEL}
{$MODE FPC}

{$HINTS OFF} {  Enable this, if you modify the sources!  }
{$NOTES OFF} {  Enable this, if you modify the sources!  }

Unit IVS_VESA;

Interface

Uses IVS_Var, {  The system variables and types  }
     CRT,     {  CRT unit for switching back to the correct textmode  }
     GO32;    {  The GO32 unit, because it's a DOS only driver  }

Const IVS_VESAVersionStr = '1.0.2';
      IVS_VESAVersion    = $102;

      IVS_VESAName     = 'VESA BIOS Driver';
      IVS_VESALongName = 'VESA BIOS 1.2 Banked & 2.0+ LFB Device Driver';

Var IVS_VESADevice : IVS_TVideoDevice; {  VESA Device Structure  }
    IVS_VESADriver : IVS_TVideoDriver; {  VESA Device Driver  }

Procedure IVS_VESADevInit; {  Inits the VESA driver structures  }

Implementation

{  >>> INCLUDE VESA TYPE DECLARATIONS <<<  }
{$INCLUDE IVS_VESA.INC\VBE_TYPE.PAS}

{  >>> L O C A L  V A R I A B L E S <<<  }

Const VESA_DevMaxMode = 7; {  Number of videomodes-1  }

Var VESA_SegA000     : Word; {  Descriptor to $A000 segment (for banked)  }
    VESA_SegLFB      : Word; {  Descriptor to LFB segment  }
    VESA_CurrentMode : Word; {  Current mode number. $FFFF = no mode.  }
    VESA_CurrentModeSetup : IVS_TModeSetup;

    VESA_PhysScrNum  : Byte;  {  Number of current physical screen  }
    VESA_PhysScrAddr : DWord; {  Physical Address to the screen  }
    VESA_PhysScrOneAddr : DWord; {  Physical Address of screen 1  }
    VESA_PhysScrTwoAddr : DWord; {  Physical Address of screen 2  }
    VESA_PhysScrOnePos : Word; {  Y Position of screen 1  }
    VESA_PhysScrTwoPos : Word; {  Y Position of screen 2  }

    VESA_Info     : VESA_TInfoBlock;       {  Global VESA Info block  }
    VESA_ModeInfo : VESA_TModeInformation; {  Global VESA Modeinfo block  }
    VESA_ModeList : Array[0..255] Of Word; {  Global VESA Modelist  }

    VESA_GranShift      : Byte;  {  Granularity shift count for banking  }
    VESA_WinSize        : DWord; {  Window size for banking  }
    VESA_ScanLineLength : DWord; {  Scanline length in bytes for banking  }

    VESA_VSync   : Boolean; {  True, if VSync mode enabled  }
    VESA_BGRMode : Byte; {  Should contain 1 if the truecolor mode is BGR  }

    VESA_CopyProc : Procedure; {  Pointer to the copy procedure to use  }

    {  Static record to fill up with videomode data  }
    VESA_DevModeList : Array[0..VESA_DevMaxMode] Of IVS_TVideoMode;

{  >>> INCLUDE VESA UTIL FUNCTIONS <<<  }
{$INCLUDE IVS_VESA.INC\VBE_UTIL.PAS}

{  >>> I N C L U D I N G  V I D E O M O D E  H A N D L E R S <<<  }

{$INCLUDE IVS_VESA.INC\VBE_LO15.PAS}
{$INCLUDE IVS_VESA.INC\VBE_LO16.PAS}
{$INCLUDE IVS_VESA.INC\VBE_LO24.PAS}
{$INCLUDE IVS_VESA.INC\VBE_LO32.PAS}
{$INCLUDE IVS_VESA.INC\VBE_HI15.PAS}
{$INCLUDE IVS_VESA.INC\VBE_HI16.PAS}
{$INCLUDE IVS_VESA.INC\VBE_HI24.PAS}
{$INCLUDE IVS_VESA.INC\VBE_HI32.PAS}


{  >>> I N T E R N A L  F U N C T I O N S <<<  }

{  Switches back to textmode 03h.  }
Procedure VESA_SwitchMode03h;
Var RealRegs : TRealRegs;
Begin
 RealRegs.AX:=$03;
 RealIntr($10,RealRegs);
End;

{  Detects VESA presence, and sets the VESA_Info record  }
Function VESA_HWDetect : Boolean;
Var Regs     : TRealRegs;
    Linear   : DWord;
    Segment  : Word;
    Selector : Word;
Begin
 VESA_HWDetect:=False;

 {  Clearing VESA_Info record  }
 FillChar(VESA_Info,SizeOf(VESA_Info),0);

 {  Init Variables for DOS (below 640K) memory access  }
 Linear:=Global_DOS_Alloc(512);
 Segment:=Word(Linear Shr 16);
 Selector:=Word(Linear And $FFFF);

 {  Calling BIOS to check VESA BIOS Extension (VBE) presence  }
 VESA_Info.Signature:='VBE2';
 DOSMemPut(Segment,0,VESA_Info,512);
 Regs.EAX:=$4F00;
 Regs.ES:=Segment;
 Regs.EDI:=0;
 RealIntr($10,Regs);

 {  Check if VBE present  }
 If (Regs.EAX And $FF)<>$4F Then Begin
   Global_DOS_Free(Selector);
   Exit;
  End;

 {  Copying VESA Info record from DOS memory to FPC Heap  }
 DOSMemGet(Segment,0,VESA_Info,512);
 Global_DOS_Free(Selector);

 {  Checking version number (1.2+ required)  }
 With VESA_Info Do Begin
   If (Signature<>'VESA') Or (VESA_Version<$0102) Then Begin
     FillChar(VESA_Info,SizeOf(VESA_Info),0);
     Exit;
    End;
  End;

 {  Copying video mode list from DOS memory to FPC Heap  }
 Segment:=Word(VESA_Info.VideoModesPtr Shr 16);
 Selector:=Word(VESA_Info.VideoModesPtr);
 DOSMemGet(Segment,Selector,VESA_ModeList,SizeOf(VESA_ModeList));

 VESA_HWDetect:=True;
End;

{  Waits retrace using the VGA registers  }
Procedure VESA_WaitRetrace; Assembler;
Asm
 MOV DX,$03DA
 @Loop1:
  IN  AL,DX
  TEST AL,$08
 JZ @Loop1
 @Loop2:
  IN  AL,DX
  TEST AL,$08
 JNZ @Loop2
End ['EAX','EDX'];

{  Detects the first videomode with the specified parameters  }
Function VESA_DetectMode(XRes,YRes : Word; BPP : Byte) : Word;
Var Counter   : Word;
    Info      : VESA_TModeInformation;
    Match     : Boolean;
    MatchInfo : VESA_TModeInformation;
    MatchMode : Word;
    Current   : Word;
Begin
 Match:=False;
 Counter:=0;
 Repeat
   Current:=VESA_ModeList[Counter];
   Inc(Counter);
   If Current<>$FFFF Then Begin
     VESA_GetModeInfo(Current,Info);
     With Info Do Begin
       If (Width=XRes) And (Height=YRes) Then Begin
         Case BPP Of
           24,32 : If (RedMaskSize+GreenMaskSize+BlueMaskSize+ReservedMaskSize=BPP) Then
                     Begin Match:=True; MatchMode:=Current; MatchInfo:=Info; End;
           15,16 : If (RedMaskSize+GreenMaskSize+BlueMaskSize=BPP) Then Begin
                     Begin Match:=True; MatchMode:=Current; MatchInfo:=Info; End;
                    End;
          End;
        End;
      End;
    End;
 Until (Current=$FFFF) Or (Counter=255);
 If Match Then Begin
   If (MatchInfo.ModeAttrib[1] And 128=128) Then
     MatchMode:=MatchMode+$4000;
   If (MatchInfo.ModeAttrib[1] And 64=64) Then Begin
     MatchMode:=MatchMode+$8000;
    End;
   VESA_DetectMode:=MatchMode;
  End Else
   VESA_DetectMode:=0;
End;

{  Gets the scanline length in pixels  }
Function VESA_GetScanline : Word;
Var Regs : TRealRegs;
Begin
 Regs.RealEAX:=$4F06;
 Regs.RealEBX:=1;
 RealIntr($10,Regs);
 VESA_GetScanline:=Regs.RealECX;
End;

{  Sets the scanline length to the number of the specified pixels  }
Function VESA_SetScanline(Pixels : Word) : DWord;
Var Regs : TRealRegs;
Begin
 Regs.RealEAX:=$4F06;
 Regs.RealEBX:=0;
 Regs.RealECX:=Pixels;
 RealIntr($10,Regs);
 If (Regs.RealEAX And $0FF) = $4F Then Begin
   VESA_SetScanline:=VESA_GetScanline;
  End;
End;

Procedure VESA_DisableMode(ModeNumber : DWord);
Begin
 With IVS_VESADevice Do Begin
   If ModeNumber>VESA_DevMaxMode Then Exit;
   With DevModeList[ModeNumber] Do Begin
     VMMode:=0;
     VMAvailable:=False;
     VMCopy_Banked:=IVS_DummyProcs;
     VMCopy_Linear:=IVS_DummyProcs;
     VMDoubleBuf:=IVS_VMNotSupport;
     VMVSync:=IVS_VMNotSupport;
    End;
  End;
End;

{  >>> B A C K B U F F E R  T O  S C R E E N  C O P Y  F U N C T I O N S <<<  }

{  BackBuffer -> Screen Copy function using single buffering  }
Procedure VESA_CopySingleBuf;
Begin
 If VESA_VSync Then VESA_WaitRetrace;
 VESA_CopyProc;
End;

{  BackBuffer -> Screen Copy function using double buffering  }
Procedure VESA_CopyDoubleBuf;
Begin
 If VESA_PhysScrNum=0 Then Begin
   VESA_PhysScrAddr:=VESA_PhysScrOneAddr;
   VESA_CopyProc;
   If VESA_VSync Then VESA_WaitRetrace;
   VESA_SetDisplayStart(0,VESA_PhysScrOnePos);
   VESA_PhysScrNum:=1;
  End Else Begin
   VESA_PhysScrAddr:=VESA_PhysScrTwoAddr;
   VESA_CopyProc;
   If VESA_VSync Then VESA_WaitRetrace;
   VESA_SetDisplayStart(0,VESA_PhysScrTwoPos);
   VESA_PhysScrNum:=0;
  End;
End;


{  >>> D E V I C E  D R I V E R  F U N C T I O N S <<<  }

{  This procedure should detect the available mode list, and setup  }
{  the modelist in the device driver record.  }
Function VESA_Detect : Boolean;
Var Counter    : Word;
    ReqMemSize : DWord;
Begin
 VESA_Detect:=False;
 With IVS_VESADevice Do Begin
   If Not DevAvail Then Exit;
   If DevModeNum<>0 Then Begin VESA_Detect:=True; Exit; End;
   DevModeNum:=VESA_DevMaxMode+1;

   {  Setting Modelist  }
   DevModeList:=@VESA_DevModeList;
   For Counter:=0 To DevModeNum-1 Do Begin
     With DevModeList[Counter] Do Begin
       VMMode:=VESA_DetectMode(VMWidth,VMHeight,VMBPP);
       {  If mode not detected, disabling mode  }
       If VMMode=0 Then Begin
         VESA_DisableMode(Counter);
        End Else Begin
         {  Checking linear framebuffer support  }
         If Not Boolean(VMMode And $4000) Then Begin
           VMCopy_Linear:=IVS_DummyProcs;
          End;
         {  Checking banked mode support  }
         If Boolean(VMMode And $8000) Then Begin
           VMCopy_Banked:=IVS_DummyProcs;
          End;

         {  Calculating required memory size  }
         ReqMemSize:=VMWidth*VMHeight;
         Case VMBPP Of
           32    : ReqMemSize:=ReqMemSize*4;
           24    : ReqMemSize:=ReqMemSize*3;
           16,15 : ReqMemSize:=ReqMemSize*2;
          End;

         {  Correcting mode number  }
         VMMode:=VMMode And $3FFF;

         {  Checking for enough video memory, and switching off  }
         {  features not available  }
         If ReqMemSize>VESA_Info.VideoMemorySize*64*1024 Then Begin
           VESA_DisableMode(Counter);
          End Else Begin
           If ReqMemSize*2>VESA_Info.VideoMemorySize*64*1024 Then Begin
             VMDoubleBuf:=IVS_VMNotSupport;
            End;
          End;

        End;
      End;
    End;

   {  Searching best mode  }
   If DevModeList[3].VMAvailable Then DevBestMode:=3 Else {  32bit truecolor  }
   If DevModeList[1].VMAvailable Then DevBestMode:=1 Else {  16bit hicolor  }
   If DevModeList[0].VMAvailable Then DevBestMode:=0 Else {  15bit hicolor  }
   If DevModeList[2].VMAvailable Then DevBestMode:=2 Else {  24bit truecolor  }
   If DevModeList[5].VMAvailable Then DevBestMode:=5 Else {  16bit doubled hicolor  }
   If DevModeList[4].VMAvailable Then DevBestMode:=4 Else {  15bit doubled hicolor  }
   If DevModeList[7].VMAvailable Then DevBestMode:=7 Else {  32bit doubled truecolor  }
   If DevModeList[6].VMAvailable Then DevBestMode:=6 Else {  24bit doubled truecolor  }
    DevBestMode:=$0FFFF; {  No mode available!  }

   If DevBestMode<>$0FFFF Then VESA_Detect:=True;
  End;
End;

{  Inits the specified videomode  }
Function VESA_Init(ModeNumber : DWord; ModeSetup : IVS_TModeSetup) : Boolean;
Var Granular      : DWord;
    BufCopyProcs  : IVS_TCopyProc;
    BufScanLength : DWord;
Begin
 VESA_Init:=False;
 With IVS_VESADevice Do Begin
   {  Checking if modenumber OK.  }
   If ModeNumber>DevModeNum-1 Then Exit;
   If VESA_CurrentMode<>$FFFF Then Exit;

   With DevModeList[ModeNumber] Do Begin
     With ModeSetup Do Begin

       {  Getting VESA mode info, for the specified videomode  }
       VESA_GetModeInfo(VMMode,VESA_ModeInfo);

       {  Selecting banked or framebuffer access  }
       If (MSLinear=IVS_VMEnabled) Or (MSLinear=IVS_VMSupport) Then Begin
         {  Allocating framebuffer memory area  }
         With VESA_ModeInfo Do Begin
           VESA_SegLFB:=Allocate_LDT_Descriptors(1);
           Set_Segment_Base_Address(VESA_SegLFB,Get_Linear_Addr(LFBAddress,VESA_Info.VideoMemorySize*64*1024));
           Set_Segment_Limit(VESA_SegLFB,VESA_Info.VideoMemorySize*64*1024-1);
          End;
         {  Switching mode on with LFB  }
         VESA_SwitchMode(VMMode+$4000);
         {  Setting Copy Procedures Record  }
         BufCopyProcs:=VMCopy_Linear;
        End Else Begin
         {  Calculating window granularity  }
         VESA_WinSize:=VESA_ModeInfo.WinSize*1024;
         Granular:=VESA_ModeInfo.WinSize Div VESA_ModeInfo.WinGranularity;
         Case Granular Of
           32 : VESA_GranShift:=5;
           16 : VESA_GranShift:=4;
            8 : VESA_GranShift:=3;
            4 : VESA_GranShift:=2;
            2 : VESA_GranShift:=1;
            1 : VESA_GranShift:=0;
          End;

         {  Allocating banked memory area (VGA segment from $A0000)  }
         VESA_SegA000:=Allocate_LDT_Descriptors(1);
         Set_Segment_Base_Address(VESA_SegA000,$A000 Shl 4);
         Set_Segment_Limit(VESA_SegA000,$FFFF);

         {  Switching mode on with banked access  }
         VESA_SwitchMode(VMMode);

         {  Getting scanline length  }
         BufScanLength:=VESA_SetScanline(VMWidth);
         Case VMBPP Of
           32    : VESA_ScanLineLength:=BufScanLength*4;
           24    : VESA_ScanLineLength:=BufScanLength*3;
           16,15 : VESA_ScanLineLength:=BufScanLength*2;
          End;

         {  Setting Copy Procedures Record  }
         BufCopyProcs:=VMCopy_Banked;
        End;

       {  Setting double buffering variables  }
       Case ModeNumber Of
         0,1 : Begin
                 VESA_PhysScrOneAddr:=0;         {  Physical Address of screen 1  }
                 VESA_PhysScrTwoAddr:=320*200*2; {  Physical Address of screen 2  }
                End;
         2   : Begin
                 VESA_PhysScrOneAddr:=0;         {  Physical Address of screen 1  }
                 VESA_PhysScrTwoAddr:=320*200*3; {  Physical Address of screen 2  }
                End;
         3   : Begin
                 VESA_PhysScrOneAddr:=0;         {  Physical Address of screen 1  }
                 VESA_PhysScrTwoAddr:=320*200*4; {  Physical Address of screen 2  }
                End;
         4,5 : Begin
                 VESA_PhysScrOneAddr:=640*40*2;  {  Physical Address of screen 1  }
                 VESA_PhysScrTwoAddr:=640*520*2; {  Physical Address of screen 2  }
                End;
         6   : Begin
                 VESA_PhysScrOneAddr:=640*40*3;  {  Physical Address of screen 1  }
                 VESA_PhysScrTwoAddr:=640*520*3; {  Physical Address of screen 2  }
                End;
         7   : Begin
                 VESA_PhysScrOneAddr:=640*40*4;  {  Physical Address of screen 1  }
                 VESA_PhysScrTwoAddr:=640*520*4; {  Physical Address of screen 2  }
                End;
        End;
       VESA_PhysScrOnePos:=0;        {  Y Position of screen 1  }
       VESA_PhysScrTwoPos:=VMHeight; {  Y Position of screen 2  }
       VESA_PhysScrNum:=0;
       VESA_PhysScrAddr:=VESA_PhysScrOneAddr;

       {  Setting Color Order for truecolor modes  }
       If VMBPP>16 Then Begin
         If VESA_ModeInfo.RedFieldPos=0 Then VESA_BGRMode:=0
                                        Else VESA_BGRMode:=1;
        End;

       {  Assign copy function  }
       If ((MSDoubleBuf=IVS_VMEnabled) Or (MSDoubleBuf=IVS_VMSupport)) Then Begin
         IVS_VESADriver.DrvCopy:=@VESA_CopyDoubleBuf;
        End Else Begin
         IVS_VESADriver.DrvCopy:=@VESA_CopySingleBuf;
        End;
       With BufCopyProcs Do Begin
         Case MSDispMode Of
           IVS_DMNormal   : VESA_CopyProc:=CP_Normal;
           IVS_DMScaled   : VESA_CopyProc:=CP_Scaled;
           IVS_DMLaced    : VESA_CopyProc:=CP_Laced;
           IVS_DMBilinear : VESA_CopyProc:=CP_Bilinear;
          End;
        End;

       {  Assign modeflags for easy access from the assembly routines  }
       VESA_VSync:=((MSVSync=IVS_VMEnabled) Or (MSVSync=IVS_VMSupport));

      End;
    End;

  End;

 VESA_CurrentMode:=ModeNumber;
 VESA_CurrentModeSetup:=ModeSetup;
 VESA_Init:=True;
End;

{  Shuts down the current active videomode  }
Function VESA_Close : Boolean;
Begin
 VESA_Close:=False;
 If VESA_CurrentMode=$FFFF Then Exit;

 {  Setting back to textmode  }
 VESA_SwitchMode03h;
 TextMode(LastMode);

 With VESA_CurrentModeSetup Do Begin
   {  Checking for Linear or VGA segment, and then free up the descriptor  }
   If (MSLinear=IVS_VMEnabled) Or (MSLinear=IVS_VMSupport) Then Begin
     Free_LDT_Descriptor(VESA_SegLFB);
    End Else Begin
     Free_LDT_Descriptor(VESA_SegA000);
    End;
  End;

 {  Deassign copy function  }
 IVS_VESADriver.DrvCopy:=@IVS_DummyProc;

 VESA_CurrentMode:=$FFFF;
 VESA_Close:=True;
End;


{  >>> I N I T  C O D E <<<  }

{  Inits the VESA driver structures  }
Procedure IVS_VESADevInit;
Begin
 With IVS_VESADriver Do Begin
   DrvDetect:=@VESA_Detect;
   DrvInit  :=@VESA_Init;
   DrvClose :=@VESA_Close;
   DrvCopy  :=@IVS_DummyProc;
  End;
 IVS_VESADevice.DevDriver:=@IVS_VESADriver;

 {$IFDEF _IVS_VESA_DEBUGMODE_}
  WriteLn('DEV_INIT: Device - ',IVS_VESALongName,' version ',IVS_VESAVersionStr);
 {$ENDIF}

 {  Detecting device...  }
 If VESA_HWDetect Then Begin
   With IVS_VESADevice Do Begin
     With VESA_Info Do Begin
       DevAvail   :=True;
       DevName    :=IVS_VESAName;
       DevDRAM    :=VideoMemorySize*64*1024;
       DevModeNum :=0;
       DevBestMode:=0;
       DevModeList:=Nil;

       {  Collect mode data into the global structure  }
       VESA_DevModeList[0]:=VESA_LowResHiColor15;
       VESA_DevModeList[1]:=VESA_LowResHiColor16;
       VESA_DevModeList[2]:=VESA_LowResTrueColor24;
       VESA_DevModeList[3]:=VESA_LowResTrueColor32;
       VESA_DevModeList[4]:=VESA_HighResHiColor15;
       VESA_DevModeList[5]:=VESA_HighResHiColor16;
       VESA_DevModeList[6]:=VESA_HighResTrueColor24;
       VESA_DevModeList[7]:=VESA_HighResTrueColor32;

       {$IFDEF _IVS_VESA_DEBUGMODE_}
        WriteLn('DEV_INIT:        - OEM String: ',VESA_GetRealString(OEM_NamePtr));
        If VESA_Version>=$0200 Then Begin
          WriteLn('DEV_INIT:        - Product String: ',VESA_GetRealString(ProductNamePtr));
         End;
        WriteLn('DEV_INIT:        - VBE Version: ',Hi(VESA_Version),'.',Lo(VESA_Version),
                ' - RAM Size: ',DevDRAM Div 1024,'K');
       {$ENDIF}
      End;
    End;
  End Else Begin
   IVS_VESADevice.DevAvail:=False;
   {$IFDEF _IVS_VESA_DEBUGMODE_}
    WriteLn('DEV_INIT:        - VESA 1.2+ DETECTION FAILED!');
   {$ENDIF}
  End;
End;

Begin
 VESA_CurrentMode:=$FFFF;
End.

{  IVS_VESA.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }

{  History:  }
{  1.0.2 - Copyright header changes. [2001.07.02 Charlie]                }
{  1.0.1 - Scanline length now set to a proper value after setting a     }
{          videomode. This is required for some buggy BIOSes.            }
{        - Some BIOS returns videomodes without enough memory on the     }
{          card. Added a workaround for this problem.                    }
{          [2001.01.17. Charlie]                                         }
{  1.0.0 - Initial version [2000.08.29. Charlie]                         }
