{Ŀ}
{  IVS_USER.PAS - User Interface Routines                                 }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - GO32V2                                                  }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}
{  User Interface releated procedures, terrible hacked and uncommented  }
{  code, requires a major cleanup. Anyway, it works (mostly:).  }

{$ASMMODE INTEL}
{$MODE FPC}

{$NOTES OFF} {  Enable this if you modify the source!  }
{$HINTS OFF} {  Enable this if you modify the source!  }
Unit IVS_User;

Interface

Procedure IVS_UISetMode80x50;
Procedure IVS_UIDrawSetupBackGround;
Procedure IVS_UIRestoreScreen;
Procedure IVS_UIDrawWindow(X1,Y1,X2,Y2 : Word; UpSide : Boolean);
Procedure IVS_UIWriteCustomSetting(SetCode : Word);
Procedure IVS_UIWriteDisplayMode(ModeCode : Word);

Implementation

Uses IVS_Var,CRT;

Var IVS_UILastMode   : Word;
    BackUpScreen     : Array[0..79,0..49] Of Word;
    BackUpX, BackUpY : Word;
    BackUpWindowMin  : Word;
    BackUpWindowMax  : Word;
    BackUpAttr       : Word;

Procedure IVS_UISetMode80x50;
Var Counter, Counter2 : Word;
Begin
 IVS_UILastMode:=LastMode;
 BackUpX:=WhereX; BackUpY:=WhereY;
 BackUpWindowMin:=WindMin; BackUpWindowMax:=WindMax;
 BackUpAttr:=TextAttr;
 For Counter:=0 To 79 Do Begin
   For Counter2:=0 To 49 Do Begin
     BackUpScreen[Counter,Counter2]:=MemW[$B800:(Counter2*80+Counter)*2];
    End;
  End;
 TextMode(CO80+Font8x8);
 Asm
  MOV AX,3h
  INT 10h
  MOV AX,1112h
  XOR DX,DX
  MOV BX,800h
  MOV CX,256
  INT 10h
 End;
 ClrScr;
 CursorOff;
End;

Procedure IVS_UIHeaderFooter;
Begin
 {  Header  }
 GotoXY(1,1);
 TextColor(White); TextBackGround(Blue);
 ClrEol;
 Write(' ',IVS_Name,' version ',IVS_VersionStr);
 GotoXY(79-Length(IVS_AdditionalVersionStr),WhereY);
 Write(IVS_AdditionalVersionStr);
 {  Footer  }
 GotoXY(1,50);
 ClrEol;
 Write(' IVS Copyright (C) 1998-2001 Karoly ''Charlie'' Balogh and Marton ''mrc!'' Ekler');
End;

Procedure IVS_UIDrawWindow(X1,Y1,X2,Y2 : Word; UpSide : Boolean);
Var Color1, Color2 : Word;
    Counter        : DWord;
Begin
 {  Setting Window Colors  }
 If UpSide Then Begin
   Color1:=White; Color2:=DarkGray;
  End Else Begin
   Color1:=DarkGray; Color2:=White;
  End;
 TextBackGround(LightGray);

 {  Drawing Window  }
 TextColor(Color1);
 GotoXY(X1,Y1); Write(''); {  Upper left corner  }
 For Counter:=X1+1 To X2-1 Do Write(''); {  Top  }
 For Counter:=Y1+1 To Y2-1 Do Begin {  Left  }
   GotoXY(X1,Counter); Write('');
  End;
 GotoXY(X1,Y2); Write(''); {  Lower left corner  }
 TextColor(Color2);
 For Counter:=X1+1 To X2-1 Do Write(''); {  Bottom  }
 Write(''); {  Lower right corner  }
 For Counter:=Y1+1 To Y2-1 Do Begin {  Rigth  }
   GotoXY(X2,Counter); Write('');
  End;
 GotoXY(X2,Y1); Write(''); {  Upper right corner  }

End;

Procedure IVS_UIBackGround;
Begin
 TextColor(DarkGray); TextBackGround(LightGray);
 Window(1,2,80,49);
 ClrScr;
End;

Procedure IVS_UIDrawSetupBackGround;
Begin
 {  Cleaning the screen, setting mode 80x50 and CRT window.  }
 TextColor(LightGray);
 TextBackGround(Black);
 IVS_UISetMode80x50;
 Window(1,1,80,50);

 {  Drawing Header and footer  }
 IVS_UIHeaderFooter;

 {  Drawing the background  }
 IVS_UIBackGround;

 {  Drawing the system window  }
 GotoXY(3,2); TextColor(Black); WriteLn(' System Information:');
 IVS_UIDrawWindow(2,3,78,13,True);

 {  Drawing the features setup window  }
 GotoXY(3,15); TextColor(Black); WriteLn(' Custom Features Setup:');
 IVS_UIDrawWindow(2,16,78,23,True);

 {  Drawing the video mode selection window  }
 GotoXY(3,25); TextColor(Black); WriteLn(' Select Videomode:');
 IVS_UIDrawWindow(2,26,78,47,True);
 IVS_UIDrawWindow(3,27,45,46,False);

End;

Procedure IVS_UIWriteCustomSetting(SetCode : Word);
Begin
 Case SetCode Of
   IVS_VMNotSupport : Begin TextColor(Black);      Write('NOT SUPPORTED'); End;
   IVS_VMSupport    : Begin TextColor(LightBlue);  Write('SUPPORTED    '); End;
   IVS_VMDisabled   : Begin TextColor(LightRed);   Write('DISABLED     '); End;
   IVS_VMEnabled    : Begin TextColor(LightGreen); Write('ENABLED      '); End;
  End;
 TextColor(DarkGray);
End;

Procedure IVS_UIWriteDisplayMode(ModeCode : Word);
Begin
 Case ModeCode Of
   IVS_DMNotSupport : Begin TextColor(Black);      Write('NOT AVAILABLE'); End;
   IVS_DMNormal     : Begin TextColor(LightGreen); Write('NORMAL       '); End;
   IVS_DMScaled     : Begin TextColor(Blue);       Write('SCALED       '); End;
   IVS_DMLaced      : Begin TextColor(LightBlue);  Write('INTERLACED   '); End;
   IVS_DMBilinear   : Begin TextColor(LightCyan);  Write('INTERPOLATED '); End;
  End;
 TextColor(DarkGray);
End;

Procedure IVS_UIRestoreScreen;
Var Counter, Counter2 : Word;
Begin
 TextColor(LightGray);
 TextBackGround(Black);
 TextMode(IVS_UILastMode);
 For Counter:=0 To 79 Do Begin
   For Counter2:=0 To 49 Do Begin
     MemW[$B800:(Counter2*80+Counter)*2]:=BackUpScreen[Counter,Counter2];
    End;
  End;
 Window(Lo(BackUpWindowMin)+1,Hi(BackUpWindowMin)+1,
        Lo(BackUpWindowMax)+1,Hi(BackUpWindowMax)+1);
 GotoXY(BackUpX,BackUpY);
 TextAttr:=BackUpAttr;
End;

Begin
End.

{  IVS_USER.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }

{  History:  }
{  0.0.4 - Copyright comment changes again. [2001.07.02. Charlie]       }
{  0.0.3 - Copyright comment changes [2001.01.17. Charlie]              }
{  0.0.2 - IVS_UIRestoreScreen restores now window size, position and   }
{          cursor color too [2000.10.15 - mrc!]                         }
{  0.0.1 - Initial version [2000.08.29. Charlie]                        }
