
/********************************************************
 *							*
 *							*
 *	SEND. Envoie d'un fichier binaire par port	*
 *	paralelle, protocole "LEO".			*
 *	Version PC->ST 4bits.				*
 *	WATCOM 16bits.					*
 *							*
 *	(C)oderight OXYGENE 1995 by lo.		*
 *							*
 *							*
 ********************************************************/



/***************************************************************************

	Le programme utilise le protocole BI-Directionnel STE<->PC by Leonard

	Voici donc le cablage  la mord moi le noeud que j'ai trouv le plus
	adapt  la liaison...

	(Le port paralelle du ST n'tant retournable qu'en tout ou rien, on
	recoit les donnes en 8 bits par le port joystick numrique du STE !)





  1) Description du protocole.


Le cable doit donc comporter deux prises 15broches  trois ranges pour etre
connectes aux 2 ports joystick numrique STE.

Le STROBE du PC a t mapp sur la broche UP du port 2 (bit 15) pour pouvoir
faire le wait de synchro avec un:

.wait:	move.w	(a0),d0
	bmi.s	.wait
	move.b	d0,(a1)+

Comme D0-D7 sont mappes sur les 8bits de poids faible, on a tout de suite
la donne 8bits dans l'octet faible de D0.


Pour envoyer sur ST, on evoie en paquets de 4bits (Le port PC n'tant pas
retournable ou ne peut rien recevoir par D0-D7). On utilise D7 du ST comme
bit de strobe. (Plus rapide  programmer que de passer par le PSG Yamaha).


Comme toutes ces liaisons sont faites en SYNCHRO, il faut toujours se demerder
pour que la machine qui RECOIT SOIT PLUS RAPIDE QUE CELLE QUI ENVOIE.
Pour que la laison boost il faut simplement faire la routine de reception la
plus rapide possible sur ST et s'arranger  rgler au mieux la vitesse sur PC.

PROBLEMES:
	Des problmes de rebond lors de changements d'tats sur les ports
joystick numriques font que j'ai t oblig de doubler le test du bit de strobe
sur ST pour que cela fonctionne:


.wait:	move.w	(a0),d0
	bmi.s	.wait
	move.w	(a0),d0
	bmi.s	.wait
	move.b	d0,(a1)+


 Voila, le port STE se lit en .W  l'adresse: $00FF9202



							Leonard, OXYGENE.




  2) Description du cable:



	ST			PC


 	   		 Port paralelle.


Port Joystick STE 1    1  STROBE
                      
        4 < 2  D0
        3 < 3  D1
        2 < 4  D2
        1 < 5  D3
                      
    GND 9  19 GND
                      
                         6  D4
                         7  D5
                         8  D6
Port Joystick STE 2      9  D7
                        
        4 <ٳ
        3 <ٳ
        2 <ٳ
        1 <
                      
   UP2 11 <

   GND 19  25 GND



 Port Paralelle ST

    D0  2 > 15 ERROR
    D1  3 > 13 SLCT (Printer OnLine (Selected))
    D2  4 > 12 PE (Paper Error)
    D3  5 > 10 ACK (Acknowledge, Printer Ready)

    D7  9 > 11 BUSY



       25  20 GND






****************************************************************************/


// includes.
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <conio.h>
#include <time.h>
#include <string.h>

typedef	unsigned long	UD;
typedef	long		SD;
typedef unsigned short	UW;
typedef short		SW;
typedef unsigned char	UB;
typedef char		SB;


#define	BLOCK_SIZE	(2048)		// Si modif, a changer aussi sur le ST !
#define DEFAULT_WAIT	(200)

#define	LOAD_ONLY		0
#define	LOAD_AND_RUN	1
#define	BLOCK_RUN		2
#define	BLOCK_SAVE		3
#define	FILE_COPY		4


#define	BLOCK_INFO_SIZE	32

UD	binaryAd;
UW	binaryMode=LOAD_ONLY;
UB	buffer[BLOCK_SIZE];
UB	info_block[BLOCK_INFO_SIZE];
UD	tempo;
char	fileName[_MAX_PATH];

static char tmpDrive[_MAX_DRIVE];
static char tmpDir[_MAX_DIR];
static char tmpFname[_MAX_FNAME];
static char tmpExt[_MAX_EXT];

/********************************************************************
			SECTION CODE
 ********************************************************************/



UD	file_size(FILE *handle)
 {
 UD	size,pos;

	pos=ftell(handle);
	fseek(handle,0,SEEK_END);
	size=ftell(handle);
	fseek(handle,pos,SEEK_SET);
	return size;
}



UW	calc_check(FILE *in,UD size)
 {
 UD	i;
 UW	check;


	printf("Calculating checksum:");
	fflush(stdout);
	check=0;
	for (i=0;i<size;i++) check+=(UB)fgetc(in);
	printf("$%4X\n",check);
	fseek(in,0,SEEK_SET);
	return check;
 }


void	wait(register int t)
 {

	do
	{
	}
	while (--t);

 }



void	paral_send(UB *ptr,register unsigned int size,int timing)
 {
 register int	strobe;
 register UB	data;


 // Version Send 8 bits par ports joystick STE.
	strobe=0;
	do
	{
	  data=*ptr++;
	  outp(0x378,(data));
	  strobe^=1;
	  outp(0x37a,strobe);
	  wait(timing);
	}
	while (--size);

 }




void	send_file(char *name)
 {
 FILE	*in;
 SD	size;
 UD	orgsize;
 int	sload;
 UW	check;
 clock_t	t1,t2;
 float	t3;
 static char tmpName[_MAX_PATH];



	if ((binaryMode==BLOCK_RUN) || (binaryMode==BLOCK_SAVE))
	{

		info_block[10]=(binaryMode>>8)&255;
		info_block[11]=(binaryMode)&255;
		paral_send(info_block,BLOCK_INFO_SIZE,2048);

		printf("Command send.\n");

		return;
	}


	in=fopen(name,"rb");
	if (!in)
	{
	  printf("Unable to open %s\n",name);
	  exit(1);
	}

	orgsize=file_size(in);
	size=orgsize;
	check=calc_check(in,size);

	// Poke la taille a transferer.
	info_block[0]=((size)>>24)&255;
	info_block[1]=((size)>>16)&255;
	info_block[2]=((size)>>8)&255;
	info_block[3]=((size))&255;

	info_block[4]=(check>>8)&255;
	info_block[5]=(check)&255;

	info_block[6]=((binaryAd)>>24)&255;
	info_block[7]=((binaryAd)>>16)&255;
	info_block[8]=((binaryAd)>>8)&255;
	info_block[9]=((binaryAd))&255;

	info_block[10]=(binaryMode>>8)&255;
	info_block[11]=(binaryMode)&255;


	_splitpath(name,NULL,NULL,tmpFname,tmpExt);
	_makepath(tmpName,NULL,NULL,tmpFname,tmpExt);
	strcpy(info_block+16,tmpName);

	paral_send(info_block,BLOCK_INFO_SIZE,2048);



	printf("Sending %ld bytes...\n",size);

	// Wait 1 sec.
	t1=clock();
	while (clock()<(t1+CLOCKS_PER_SEC));

	t1=clock();

	while (size>0)
	{
	  if (size>=BLOCK_SIZE) sload=BLOCK_SIZE;
	  else sload=size;
	  memset(buffer,0,BLOCK_SIZE);
	  fread(buffer,1,sload,in);
	  //putchar('*');
	  fputc('*',stdout);
	  paral_send(buffer,BLOCK_SIZE,tempo);
	  size-=sload;
	}

	printf("\n");

	memset(buffer,0,BLOCK_SIZE);
	paral_send(buffer,BLOCK_SIZE,tempo);


	outp(0x378,0);		// Data clear.
	outp(0x37a,0);		// Strobe clear.


	t2=clock();
	t3=t2-t1;
	t3/=CLOCKS_PER_SEC;

	printf("Sending %ldbytes in %.02f seconds.\n",orgsize,t3);
	printf("(Rate: %3.02f bytes/sec.)\n",((float)orgsize/t3));



 }


void	usage(void)
 {



		printf(	"Usage: STS <command> [pc_file_name] [-options]\n\n"
				"command:\n"
				"\td.......: Download \"pc_file_name\" in ST-Memory.\n"
				"\tr.......: Run \"pc_file_name\" in ST-Memory.\n"
				"\ts.......: Save block \"BLOCK.BIN\" on ST-Disk.\n"
				"\tg.......: GO: run block.\n"
				"\tc.......: file Copy.\n"
				"\n"
				"options:\n"
				"\t-a0xADR...: Specify ST-RAM adress.\n"
				);

		exit(1);
 }



void	CheckArgs(int argc,char **argv)
 {
 int	n=0;
 int	i;
 char	c;


		binaryAd = 0x8000;

		for (i=1;i<argc;i++)
		{
			c=toupper(*argv[i]);
			if ((c=='-') || (c=='/'))
			{
				c=argv[i][1];
				c=toupper(c);
				switch (c)
				{
					case '?':
					case 'H':
						Usage();
						break;
					case 'A':
						sscanf(&argv[i][2],"%lx",&binaryAd);
						if (!binaryAd)
						{
							printf("Wrong adress value.\n");
							usage();
						}
						break;
					default:
						printf("%s:Unknow option.\n\n",argv[i]);
						Usage();
						break;
				}
			}
			else
			{
				n++;
				switch (n)
				{
					case 1:
						switch (c)
						{
							case 'D':
								binaryMode=LOAD_ONLY;
								break;
							case 'R':
								binaryMode=LOAD_AND_RUN;
								break;
							case 'S':
								binaryMode=BLOCK_SAVE;
								break;
							case 'G':
								binaryMode=BLOCK_RUN;
								break;
							case 'C':
								binaryMode=FILE_COPY;
								break;
							default:
								printf("%s:Unknow command.\n\n",argv[i]);
								usage();
						}
					case 2:
						strcpy(fileName,argv[i]);
						break;
					default:
						printf("TOO much args.\n");
						Usage();
				}
			}
		}

		if ((binaryMode==LOAD_ONLY) || (binaryMode==LOAD_AND_RUN) || (binaryMode==FILE_COPY))
		{
			if (n!=2) Usage();
		}
		else
		{
			if (n!=1) Usage();
		}

 }


void	main(int argc,char **argv)
 {

		printf(	"FAST Atari SEND-Command tool.\n"
				"Version 16Bits.\n"
				"(C)OXYGENE 1995 by Leonard.\n\n");

		CheckArgs(argc,argv);

		tempo=DEFAULT_WAIT;

		printf("Tempo assumed: %ld\n",tempo);

		printf("Adress assumed:$%lx\n",binaryAd);

		send_file(fileName);

 }




