/*
 * $Id: exceptions.hpp 149 2007-11-08 23:43:53Z hangman $
 *
 * What We Are
 *
 * Copyright (C) 1994 - 2007 Enver Haase
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */



#ifndef EXCEPTIONS_HPP
#define EXCEPTIONS_HPP
#pragma warning( disable : 4290 )



//
// Includes.
//

#include "main.hpp"



//
// Classes.
//

class GameException : std::exception {
    public:
        static const HRESULT RESULT_UNSET = 0xcafebabe;
        GameException(std::string reason);
        GameException(std::string reason, HRESULT res);
        std::string getReason(void);
        HRESULT getResult();
        const char *what() const throw(); // override virtual function
    private:
        std::string reason;
        HRESULT result;
};


class BitmapCreateError : public GameException {        // make sure "public" is there:
                                                        // otherwise "catch GameError"
                                                        // would not catch this class!!!
    public:
        BitmapCreateError(std::string reason);
};



//
// Functions.
//

/**
 * Throws a GameException with the given message.
 */
void throwException(std::string message) throw (GameException);

/**
 * Throws a GameException with the given message; this exception
 * could be a SurfaceLostException, depending on the DirectDraw
 * result res.
 */
void throwException(std::string message, HRESULT res) throw (GameException);



#endif
