;
; Andreas 'Yup' Schneider's Vertical Blanc Interrupt
;
; VBI working under DOS and WIN95 !!!
;
; Copyright (C) Andreas 'Yup' Schneider. All Rights Reserved. Free for use in any Software.
;
; E-Mail   : yup@mindless.com
;
; Homepage : http://privat.swol.de/AndreasSchneider/
;


.486p

; to do: maybe convert all labels to dd, that no prefixes are needed

_DATA		SEGMENT PARA PUBLIC USE32 'DATA'

	lCalctime			dd	0
	lOldTimeAdd			dd	0
	lOldPMTimeInt		df	0
	WinTimerAusgl		dw	0
	WinTimerAusgl2		dw	0

	_VBLTimerWert		dw	0
	_lFrameCount		dd	0
	_cIfTimerDos		db	0

_DATA		ENDS


_TEXT           SEGMENT PARA PUBLIC USE32 'CODE'
                ASSUME  CS:_TEXT

;*******************************************
; public Functions
;*******************************************
			PUBLIC	TimerIrqInit_
			PUBLIC	TimerIrqClose_
			PUBLIC	CheckDosWinTimer_
			PUBLIC	_cIfTimerDos
			PUBLIC	_lFrameCount
			PUBLIC	_VBLTimerWert


;*******************************************
; check, if Dos or Win. This isn't the best way, but it's some time
; since I did this code and I'm too lazy to change it.
; The important thing is, it works.
;*******************************************
CheckDosWinTimer_:
		cli
		mov	bx,0aff0h
		call	CheckDosWin2
		cmp	al,bh
		jz	CheckIsDos
		mov	_cIfTimerDos,1
		jmp	CID2
CheckIsDos:
		mov	_cIfTimerDos,0
CID2:
		mov	bx,0eff0h
		call	CheckDosWin2
		cmp	_cIfTimerDos,0
		jz	CID3
		cmp	al,bh
		jnz	CIDEND
		mov	_cIfTimerDos,3
		jmp	CIDEND
CID3:		cmp	al,bh
		jz	CIDEND
		mov	_cIfTimerDos,2
CIDEND:
		mov	al,00110110b
		out	43h,al
		mov	al,0
		nop
		out	40h,al
		nop
		nop
		out	40h,al
		sti
		ret


CheckDosWin2:
		mov	al,00110000b
		out	43h,al
		mov	al,bl
		nop
		out	40h,al
		mov	al,bh
		nop
		out	40h,al

		mov	al,00000000b
		out	43h,al
		nop
		nop
		in	al,40h
		mov	ah,al
		nop
		in	al,40h

CheckDW1:	mov	al,00000000b
		out	43h,al
		nop
		nop
		in	al,40h
		mov	bl,al
		nop
		in	al,40h
		cmp	bl,ah
		jz	CheckDW1
		ret



;*******************************************
; calculate VBLTimerWert for actual ScreenMode	; uses Timer2, change to 0
;*******************************************
CheckVBLTime_:
		cli
		in	al,61h
		and	al,0fch
		or	al,01h
		out	61h,al
		mov	dx,3dah
CwaitVBL1:	in	al,dx
		test	al,8
		jnz	CwaitVBL1
CwaitVBL2:	in	al,dx
		test	al,8
		jz	CwaitVBL2
		mov	al,10110100b
		out	43h,al
		mov	al,0
		nop
		out	42h,al
		nop
		nop
		out	42h,al

		mov	ebx,0ff00h
		mov	ecx,lCalctime
		mov	eax,1
		shl	eax,cl
		mov	ecx,eax
CwaitVBL3:	in	al,dx
		test	al,8
		jnz	CwaitVBL3
CwaitVBL4:	in	al,dx
		test	al,8
		jz	CwaitVBL4
		mov	al,10000100b
		out	43h,al
		nop
		nop
		in	al,42h
		mov	bl,al
		nop
		in	al,42h
		cmp	al,bh
		jbe	Cweiter
		add	ebx,010000h
Cweiter:	mov	bh,al
		sub	cl,1
		cmp	cl,0
		jnz	CwaitVBL3

		neg	bx
		mov	ecx,lCalctime
		shr	ebx,cl
		sti
		mov	_VBLTimerWert,bx
		ret


;*******************************************
; Initialise TimerIrq . Parameter 	eax: 0=> calc TimerValue, !=0 => take value
;						ebx: time to calc value 1-8
;*******************************************
TimerIrqInit_:
		mov	_VBLTimerWert,ax
		mov	lCalctime,ebx
		call	CheckDosWinTimer_
		mov	ax,_VBLTimerWert
		cmp	ax,0
		jnz	NoCheck
		call	CheckVBLTime_
NoCheck:
; Get OLD INT PM 08h Vector
		mov	ax,0204h				; Get vector for INT 08h (Timer)
		mov	bl,08h
		int	31h
		mov	DWORD PTR lOldPMTimeInt,edx
		mov	WORD PTR lOldPMTimeInt+4,cx
; Set NEW PM INT 08h Vector
		cli
		mov 	ax,0205h
		cmp	_cIfTimerDos,0
		jz	TisDos				; choose the right IRQ-Handler
		mov	edx,offset cs:TimerIrqWin
		jmp	Tgem
TisDos:	mov	edx,offset cs:TimerIrqDos
Tgem:		mov	cx,cs
		mov	bl,08h
		int	31h
		jc	TimerIniError
; Set new Timer-Value
		mov	bx,_VBLTimerWert
		sub	bx,135
		mov	dx,3dah
TwaitVBL0:	in	al,dx
		test	al,8
		jnz	TwaitVBL0				;wait for VBL
		mov	dx,3dah
TwaitVBL1:	in	al,dx
		test	al,8
		jz	TwaitVBL1
		mov	al,00110100b
		out	43h,al
		mov	ax,bx
		nop
		out	40h,al
		mov	al,ah
		nop
		out	40h,al
		nop
		mov	al,20h				; Send generic EOI to PIC
		out	20h,al
		sti

		mov	lOldTimeAdd,0
		mov	WinTimerAusgl2,32

		mov	eax,0
		ret

TimerIniError:
		mov	eax,1
		ret


;*******************************************
; Restore the TimerIrq 
;*******************************************
TimerIrqClose_:
; Set standart Timer-Value
		cli
		mov	al,00110110b
		out	43h,al
		xor	al,al
		nop
		out	40h,al
		nop
		nop
		out	40h,al
		sti
; Restore OLD PM INT 08h Vector
		mov	ax,0205h				; Set vector for INT 08h (Timer)
		mov	bl,08h
		mov	edx,DWORD PTR lOldPMTimeInt
		mov	cx,WORD PTR lOldPMTimeInt+4
		int	31h
		ret


;*******************************************
; The Timer-Handler for Windows
;*******************************************
TimerIrqWin:
		pushfd
		cli
		push	ds
		push	eax
		push	ebx
		push	edx
		mov	ax,_DATA
		mov	ds,ax

		xor	ebx,ebx
		mov	bx,WinTimerAusgl2
		mov	WinTimerAusgl,bx
		mov	bx,_VBLTimerWert
		mov	dx,3dah
		in	al,dx
		test	al,8
		jz	zue					; wait for VBL
		mov	WinTimerAusgl,0fff0h
		mov	WinTimerAusgl2,1
zue:		sub	bx,WinTimerAusgl
		mov	al,00110100b
		out	43h,al
		mov	ax,bx
		nop
		out	40h,al
		mov	al,ah
		nop
		out	40h,al

		inc	_lFrameCount


		add	lOldTimeAdd,ebx
		cmp	lOldTimeAdd,10000h
		jae	WinOldTimer

		mov	al,20h				; Send generic EOI to PIC
		out	20h,al
		pop	edx
		pop	ebx
		pop	eax
		pop	ds
		sti
		popfd
		iretd   
WinOldTimer:
		sub	lOldTimeAdd,10000h
		pop	edx
		pop	ebx
		pop	eax
		pop	ds
		sti
		popfd
		jmp	cs:lOldPMTimeInt		



;*******************************************
; The Timer-Handler for DOS 
;*******************************************
TimerIrqDos:
		pushfd
		cli
		push	ds
		push	eax
		push	ebx
		push	edx
		mov	ax,_DATA
		mov	ds,ax

		mov	bx,_VBLTimerWert
		sub	bx,35					; you can use a lower value if you want
		mov	dx,3dah
TwaitVBL2:	in	al,dx
		test	al,8
		jz	TwaitVBL2				; wait for VBL
		mov	al,00110100b
		out	43h,al
		mov	ax,bx
		nop
		out	40h,al
		mov	al,ah
		nop
		out	40h,al

		inc	_lFrameCount

		xor	ebx,ebx
		mov	bx,_VBLTimerWert			;this isn't correct at all,but the best solution
		add	lOldTimeAdd,ebx
		cmp	lOldTimeAdd,10000h
		jae	DosOldTimer

		mov	al,20h				; Send generic EOI to PIC
		out	20h,al
		pop	edx
		pop	ebx
		pop	eax
		pop	ds
		sti
		popfd
		iretd   
DosOldTimer:
		sub	lOldTimeAdd,10000h
		pop	edx
		pop	ebx
		pop	eax
		pop	ds
		sti
		popfd
		jmp	cs:lOldPMTimeInt		

_TEXT		ENDS
		END
