/*
The font structure: think it out as a segmented lcd display:
	
	 aa bb
	c  d  e
	c  d  e
	 ff gg
	h  i  j
	h  i  j
	 kk ll
*/   
    
#define Q(a,b,c,d,e,f,g,h,i,j,k,l) \
        a+(b<<1)+(c<<2)+(d<<3)+(e<<4)+(f<<5)+(g<<6)+ \
        (h<<7)+(i<<8)+(j<<9)+(k<<10)+(l<<11)

short phont[]={

Q(	/* space 32 */
 0,0,
0,0,0,
 0,0,
0,0,0,
 0,0 ),

Q(	/* ! 33 */
  1,1,
 1,0,1,
  1,1,
 0,0,0,
  1,1 ),

Q(	/* " 34 */
 0,0,
1,0,1,
 0,0,
0,0,0,
 0,0 ),
 
Q(	/* # 35 .. let's give up :) */
 1,1,
1,1,1,
 1,1,
1,1,1,
 1,1 ),
 
Q(	/* $ 36 */
 1,1,
1,1,0,
 1,1,
0,1,1,
 1,1 ),

Q(	/* % 37 */
 1,0,
0,0,1,
 1,1,
1,0,0,
 0,1 ),
 
Q(	/* ~ 38	not ascii */
 0,1,
1,0,1,
 1,0,
0,0,0,
 0,0 ),
 
Q(	/* ' 39 */
 0,0,
0,0,1,
 0,1,
0,0,0, 
 0,0 ),
 
Q(	/* ( 40 */
 1,1,
1,0,0,
 0,0,
1,0,0,
 1,1 ),
 
Q(	/* ) 41 */
 1,1,
0,0,1,
 0,0,
0,0,1,
 1,1 ),
 
Q(	/* * 42 */
 0,0,
1,1,1,
 1,1,
1,1,1,
 0,0 ),
 
Q(	/* + 43 */
 0,0,
0,1,0,
 1,1,
0,1,0,
 0,0 ),

Q(	/* , 44 */
 0,0,
0,0,0,
 0,0,
0,0,1,
 0,1 ),
 
Q(	/* - 45 */
 0,0,
0,0,0,
 1,1,
0,0,0,
 0,0 ),
 
Q(	/* . 46 */
 0,0,
0,0,0,
 0,0,
0,0,0,
 1,1 ),

Q(	/* / 47 */
 0,0,
0,0,1,
 1,1,
1,0,0,
 0,0 ),
 
Q(	/* 0 48 */
 1,1,
1,0,1,
 0,0,
1,0,1,
 1,1 ),
 
Q(	/* 1 49 */
 0,0,
0,1,0,
 0,0,
0,1,0,
 0,0 ),
 
Q(	/* 2 50 */
 1,1,
0,0,1,
 1,1,
1,0,0,
 1,1 ),
 
Q(	/* 3 51 */
 1,1,
0,0,1,
 0,1,
0,0,1,
 1,1 ),
 
Q(	/* 4 52 */
 0,0,
1,0,1,
 1,1,
0,0,1,
 0,0 ),

Q(	/* 5 53 */
 1,1,
1,0,0,
 1,1,
0,0,1,
 1,1 ),
 
Q(	/* 6 54 */
 1,1,
1,0,0,
 1,1,
1,0,1,
 1,1 ),
 
Q(	/* 7 55 */
 1,1,
1,0,1,
 0,0, 
0,0,1,
 0,0 ),
 
Q(	/* 8 56 */
 1,1,
1,0,1,
 1,1,
1,0,1,
 1,1 ),
 
Q(	/* 9 57 */
 1,1,
1,0,1,
 1,1,
0,0,1,
 1,1 ),
 
Q(	/* : 58 */
 1,1,
0,0,0,
 0,0,
0,0,0,
 1,1 ),
 
Q(	/* ; 59 */
 1,1,
0,0,0,
 0,0,
0,0,1,
 0,1 ),
 
Q(	/* < 60 */
 0,1,
0,1,0,
 1,0,
0,1,0,
 0,1 ),
 
Q(	/* = 61 */
 1,1,
0,0,0,
 0,0,
0,0,0,
 1,1 ),
 
Q(	/* > 62 */
 1,0,
0,1,0,
 0,1,
0,1,0,
 1,0 ),
 
Q(	/* ? 63 */
 1,1,
0,0,1,
 1,1,
0,0,0,
 1,1 ),
  
Q(	/* @ 64 */
 1,1,
1,1,1,
 0,1,
1,1,1,
 1,0 ),
 
Q(	/* A 65 */
 1,1,
1,0,1,
 1,1,
1,0,1,
 0,0 ),
 
Q(	/* B 66 */
 1,0,
1,1,0,
 1,1,
1,0,1,
 1,1 ),
 
Q(	/* C 67 */
 1,1,
1,0,1,
 0,0,
1,0,0,
 1,1 ),
 
Q(	/* D 68 */
 0,0,
0,0,1,
 1,1,
1,0,1,
 1,1 ),
 
Q(	/* E 69 */
 1,1,
1,0,0,
 1,0,
1,0,0,
 1,1 ),
 
Q(	/* F 70 */
 1,1,
1,0,0,
 1,0,
1,0,0,
 0,0 ),
 
Q(	/* G 71 */
 1,1,
1,0,0, 
 0,1,
1,0,1,
 1,1 ),
 
Q(	/* H 72 */
 0,0,
1,0,1,
 1,1,
1,0,1,
 0,0 ),
 
Q(	/* I 73 */
 1,1,
0,1,0,
 0,0,
0,1,0,
 1,1 ),
 
Q(	/* J 74 */
 0,0,
0,0,1,
 0,0,
1,0,1,
 1,1 ),
 
Q(	/* K 75 */
 0,1,
1,1,0,
 1,1,
1,0,1,
 0,0 ),

Q(	/* L 76 */
 1,0,
1,0,0,
 0,0,
1,0,0,
 1,1 ),

Q(	/* M 77 */
 1,1,
1,1,1,
 0,0,
1,0,1,
 0,0 ),

Q(	/* N 78 */
 1,1,
1,0,1,
 0,0,
1,0,1,
 0,0 ),
 
Q(	/* O 79 */
 1,1,
1,0,1,
 0,0,
1,0,1,
 1,1 ),
 
Q(	/* P 80 */
 1,1,
1,0,1,
 1,1,
1,0,0,
 0,0 ),
 
Q(	/* Q 81 */
 1,1,
1,0,1,
 0,0,
1,1,1,
 1,1 ),
 
Q(	/* R 82 */
 1,1,
1,0,1,
 1,1,
1,1,0,
 0,1 ),
 
Q(	/* S 83 */
 1,1,
1,0,0,
 1,1,
0,0,1,
 1,1 ),
 
Q(	/* T 84 */
 1,1,
1,1,1,
 0,0,
0,1,0,
 0,0 ), 

Q(	/* U 85 */
 0,0,
1,0,1,
 0,0,
1,0,1,
 1,1 ),
 
Q(	/* V 86 */
 0,0,
1,0,1,
 1,0,
0,1,1,
 0,1 ),
 
Q(	/* W 87 */
 0,0,
1,0,1,
 0,0,
1,1,1,
 1,1 ),

Q(	/* X 88 */
 0,0,
0,1,1,
 1,1,
1,1,0,
 0,0 ),

Q(	/* Y 89 */
 0,0,
1,0,1,
 1,1,
0,1,0,
 0,0 ),
 
Q(	/* Z 90 */
 1,1,
0,0,1,
 1,1,
1,0,0,
 1,1 ),
  
}; 

#undef Q
