class Ribbon
{
  Ribbon()
  {
    _doRenderHead = true;
    _doUpdate = true;
    
    _tailTexID = -1;
    _headTexID = -1;

    _tailSize = 20;
    _tailRenderSegments = 0;
    _tailWidth = 1.0;

    _initPos = new Vector3();

    _headSize = 8*3;
    _head = new Vector3();
    _right = new Vector3();

    _add = new Vector3();

    _age = 0;
    _agePer = 0;
    _timeToLive = 100;
    _invTimeToLive = 1.0 / _timeToLive;

    _facets = 8;

    _colour = new Vector4( 1, 1, 1, 1 );

    yTable = new int[_tailSize];
    for( int i=0; i<_tailSize; i++ )
      yTable[i] = i * (_facets+1);
    _vertices = new Vector3[ ((_tailSize)*(_facets+1)) ];
    _normals = new Vector3[ ((_tailSize)*(_facets+1)) ];
    for( int i=0; i<((_tailSize)*(_facets+1)); i++ )
    {
      _vertices[i] = new Vector3();
      _normals[i] = new Vector3();
    }
  }

  Ribbon( int tailSize, float tailWidth, float headSize, boolean renderHead )
  {
    _doRenderHead = renderHead;
    _doUpdate = true;

    _tailSize = tailSize;
    _tailRenderSegments = 0;
    _tailWidth = tailWidth;

    _initPos = new Vector3();

    _headSize = headSize;
    _head = new Vector3();
    _right = new Vector3();

    _add = new Vector3();    

    _age = 0;
    _agePer = 0;
    _timeToLive = 100;
    _invTimeToLive = 1.0 / _timeToLive;

    _colour = new Vector4( 1, 1, 1, 1 );

    _facets = 8;
    
    yTable = new int[_tailSize];
    for( int i=0; i<_tailSize; i++ )
      yTable[i] = i * (_facets+1);
    _vertices = new Vector3[ ((_tailSize)*(_facets+1)) ];
    _normals = new Vector3[ ((_tailSize)*(_facets+1)) ];
    for( int i=0; i<((_tailSize)*(_facets+1)); i++ )
    {
      _vertices[i] = new Vector3();
      _normals[i] = new Vector3();
    }
  }


  void setHeadTexture( int id )
  {
    _headTexID = id;
    //_headTex = new XTexture( file );
  }

  void setTailTexture( int id )
  {
    _tailTexID = id;
    //_headTex = new XTexture( file );
  }


  void computeTail()
  {
    if( _tail == null )
    {
      _tail = new Vector3[_tailSize];
    }

    for( int i=0; i<_tailSize; i++ )
    {
      _tail[i] = new Vector3();
      _tail[i] = _head.copy();
    }
  }

  boolean isDead()
  {
    if( _age >= _timeToLive )
      return true;

    return false;
  }


  void setTimeToLive( float t )
  {
    _timeToLive = t;
    _invTimeToLive = 1.0 / _timeToLive;
  }

  void setHeadY( float y )
  {
    _head.y = y;
    _initPos = _head.copy();
  }

  void setHead( float x, float y )
  {
    _head.set( x, y, 0 );
    _initPos = _head.copy();
  }

  void setHead( float x, float y, float z )
  {
    _head.set( x, y, z );
    _initPos = _head.copy();
  }

  void setHead( Vector3 h )
  {
    _head = h;
    _initPos = _head.copy();
  }

  void addHead( float x, float y )
  {
    if( _doUpdate )
      _head.add( x, y, 0 );
  }

  void addHead( float x, float y, float z )
  {
    if( _doUpdate )
      _head.add( x, y, z );
  }

  void addHead( Vector3 a )
  {
    if( _doUpdate )
      _head.add( a );
  }

  void renderHead( boolean f )
  {
    _doRenderHead = f;
  }


  void update( float time )
  {
    if( _age < _timeToLive )
    {
      if( _tailRenderSegments < _tailSize )
      {
        for( int i=_tailRenderSegments; i>0; i-- )
        {
          _tail[i] = _tail[i-1];
        }
        _tail[0] = _head.copy();
        
        if( _tailRenderSegments < _tailSize-1 )
          _tailRenderSegments++;
      }
      else
      {
        _doUpdate = false;
      }
    }
    
    if( _doUpdate )
    {    
      _head.add( _add );
    
      _age += 0.05;
//    _age ++;
      _agePer = _age * _invTimeToLive;
    }
  }


  void updateJelly( float time )
  {
    //if( _age < _timeToLive )
    {
      //if( _tailRenderSegments < _tailSize )
      {
        for( int i=_tailRenderSegments; i>0; i-- )
        {
          _tail[i] = _tail[i-1];
        }
        _tail[0] = _head.copy();
        
        if( _tailRenderSegments < _tailSize-1 )
          _tailRenderSegments++;
      }
      /*else
      {
        _doUpdate = false;
      }*/
    }
    
    //if( _doUpdate )
    {    
      _head.add( _add );
    
      _age += 0.05;
//    _age ++;
      _agePer = _age * _invTimeToLive;
    }
  }


  void draw( float time )
  {
//    if( _age < _timeToLive )
    {
/*      if( _doRenderHead )
      {
        _headTex.enable();
        renderHead();
        _headTex.disable();
      }*/

      //
      // Render shadow tail
      //
      vgl.gl().glDisable( GL.GL_CULL_FACE );
      vgl.setDepthWrite( true );
      vgl.setDepthMask( false );
//      vgl.setAlphaBlend();

      renderTail();
//      renderTailCylinder();

      // Stop head motion once it completes its growth      
      if( !_doUpdate )
        _head = _tail[0].copy();


      // Render base of each tail (not needed for most cases)
//      renderBase();
    }
  }

  void drawCylinderRibbon( float time )
  {
    if( _age < _timeToLive )
    {
      vgl.gl().glDisable( GL.GL_CULL_FACE );
      vgl.setDepthWrite( true );
//      gl.setDepthMask( false );
      vgl.setAlphaBlend();

      renderTailCylinder();
    }
  }

/*  void renderBase()
  {
    activeNoteTex.enable();

    // Draw activator center 
    gl.setAlphaBlend();
    gl.fill( 1, 1.0-_agePer );
    gl.pushMatrix();
    gl.translate( _initPos );
    gl.rotateX( 90 );
    gl.quad( 20 );
    gl.popMatrix();

    activeNoteTex.disable();
  }*/


  void renderHead()
  {
    // Draw activator center 
    if( _headTexID >= 0 )
    {
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _headTexID );
    }

    vgl.setDepthWrite( false );
    vgl.setAlphaBlend();
    vgl.fill( 1, 1.0-_agePer );
    vgl.pushMatrix();
    vgl.translate( _head.x, _head.y, _head.z );
    vgl.rotateX( 90 );
    vgl.quad( _headSize );
    vgl.popMatrix();

    vgl.setDepthWrite( true );
  }


  void renderTail()
  {
    float per;
    float xp, yp, zp;
    float xOff, yOff, zOff;

/*    if( _tailTexID > 0 )
    {
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _tailTexID );
    }*/
    
    /*for ( int i=0; i<_tailSize; i++ )
    {
      per = 1.0 - (((float)i/(float)(_tailSize)));
      //per *= 0.5;
      
      vgl.fill( 1.0, _agePer );
//      gl.fill( 1.0, 1.0-_agePer );
      vgl.pushMatrix();
      vgl.translate( _tail[i] );
      vgl.quad( 1*per );
      vgl.popMatrix();
    }*/
    vgl.enableTexture( false );
    
    ///////////////////////////////////////
    ///////////////////////////////////////
    vgl.gl().glBegin( GL.GL_QUAD_STRIP );
    for ( int i=0; i<_tailSize-1; i++ )
//    int hlen = (int)((_tailSize-1)*0.5);
//    for ( int ii=-hlen; ii<hlen; ii++ )
    {
//      int i = ii+hlen;
//      per           = 1.0 - (((float)(abs(ii))/(float)(hlen)));    

      //per = (((float)i/(float)(_tailSize)));
      per = 1.0-(((float)i/(float)(_tailSize)));
      //per *= 0.5;

      if( per > 1.0 ) per = 1.0;
      if( per < 0.0 ) per = 0.0;

      float ownAlpha = (((float)i/(float)(_tailSize)));

      if( i < _tailSize-1 )
      {
        Vector3 dir = Vector3.sub( _tail[i+1], _tail[i] );
        dir.normalize();
//        Vector3 V = dir.cross( new Vector3( 0, 0, 1 ) );
        Vector3 V = dir.cross( new Vector3( 0, 1, 0 ) );
        V.normalize();
        Vector3 N = dir.cross( V );
        N.normalize();
        V = N.cross( dir );
        //V = dir.cross( N );
        V.normalize();

        _right = V.copy();

        xp = _tail[i].x;
        yp = _tail[i].y;
        zp = _tail[i].z;

        xOff = V.x * _tailWidth * per;// * 0.15;
        yOff = V.y * _tailWidth * per;// * 0.15;
        zOff = V.z * _tailWidth * per;// * 0.15;

        vgl.gl().glColor4f( 1, 1, 1, per * ownAlpha ); //1.0-_agePer );

        //      vgl.gl().glNormal3f( N.x, N.y, N.z );
        //      vgl.gl().glTexCoord2f( 0, 0 );
        vgl.gl().glVertex3f( xp - xOff, yp - yOff, zp - zOff );
        //      vgl.gl().glNormal3f( N.x, N.y, N.z );
        //      vgl.gl().glTexCoord2f( 1, 1 );
        vgl.gl().glVertex3f( xp + xOff, yp + yOff, zp + zOff );
      }
    }
    vgl.gl().glEnd();
    
  }


  void renderTailColor( float r, float g, float b, float a )
  {
    float per;
    float xp, yp, zp;
    float xOff, yOff, zOff;

/*    if( _tailTexID > 0 )
    {
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _tailTexID );
    }*/
    
    /*for ( int i=0; i<_tailSize; i++ )
    {
      per = 1.0 - (((float)i/(float)(_tailSize)));
      //per *= 0.5;
      
      vgl.fill( 1.0, _agePer );
//      gl.fill( 1.0, 1.0-_agePer );
      vgl.pushMatrix();
      vgl.translate( _tail[i] );
      vgl.quad( 1*per );
      vgl.popMatrix();
    }*/
    //vgl.enableTexture( false );
    
    ///////////////////////////////////////
    ///////////////////////////////////////
    vgl.gl().glBegin( GL.GL_QUAD_STRIP );
    for ( int i=0; i<_tailSize-1; i++ )
//    int hlen = (int)((_tailSize-1)*0.5);
//    for ( int ii=-hlen; ii<hlen; ii++ )
    {
//      int i = ii+hlen;
//      per           = 1.0 - (((float)(abs(ii))/(float)(hlen)));    

      per = (((float)i/(float)(_tailSize)));
      //per = 1.0-(((float)i/(float)(_tailSize)));
      //per *= 0.5;

      if( per > 1.0 ) per = 1.0;
      if( per < 0.0 ) per = 0.0;

      float ownAlpha = (((float)i/(float)(_tailSize)));

      if( i < _tailSize-1 )
      {
        Vector3 dir = Vector3.sub( _tail[i+1], _tail[i] );
        dir.normalize();
//        Vector3 V = dir.cross( new Vector3( 0, 0, 1 ) );
        Vector3 V = dir.cross( new Vector3( 0, 1, 0 ) );
        V.normalize();
        Vector3 N = dir.cross( V );
        N.normalize();
        V = N.cross( dir );
        //V = dir.cross( N );
        V.normalize();

        _right = V.copy();

        xp = _tail[i].x;
        yp = _tail[i].y;
        zp = _tail[i].z;

        xp = _tail[i].x + _right.x*sin(i*.12+time*2)*3*(_tailSize-i)*.053;
        yp = _tail[i].y - 3;// + _right.y*sin(i*.2+time*8)*3*(_tailSize-i)*.053;
        zp = _tail[i].z + _right.z*sin(i*.12+time*2)*3*(_tailSize-i)*.053;

//        xp = _tail[i].x + _right.x*sin(i*.2+time*8)*3*(_tailSize-i)*.053;
//        yp = _tail[i].y + _right.y*sin(i*.2+time*8)*3*(_tailSize-i)*.053;
//        zp = _tail[i].z + _right.z*sin(i*.2+time*8)*3*(_tailSize-i)*.053;


        xOff = V.x * _tailWidth * per;// * 0.15;
        yOff = V.y * _tailWidth * per;// * 0.15;
        zOff = V.z * _tailWidth * per;// * 0.15;

        vgl.gl().glColor4f( r, g, b, 1.0-_agePer );

        //      vgl.gl().glNormal3f( N.x, N.y, N.z );
        //      vgl.gl().glTexCoord2f( 0, 0 );
        vgl.gl().glVertex3f( xp - xOff, yp - yOff, zp - zOff );
        //      vgl.gl().glNormal3f( N.x, N.y, N.z );
        //      vgl.gl().glTexCoord2f( 1, 1 );
        vgl.gl().glVertex3f( xp + xOff, yp + yOff, zp + zOff );
      }
    }
    vgl.gl().glEnd();
    
  }


  void renderTailFromBuffer( Vector3[] buf, int tailWidth, float addA )
  {
    float per;
    float xp, yp, zp;
    float xOff, yOff, zOff;
    
    int size = buf.length;

/*    flare3.enable();
    for ( int i=0; i<size; i++ )
    {
      per = 1.0 - (((float)i/(float)(size)));
      per *= 0.5;
      
      gl.fill( 1.0, _agePer );
//      gl.fill( 1.0, 1.0-_agePer );
      gl.pushMatrix();
      gl.translate( buf[i] );
      gl.quad( 10*per );
      gl.popMatrix();
    }*/
    vgl.enableTexture( false );
    
    ///////////////////////////////////////
    ///////////////////////////////////////
    vgl.gl().glBegin( GL.GL_QUAD_STRIP );
    for ( int i=0; i<size; i++ )
//    int hlen = (int)((size-1)*0.5);
//    for ( int ii=-hlen; ii<hlen; ii++ )
    {
//      int i = ii+hlen;
//      per = 1.0 - (((float)(abs(ii))/(float)(hlen)));    

//      per = (((float)i/(float)(_tailSize)));
      per = 1.0-(((float)i/(float)(_tailSize)));
      //per *= 0.5;

      if( per > 1.0 ) per = 1.0;
      if( per < 0.0 ) per = 0.0;

      float ownAlpha = (((float)i/(float)(_tailSize)));

      if( i < size-1 )
      {
        //Vector3 perp0 = Vector3.sub( ploc[j][i], ploc[j][i+1] );
        Vector3 dir = Vector3.sub( buf[i+1], buf[i] );
        dir.normalize();
        Vector3 V = dir.cross( new Vector3( 0, 0, 1 ) );
//        Vector3 V = dir.cross( new Vector3( 0, 1, 0 ) );
        V.normalize();
        Vector3 N = dir.cross( V );
        N.normalize();
        V = N.cross( dir );
        //V = dir.cross( N );
        V.normalize();

        _right = V.copy();

        xp = buf[i].x;
        yp = buf[i].y;
        zp = buf[i].z;

//        xp = _tail[i].x + _right.x*sin(i*.2+time*8)*3*(_tailSize-i)*.053;
//        yp = _tail[i].y + _right.y*sin(i*.2+time*8)*3*(_tailSize-i)*.053;
//        zp = _tail[i].z + _right.z*sin(i*.2+time*8)*3*(_tailSize-i)*.053;


        xOff = V.x * tailWidth * per;// * 0.15;
        yOff = V.y * tailWidth * per;// * 0.15;
        zOff = V.z * tailWidth * per;// * 0.15;


        vgl.gl().glColor4f( 1, 1, 1, per * ownAlpha * addA );
//        vgl.gl().glColor4f( 0, 0, 0, _agePer );
        //      vgl.gl().glColor4f( 1-per, 1-per, 1-per, per );
//        vgl.gl().glColor4f( 0, 0, 0, 1-_agePer );
//        vgl.gl().glColor4f( 1, 1, 1, 1.0-_agePer );
        //      vgl.gl().glColor4f( per, per, per, per );
        //      vgl.gl().glColor4f( per, per*.5, 1.5 - per, per);

        //      vgl.gl().glNormal3f( N.x, N.y, N.z );
        //      vgl.gl().glTexCoord2f( 0, 0 );
        vgl.gl().glVertex3f( xp - xOff, yp - yOff, zp - zOff );
        //      vgl.gl().glNormal3f( N.x, N.y, N.z );
        //      vgl.gl().glTexCoord2f( 1, 1 );
        vgl.gl().glVertex3f( xp + xOff, yp + yOff, zp + zOff );
      }
    }
    vgl.gl().glEnd();
  }



  void renderTailCylinder()
  {
    float invsteps = 1.0 / (float)(_tailSize);
    float invfacets = 1.0 / (float)(_facets+1);

//    float pi2OverSteps = TWO_PI / _tailSize;
    float pi2OverFacets = TWO_PI / (_facets+1);
//    float pi2MulInvsteps = TWO_PI * invsteps;
    float pi2MulInvfacets = TWO_PI * invfacets;
    
//    float _p = 5;
//    float _q = 5;
//    float _scale = 20;
//    float _thickness = 10;

    ///////////////////////////////////////
    ///////////////////////////////////////
    for ( int j=0; j<_tailRenderSegments-1; j++ )
    {
      
/*    activeNoteTex.enable();
    // Draw activator center 
    gl.setAlphaBlend();
    gl.setDepthWrite( false );
    gl.fill( .3 );//, 1.0-_agePer );
    gl.pushMatrix();
    gl.translate( _tail[j].x, -115, _tail[j].z );
    gl.rotateX( 90 );
    gl.quad( 15 );
    gl.popMatrix();
    activeNoteTex.disable();*/
      
    float per = (((float)(j+1)/(float)(_tailSize)));
      
      // first point
//      float Pp = _p * j * pi2MulInvsteps;
//      float Qp = _q * j * pi2MulInvsteps;
//      float r = (.5f * (2 + (float)sin(Qp))) * _scale;
      Vector3 center = new Vector3();
/*      center.x = r * (float)cos(Pp);
      center.y = r * (float)cos(Qp);
      center.z = r * (float)sin(Pp);*/
      center = _tail[j].copy();

      // next point
//      Pp = _p * (j+1) * pi2MulInvsteps;
//      Qp = _q * (j+1) * pi2MulInvsteps;
//      r = (.5f * (2 + (float)sin(Qp))) * _scale;
      Vector3 nextPoint = new Vector3();
/*      nextPoint.x = r * (float)cos(Pp);
      nextPoint.y = r * (float)cos(Qp);
      nextPoint.z = r * (float)sin(Pp);*/
      nextPoint = _tail[j+1].copy();

      // get TBN matrix for transformation
      Vector3 T = new Vector3();
      T.x = nextPoint.x - center.x;
      T.y = nextPoint.y - center.y;
      T.z = nextPoint.z - center.z;

      Vector3 N = new Vector3();
      N.x = nextPoint.x + center.x;
      N.y = nextPoint.y + center.y;
      N.z = nextPoint.z + center.z;

      Vector3 B = new Vector3();
      B = T.cross( N );//cross( T, N );
      N = B.cross( T );//cross( B, T );

      // normalize vectors
      B.normalize();
      N.normalize();


      // go through facets and tweak a bit with some distortions
      for( int i=0; i<_facets+1; i++ )
      {
        float x = (sin(i * pi2OverFacets) * _tailWidth * per);
        float y = (cos(i * pi2OverFacets) * _tailWidth * per);
/*        // distort knot along the curve
        if( _displaces != 0.0 )
        {
          x *= (1 + (sin(_dispoffset + _displaces * j * pi2OverSteps) * _dispscale));
          y *= (1 + (cos(_dispoffset + _displaces * j * pi2OverSteps) * _dispscale));
        }*/

        int idx = j*_facets + i;
//        int idx = yTable[j] + i;
        _vertices[ idx ].x = N.x * x + B.x * y + center.x;
        _vertices[ idx ].y = N.y * x + B.y * y + center.y;
        _vertices[ idx ].z = N.z * x + B.z * y + center.z;

        // get vertex normal
        _normals[ idx ].x = _vertices[ idx ].x - center.x;
        _normals[ idx ].y = _vertices[ idx ].y - center.y;
        _normals[ idx ].z = _vertices[ idx ].z - center.z;
        // normalize
        _normals[ idx ].normalize();
      }

      // duplicate sideways vertices/normals
/*      _vertices[j*(_facets+1) + _facets].x = _vertices[j*(_facets+1) + 0].x;
      _vertices[j*(_facets+1) + _facets].y = _vertices[j*(_facets+1) + 0].y;
      _vertices[j*(_facets+1) + _facets].z = _vertices[j*(_facets+1) + 0].z;
      _normals[j*(_facets+1) + _facets].x  = _normals[j*(_facets+1) + 0].x;
      _normals[j*(_facets+1) + _facets].y  = _normals[j*(_facets+1) + 0].y;
      _normals[j*(_facets+1) + _facets].z  = _normals[j*(_facets+1) + 0].z;*/
      _vertices[j*(_facets) + _facets].x = _vertices[j*(_facets) + 0].x;
      _vertices[j*(_facets) + _facets].y = _vertices[j*(_facets) + 0].y;
      _vertices[j*(_facets) + _facets].z = _vertices[j*(_facets) + 0].z;
      _normals[j*(_facets) + _facets].x  = _normals[j*(_facets) + 0].x;
      _normals[j*(_facets) + _facets].y  = _normals[j*(_facets) + 0].y;
      _normals[j*(_facets) + _facets].z  = _normals[j*(_facets) + 0].z;
      
    }

/*    // duplicate vertices/normals. to get a closed surface
    for( int i=0; i<_facets+1; i++ )
    {
        _vertices[yTable[_tailSize-1] + i].x = _vertices[i].x;
        _vertices[yTable[_tailSize-1] + i].y = _vertices[i].y;
        _vertices[yTable[_tailSize-1] + i].z = _vertices[i].z;
        _normals[yTable[_tailSize-1] + i].x  = _normals[i].x;
        _normals[yTable[_tailSize-1] + i].y  = _normals[i].y;
        _normals[yTable[_tailSize-1] + i].z  = _normals[i].z;        
    }
    // first are last as well
    _vertices[yTable[_tailSize-1] + _facets].x = _vertices[0].x;
    _vertices[yTable[_tailSize-1] + _facets].y = _vertices[0].y;
    _vertices[yTable[_tailSize-1] + _facets].z = _vertices[0].z;
    _normals[yTable[_tailSize-1] + _facets].x  = _normals[0].x;
    _normals[yTable[_tailSize-1] + _facets].y  = _normals[0].y;
    _normals[yTable[_tailSize-1] + _facets].z  = _normals[0].z;*/


    // Increase color as it grows
//    _colour.x += 0.01;
//    _colour.y += 0.01;
//    _colour.z += 0.01;


    int facets = _facets;
    int j = 2;
/*      vgl.gl().glBegin( GL.GL_TRIANGLE_STRIP );
      for( int i=0; i<facets+1; i++ )
      {
        vgl.gl().glColor4f( _colour.x, _colour.y, _colour.z,  (i/(float)facets) );//-_agePer );
//        vgl.gl().glColor4f( _colour.x-_agePer, _colour.y-_agePer, _colour.z-_agePer, 1 );//-_agePer );
        
        vgl.gl().glNormal3f( _normals[i+j*(facets)].x, _normals[i+j*(facets)].y, _normals[i+j*(facets)].z );
        vgl.gl().glVertex3f( _head.x, _head.y, _head.z );

        vgl.gl().glColor4f( _colour.x, _colour.y, _colour.z, (i/(float)facets) );
        vgl.gl().glNormal3f( _normals[i+(j+1)*(facets)].x, _normals[i+(j+1)*(facets)].y, _normals[i+(j+1)*(facets)].z );
        vgl.gl().glVertex3f( _vertices[i+(j+1)*(facets)].x, _vertices[i+(j+1)*(facets)].y, _vertices[i+(j+1)*(facets)].z );
      }      
      vgl.gl().glEnd();
*/

    for ( j=0; j<_tailSize-1; j++ )
    {
      vgl.gl().glBegin( GL.GL_TRIANGLE_STRIP );
      for( int i=0; i<facets+1; i++ )
      {
        vgl.gl().glColor4f( _colour.x, _colour.y, _colour.z, _colour.w );
//        vgl.gl().glColor4f( _colour.x-_agePer, _colour.y-_agePer, _colour.z-_agePer, 1 );//-_agePer );
        vgl.gl().glNormal3f( _normals[i+j*(facets)].x, _normals[i+j*(facets)].y, _normals[i+j*(facets)].z );
        vgl.gl().glVertex3f( _vertices[i+j*(facets)].x, _vertices[i+j*(facets)].y, _vertices[i+j*(facets)].z );

        vgl.gl().glColor4f( _colour.x, _colour.y, _colour.z, _colour.w );
        vgl.gl().glNormal3f( _normals[i+(j+1)*(facets)].x, _normals[i+(j+1)*(facets)].y, _normals[i+(j+1)*(facets)].z );
        vgl.gl().glVertex3f( _vertices[i+(j+1)*(facets)].x, _vertices[i+(j+1)*(facets)].y, _vertices[i+(j+1)*(facets)].z );
      }      
      vgl.gl().glEnd();
    }
  }


  void reset( Vector3 newPos, float ttl )
  {
    setHead( newPos );
    computeTail();
    setTimeToLive( ttl );
    _tailRenderSegments = 0;
    _age = 0;
    _doUpdate = true;  
    
    if( random(100) > 50 )
      _colour.set( 1, 1, 1, 1 );
    else
      _colour.set( 0, 0, 0, 1 );

  }


  int _facets;
  int[] yTable;
  Vector3[] _vertices;
  Vector3[] _normals;
  
  //XTexture _headTex;
  int _headTexID;
  int _tailTexID;
  
  Vector4  _colour;

  boolean _doRenderHead;
  boolean _doUpdate;

  float _age;
  float _agePer;
  float _timeToLive;
  float _invTimeToLive;

  Vector3 _initPos;

  float _headSize;
  Vector3 _head;
  Vector3 _right;

  Vector3  _add;

  float _tailWidth;
  int  _tailRenderSegments;    // counts number of tail segments to render  
  int  _tailSize;
  Vector3[] _tail;
}
