class LandTriangle
{
  int a, b, c;
  
  Vector3 _normal;
}


class Landscape
{
  Vector3 eye, target;
  
  vitamin.math.Matrix localMatrix;
  vitamin.math.Matrix invCamMatrix;

  boolean _useList;
  int _callListID;
  boolean _callListCompiled;

  float _gridScaleX;
  float _gridScaleZ;
  float _heightScale;
  int _numCells;
  Vector3[] _map;
  int[] _indices;
  Vector3[] _vertexNormals;
  Vector3[] _vertexTexCoords;
  
  Vector3[] _grassOffset;

  LandTriangle[] _triangles;

  XTexture _landTex;

//  CG diffspec;
//  ShaderCGFX diffspec;
  int diffspecID;

  float _alpha;

  GL _gl;


  Landscape( GL gl, float scaleX, float scaleZ, float h, int numCells )
  {
    _gl = gl;

    _useList = true;

    eye = new Vector3();
    target = new Vector3();

    localMatrix = new vitamin.math.Matrix();
    localMatrix.identity();

    writelog( "land - load tex" );
    _landTex = new XTexture( "fur_color2.jpg" );

    writelog( "land - load shader" );
//    diffspec = new CG( vgl.gl() );
//    diffspec.loadFXFromFile( dataPath("diffusespecular.cgfx") );
    diffspecID = vgl.addEffectFromFile( dataPath("diffusespecular.cgfx") );
    
    _gridScaleX = scaleX;
    _gridScaleZ = scaleZ;
    _heightScale = h;
    _numCells = numCells;
    _alpha = 1.0;

    writelog( "land - load data" );    
    _vertexTexCoords = new Vector3[numCells*numCells];
    _grassOffset = new Vector3[(numCells)*(numCells)];

    int i, j;
    if( _map != null ) _map = null;
    _map = new Vector3[numCells*numCells];
    for( j=0; j<numCells; j++) 
    {
      for( i=0; i<numCells; i++) 
      {
        _vertexTexCoords[i+j*numCells] = new Vector3();
        _vertexTexCoords[i+j*numCells].x = (float)i*5 / (float)numCells;
        _vertexTexCoords[i+j*numCells].y = (float)j*5 / (float)numCells;

        _grassOffset[i+j*numCells] = new Vector3();
        _grassOffset[i+j*numCells].x = random( -100, 100 );
        _grassOffset[i+j*numCells].y = 0;
        _grassOffset[i+j*numCells].z = random( -100, 100 );
        
        _map[i+j*numCells] = new Vector3();
        _map[i+j*numCells].x = (numCells*_gridScaleX*0.5) - i * _gridScaleX;
        _map[i+j*numCells].z = (numCells*_gridScaleZ*0.5) - j * _gridScaleZ;

        _map[i+j*numCells].y = ((noise(j*.2, i*.1) * _heightScale) - (sqrt(_map[i+j*numCells].x*_map[i+j*numCells].x+_map[i+j*numCells].z*_map[i+j*numCells].z) * 0.125));
        //_map[i+j*numCells].y = ((noise(i*.1, j*.2) * _heightScale) - (sqrt(_map[i+j*numCells].x*_map[i+j*numCells].x+_map[i+j*numCells].z*_map[i+j*numCells].z) * 0.125));

        //_map[i+j*sizee].y = sin(i*0.1+j*0.2)+cos(i*2.2-j*0.1) * heightscale;// - (sqrt(_map[i+j*a.width].x*_map[i+j*a.width].x+_map[i+j*a.width].z*_map[i+j*a.width].z) * 0.5);
      }
    }


    writelog( "land - compute triangle indices" );    
    // compute triangle indices
    _indices = new int[numCells*numCells*3*2];
    int index = 0;
    for(j=0; j<numCells-1; j++) 
    {
      for(i=0; i<numCells-1; i++) 
      {
         int a1 = i+j*_numCells;
         int a2 = (i+1)+j*_numCells;
         int a3 = i+(j+1)*_numCells;
         int a4 = (i+1)+(j+1)*_numCells;

         _indices[index] = a1;
         index++;
         _indices[index] = a3;
         index++;
         _indices[index] = a2;
         index++;  

         _indices[index] = a2;
         index++;
         _indices[index] = a3;
         index++;
         _indices[index] = a4;
         index++;  
      }
    }
    
    _triangles = new LandTriangle[(numCells-1)*(numCells-1)*2];
    int triIndex = 0;
    for(j=0; j<numCells-1; j++) 
    {
      for(i=0; i<numCells-1; i++) 
      {
         int a1 = i+j*_numCells;
         int a2 = (i+1)+j*_numCells;
         int a3 = i+(j+1)*_numCells;
         int a4 = (i+1)+(j+1)*_numCells;
        
         _triangles[triIndex] = new LandTriangle();
         _triangles[triIndex].a = a1;
         _triangles[triIndex].b = a3;
         _triangles[triIndex].c = a2;
         _triangles[triIndex+1] = new LandTriangle();
         _triangles[triIndex+1].a = a2;
         _triangles[triIndex+1].b = a3;
         _triangles[triIndex+1].c = a4;
         triIndex += 2;
      }
    }
    
    writelog( "land - compute normals" );
    computeNormals();

    writelog( "land - use list" );
    if( _useList )
    {
      _callListCompiled = false;
      _callListID = vgl.gl().glGenLists( 1 );
      renderLandscape();
    }

    writelog( "land - end init" );
  }
  
  
  void computeNormals()
  {
    int i=0;
    
    Vector3[] tmpNormals = new Vector3[ _triangles.length ];
    for( i=0; i<_triangles.length; i++ )
    {
     // println( i + ": " + _triangles[i].a );
      Vector3 v1 = _map[ _triangles[i].a ].copy();
      Vector3 v2 = _map[ _triangles[i].b ].copy();
      Vector3 v3 = _map[ _triangles[i].c ].copy();
      
      Vector3 e1 = Vector3.sub( v2, v1 );
      Vector3 e2 = Vector3.sub( v3, v1 );
      
      Vector3 n = Vector3.cross( e1, e2 );
      tmpNormals[ i ] = n.copy();
      n.normalize();
      
      _triangles[i]._normal = n.copy();
    }
    
    //
    // Compute vertex normals
    //
    // Take average from adjacent face normals.
    // TODO. find coplanar faces or get weighted normals.
    // One could also use the smooth groups from 3ds to compute normals. we'll see about that. 
    // this will have to work for now.
    //
    _vertexNormals = new Vector3[ _map.length ];
    
    Vector3 vn = new Vector3();
    int num = 0;    
    for( int vi=0; vi<_map.length; vi++ )
    {
      Vector3 vertex = _map[ vi ];

      vn.set( 0, 0, 0 );

      for( int fi=0; fi<_triangles.length; fi++ )
      {
    	  LandTriangle f = _triangles[ fi ];

    	  // Does this face shares vertex ?
    	  if( vi == f.a || vi == f.b || vi == f.c )
    	  {
	    num++;
	    vn.add( tmpNormals[fi] );  // add un-normalized face normals that share current vertex
	  }
       }

       if( num > 1 ) vn.mul( 1.0f/(float)num );
       vn.normalize();

       // Save vertex normals
      _vertexNormals[vi] = vn.copy();
    }

    // Release temp memory 
    tmpNormals = null; 	    
  }
  
/*  // Get height value at position x,z on the landscape
  float getHeight( float x, float z )
  {
    int xIdx = (int)(x / _gridScaleX);
    int zIdx = (int)(z / _gridScaleZ);
    xIdx += _numCells/2;
    zIdx += _numCells/2;
    
    //println( xIdx + ", " + zIdx + " at height: " + _map[xIdx+zIdx*_numCells].y );
    if( xIdx < 0 || xIdx >= _numCells ) return -99999;
    if( zIdx < 0 || zIdx >= _numCells ) return -99999;
    
    return _map[xIdx+zIdx*_numCells].y;
  }
*/
/*  public float GetHeight( float x, float z ) 
  { 
    if (_map == null) return -99999; 
 
    int xIdx = (int)(x / _gridScaleX);
    int zIdx = (int)(z / _gridScaleZ);
    xIdx += _numCells/2;
    zIdx += _numCells/2;
    if( xIdx < 0 || xIdx >= _numCells ) return -99999;
    if( zIdx < 0 || zIdx >= _numCells ) return -99999;

    float xNormalized = (x % tileScale) / _gridScaleX; 
    float zNormalized = (z % tileScale) / _gridScaleZ; 

    float topHeight = lerp( heightField.GetHeight(tileX, tileZ), heightField.GetHeight(tileX + 1, tileZ), xNormalized ); 

//      positionX += FullMapSizeX * 0.5f; 
//      positionZ += FullMapSizeZ * 0.5f; 
//      float tileScale = heightField.ScaleX; 
//      uint tileX = (uint)(positionX / tileScale); 
//      uint tileZ = (uint)(positionZ / tileScale); 
//      float xNormalized = (positionX % tileScale) / tileScale; 
//      float zNormalized = (positionZ % tileScale) / tileScale; 
//      float topHeight = MathHelper.Lerp(heightField.GetHeight(tileX, tileZ), heightField.GetHeight(tileX + 1, tileZ), xNormalized); 
//      float bottomHeight = MathHelper.Lerp(heightField.GetHeight(tileX, tileZ + 1), heightField.GetHeight(tileX + 1, tileZ + 1), xNormalized); 
//      return MathHelper.Lerp(topHeight, bottomHeight, zNormalized); 
  } */

  float InterpolatedValue( float xp, float yp ) 
  {
/*    float xIdxf = (xPos / (float)_gridScaleX);
    float zIdxf = (yPos / (float)_gridScaleZ);
    int xIdx = (int)(xPos / (float)_gridScaleX);
    int zIdx = (int)(yPos / (float)_gridScaleZ);
    xIdx += _numCells/2;
    zIdx += _numCells/2;

    float dx = xIdxf - xIdx;
    float dy = zIdxf - zIdx;

    //println( xIdx + ", " + zIdx + " at height: " + _map[xIdx+zIdx*_numCells].y );
    if( xIdx < 0 || xIdx >= _numCells ) return -99999;
    if( zIdx < 0 || zIdx >= _numCells ) return -99999;

    float p00 = _map[xIdx+zIdx*_numCells].y;
    float p10 = _map[(xIdx+1)+zIdx*_numCells].y;
    float p01 = _map[xIdx+(zIdx+1)*_numCells].y;
    float p11 = _map[(xIdx+1)+(zIdx+1)*_numCells].y;
*/
    int xPos = (int)(xp / _gridScaleX);
    int yPos = (int)(yp / _gridScaleZ);
    xPos += _numCells/2;
    yPos += _numCells/2;

    int x = (int)Math.floor( xPos );
    int y = (int)Math.floor( yPos );
    float dx = xPos - x;
    float dy = yPos - y;    
    if( x < 0 || x >= _numCells || y < 0 || y >= _numCells ) 
    {
      System.err.println( "(Landscape)   Position outside of the terrain area. ERROR!" );
      return -99999;
    }

/*    float p00 = getHeight( x, y );
    float p10 = getHeight( x+1, y );
    float p01 = getHeight( x, y+1 );
    float p11 = getHeight( x+1, y+1 );*/
    float p00 = _map[x+y*_numCells].y;
    float p10 = _map[(x+1)+y*_numCells].y;
    float p01 = _map[x+(y+1)*_numCells].y;
    float p11 = _map[(x+1)+(y+1)*_numCells].y;
    
    float h0 = p00 * (1 - dy) + p01 * dy;
    float h1 = p10 * (1 - dy) + p11 * dy;
    float hei = h0 * (1 - dx) + h1 * dx;
    
    //println( xp + ", " + yp );
    //println( p00 + ", " + p10 + ", " + p01 + ", " + p11 );
    //println( "res: " + hei );
    
    return hei;
  }
  
  void setAlpha( float a )
  {
    if( a < 1.0 ) 
      _alpha = a;
    else
      _alpha = 1.0;
  }

  void draw()
  {
    //vgl.pushMatrix();
    //vgl.rotateY( 90 );

    vgl.setShader( diffspecID );
    vgl.setTextureParameter( "ColorSampler", _landTex.getId() );
    vgl.setParameter3f( "cameraPos", eye );
    vgl.setParameter4f( "lightPos", lightPos );
    vgl.setParameter4f( "fogColor", fogColor );
    vgl.setParameter1f( "fogDensity", fogDensity );
    vgl.setParameter1f( "kC", kC );
    vgl.setParameter1f( "kL", kL );
    vgl.setParameter1f( "kQ", kQ );
    vgl.setParameter1f( "specularLevel", 16 );
    vgl.setParameter1f( "useSpecular", 1 );
    
    vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX );
    vgl.setMatrixParameterSemantic( "MODELVIEW", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.IDENTITY_MATRIX );
    vgl.setMatrixParameterSemantic( "VIEWINVERSE", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.INVERSE_MATRIX );
    vgl.setMatrixParameterSemantic( "VIEWINVERSETRANSPOSE", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.INVERSE_TRANSPOSE_MATRIX );
    vgl.setMatrixParameterSemantic( "WORLD", localMatrix.getArray() );
    vgl.setMatrixParameterSemantic( "WORLDTOCAMERA", invCamMatrix.getArray() );
    CGpass pass = ((ShaderCGFX)vgl.getActiveShader()).setFirstPass( "Technique_DiffuseSpecular" );
    CgGL.cgSetPassState( pass );     
  
/*    CGpass pass = diffspec.getTechniqueFirstPass( "Technique_DiffuseSpecular" );
    //CGpass pass = diffspec.getTechniqueFirstPass( "Technique_DiffuseSpecularNoTexture" );
    diffspec.setTextureParameter( "ColorSampler", _landTex.getId() );
    diffspec.setParameter3f( "cameraPos", eye );
    diffspec.setParameter4f( "lightPos", lightPos );
    diffspec.setParameter4f( "fogColor", fogColor );
    diffspec.setParameter1f( "fogDensity", fogDensity );
    diffspec.setParameter1f( "kC", kC );
    diffspec.setParameter1f( "kL", kL );
    diffspec.setParameter1f( "kQ", kQ );
    diffspec.setParameter1f( "specularLevel", 16 );
    diffspec.setParameter1f( "useSpecular", 1 );

    diffspec.setParameter4x4fBySemantic( "WorldViewProjection", CgGL.CG_GL_MODELVIEW_PROJECTION_MATRIX, CgGL.CG_GL_MATRIX_IDENTITY );
    diffspec.setParameter4x4f( "view", CgGL.CG_GL_MODELVIEW_MATRIX, CgGL.CG_GL_MATRIX_IDENTITY );
    diffspec.setParameter4x4f( "viewI", CgGL.CG_GL_MODELVIEW_MATRIX, CgGL.CG_GL_MATRIX_INVERSE );
    diffspec.setParameter4x4f( "viewIT", CgGL.CG_GL_MODELVIEW_MATRIX, CgGL.CG_GL_MATRIX_INVERSE_TRANSPOSE );
    diffspec.setParameter4x4f( "WorldXf", localMatrix );
    diffspec.setParameter4x4f( "W2C", invCamMatrix );
    CgGL.cgSetPassState( pass );*/

    renderLandscape();

    CgGL.cgResetPassState( pass );
    vgl.disableShader();

    //vgl.popMatrix();
  }

  void renderLandscape()
  {
    // If the list is compiled and everything is ok, render
    if( _useList && _callListID > 0 && _callListCompiled )
    {
      vgl.gl().glCallList( _callListID );
      return;
    }

    if( _useList && _callListID > 0 && !_callListCompiled )
    {
      vgl.gl().glNewList( _callListID, GL.GL_COMPILE ); 
    }

    //
    // render the landscape
    //
     // render!
     int index = 0;
     _gl.glBegin( GL.GL_TRIANGLES );
     for( int i=0; i<_triangles.length; i+=1 )
     {
         Vector3 v1 = _map[ _triangles[i].a ].copy();
         Vector3 v2 = _map[ _triangles[i].b ].copy();
         Vector3 v3 = _map[ _triangles[i].c ].copy();

         Vector3 uv1 = _vertexTexCoords[ _triangles[i].a ].copy();
         Vector3 uv2 = _vertexTexCoords[ _triangles[i].b ].copy();
         Vector3 uv3 = _vertexTexCoords[ _triangles[i].c ].copy();

         //Vector3 n = _triangles[i]._normal;
         Vector3 n1 = _vertexNormals[_triangles[i].a];
         Vector3 n2 = _vertexNormals[_triangles[i].b];
         Vector3 n3 = _vertexNormals[_triangles[i].c];

         //_gl.glColor4f( 1, 1, 1, 1 );
//         float colmul = 3;
//         _gl.glColor4f( (6/255.0)*colmul*_alpha, (13/255.0)*colmul*_alpha, (23/255.0)*colmul*_alpha, 1*_alpha );
//         float colmul = 4.0;
//         _gl.glColor4f( (1/255.0)*colmul*_alpha, (36/255.0)*colmul*_alpha, (36/255.0)*colmul*_alpha, 1*_alpha );

         float colmul = 9.0 - (noise(eye.z*0.2, time*0.01)*0.3*9);
         _gl.glColor4f( ((1*gamma)/255.0)*colmul*_alpha, ((13*gamma)/255.0)*colmul*_alpha, ((36*gamma)/255.0)*colmul*_alpha, 1*_alpha );
         //_gl.glColor4f( (1/255.0)*colmul*_alpha, (7/255.0)*colmul*_alpha, (20/255.0)*colmul*_alpha, 1*_alpha );

//         float colmul = 0.6;
//         _gl.glColor4f( .1*colmul*_alpha, .1*colmul*_alpha, 0.04+1*colmul*_alpha, 1*colmul*_alpha );

         _gl.glNormal3f( n1.x, n1.y, n1.z );
         _gl.glTexCoord2f( uv1.x, uv1.y );
         _gl.glVertex3f( v1.x, v1.y, v1.z );

         _gl.glNormal3f( n2.x, n2.y, n2.z );
         _gl.glTexCoord2f( uv2.x, uv2.y );
         _gl.glVertex3f( v2.x, v2.y, v2.z );

         _gl.glNormal3f( n3.x, n3.y, n3.z );
         _gl.glTexCoord2f( uv3.x, uv3.y );
         _gl.glVertex3f( v3.x, v3.y, v3.z );
     }
     _gl.glEnd();


    // End display list
    if( _useList && _callListID > 0 && !_callListCompiled )
    {
      vgl.gl().glEndList();
      _callListCompiled = true;
    }
  }

} // end class
