import vitamin.fx.*;


class GrassComparator implements Comparator
{
  public final int compare( Object a, Object b )
  {
     float z1 = ((GrassLine)a).origin.z;
     float z2 = ((GrassLine)b).origin.z;
//    float z1 = ((Vector3)a).z;
//    float z2 = ((Vector3)b).z;

    if( z1 > z2 )  return 1;
    else return -1;
  }
}


class GrassScene //extends Effect
{
  int _numGrass;
  GrassLine[] _grassLines;

  GrassComparator comparator;
  ArrayList _grassList;
//  ArrayList _grassListViewSpace;  
  
  XTexture grassTexture;
//  XTexture flare3;
  
  Vector3 eye, target;
  vitamin.math.Matrix camMatrix;

  FloatBuffer _grassSegPos;
  FloatBuffer _grassSegTexCoords;
  FloatBuffer _grassSegColor;


  GrassScene()
  {
  }
/*

  boolean Init( GL gl )
  {}
  
  void Render( float time )
  {}
  
  void Release()
  {}
*/  
  void init( int num )
  {
    eye = new Vector3();
    target = new Vector3();
    camMatrix = new vitamin.math.Matrix();    
    
    grassTexture = new XTexture( "flare3.png" );
    
    comparator = new GrassComparator();
    _grassList = new ArrayList();
//    _grassListViewSpace = new ArrayList();
    
    int numberOfElements = num;
    
    _numGrass = num;
    _grassLines = new GrassLine[_numGrass];
    for( int i=0; i<_grassLines.length; i++ )
    {
      _grassLines[i] = new GrassLine();
      //_grassLines[i].loadSegmentTexture( "flare2.png", 2 );
      _grassLines[i].setLeafTextureSize( random(8, 30) );

      // this is for the same landscape camera
      int numSegments = 15;
      numberOfElements += numSegments;
      
      _grassLines[i].init( i, new Vector3( random(-1850, 1350), random(1600, 2000), random(-1350,100)), numSegments, random(500, 1500) );
//      _grassLines[i].init( i, new Vector3( random(-2850, 2350), random(2000, 2500), random(-1550,300)), 15, random(500, 1550) );
//      _grassLines[i].init( i, new Vector3( random(-2850, 2350), random(2000, 2500), random(-1550,0)), 15, random(500, 1550) );

      // this is for own camera
      //_grassLines[i].init( i, new Vector3( random(-2850, 2350), random(500, 1000), random(-1550,320)), 15, random(500, 1550) );

      // Set flare texture
      _grassLines[i]._headTexID = grassTexture.getId();
 
      // Add to array
      _grassList.add( _grassLines[i] );
    }    
    
    _grassSegPos = BufferUtil.newFloatBuffer(numberOfElements*18);
    _grassSegPos.rewind();

    _grassSegTexCoords = BufferUtil.newFloatBuffer(numberOfElements*12);
    _grassSegTexCoords.rewind();

    _grassSegColor = BufferUtil.newFloatBuffer(numberOfElements*24);
    _grassSegColor.rewind();
  }

  void draw( float time )
  {
/*    // Sort grasslines
    _grassListViewSpace.clear();
    for( int i=0; i<_grassList.size(); i++ )
    {
      Vector3 v0 = ((GrassLine)_grassList.get(i)).origin;
      Vector3 v1 = Vector3.transform( v0, camMatrix );
      _grassListViewSpace.add( new Vector3Order(v1, i) );
    }
    Collections.sort( _grassListViewSpace, comparator );*/
    Collections.sort( _grassList, comparator );

    
    vgl.setDepthMask( true );
    vgl.setDepthWrite( true );
    vgl.setAdditiveBlend();
    
    int index = 0;
    int indexc = 0;
    int indextc = 0;
    int numSegs = 0;
    for( int i=0; i<_grassList.size(); i++ )
    {
      //int idx = ((Vector3Order)_grassListViewSpace.get(i)).idx;
      //GrassLine ll = (GrassLine)_grassList.get( idx );
      GrassLine ll = (GrassLine)_grassList.get( i );

      numSegs += ll.numSegments;

      float xs = ll.leafTextureSize;
      float ys = ll.leafTextureSize;
      for( int si=0; si<ll.numSegments; si++ )
      {        
        Vector3 pos = ll.renderPoints[si];

        xs = ll.leafTextureSize*(time*0.01)*((sin(time*.952+ll.id+si*0.2)));
        ys = ll.leafTextureSize*(time*0.01)*((sin(time*.952+ll.id+si*0.2)));

        // TRI 1
        _grassSegPos.put( index+0, pos.x-xs );
        _grassSegPos.put( index+1, pos.y+ys );
        _grassSegPos.put( index+2, pos.z );
        _grassSegPos.put( index+3, pos.x+xs );
        _grassSegPos.put( index+4, pos.y+ys );
        _grassSegPos.put( index+5, pos.z );
        _grassSegPos.put( index+6, pos.x-xs );
        _grassSegPos.put( index+7, pos.y-ys );
        _grassSegPos.put( index+8, pos.z );
        _grassSegTexCoords.put( indextc+0, 0 );
        _grassSegTexCoords.put( indextc+1, 0 );
        _grassSegTexCoords.put( indextc+2, 1 );
        _grassSegTexCoords.put( indextc+3, 0 );
        _grassSegTexCoords.put( indextc+4, 0 );
        _grassSegTexCoords.put( indextc+5, 1 );
        _grassSegColor.put( indexc+0, 1*gamma );
        _grassSegColor.put( indexc+1, 1*gamma );
        _grassSegColor.put( indexc+2, 1*gamma );
        _grassSegColor.put( indexc+3, 1*gamma );
        _grassSegColor.put( indexc+4, 1*gamma );
        _grassSegColor.put( indexc+5, 1*gamma );
        _grassSegColor.put( indexc+6, 1*gamma );
        _grassSegColor.put( indexc+7, 1*gamma );
        _grassSegColor.put( indexc+8, 1*gamma );
        _grassSegColor.put( indexc+9, 1*gamma );
        _grassSegColor.put( indexc+10, 1*gamma );
        _grassSegColor.put( indexc+11, 1*gamma );
  
        // TRI 2
        _grassSegPos.put( index+9, pos.x+xs );
        _grassSegPos.put( index+10, pos.y+ys );
        _grassSegPos.put( index+11, pos.z );
        _grassSegPos.put( index+12, pos.x+xs );
        _grassSegPos.put( index+13, pos.y-ys );
        _grassSegPos.put( index+14, pos.z );
        _grassSegPos.put( index+15, pos.x-xs );
        _grassSegPos.put( index+16, pos.y-ys );
        _grassSegPos.put( index+17, pos.z );
        _grassSegTexCoords.put( indextc+6, 1 );
        _grassSegTexCoords.put( indextc+7, 0 );
        _grassSegTexCoords.put( indextc+8, 1 );
        _grassSegTexCoords.put( indextc+9, 1 );
        _grassSegTexCoords.put( indextc+10, 0 );
        _grassSegTexCoords.put( indextc+11, 1 );
        _grassSegColor.put( indexc+12, 1*gamma );
        _grassSegColor.put( indexc+13, 1*gamma );
        _grassSegColor.put( indexc+14, 1*gamma );
        _grassSegColor.put( indexc+15, 1*gamma );
        _grassSegColor.put( indexc+16, 1*gamma );
        _grassSegColor.put( indexc+17, 1*gamma );
        _grassSegColor.put( indexc+18, 1*gamma );
        _grassSegColor.put( indexc+19, 1*gamma );
        _grassSegColor.put( indexc+20, 1*gamma );
        _grassSegColor.put( indexc+21, 1*gamma );
        _grassSegColor.put( indexc+22, 1*gamma );
        _grassSegColor.put( indexc+23, 1*gamma );
        

        index += 18; // 6 vertices of 3 components = 18      
        indexc += 24; // 6 vertices of 4 components = 24
        indextc += 12;   // 6 vertices of 2 components = 12
      }
      
      ll.draw( time );
      ll.update( time + i*4 );
    }

    grassTexture.enable();
    vgl.fill( 1, 1 );

    _grassSegPos.rewind();
    _grassSegColor.rewind();
    _grassSegTexCoords.rewind();
    vgl.gl().glEnableClientState( GL.GL_VERTEX_ARRAY );
    vgl.gl().glEnableClientState( GL.GL_COLOR_ARRAY ); 
    vgl.gl().glEnableClientState( GL.GL_TEXTURE_COORD_ARRAY ); 
    vgl.gl().glVertexPointer( 3, GL.GL_FLOAT, 0, _grassSegPos );
    vgl.gl().glColorPointer( 4, GL.GL_FLOAT, 0, _grassSegColor );
    vgl.gl().glTexCoordPointer( 2, GL.GL_FLOAT, 0, _grassSegTexCoords );
    vgl.gl().glDrawArrays( GL.GL_TRIANGLES, 0, numSegs*3*2 );//*numSegs );
    vgl.gl().glDisableClientState( GL.GL_VERTEX_ARRAY );
    vgl.gl().glDisableClientState( GL.GL_COLOR_ARRAY ); 
    vgl.gl().glDisableClientState( GL.GL_TEXTURE_COORD_ARRAY ); 
    
    grassTexture.disable();
  }
  
}  // end class
