import java.nio.*;
import javax.media.opengl.*;
//import com.sun.opengl.util.*;
import processing.opengl.*;


//
// based on article: http://ogltotd.blogspot.com/2006/12/render-to-texture.html
//

class FBO
{
  FBO( int width, int height, boolean depthOnly )
  {
    _gl = vgl.gl();

/*    int[] maxAttach = new int[1];
    maxAttach[0] = 0;
    _gl.glGetIntegerv( GL.GL_MAX_RENDERBUFFER_SIZE_EXT, maxAttach, 0 );
    println( "maxattach: " + maxAttach[0] );
    int[] colorBufferCount = new int[1];
    colorBufferCount[0] = 0;
    _gl.glGetIntegerv( GL.GL_MAX_COLOR_ATTACHMENTS_EXT, colorBufferCount, 0 );
    println( "max colorbuffers attachments: " + colorBufferCount[0] );*/

    // Creating arrays for FBO and depth&stencil buffer.
    FBO = new int[1];
    FBO[0] = 0;
    depthStencilBuffer = new int[1];
    depthStencilBuffer[0] = 0; 
    
    _width = width;
    _height = height;
    _depthOnly = depthOnly;
  }

  void init()
  {
    _gl.glGenFramebuffersEXT( 1, FBO, 0 );   
    errcheck();
    println( "FBO id: " + FBO[0] );
    //bind();
    //errcheck();
  }

  void attachTexture( int attachment, int texTarget, int texId )
  {
    _gl.glFramebufferTexture2DEXT( GL.GL_FRAMEBUFFER_EXT, attachment, texTarget, texId, 0 ); 
    errcheck();
    
    if( _depthOnly )
    {
      // No color buffer to draw to or read from
      println( "depth only texture!" );
      _gl.glDrawBuffer( GL.GL_NONE );
      _gl.glReadBuffer( GL.GL_NONE );
    }
  }

  void attachRenderBuffer( int w, int h )
  {
//    if( depthStencilBuffer[0] > 0 ) return;   

    // initialize depth+stencil renderbuffer
    _gl.glGenRenderbuffersEXT( 1, depthStencilBuffer, 0 );    
    errcheck();
    println( "RenderBuffer id: " + depthStencilBuffer[0] );
    
    _gl.glBindRenderbufferEXT( GL.GL_RENDERBUFFER_EXT, depthStencilBuffer[0] );
    errcheck();
    _gl.glRenderbufferStorageEXT( GL.GL_RENDERBUFFER_EXT, GL.GL_DEPTH_COMPONENT24, w, h );
    errcheck();
    _gl.glFramebufferRenderbufferEXT( GL.GL_FRAMEBUFFER_EXT, GL.GL_DEPTH_ATTACHMENT_EXT, GL.GL_RENDERBUFFER_EXT, depthStencilBuffer[0] );
    errcheck();
    _gl.glBindRenderbufferEXT( GL.GL_RENDERBUFFER_EXT, depthStencilBuffer[0] );
    _gl.glFramebufferRenderbufferEXT( GL.GL_FRAMEBUFFER_EXT, GL.GL_STENCIL_ATTACHMENT_EXT, GL.GL_RENDERBUFFER_EXT, depthStencilBuffer[0] );
  }

  void validate()
  {
    int stat = _gl.glCheckFramebufferStatusEXT( GL.GL_FRAMEBUFFER_EXT );
    switch( stat )
    {
      case GL.GL_FRAMEBUFFER_COMPLETE_EXT:
        println( "GL_FRAMEBUFFER_COMPLETE_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_UNSUPPORTED_EXT:
        println( "GL_FRAMEBUFFER_UNSUPPORTED_EXT" );
        break;
      default:
        println( "Unknown" );
        break;
    }
  }

  void bind()
  { 
//    _gl.glBindTexture( GL.GL_TEXTURE_2D, 0 );
    _gl.glBindFramebufferEXT( GL.GL_FRAMEBUFFER_EXT, FBO[0] );
    //_gl.glFramebufferTexture2DEXT( GL.GL_FRAMEBUFFER_EXT, GL.GL_COLOR_ATTACHMENT0_EXT, GL_TEXTURE_2D, _texId, 0 );
    //errcheck();
    //_gl.glDrawBuffer( GL.GL_COLOR_ATTACHMENT0_EXT );
    //errcheck();
  }

  void unbind()
  {
    _gl.glBindFramebufferEXT( GL.GL_FRAMEBUFFER_EXT, 0 );
    // errcheck();
  }

  void disable()
  {
    _gl.glBindFramebufferEXT( GL.GL_FRAMEBUFFER_EXT, 0 );
    errcheck();
  }

  void drawBuffer( int idx )
  {
    if( idx == 0 )
      _gl.glDrawBuffer( GL.GL_COLOR_ATTACHMENT0_EXT );			 // Draw into the first texture     
    else if( idx == 1 )
      _gl.glDrawBuffer( GL.GL_COLOR_ATTACHMENT1_EXT );			 // Draw into the second texture     
  }

  void delete()
  {
//    if( _fboID )
      _gl.glDeleteFramebuffersEXT( 1, FBO, 0 );
    
//    if( _depthBufferID )
      _gl.glDeleteRenderbuffersEXT( 1, depthStencilBuffer, 0 );
  }

  int checkStatus()
  {     
    int status = _gl.glCheckFramebufferStatusEXT( GL.GL_FRAMEBUFFER_EXT );  

    //Our FBO is perfect, return true
    if( status == GL.GL_FRAMEBUFFER_COMPLETE_EXT )
    {
      System.out.println("FBO is complete.. ok!");
      return 1;
    }

    return status;
  }
  
  
  void errcheck()
  {
    int errCode = vgl.gl().glGetError();
    if( errCode != GL.GL_NO_ERROR ) 
    {
      String errString = vgl.glu().gluErrorString( errCode );
      //fprintf (stderr, "OpenGL Error: %s\n", errString);
      println( errString );
      exit();
    }
  }



  //
  // Members
  //
  protected GL _gl; 
  
  boolean _depthOnly;
  
  protected int[] FBO;
  protected int[] depthStencilBuffer;   
  
  private int _width;
  private int _height;  
};
