/*
 * Decompiled with CFR 0.152.
 */
package micromod.output;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import micromod.output.HasAvailableOutputDevice;
import micromod.output.OutputDeviceException;
import micromod.output.converters.AudioFormatConverter;

public class JavaSoundOutputDevice
extends HasAvailableOutputDevice {
    protected int samplingRate;
    protected int bufferFrames;
    protected int available;
    protected long timeMillis;
    protected long lastMillis;
    protected SourceDataLine sourceDataLine;
    static /* synthetic */ Class class$0;

    public JavaSoundOutputDevice(AudioFormatConverter converter, int samplingRate, int bufferTimeMillis) throws OutputDeviceException {
        this.samplingRate = samplingRate;
        int bitsPerSample = converter.getBytesPerFrame() / converter.getNumberOfChannels() * 8;
        this.initialise(converter);
        AudioFormat outFormat = new AudioFormat(samplingRate, bitsPerSample, converter.getNumberOfChannels(), converter.isSigned(), converter.isBigEndian());
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.sound.sampled.SourceDataLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DataLine.Info lineInfo = new DataLine.Info(clazz, outFormat);
            this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(lineInfo);
            this.sourceDataLine.open(outFormat, bufferTimeMillis * samplingRate / 1000 * this.bytesPerFrame);
        }
        catch (LineUnavailableException e) {
            throw new OutputDeviceException(" JavaSoundOutputDevice: Can't get a valid audio line!");
        }
        this.bufferFrames = this.sourceDataLine.getBufferSize() / this.bytesPerFrame;
    }

    public int framesAvailable() {
        this.timeMillis = System.currentTimeMillis();
        this.available += (int)(this.timeMillis - this.lastMillis) * this.samplingRate / 1000;
        int realAvailable = super.framesAvailable();
        if (this.available > realAvailable || realAvailable >= this.bufferFrames) {
            this.available = realAvailable;
        }
        this.lastMillis = this.timeMillis;
        return this.available;
    }

    public void write(byte[] buffer, int length) {
        this.sourceDataLine.write(buffer, 0, length);
        this.available -= length / this.bytesPerFrame;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public void start() {
        this.sourceDataLine.start();
        this.available = super.framesAvailable();
        this.lastMillis = System.currentTimeMillis();
    }

    public void pause() {
        this.sourceDataLine.stop();
    }

    public void stop() {
        this.sourceDataLine.drain();
        try {
            Thread.sleep(this.bufferFrames * 500 / this.samplingRate);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sourceDataLine.stop();
    }

    public void close() {
        this.sourceDataLine.close();
    }

    protected int bytesAvailable() {
        return this.sourceDataLine.available();
    }
}

