/*
 * Decompiled with CFR 0.152.
 */
package micromod;

public class ProTrackerLFO {
    public static final int WF_SINUS = 1;
    public static final int WF_SAWDN = 3;
    public static final int WF_SQUARE = 4;
    public static final int WF_RANDOM = 5;
    protected static int[] sinTable;
    protected int waveform;
    protected int position;
    protected int value;
    protected boolean retrig;

    static {
        int[] nArray = new int[32];
        nArray[1] = 24;
        nArray[2] = 49;
        nArray[3] = 74;
        nArray[4] = 97;
        nArray[5] = 120;
        nArray[6] = 141;
        nArray[7] = 161;
        nArray[8] = 180;
        nArray[9] = 197;
        nArray[10] = 212;
        nArray[11] = 224;
        nArray[12] = 235;
        nArray[13] = 244;
        nArray[14] = 250;
        nArray[15] = 253;
        nArray[16] = 255;
        nArray[17] = 253;
        nArray[18] = 250;
        nArray[19] = 244;
        nArray[20] = 235;
        nArray[21] = 224;
        nArray[22] = 212;
        nArray[23] = 197;
        nArray[24] = 180;
        nArray[25] = 161;
        nArray[26] = 141;
        nArray[27] = 120;
        nArray[28] = 97;
        nArray[29] = 74;
        nArray[30] = 49;
        nArray[31] = 24;
        sinTable = nArray;
    }

    public ProTrackerLFO() {
        this.reset();
    }

    public void reset() {
        this.retrig = true;
        this.setWaveform(1, true);
    }

    public void setWaveform(int wave, boolean retrig) {
        this.waveform = wave;
        this.retrig = retrig;
    }

    public int update(int speed, boolean newNote) {
        if (newNote && this.retrig) {
            this.position = 0;
        }
        switch (this.waveform) {
            case 1: {
                this.value = sinTable[this.position & 0x1F];
                if (this.position <= 31) break;
                this.value = -this.value;
                break;
            }
            case 3: {
                this.value = -8 * this.position + 255;
                break;
            }
            case 4: {
                this.value = (this.position & 0x20) == 0 ? -255 : 255;
                break;
            }
            case 5: {
                this.value = (int)(Math.random() * 511.0 - 255.0);
            }
        }
        this.position = this.position + speed & 0x3F;
        return this.value;
    }
}

