/*
 * Decompiled with CFR 0.152.
 */
package micromod;

import micromod.Instrument;
import micromod.InstrumentPlayer;
import micromod.resamplers.Resampler;

public class Channel {
    protected static final int FIXED_POINT_SHIFT = 16;
    protected int period;
    protected int volume;
    protected int fineTune;
    protected int amplitude;
    protected int leftPan;
    protected int rightPan;
    protected int mixerStepPrecalc;
    protected InstrumentPlayer instrumentPlayer;
    protected int[] fineTuneTable = new int[]{17358, 17233, 17109, 16986, 16864, 16743, 16622, 16503, 16384, 16266, 16149, 16033, 15918, 15803, 15689, 15576};

    public Channel(int samplingRate, boolean pal) {
        this.instrumentPlayer = new InstrumentPlayer();
        this.configure(samplingRate, pal);
        this.reset();
    }

    public void configure(int samplingRate, boolean pal) {
        int cpuClock = 7159090;
        if (pal) {
            cpuClock = 7093789;
        }
        this.mixerStepPrecalc = (cpuClock << 8) / samplingRate << 4;
    }

    public void reset() {
        this.instrumentPlayer.assignInstrument(new Instrument());
        this.instrumentPlayer.setAssigned();
        this.amplitude = 0;
        this.leftPan = 65536;
        this.rightPan = 65536;
        this.volume = 0;
        this.period = 0;
        this.fineTune = 0;
    }

    public void trigger(Instrument instrument, int period) {
        this.setVolume(this.volume, false);
        this.setPeriod(this.period, false);
        if (instrument != null) {
            this.instrumentPlayer.assignInstrument(instrument);
            this.setVolume(instrument.volume, true);
            if (period == -1) {
                if (this.period != 0) {
                    this.switchInstrument(false);
                    this.setPeriod(this.period, false);
                }
            } else if (period > 0) {
                this.switchInstrument(true);
                this.setPeriod(period, true);
            }
        } else if (period > 0) {
            this.switchInstrument(true);
            this.setPeriod(period, true);
        }
    }

    public int getPeriod() {
        return this.period;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setPeriod(int period, boolean permanent) {
        if (period == 0) {
            return;
        }
        if (period < 113) {
            period = 113;
        }
        if (period > 856) {
            period = 856;
        }
        this.calculateMixerStep(period, this.fineTune);
        if (permanent) {
            this.period = period;
        }
    }

    public void setVolume(int volume, boolean permanent) {
        if (volume > 64) {
            volume = 64;
        }
        if (volume < 0) {
            volume = 0;
        }
        this.amplitude = volume << 10;
        if (permanent) {
            this.volume = volume;
        }
    }

    public void setSamplePosition(int samplePosition) {
        this.instrumentPlayer.setSamplePosition(samplePosition);
    }

    public void setFineTune(int fineTune) {
        this.fineTune = fineTune;
        this.calculateMixerStep(this.period, fineTune);
    }

    public void setPanning(int left, int right) {
        this.leftPan = left;
        this.rightPan = right;
    }

    public int getLeftAmplitude() {
        return this.amplitude * (this.leftPan >> 1) >> 15;
    }

    public int getRightAmplitude() {
        return this.amplitude * (this.rightPan >> 1) >> 15;
    }

    public boolean isSilent() {
        return this.instrumentPlayer.hasFinished();
    }

    public void getAudio(short[] buffer, int length, Resampler resampler, boolean snapBack) {
        if (this.period == 0) {
            return;
        }
        this.instrumentPlayer.getAudio(buffer, length, resampler, snapBack);
    }

    protected void switchInstrument(boolean trig) {
        this.instrumentPlayer.setAssigned();
        this.fineTune = this.instrumentPlayer.getInstrument().fineTune;
        if (trig) {
            this.instrumentPlayer.setSamplePosition(0);
        }
    }

    protected void calculateMixerStep(int period, int fineTune) {
        if (period == 0) {
            return;
        }
        int ftPeriod = period * this.fineTuneTable[fineTune + 8] >> 7;
        this.instrumentPlayer.setResampleFactor((this.mixerStepPrecalc << 6) / ftPeriod << 4);
    }
}

