/*****************************************************************************
 *
 * File: vguicdlg.c, Fredrik Kling 1997
 * Desc: Commond dialog boxes for the gui...
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-08-23 | Fredrik Kling    | Implementation av filedialog...
 *
 * Todo:
 *	MessageBox,
 *
 *
 ****************************************************************************/
#include "vgui/vgui.h"
#include "vgui/vguicdlg.h"
#include "drivers/drv8.h"
#include "system/xstdio.h"


#define FILE_CANCEL 0
#define FILE_LOAD 1
#define FILE_SAVE 2
#define FILE_DELETE 3
#define FILE_OK 4
#define FILE_NAME 5

static DRV *drv;

static int filedlg_status = 0;
static int knapp;
static char filename[256];
static VGUIGADGET *fnamegad;

static void filedlg_init (void)
{
	VGUIGADGET *gad;
	APPLIST *app;
	VGUIDBOX *dbox;
	int xs,ys;

	vguigad_disposelist ();
	app = app_dboxfrmhand (VGUICFILEDLG);

	dbox = (VGUIDBOX *) app -> win;

	xs = dbox -> x2 - dbox -> x1;
	ys = dbox -> y2 - dbox -> y1;

	fnamegad = gad = vguigad_insert (4,ys-25-20,xs/2-8,ys-5-20,"Filename:",VGUIGAD_SBOX,FILE_NAME);
	sprintf (gad->sbox->string,"%s",filename);
	switch (knapp)
	{
		case FILE_LOAD :
					vguigad_insert (xs/2+8,4,xs-8,20,"Load",VGUIGAD_BUTT,FILE_LOAD);
					break;
		case FILE_SAVE :
					vguigad_insert (xs/2+8,4,xs-8,20,"Save",VGUIGAD_BUTT,FILE_SAVE);
					break;
		case FILE_DELETE :
					vguigad_insert (xs/2+8,4,xs-8,20,"Delete",VGUIGAD_BUTT,FILE_DELETE);
					break;
	}
	vguigad_insert (xs/2+8,25,xs-8,40,"Cancle",VGUIGAD_BUTT,FILE_CANCEL);
}
static void filedlg_main (int mess, int p1,int p2,int p3)
{
	switch (mess)
	{
		case VG_COMMAND : switch (p1)
											{
												case VGC_BUTTON :
																switch (p2)
																{
																	case FILE_CANCEL : vgui_postmessage (VGS_EXIT,0,0,0);
																										 filedlg_status = FILE_CANCEL;
																										 break;
																	case FILE_LOAD : sprintf (filename,"%s",fnamegad -> sbox -> string);
																									 filedlg_status = FILE_LOAD;
																									 vgui_postmessage (VGS_EXIT,0,0,0);
																									 break;
																	case FILE_SAVE : sprintf (filename,"%s",fnamegad->sbox->string);
																									 filedlg_status = FILE_SAVE;
																									 vgui_postmessage (VGS_EXIT,0,0,0);
																									 break;
																	case FILE_DELETE : sprintf (filename,"%s",fnamegad->sbox->string);
																									 filedlg_status = FILE_DELETE;
																									 vgui_postmessage (VGS_EXIT,0,0,0);
																									 break;
																}
																break;
											}
											break;
		case VG_HELLOW : filedlg_init ();
										 break;
	}

}
int vguicdlg_file (int flags,char *string)
{
	VGUIDBOX *dialog;

	drv = vgui_getdriver ();

	switch (flags)
	{
		case FILEFLAG_LOAD :
					dialog = vguidbox_create (drv->width/4,drv->height/4,drv->width/2+drv->width/4,drv->height/4+64,"Load file",VGUICFILEDLG);
					knapp = FILE_LOAD;
					break;
		case FILEFLAG_SAVE :
					dialog = vguidbox_create (drv->width/4,drv->height/4,drv->width/2+drv->width/4,drv->height/4+64,"Save file",VGUICFILEDLG);
					knapp = FILE_SAVE;
					break;
		case FILEFLAG_DELETE :
					dialog = vguidbox_create (drv->width/4,drv->height/4,drv->width/2+drv->width/4,drv->height/4+64,"Delete file",VGUICFILEDLG);
					knapp = FILE_DELETE;
					break;
	}

	sprintf (filename,"%s",string);
 	dialog -> vgui_main = &filedlg_main;
	vguidbox_run (VGUICFILEDLG);

	if (filedlg_status)	sprintf (string,"%s",filename);
	return (filedlg_status);
}


