/*****************************************************************************
 *
 * File: vguicbox.c, Fredrik Kling 1997
 * Desc: Check box controling...
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-08-12 | Fredrik Kling    | Implementation
 *
 ****************************************************************************/
#include "vgui/vgui.h"
#include "vgui/vguicbox.h"

#define CBOX_SIZE 10

void vguicbox_draw (int x1, int y1, int x2, int y2, char *caption,int state)
{
	vgui_line (x1,y1,x1+CBOX_SIZE,y1,VG_CDARK);
	vgui_line (x1,y1,x1,y1+CBOX_SIZE,VG_CDARK);
	vgui_line (x1,y1+CBOX_SIZE,x1+CBOX_SIZE+1,y1+CBOX_SIZE,VG_CLIGHT);
	vgui_line (x1+CBOX_SIZE,y1,x1+CBOX_SIZE,y1+CBOX_SIZE,VG_CLIGHT);

	vgui_bar (x1+1,y1+1,x1+CBOX_SIZE,y1+CBOX_SIZE,VG_CBLACK);
	if (state) vgui_bar (x1+2,y1+2,x1+CBOX_SIZE-1,y1+CBOX_SIZE-1,VG_CLGREEN);

	vgui_printfxyc (x1+CBOX_SIZE+4,y1+2,VG_CBLACK,caption);
}
void vguicbox_highlight (int x1, int y1, int x2, int y2, char *caption)
{
	vgui_printfxyc (x1+CBOX_SIZE+4,y1+2,VG_CWHITE,caption);
}
void vguicbox_select (int x1, int y1, int x2, int y2, char *caption,int state)
{
	vgui_line (x1,y1,x1+CBOX_SIZE,y1,VG_CDARK);
	vgui_line (x1,y1,x1,y1+CBOX_SIZE,VG_CDARK);
	vgui_line (x1,y1+CBOX_SIZE,x1+CBOX_SIZE+1,y1+CBOX_SIZE,VG_CLIGHT);
	vgui_line (x1+CBOX_SIZE,y1,x1+CBOX_SIZE,y1+CBOX_SIZE,VG_CLIGHT);

	vgui_bar (x1+1,y1+1,x1+CBOX_SIZE,y1+CBOX_SIZE,VG_CBLACK);

	if (state) vgui_bar (x1+2,y1+2,x1+CBOX_SIZE-1,y1+CBOX_SIZE-1,VG_CLGREEN);

	vgui_printfxyc (x1+CBOX_SIZE+4,y1+2,VG_CWHITE,caption);
}


