/*-------------------------------------------------------------------------
 *
 * File: xstring.c
 * Auth: Fredrik Kling
 * Desc: Strnghanterings rutiner som inte finns i ANSI C.
 *
 * -- Date -- | --- Name ---- |-- Did what....
 * 1997-05-08 | Fredrik Kling | Implementation
 *
 *
 *------------------------------------------------------------------------*/

#include <ctype.h>
#include "system/xstdio.h"
#include "system/xstring.h"

/************************************************************************
 *
 * Func: xstrrev
 * Auth: Fredrik Kling
 * Date: 1997-05-08 - Implementation
 *
 * Desc: string reverse, vnder p en strng...
 *       Samma funktion som "strrev" fr dos...
 *       Max strnglngd: 1024..
 *
 ************************************************************************/
char *xstrrev (char *s)
{
	int c,i;
	char tmp[1024];
	strcpy (tmp,s);
	c=strlen (s)-1;
	i=0;
	while (c>0) s[i++]=tmp[c--];
	s[strlen(s)-1]=tmp[0];
	return s;

}
/************************************************************************
 *
 * Func: xstrupr
 * Auth: Fredrik Kling
 * Date: 1997-05-08 - Implementation
 *
 * Desc: Stter en strng i "uppercase" mode...  ASCII - only!!
 *
 * Update: Anvnder sig av ansi-standard toupper() (Alexander 15/5)
 *
 ************************************************************************/
char *xstrupr (char *s)
{
  int i;
  for( i=0; (s[i] != '\0'); i++)
    s[i] = toupper( s[i]);

  return s;
}
/************************************************************************
 *
 * Func: xstrlwr
 * Auth: Fredrik Kling
 * Date: 1997-05-08 - Implementation
 *
 * Desc: Stter en strng i "lowercase" mode...  ASCII - only!!
 *
 * Update: Anvnder sig av ansi-standard tolower() (Alexander 15/5)
 *
 ************************************************************************/
char *xstrlwr (char *s)
{
  int i;
  for( i=0; (s[i] != '\0'); i++)
    s[i] = tolower( s[i]);

	return s;
}

