#pragma once

//#ifndef __XSTDLIB_H
//#define __XSTDLIB_H

#ifdef __WATCOMC__
#pragma library("system.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//
#include <stdlib.h>
#include "system/xstddef.h"

#if defined(__WATCOMC__)

void memset4( void *dst, DWORD data, DWORD length);
#pragma aux memset4 "*" =\
	"rep stosd"\
	parm [edi] [eax] [ecx]\
	modify[edi ecx];

void memcpy4( void *dst, void *src, DWORD length);
#pragma aux memcpy4 "*" =\
	"rep movsd"\
	parm [edi] [esi] [ecx]\
	modify[edi esi ecx];

void memset16( void *dst, DWORD data, DWORD length);
#pragma aux memset16 "*" =\
  "mov [edi+0],eax"\
  "mov [edi+4],eax"\
  "fild qword ptr [edi]"\
	"l:"\
  "fst qword ptr [edi]"\
  "fst qword ptr [edi+8]"\
  "add edi,16"\
	"dec ecx"\
	"jnz l"\
  "fstp st(0)"\
	parm [edi] [eax] [ecx]\
	modify[edi ecx];

void memcpy16( void *dst, void *src, DWORD length);
#pragma aux memcpy16 "*" =\
	"l:"\
  "fld qword ptr [esi]"\
  "fld qword ptr [esi+8]"\
	"fxch"\
  "fstp qword ptr [edi]"\
  "fstp qword ptr [edi+8]"\
	"add esi,16"\
	"add edi,16"\
	"dec ecx"\
	"jnz l"\
	parm [edi] [esi] [ecx]\
	modify[edi esi ecx];


#else

void memset4( void *dst, DWORD data, DWORD length);
void memcpy4( void *dst, void *src, DWORD length);

void memset16( void *dst, DWORD data, DWORD length);
void memcpy16( void *dst, void *src, DWORD length);

#endif

void *xmalloc( DWORD size);
void *xsafe_malloc( DWORD size); // I don't like this one.... [alex]
void xfree( void *buffer);
int xbytes_allocated (void);
int xbytes_peak (void);
int xblocks_allocated (void);
int xblocks_peak (void);


//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif
