/*--------------------------------------------------------------------------
 * File: object.c
 * Written by: Fredrik Kling, 1997-05-09
 * Description: object handling file
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-05-09 | Fredrik Kling    | Implementation
 * 1997-05-16 | Fredrik Kling    | Error handling...
 *
 * Todo:
 *
 *-------------------------------------------------------------------------------*/

#include "system/xstdlib.h"
#include "objects/object.h"

#include "system/xstring.h"

typedef enum
{
	ERR_NOERR,
	ERR_NOFILE,
	ERR_NOMEM,
	ERR_CUSTOM,
	ERR_V3O,
	ERR_VIO,
} ERROR;

static ERROR error = ERR_NOERR;
static char errstr[256];

void object_boundingsphere (OBJECT *obj)
{
	switch (obj->type)
	{
		case T_V3O : obj->radius=v3o_boundingsphere (obj->v3o); break;
//		case T_VIO : obj->radius=vio_boundingsphere (obj->vio); break;
	}
}


OBJECT *object_create (void)
{
	int i;
	OBJECT *o;

	if ((o=xmalloc (sizeof (OBJECT)))==NULL)
	{
		error = ERR_NOMEM;
		return NULL;
	}
	o->flags=OBJFLAG_DRAW;
	o->calcpos.x=0;
	o->calcpos.y=0;
	o->calcpos.z=0;

	o->radius=1;
	o->calcradius=1;
	o->num_parent = -1;


	for (i=0;i<3;i++) o->angleadd[i]=0;

	o->prev=o->next=o->parent=NULL;
	o->anim = NULL;

	return o;
}
void object_dispose (OBJECT *o)
{
}
OBJECT *object_load (OBJECT *o,char *fn, char *imagepath)
{
	switch (o->type)
	{
    case T_V3O  : if( (o->v3o=v3o_load(fn, imagepath)) == NULL)
									{
										error = ERR_V3O;
										return( NULL);
									}	break;
		case T_VIO  : printf ("   Loading vio:%s.. =)\n",fn); break;//o->vio=vio_load (fn); break;
//    case T_VSND : if( (o->vsnd=vsnd_load (fn)) == NULL) return( NULL); break;
//    case T_VCAM : if( (o->vcam=vcam_load (fn)) == NULL) return( NULL); break; // Tror vi inte kan ha den hr?!
//    case T_VLGH : if( (o->vlgh=vlgh_load (fn)) == NULL) return( NULL); break;
		default : printf ("[!] Error: Type missmath!\n"); break;
	}
	return o;
}

/*################################################################
	# object - geterror
	#################################################################*/
char *object_geterror(void)
{
	switch( error)
	{
		case ERR_NOERR: return( "[OBJECT] No error");
		case ERR_NOFILE: return( "[OBJECT] Unable to open file");
		case ERR_NOMEM: return( "[OBJECT] Unable to allocate memory");
		case ERR_V3O : {
										 sprintf (errstr,"[OBJECT] - %s.",v3o_geterror());
										 return errstr;
									 }
		case ERR_CUSTOM:
		{
			char str[256];
			strcpy( str, errstr);
			sprintf( errstr, "[OBJECT] %s", str);
			return( errstr);
		}
		default: return( "[OBJECT] Unknown error!");
	}
}
