#pragma once

#ifdef __WATCOMC__
#pragma library("formats.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//

#include "formats/vio.h"    // Needed for textures
#include "vmath/vector.h"
#include "misc/col.h"

//--------------------------------------------
// Type's
//

typedef struct s_V3O V3O;
typedef struct s_V3OMATERIAL V3OMATERIAL;
typedef struct s_V3OTEXTURE V3OTEXTURE;
typedef struct s_V3OSURFACE V3OSURFACE;
typedef struct s_V3OVERTEX V3OVERTEX;
typedef struct s_V3OATTACH V3OATTACH;

// Ok!

#define V3O_SAVE_NORMAL 0
#define V3O_SAVE_ASM		1
#define V3O_SAVE_C			2
#define V3O_SAVE_PAS		3

// Flag defines etc..
typedef enum
{
	V3OFLAG_BOUNDINGSPHERE = 1 << 0
} V3OFLAGS;

typedef enum
{
  V3OMATERIALFLAG_COLOR = 1 << 0,
  V3OMATERIALFLAG_FLAT = 1 << 1,
  V3OMATERIALFLAG_GOURADE = 1 << 2,
  V3OMATERIALFLAG_PHONG = 1 << 3,
  V3OMATERIALFLAG_TEXTURE = 1 << 4,
  V3OMATERIALFLAG_DBLSIDE = 1 << 5,
  V3OMATERIALFLAG_TRANSPARENT = 1 << 6,
	V3OMATERIALFLAG_ENVMAP = 1 << 7
} V3OMATERIALFLAGS;

typedef enum
{
  V3OTEXTUREFLAG_LOADED = 1 << 0,
  V3OTEXTUREFLAG_INCLUDED = 1 << 1,
} V3OTEXTUREFLAGS;

typedef enum
{
  V3OSURFACEFLAG_POINT = 1 << 0,
  V3OSURFACEFLAG_LINE = 1 << 1,
  V3OSURFACEFLAG_POLY = 1 << 2
} V3OSURFACEFLAGS;

//--------------------------------------------
// structures
//

//
// Lgger s mycket gemensamma saker som mjligt fr de olika objekten
// i grundstrukturen..
// P s stt behver vi minimalt med kod fr olika objekt-typer...
// Lite objektorienterat... typ..   =)
//
// Vi br kanske lgga objekt pekaren i en annan fil....
//


struct s_V3O
{
	char name[32];
	V3OFLAGS flags;

  int nummaterial;
	int numtexture;
	int numsurface;
	int numvertex;

	V3OMATERIAL *material;	//  MATERIAL *material;
	V3OTEXTURE *texture;	//  TEXTURE *texture;
  V3OSURFACE *surface;
  VECTOR *orgvertex,*orgnormal,*rotvertex,*rotnormal,*projvertex;
};

struct s_V3OMATERIAL
{
  char name[64];
	V3OMATERIALFLAGS flags;

	RGBA color;
  BYTE ci;

	int texture;
  V3OTEXTURE *phongmap;
};

struct s_V3OTEXTURE
{
	char filename[64];
	V3OTEXTUREFLAGS flags;
	VIO *image;
};

struct s_V3OSURFACE
{
	V3OSURFACEFLAGS flags;

	int material;

	int v1,v2,v3;
	float tx1,tx2,tx3,ty1,ty2,ty3;
};

//---------------------------------------------------------------------------//

int v3o_addmtrl (V3O *, V3OMATERIAL *);
V3OMATERIAL *v3o_createstdmtrl (void);
void v3o_setmtrl (V3O *, int );
float v3o_boundingsphere (V3O *);
void v3o_center (V3O *);
void v3o_calcnormals (V3O *);

//---------------------------------------------------------------------------//

void v3o_scale (V3O *,float,float,float);
void v3o_translate (V3O *,float,float,float);
void v3o_dump (V3O *,int,int);
int v3o_alloc (V3O *);

V3O *v3o_create( void);
V3O *v3o_load( char *filename, char *imagepath);
void v3o_free( V3O *obj);
int v3o_save( char *filename, V3O *obj,int type);
char *v3o_geterror (void);
//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif

