#pragma once

//#ifndef __V3D_H
//#define __V3D_H

#ifdef __WATCOMC__
#pragma library("formats.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//
#include "formats/v3o.h"
#include "formats/vio.h"
#include "objects/object.h"
#include "objects/camera.h"
#include "misc/col.h"

// typedefines
#define ANIM_POS_X 0
#define ANIM_POS_Y 1
#define ANIM_POS_Z 2
#define ANIM_ANG_X 3
#define ANIM_ANG_Y 4
#define ANIM_ANG_Z 5
#define ANIM_SCL_X 6
#define ANIM_SCL_Y 7
#define ANIM_SCL_Z 8

#define ANIM_TARGET_X 6
#define ANIM_TARGET_Y 7
#define ANIM_TARGET_Z 8

// No everything is implemented...  =)
#define V3D_SAVE_NORMAL 0
#define V3D_SAVE_ASM 		1
#define V3D_SAVE_C 			2
#define V3D_SAVE_PAS 		3



typedef struct s_V3D V3D;

typedef enum
{
	V3DFLAG_BACKGROUND = 1
} V3DFLAGS;

// structures

struct s_V3D
{
	V3DFLAGS flags;

	CAMERA *activecamera;
  OBJECT *obj;
	OBJECT *lightlist;

	RGB ambient,maxlight;
	VIO *background;

	float framecounter,fps;

	float zmax,zmin;
};


// Functions

V3D *v3d_create();
void v3d_free( V3D *v3d);
V3D *v3d_load( char *filename, char *objectpath, char *imagepath);
int v3d_save( V3D *v3d, char *filename, int type);
int v3d_setup( V3D *v3d, RGB *palette, BYTE *lighttab);
char *v3d_geterror();
void v3d_dump( V3D *v3d);
void v3d_obj2scene(V3D *,OBJECT *);
OBJECT *v3d_objfromname (V3D *,char *name);

//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif
