/*--------------------------------------------------------------------------
 * File: poly.c
 * Written by: Alexander Boczar, 1997-03-29
 * Description: Poly drawer for 8bit palette based drivers.
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-06-24 | Alexander Boczar | Implementation
 *
 -------------------------------------------------------------------------------*/

#include "system/xstdlib.h"
#include "system/xmath.h"
#include "drivers/drv8.h"
#include "draw8/draw8.h"
#include "misc/clip.h"
//#include "debug/mono.h"

#if defined(__X86__)

#if defined(__WATCOMC__)
	extern poly_glzt_asm ( BYTE *screen, int minx, int maxx, int width, int ylen, int x1, int x1add, int x2, int x2add, BYTE col);
	#pragma aux poly_glzt_asm "*" parm caller [];
#else
	extern void poly_glzt_asm( BYTE *screen, int minx, int maxx, int width, int ylen, int x1, int x1add, int x2, int x2add, BYTE col);
#endif

#if defined (__WATCOMC__)
	extern poly_glZt_asm( BYTE *screen, int *zbuffer, int minx, int maxx, int width, int ylen, int x1, int x1add, int z1, int z1add, int x2, int x2add, int z2, int z2add, BYTE col);
	#pragma aux poly_glZt_asm "*" parm caller [];
#else
	extern void poly_glZt_asm( BYTE *screen, int *zbuffer, int minx, int maxx, int width, int ylen, int x1, int x1add, int z1, int z1add, int x2, int x2add, int z2, int z2add, BYTE col);
#endif

#if defined (__WATCOMC__)
	extern poly_GLZt_asm( BYTE *screen, int *zbuffer, BYTE *lighttab, int minx, int maxx, int width, int ylen, int x1, int x1add, int z1, int z1add, int l1, int l1add, int x2, int x2add, int z2, int z2add, int l2, int l2add);
	#pragma aux poly_GLZt_asm "*" parm caller [];
#else
	extern poly_GLZt_asm( BYTE *screen, int *zbuffer, BYTE *lighttab, int minx, int maxx, int width, int ylen, int x1, int x1add, int z1, int z1add, int l1, int l1add, int x2, int x2add, int z2, int z2add, int l2, int l2add);
#endif
/*
extern poly_GLZT_asm( BYTE *screen, int *zbuffer, BYTE *lighttab, BYTE *texture, int minx, int maxx, int width, int ylen,
											int x1, int x1add, int z1, int z1add, int tx1, int tx1add, int ty1, int ty1add, int l1, int l1add,
											int x2, int x2add, int z2, int z2add, int tx2, int tx2add, int ty2, int ty2add, int l2, int l2add);
#pragma aux poly_GLZT_asm "*" parm caller [];
*/
#endif

#undef  GOURADE
#undef  LIGHT
#undef  ZBUFFER
#undef  TRANS
static void poly_glzt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#undef  GOURADE
#define LIGHT
#undef  ZBUFFER
#undef  TRANS
static void poly_gLzt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#define GOURADE
#define LIGHT
#undef  ZBUFFER
#undef  TRANS
static void poly_GLzt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#undef  GOURADE
#undef  LIGHT
#define ZBUFFER
#undef  TRANS
static void poly_glZt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#undef  GOURADE
#define LIGHT
#define ZBUFFER
#undef  TRANS
static void poly_gLZt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#define GOURADE
#define LIGHT
#define ZBUFFER
#undef  TRANS
static void poly_GLZt( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#undef  GOURADE
#undef  LIGHT
#undef  ZBUFFER
#define TRANS
static void poly_glzT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#undef  GOURADE
#define LIGHT
#undef  ZBUFFER
#define TRANS
static void poly_gLzT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#define GOURADE
#define LIGHT
#undef  ZBUFFER
#define TRANS
static void poly_GLzT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#undef  GOURADE
#undef  LIGHT
#define ZBUFFER
#define TRANS
static void poly_glZT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#undef  GOURADE
#define LIGHT
#define ZBUFFER
#define TRANS
static void poly_gLZT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

#define GOURADE
#define LIGHT
#define ZBUFFER
#define TRANS
static void poly_GLZT( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, char col)
#include "poly0.c"

void poly( BUFF *buff, const XYZ p1, const XYZ p2, const XYZ p3, BYTE col)
{
	BYTE funcs;
	funcs = ((buff->zbuffer != NULL)? 0x01 : 0x00)
			 	| ((buff->lighttab != NULL)? 0x02 : 0x00)
			 	| ((buff->transtab != NULL)? 0x04 : 0x00)
			 	| (((p1.l == p2.l) && (p1.l == p3.l))? 0x00 : 0x08);

	switch( funcs)
	{
    case 0x00: poly_glzt( buff, p1, p2, p3, col); break;
    case 0x01: poly_glZt( buff, p1, p2, p3, col); break;
    case 0x02: poly_gLzt( buff, p1, p2, p3, col); break;
    case 0x03: poly_gLZt( buff, p1, p2, p3, col); break;
    case 0x04: poly_glzT( buff, p1, p2, p3, col); break;
    case 0x05: poly_glZT( buff, p1, p2, p3, col); break;
    case 0x06: poly_gLzT( buff, p1, p2, p3, col); break;
    case 0x07: poly_gLZT( buff, p1, p2, p3, col); break;
    case 0x08: poly_glzt( buff, p1, p2, p3, col); break;
    case 0x09: poly_glZt( buff, p1, p2, p3, col); break;
    case 0x0a: poly_GLzt( buff, p1, p2, p3, col); break;
    case 0x0b: poly_GLZt( buff, p1, p2, p3, col); break;
    case 0x0c: poly_glzT( buff, p1, p2, p3, col); break;
    case 0x0d: poly_glZT( buff, p1, p2, p3, col); break;
    case 0x0e: poly_GLzT( buff, p1, p2, p3, col); break;
    case 0x0f: poly_GLZT( buff, p1, p2, p3, col); break;
	}
}
