/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class SdwUtil {
    static int[][] edgeList;
    static int edgeMin;
    static int edgeMax;
    static int r1;
    static int r2;
    static int r3;
    static int r4;
    public static final int[] sinTab;
    public static final int[] cosTab;

    SdwUtil() {
    }

    public static void SetupEdgeList(int n, int n2) {
        edgeList = new int[2][n2];
        edgeMin = n;
        edgeMax = n + n2 - 1;
    }

    public static int SinCalc(int n, int n2) {
        return n * sinTab[n2 & 0x3FF] >> 16;
    }

    public static int CosCalc(int n, int n2) {
        return n * cosTab[n2 & 0x3FF] >> 16;
    }

    public static void Seed(int n) {
        r1 = n;
    }

    public static int Rand() {
        int n = r1 ^ r1 << 11;
        r1 = r2;
        r2 = r3;
        r3 = r4;
        r4 = r4 ^ r4 >> 19 ^ (n ^ n >> 8);
        return r4;
    }

    public static void DrawTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n2 < edgeMin && n4 < edgeMin && n6 < edgeMin) {
            return;
        }
        if (n2 > edgeMax && n4 > edgeMax && n6 > edgeMax) {
            return;
        }
        int n7 = Math.abs(n4 - n2);
        int n8 = Math.abs(n6 - n4);
        int n9 = Math.abs(n2 - n6);
        if (n7 > n8 && n7 > n9) {
            SdwUtil.SetupEdge(n, n2, n3, n4, 0);
            SdwUtil.SetupEdge(n3, n4, n5, n6, 1);
            SdwUtil.SetupEdge(n5, n6, n, n2, 1);
        } else if (n8 >= n7 && n8 >= n9) {
            SdwUtil.SetupEdge(n, n2, n3, n4, 1);
            SdwUtil.SetupEdge(n3, n4, n5, n6, 0);
            SdwUtil.SetupEdge(n5, n6, n, n2, 1);
        } else {
            SdwUtil.SetupEdge(n, n2, n3, n4, 1);
            SdwUtil.SetupEdge(n3, n4, n5, n6, 1);
            SdwUtil.SetupEdge(n5, n6, n, n2, 0);
        }
        int n10 = n2;
        int n11 = n2;
        if (n4 < n10) {
            n10 = n4;
        }
        if (n6 < n10) {
            n10 = n6;
        }
        if (n4 > n11) {
            n11 = n4;
        }
        if (n6 > n11) {
            n11 = n6;
        }
        if (n10 < edgeMin) {
            n10 = edgeMin;
        }
        if (n11 > edgeMax) {
            n11 = edgeMax;
        }
        for (int i = n10 - edgeMin; i < n11 - edgeMin; ++i) {
            graphics.drawLine(edgeList[0][i], i + edgeMin, edgeList[1][i], edgeMin + i);
        }
    }

    public static void SetupEdge(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n4 < n2) {
            n6 = n3;
            n3 = n;
            n = n6;
            n6 = n4;
            n4 = n2;
            n2 = n6;
        }
        n6 = n4 - n2 == 0 ? 0 : (n3 - n << 16) / (n4 - n2);
        int n7 = n << 16;
        for (int i = n2; i < n4; ++i) {
            if (i >= edgeMin && i <= edgeMax) {
                SdwUtil.edgeList[n5][i - SdwUtil.edgeMin] = n7 >> 16;
            }
            n7 += n6;
        }
    }

    static {
        edgeMin = 0;
        edgeMax = 0;
        r2 = 42502087;
        r3 = 579807591;
        r4 = 73326509;
        sinTab = new int[]{0, 402, 804, 1206, 1608, 2010, 2412, 2813, 3215, 3617, 4018, 4419, 4821, 5221, 5622, 6023, 6423, 6823, 7223, 7622, 8022, 8421, 8819, 9218, 9615, 10013, 10410, 10807, 11203, 11599, 11995, 12390, 12785, 13179, 13573, 13966, 14358, 14750, 15142, 15533, 15923, 16313, 16702, 17091, 17479, 17866, 18252, 18638, 19023, 19408, 19791, 20174, 20557, 20938, 21319, 21699, 22078, 22456, 22833, 23210, 23585, 23960, 24334, 24707, 25079, 25450, 25820, 26189, 26557, 26924, 27290, 27655, 28019, 28382, 28744, 29105, 29465, 29823, 30181, 30537, 30892, 31247, 31599, 31951, 32302, 32651, 32999, 33346, 33691, 34035, 34378, 34720, 35061, 35400, 35737, 36074, 36409, 36742, 37075, 37406, 37735, 38063, 38390, 38715, 39039, 39361, 39682, 40001, 40319, 40635, 40950, 41263, 41574, 41885, 42193, 42500, 42805, 43109, 43411, 43711, 44010, 44307, 44603, 44896, 45189, 45479, 45768, 46055, 46340, 46623, 46905, 47185, 47463, 47739, 48014, 48287, 48558, 48827, 49094, 49360, 49623, 49885, 50145, 50403, 50659, 50913, 51165, 51415, 51664, 51910, 52155, 52397, 52638, 52876, 53113, 53347, 53580, 53810, 54039, 54265, 54490, 54712, 54933, 55151, 55367, 55581, 55793, 56003, 56211, 56416, 56620, 56821, 57021, 57218, 57413, 57606, 57796, 57985, 58171, 58355, 58537, 58717, 58894, 59069, 59242, 59413, 59582, 59748, 59912, 60074, 60234, 60391, 60546, 60699, 60849, 60997, 61143, 61287, 61428, 61567, 61704, 61838, 61970, 62100, 62227, 62352, 62474, 62595, 62713, 62828, 62941, 63052, 63161, 63267, 63370, 63472, 63570, 63667, 63761, 63853, 63942, 64029, 64114, 64196, 64275, 64353, 64427, 64500, 64570, 64637, 64702, 64765, 64825, 64883, 64938, 64991, 65042, 65090, 65135, 65178, 65219, 65257, 65293, 65326, 65357, 65385, 65411, 65435, 65456, 65474, 65490, 65504, 65515, 65523, 65530, 65533, 65535, 65533, 65530, 65523, 65515, 65504, 65490, 65474, 65456, 65435, 65411, 65385, 65357, 65326, 65293, 65257, 65219, 65178, 65135, 65090, 65042, 64991, 64938, 64883, 64825, 64765, 64702, 64637, 64570, 64500, 64427, 64353, 64275, 64196, 64114, 64029, 63942, 63853, 63761, 63667, 63570, 63472, 63370, 63267, 63161, 63052, 62941, 62828, 62713, 62595, 62474, 62352, 62227, 62100, 61970, 61838, 61704, 61567, 61428, 61287, 61143, 60997, 60849, 60699, 60546, 60391, 60234, 60074, 59912, 59748, 59582, 59413, 59242, 59069, 58894, 58717, 58537, 58355, 58171, 57985, 57796, 57606, 57413, 57218, 57021, 56821, 56620, 56416, 56211, 56003, 55793, 55581, 55367, 55151, 54933, 54712, 54490, 54265, 54039, 53810, 53580, 53347, 53113, 52876, 52638, 52397, 52155, 51910, 51664, 51415, 51165, 50913, 50659, 50403, 50145, 49885, 49623, 49360, 49094, 48827, 48558, 48287, 48014, 47739, 47463, 47185, 46905, 46623, 46340, 46055, 45768, 45479, 45189, 44896, 44603, 44307, 44010, 43711, 43411, 43109, 42805, 42500, 42193, 41885, 41574, 41263, 40950, 40635, 40319, 40001, 39682, 39361, 39039, 38715, 38390, 38063, 37735, 37406, 37075, 36742, 36409, 36074, 35737, 35400, 35061, 34720, 34378, 34035, 33691, 33346, 32999, 32651, 32302, 31951, 31599, 31247, 30892, 30537, 30181, 29823, 29465, 29105, 28744, 28382, 28019, 27655, 27290, 26924, 26557, 26189, 25820, 25450, 25079, 24707, 24334, 23960, 23585, 23210, 22833, 22456, 22078, 21699, 21319, 20938, 20557, 20174, 19791, 19408, 19023, 18638, 18252, 17866, 17479, 17091, 16702, 16313, 15923, 15533, 15142, 14750, 14358, 13966, 13573, 13179, 12785, 12390, 11995, 11599, 11203, 10807, 10410, 10013, 9615, 9218, 8819, 8421, 8022, 7622, 7223, 6823, 6423, 6023, 5622, 5221, 4821, 4419, 4018, 3617, 3215, 2813, 2412, 2010, 1608, 1206, 804, 402, 0, -403, -805, -1207, -1609, -2011, -2413, -2814, -3216, -3618, -4019, -4420, -4822, -5222, -5623, -6024, -6424, -6824, -7224, -7623, -8023, -8422, -8820, -9219, -9616, -10014, -10411, -10808, -11204, -11600, -11996, -12391, -12786, -13180, -13574, -13967, -14359, -14751, -15143, -15534, -15924, -16314, -16703, -17092, -17480, -17867, -18253, -18639, -19024, -19409, -19792, -20175, -20558, -20939, -21320, -21700, -22079, -22457, -22834, -23211, -23586, -23961, -24335, -24708, -25080, -25451, -25821, -26190, -26558, -26925, -27291, -27656, -28020, -28383, -28745, -29106, -29466, -29824, -30182, -30538, -30893, -31248, -31600, -31952, -32303, -32652, -33000, -33347, -33692, -34036, -34379, -34721, -35062, -35401, -35738, -36075, -36410, -36743, -37076, -37407, -37736, -38064, -38391, -38716, -39040, -39362, -39683, -40002, -40320, -40636, -40951, -41264, -41575, -41886, -42194, -42501, -42806, -43110, -43412, -43712, -44011, -44308, -44604, -44897, -45190, -45480, -45769, -46056, -46341, -46624, -46906, -47186, -47464, -47740, -48015, -48288, -48559, -48828, -49095, -49361, -49624, -49886, -50146, -50404, -50660, -50914, -51166, -51416, -51665, -51911, -52156, -52398, -52639, -52877, -53114, -53348, -53581, -53811, -54040, -54266, -54491, -54713, -54934, -55152, -55368, -55582, -55794, -56004, -56212, -56417, -56621, -56822, -57022, -57219, -57414, -57607, -57797, -57986, -58172, -58356, -58538, -58718, -58895, -59070, -59243, -59414, -59583, -59749, -59913, -60075, -60235, -60392, -60547, -60700, -60850, -60998, -61144, -61288, -61429, -61568, -61705, -61839, -61971, -62101, -62228, -62353, -62475, -62596, -62714, -62829, -62942, -63053, -63162, -63268, -63371, -63473, -63571, -63668, -63762, -63854, -63943, -64030, -64115, -64197, -64276, -64354, -64428, -64501, -64571, -64638, -64703, -64766, -64826, -64884, -64939, -64992, -65043, -65091, -65136, -65179, -65220, -65258, -65294, -65327, -65358, -65386, -65412, -65436, -65457, -65475, -65491, -65505, -65516, -65524, -65531, -65534, -65535, -65534, -65531, -65524, -65516, -65505, -65491, -65475, -65457, -65436, -65412, -65386, -65358, -65327, -65294, -65258, -65220, -65179, -65136, -65091, -65043, -64992, -64939, -64884, -64826, -64766, -64703, -64638, -64571, -64501, -64428, -64354, -64276, -64197, -64115, -64030, -63943, -63854, -63762, -63668, -63571, -63473, -63371, -63268, -63162, -63053, -62942, -62829, -62714, -62596, -62475, -62353, -62228, -62101, -61971, -61839, -61705, -61568, -61429, -61288, -61144, -60998, -60850, -60700, -60547, -60392, -60235, -60075, -59913, -59749, -59583, -59414, -59243, -59070, -58895, -58718, -58538, -58356, -58172, -57986, -57797, -57607, -57414, -57219, -57022, -56822, -56621, -56417, -56212, -56004, -55794, -55582, -55368, -55152, -54934, -54713, -54491, -54266, -54040, -53811, -53581, -53348, -53114, -52877, -52639, -52398, -52156, -51911, -51665, -51416, -51166, -50914, -50660, -50404, -50146, -49886, -49624, -49361, -49095, -48828, -48559, -48288, -48015, -47740, -47464, -47186, -46906, -46624, -46341, -46056, -45769, -45480, -45190, -44897, -44604, -44308, -44011, -43712, -43412, -43110, -42806, -42501, -42194, -41886, -41575, -41264, -40951, -40636, -40320, -40002, -39683, -39362, -39040, -38716, -38391, -38064, -37736, -37407, -37076, -36743, -36410, -36075, -35738, -35401, -35062, -34721, -34379, -34036, -33692, -33347, -33000, -32652, -32303, -31952, -31600, -31248, -30893, -30538, -30182, -29824, -29466, -29106, -28745, -28383, -28020, -27656, -27291, -26925, -26558, -26190, -25821, -25451, -25080, -24708, -24335, -23961, -23586, -23211, -22834, -22457, -22079, -21700, -21320, -20939, -20558, -20175, -19792, -19409, -19024, -18639, -18253, -17867, -17480, -17092, -16703, -16314, -15924, -15534, -15143, -14751, -14359, -13967, -13574, -13180, -12786, -12391, -11996, -11600, -11204, -10808, -10411, -10014, -9616, -9219, -8820, -8422, -8023, -7623, -7224, -6824, -6424, -6024, -5623, -5222, -4822, -4420, -4019, -3618, -3216, -2814, -2413, -2011, -1609, -1207, -805, -403};
        cosTab = new int[]{65535, 65533, 65530, 65523, 65515, 65504, 65490, 65474, 65456, 65435, 65411, 65385, 65357, 65326, 65293, 65257, 65219, 65178, 65135, 65090, 65042, 64991, 64938, 64883, 64825, 64765, 64702, 64637, 64570, 64500, 64427, 64353, 64275, 64196, 64114, 64029, 63942, 63853, 63761, 63667, 63570, 63472, 63370, 63267, 63161, 63052, 62941, 62828, 62713, 62595, 62474, 62352, 62227, 62100, 61970, 61838, 61704, 61567, 61428, 61287, 61143, 60997, 60849, 60699, 60546, 60391, 60234, 60074, 59912, 59748, 59582, 59413, 59242, 59069, 58894, 58717, 58537, 58355, 58171, 57985, 57796, 57606, 57413, 57218, 57021, 56821, 56620, 56416, 56211, 56003, 55793, 55581, 55367, 55151, 54933, 54712, 54490, 54265, 54039, 53810, 53580, 53347, 53113, 52876, 52638, 52397, 52155, 51910, 51664, 51415, 51165, 50913, 50659, 50403, 50145, 49885, 49623, 49360, 49094, 48827, 48558, 48287, 48014, 47739, 47463, 47185, 46905, 46623, 46340, 46055, 45768, 45479, 45189, 44896, 44603, 44307, 44010, 43711, 43411, 43109, 42805, 42500, 42193, 41885, 41574, 41263, 40950, 40635, 40319, 40001, 39682, 39361, 39039, 38715, 38390, 38063, 37735, 37406, 37075, 36742, 36409, 36074, 35737, 35400, 35061, 34720, 34378, 34035, 33691, 33346, 32999, 32651, 32302, 31951, 31599, 31247, 30892, 30537, 30181, 29823, 29465, 29105, 28744, 28382, 28019, 27655, 27290, 26924, 26557, 26189, 25820, 25450, 25079, 24707, 24334, 23960, 23585, 23210, 22833, 22456, 22078, 21699, 21319, 20938, 20557, 20174, 19791, 19408, 19023, 18638, 18252, 17866, 17479, 17091, 16702, 16313, 15923, 15533, 15142, 14750, 14358, 13966, 13573, 13179, 12785, 12390, 11995, 11599, 11203, 10807, 10410, 10013, 9615, 9218, 8819, 8421, 8022, 7622, 7223, 6823, 6423, 6023, 5622, 5221, 4821, 4419, 4018, 3617, 3215, 2813, 2412, 2010, 1608, 1206, 804, 402, 0, -403, -805, -1207, -1609, -2011, -2413, -2814, -3216, -3618, -4019, -4420, -4822, -5222, -5623, -6024, -6424, -6824, -7224, -7623, -8023, -8422, -8820, -9219, -9616, -10014, -10411, -10808, -11204, -11600, -11996, -12391, -12786, -13180, -13574, -13967, -14359, -14751, -15143, -15534, -15924, -16314, -16703, -17092, -17480, -17867, -18253, -18639, -19024, -19409, -19792, -20175, -20558, -20939, -21320, -21700, -22079, -22457, -22834, -23211, -23586, -23961, -24335, -24708, -25080, -25451, -25821, -26190, -26558, -26925, -27291, -27656, -28020, -28383, -28745, -29106, -29466, -29824, -30182, -30538, -30893, -31248, -31600, -31952, -32303, -32652, -33000, -33347, -33692, -34036, -34379, -34721, -35062, -35401, -35738, -36075, -36410, -36743, -37076, -37407, -37736, -38064, -38391, -38716, -39040, -39362, -39683, -40002, -40320, -40636, -40951, -41264, -41575, -41886, -42194, -42501, -42806, -43110, -43412, -43712, -44011, -44308, -44604, -44897, -45190, -45480, -45769, -46056, -46341, -46624, -46906, -47186, -47464, -47740, -48015, -48288, -48559, -48828, -49095, -49361, -49624, -49886, -50146, -50404, -50660, -50914, -51166, -51416, -51665, -51911, -52156, -52398, -52639, -52877, -53114, -53348, -53581, -53811, -54040, -54266, -54491, -54713, -54934, -55152, -55368, -55582, -55794, -56004, -56212, -56417, -56621, -56822, -57022, -57219, -57414, -57607, -57797, -57986, -58172, -58356, -58538, -58718, -58895, -59070, -59243, -59414, -59583, -59749, -59913, -60075, -60235, -60392, -60547, -60700, -60850, -60998, -61144, -61288, -61429, -61568, -61705, -61839, -61971, -62101, -62228, -62353, -62475, -62596, -62714, -62829, -62942, -63053, -63162, -63268, -63371, -63473, -63571, -63668, -63762, -63854, -63943, -64030, -64115, -64197, -64276, -64354, -64428, -64501, -64571, -64638, -64703, -64766, -64826, -64884, -64939, -64992, -65043, -65091, -65136, -65179, -65220, -65258, -65294, -65327, -65358, -65386, -65412, -65436, -65457, -65475, -65491, -65505, -65516, -65524, -65531, -65534, -65535, -65534, -65531, -65524, -65516, -65505, -65491, -65475, -65457, -65436, -65412, -65386, -65358, -65327, -65294, -65258, -65220, -65179, -65136, -65091, -65043, -64992, -64939, -64884, -64826, -64766, -64703, -64638, -64571, -64501, -64428, -64354, -64276, -64197, -64115, -64030, -63943, -63854, -63762, -63668, -63571, -63473, -63371, -63268, -63162, -63053, -62942, -62829, -62714, -62596, -62475, -62353, -62228, -62101, -61971, -61839, -61705, -61568, -61429, -61288, -61144, -60998, -60850, -60700, -60547, -60392, -60235, -60075, -59913, -59749, -59583, -59414, -59243, -59070, -58895, -58718, -58538, -58356, -58172, -57986, -57797, -57607, -57414, -57219, -57022, -56822, -56621, -56417, -56212, -56004, -55794, -55582, -55368, -55152, -54934, -54713, -54491, -54266, -54040, -53811, -53581, -53348, -53114, -52877, -52639, -52398, -52156, -51911, -51665, -51416, -51166, -50914, -50660, -50404, -50146, -49886, -49624, -49361, -49095, -48828, -48559, -48288, -48015, -47740, -47464, -47186, -46906, -46624, -46341, -46056, -45769, -45480, -45190, -44897, -44604, -44308, -44011, -43712, -43412, -43110, -42806, -42501, -42194, -41886, -41575, -41264, -40951, -40636, -40320, -40002, -39683, -39362, -39040, -38716, -38391, -38064, -37736, -37407, -37076, -36743, -36410, -36075, -35738, -35401, -35062, -34721, -34379, -34036, -33692, -33347, -33000, -32652, -32303, -31952, -31600, -31248, -30893, -30538, -30182, -29824, -29466, -29106, -28745, -28383, -28020, -27656, -27291, -26925, -26558, -26190, -25821, -25451, -25080, -24708, -24335, -23961, -23586, -23211, -22834, -22457, -22079, -21700, -21320, -20939, -20558, -20175, -19792, -19409, -19024, -18639, -18253, -17867, -17480, -17092, -16703, -16314, -15924, -15534, -15143, -14751, -14359, -13967, -13574, -13180, -12786, -12391, -11996, -11600, -11204, -10808, -10411, -10014, -9616, -9219, -8820, -8422, -8023, -7623, -7224, -6824, -6424, -6024, -5623, -5222, -4822, -4420, -4019, -3618, -3216, -2814, -2413, -2011, -1609, -1207, -805, -403, -1, 402, 804, 1206, 1608, 2010, 2412, 2813, 3215, 3617, 4018, 4419, 4821, 5221, 5622, 6023, 6423, 6823, 7223, 7622, 8022, 8421, 8819, 9218, 9615, 10013, 10410, 10807, 11203, 11599, 11995, 12390, 12785, 13179, 13573, 13966, 14358, 14750, 15142, 15533, 15923, 16313, 16702, 17091, 17479, 17866, 18252, 18638, 19023, 19408, 19791, 20174, 20557, 20938, 21319, 21699, 22078, 22456, 22833, 23210, 23585, 23960, 24334, 24707, 25079, 25450, 25820, 26189, 26557, 26924, 27290, 27655, 28019, 28382, 28744, 29105, 29465, 29823, 30181, 30537, 30892, 31247, 31599, 31951, 32302, 32651, 32999, 33346, 33691, 34035, 34378, 34720, 35061, 35400, 35737, 36074, 36409, 36742, 37075, 37406, 37735, 38063, 38390, 38715, 39039, 39361, 39682, 40001, 40319, 40635, 40950, 41263, 41574, 41885, 42193, 42500, 42805, 43109, 43411, 43711, 44010, 44307, 44603, 44896, 45189, 45479, 45768, 46055, 46340, 46623, 46905, 47185, 47463, 47739, 48014, 48287, 48558, 48827, 49094, 49360, 49623, 49885, 50145, 50403, 50659, 50913, 51165, 51415, 51664, 51910, 52155, 52397, 52638, 52876, 53113, 53347, 53580, 53810, 54039, 54265, 54490, 54712, 54933, 55151, 55367, 55581, 55793, 56003, 56211, 56416, 56620, 56821, 57021, 57218, 57413, 57606, 57796, 57985, 58171, 58355, 58537, 58717, 58894, 59069, 59242, 59413, 59582, 59748, 59912, 60074, 60234, 60391, 60546, 60699, 60849, 60997, 61143, 61287, 61428, 61567, 61704, 61838, 61970, 62100, 62227, 62352, 62474, 62595, 62713, 62828, 62941, 63052, 63161, 63267, 63370, 63472, 63570, 63667, 63761, 63853, 63942, 64029, 64114, 64196, 64275, 64353, 64427, 64500, 64570, 64637, 64702, 64765, 64825, 64883, 64938, 64991, 65042, 65090, 65135, 65178, 65219, 65257, 65293, 65326, 65357, 65385, 65411, 65435, 65456, 65474, 65490, 65504, 65515, 65523, 65530, 65533};
    }
}

