; ------------------------------------------------------
; Useful equates
; ------------------------------------------------------
TRUN                equ     0x0020
TREG0               equ     0x0022
TREG1               equ     0x0023
T01MOD              equ     0x0024
TFFCR               equ     0x0025
TREG2               equ     0x0026
TREG3               equ     0x0027
T23MOD              equ     0x0028
TRDC                equ     0x0029

DACL                equ     0x00A2
DACR                equ     0x00A3

DMA0V               equ     0x007C
DMA1V               equ     0x007D
DMA2V               equ     0x007E
DMA3V               equ     0x007F

SOUNDCPU_CTRL       equ     0x00B8
Z80_NMI             equ     0x00BA
Z80_COMM            equ     0x00BC
WATCHDOG            equ     0x006F
INT_ROM             equ     0xFF0000
CART_ROM            equ     0x200000
TILE_RAM            equ     0xA000
CHAR_RAM            equ     0xA000
WORK_RAM            equ     0x4000
MAIN_RAM            equ     0x4000
Z80_RAM             equ     0x7000

REG_CH4             equ     0x4000
REG_CH123           equ     0x4001

FIRST_TXFER         equ     0x80
TONE1_FREQ          equ     0x0
TONE1_VOL           equ     0x10
TONE2_FREQ          equ     0x20
TONE2_VOL           equ     0x30
TONE3_FREQ          equ     0x40
TONE3_VOL           equ     0x50
NOISE_CTRL          equ     0x60
NOISE_VOL           equ     0x70

Z80_OFF_SOUND_OFF   equ     0xAAAA
Z80_ON_SOUND_ON     equ     0x5555

BAT_VOLT            equ     0x6F80
JOYPAD              equ     0x6F82
SYS_LEVER           equ     0x6F82
USR_BOOT            equ     0x6F84
USR_SHUTDOWN        equ     0x6F85
USR_ANSWER          equ     0x6F86
LANGUAGE            equ     0x6F87
OS_VERSION          equ     0x6F91

DISP_CTL0           equ     0x8000
STS_RG              equ     0x8010
LCD_CTR             equ     0x8012
RESET               equ     0x87E0
VERSION             equ     0x87FE
SCRL_PRIO           equ     0x8030
SPR_RAM             equ     0x8800
SPR_COLOR           equ     0x8C00
SPR_X               equ     0x8020
SPR_Y               equ     0x8021
SCR1_RAM            equ     0x9000
SCR2_RAM            equ     0x9800
SCR_PRIORITY        equ     0x8030
SCR1_X              equ     0x8032
SCR1_Y              equ     0x8033
SCR2_X              equ     0x8034
SCR2_Y              equ     0x8035
WIN_X               equ     0x8002
WIN_Y               equ     0x8003
WIN_W               equ     0x8004
WIN_H               equ     0x8005
WIN_WH              equ     0x8004
REF                 equ     0x8006
BG_COL              equ     0x8118
RAS_H               equ     0x8008
RAS_Y               equ     0x8009
STATUS_2D           equ     0x8010
CONTROL_2D          equ     0x8012
SPR_PAL             equ     0x8200
SCR1_PAL            equ     0x8280
SCR2_PAL            equ     0x8300
SCR1_LUT            equ     0x8108
SCR2_LUT            equ     0x8110
BG_PAL              equ     0x83E0
WIN_PAL             equ     0x83F0
GE_MODE             equ     0x87E2

SWI3_INT            equ     0x6FB8
SWI4_INT            equ     0x6FBC
SWI5_INT            equ     0x6FC0
SWI6_INT            equ     0x6FC4
RTCI_INT            equ     0x6FC8
VBL_INT             equ     0x6FCC
Z80_INT             equ     0x6FD0
HBL_INT             equ     0x6FD4
TI0_INT             equ     0x6FD4
TI1_INT             equ     0x6FD8
TI2_INT             equ     0x6FDC
TI3_INT             equ     0x6FE0
STX_INT             equ     0x6FE4
SRX_INT             equ     0x6FE8
DMA0_INT            equ     0x6FF0
DMA1_INT            equ     0x6FF4
DMA2_INT            equ     0x6FF8
DMA3_INT            equ     0x6FFC

NEG_2D              equ     (1 << 7)

PROP_PALETTE_1      equ     (0 << 5)
PROP_PALETTE_2      equ     (1 << 5)
PROP_H_FLIP         equ     (1 << 6)
PROP_V_FLIP         equ     (1 << 7)

PROP_SPR_PRIO_FURTHEST equ  (1 << 3)
PROP_SPR_PRIO_MIDDLE equ    (2 << 3)
PROP_SPR_PRIO_FRONT equ     (3 << 3)

CTL0_VBL            equ     (1 << 7)
CTL0_HBL            equ     (1 << 6)

SCRN_W              equ     160
SCRN_H              equ     152
SCRN_TX             equ     20
SCRN_TY             equ     19

BLNK                equ     0x40
C_OVR               equ     0x80

WATCHDOG_CLEAR      equ     0x4E

J_UP                equ     0x01
J_DOWN              equ     0x02
J_LEFT              equ     0x04
J_RIGHT             equ     0x08
J_A                 equ     0x10
J_B                 equ     0x20
J_OPTION            equ     0x40
J_POWER             equ     0x80

VECT_SHUTDOWN       equ     0                               ; Shutdown (Power OFF)
VECT_CLOCKGEARSET   equ     1                               ; CPU operation clock setting
VECT_RTCGET         equ     2                               ; Real time clock - obtain time
VECT_INTLVSET       equ     4                               ; Interrupt level setting
VECT_SYSFONTSET     equ     5                               ; System   font setting
VECT_FLASHWRITE     equ     6                               ; Flash memory -   data write
VECT_FLASHALLERS    equ     7                               ; Flash memory -   erase all blocks
VECT_FLASHERS       equ     8                               ; Flash memory -   erase specified blocks
VECT_ALARMSET       equ     9                               ; Real time clock - alarm setting during   game operation
VECT_ALARMDOWNSET   equ     11                              ; Real time clock - unit   start up alarm setting
VECT_FLASHPROTECT   equ     13                              ; Flash memory -   protect specified blocks
VECT_GEMODESET      equ     14                              ; Color LCD color mode setting (color version only)
VECT_COMINIT        equ     16                              ; Initialize   serial communication BIOS
VECT_COMSENDSTART   equ     17                              ; Communication start send BIOS
VECT_COMRECIVESTART equ     18                              ; Communication start reception BIOS
VECT_COMCREATEDATA  equ     19                              ; Communication create send data   BIOS
VECT_COMGETDATA     equ     20                              ; Communication obtain reception   data BIOS
VECT_COMONRTS       equ     21                              ; Communication allow RTS signal   send BIOS
VECT_COMOFFRTS      equ     22                              ; Communication prohibit   RTS signal send BIOS
VECT_COMSENDSTATUS  equ     23                              ; Communication obtain send status BIOS
VECT_COMRECIVESTATUS equ    24                              ; Communication obtain reception   status BIOS
VECT_COMCREATEBUFDATA equ   25                              ; Communication obtain create data buffer BIOS
VECT_COMGETBUFDATA  equ     26                              ; Communication write reception obtaining buffer   BIOS
