; ------------------------------------------------------
; 1kPack v0.9c - OpenGL Framework
; Written by Franck "hitchhikr" Charlet / Neural
; ------------------------------------------------------
; OpenGL version by nystep & hitchhikr
; ------------------------------------------------------
; buildblock RELEASE
; CAPT "[SOURCEDIR]nasmw.exe" -f bin "%2" -o "%1.bin" -s -O9
; CAPT "[SOURCEDIR]1kpack.exe" "depackers\ogl_depacker_gtc.bin" "%1.bin"
; buildblockend
;
; buildblock DEBUG
; CAPT "[SOURCEDIR]nasmw.exe" -D DEBUG -f bin "%2" -o "%1.bin" -s -O9
; CAPT "[SOURCEDIR]1kpack.exe" "depackers\ogl_depacker_gtc_debug.bin" "%1.bin"
; buildblockend

; ------------------------------------------------------
; Header
                                bits    32

; ------------------------------------------------------
; Pre-processor constants
;%define DEBUG

; ------------------------------------------------------
; User constants
SCREENX                         equ     1024
SCREENY                         equ     768

; ------------------------------------------------------
; Constants
WS_MAXIMIZE                     equ     0x01000000
WS_CAPTION                      equ     0xc00000
WS_POPUP                        equ     0x80000000
WS_BORDER                       equ     0x800000
WS_SYSMENU                      equ     0x80000
WS_VISIBLE                      equ     0x10000000
WS_THICKFRAME                   equ     0x40000
WS_POPUPWINDOW                  equ     WS_BORDER | WS_SYSMENU | WS_CAPTION | WS_VISIBLE | WS_THICKFRAME
SW_SHOWNORMAL                   equ     1
VK_ESCAPE                       equ     0x1b

PM_REMOVE                       equ     0x1

CDS_FULLSCREEN                  equ     0x00000004
CCHDEVICENAME                   equ     32
CCHFORMNAME                     equ     32

DM_PELSWIDTH                    equ     0x00080000
DM_PELSHEIGHT                   equ     0x00100000

PFD_SUPPORT_OPENGL              equ     0x20
PFD_DOUBLEBUFFER                equ     1

GL_FRAGMENT_SHADER              equ     0x8B30
GL_VERTEX_SHADER                equ     0x8B31

BASE                            equ     0x420000

; Those are located inside the depacker
POS_fnc_exit                    equ     0x410090
POS_fnc_LoadLibrary             equ     0x4100b4
POS_fnc_GetProcAddress          equ     0x4100b8
POS_fnc_GetTickCount            equ     0x4100bc

; ---------------------------------------------------------
; Program entry point
; edi contains D3DXCompileShader address
                                org     BASE
                                
; ---------------------------------------------------------
; Program entry point
EntryPoint:                     ; Import the functions we need
                                mov     edi, table_dlls
                                lea     esi, [edi + (API_CreateWindowEx - table_dlls)]
load_dlls:                      push    edi
                                call    dword [POS_fnc_LoadLibrary]
                                test    eax, eax
                                jz      done_dlls
                                push    0x59                            ; Fix a problem with windows 7
                                pop     ecx
                                repne   scasb                           ; Go to end of string
load_functions:                 xchg    ebx, eax                        ; DLL handle
                                push    edi
                                push    ebx
                                call    dword [POS_fnc_GetProcAddress]
                                test    eax, eax
                                jz      load_dlls
                                stosd
                                xchg    ebx, eax
                                repne   scasb                           ; Go to end of string
                                jmp     load_functions
done_dlls:
                                ; ----------------------------------------------------

                                push    CDS_FULLSCREEN
                                push    devicemode
                                call    dword [esi + (API_ChangedisplaySettings - API_CreateWindowEx)]
                                
                                push    PixelFormatDescriptor
                                push    PixelFormatDescriptor
                            
                                %ifndef DEBUG
                                push    0                               ; SetCursor
                                %endif
                            
                                push    0                               ; CreateWindowExA
                                push    0
                                push    0
                                push    0
                                %ifdef DEBUG
                                push    SCREENY
                                push    SCREENX
                                %else
                                push    0
                                push    0
                                %endif
                                push    0
                                push    0
                                %ifdef DEBUG
                                push    WS_POPUPWINDOW
                                %else
                                push    WS_MAXIMIZE + WS_POPUP + WS_VISIBLE
                                %endif
                                push    0
                                push    ClassName
                                push    0
                                call    dword [esi]                     ; + (hash_CreateWindowEx - hash_CreateWindowEx)]
                                xchg    ebx, eax
                                push    ebx
                                call    dword [esi + (API_GetDC - API_CreateWindowEx)]
                                xchg    eax, ebp

                                %ifdef DEBUG
                                push    SW_SHOWNORMAL
                                push    ebx
                                call    dword [esi + (API_ShowWindow - API_CreateWindowEx)]
                                %else
                                call    dword [esi + (API_SetCursor - API_CreateWindowEx)]
                                %endif

                                push    ebp
                                call    dword [esi + (API_ChoosePixelFormat - API_CreateWindowEx)]

                                push    eax
                                push    ebp
                                call    dword [esi + (API_SetPixelFormat - API_CreateWindowEx)]
                            
                                push    ebp
                                call    dword [esi + (API_wglCreateContext - API_CreateWindowEx)]
                                push    eax
                                push    ebp
                                call    dword [esi + (API_wglMakeCurrent - API_CreateWindowEx)]

                                dec     eax                             ; (wglMakeCurrent returns 1 if successful)
getOglExtensions:               push    eax
                                push    edi
                                call    dword [esi + (API_wglGetProcAddress - API_CreateWindowEx)]
                                test    eax, eax
                                jz      done_oglextensions
                                stosd
                                pop     eax
                                repne   scasb
                                jmp     getOglExtensions
done_oglextensions:
                                push    ebp

                                push    0                               ; glShaderSource
                                push    FragmentShader
                                push    1

                                push    0                               ; glShaderSource
                                push    VertexShader
                                push    1

                                push    GL_FRAGMENT_SHADER              ; glCreateShader

                                push    GL_VERTEX_SHADER
                                call    dword [esi + (API_glCreateShader - API_CreateWindowEx)]
                                mov     ebx, eax

                                call    dword [esi + (API_glCreateShader - API_CreateWindowEx)]
                                mov     edi, eax

                                call    dword [esi + (API_glCreateProgram - API_CreateWindowEx)]
                                mov     ebp, eax

                                push    ebx
                                call    dword [esi + (API_glShaderSource - API_CreateWindowEx)]
                                push    ebx
                                call    dword [esi + (API_glCompileShader  - API_CreateWindowEx)]

                                push    edi
                                call    dword [esi + (API_glShaderSource - API_CreateWindowEx)]
                                push    edi
                                call    dword [esi + (API_glCompileShader - API_CreateWindowEx)]

                                push    ebx
                                push    ebp
                                call    dword [esi + (API_glAttachShader - API_CreateWindowEx)]

                                push    edi
                                push    ebp
                                call    dword [esi + (API_glAttachShader - API_CreateWindowEx)]

                                push    ebp
                                call    dword [esi + (API_glLinkProgram - API_CreateWindowEx)]
                                push    ebp
                                call    dword [esi + (API_glUseProgram - API_CreateWindowEx)]

                                pop     ebp

; ------------------------------------------------------
; Program loop
MainLoop:                       
                                %ifdef DEBUG
                                push    PM_REMOVE
                                push    0
                                push    0
                                push    0
                                push    Msg
                                call    dword [esi + (API_PeekMessage - API_CreateWindowEx)]
                                test    eax, eax
                                jz      No_Msg
                                push    Msg
                                call    dword [esi + (API_TranslateMessage - API_CreateWindowEx)]
No_Msg:
                                %endif
                                
                                call    dword [POS_fnc_GetTickCount]
                                push    1
                                push    eax
                                push    -1
                                neg     eax
                                push    eax
                                call    dword [esi + (API_glRecti - API_CreateWindowEx)]        ; glRecti(-t,-1,t,1);
                                push    ebp
                                call    dword [esi + (API_SwapBuffers - API_CreateWindowEx)]

                                push    VK_ESCAPE
                                call    dword [esi + (API_GetAsyncKeyState - API_CreateWindowEx)]
                                sahf
                                jns     MainLoop
                                call    dword [POS_fnc_exit]

; ------------------------------------------------------
; Datas
                                %ifdef DEBUG
Msg:                            times   100 db 0
                                %endif

VertexShader:                   dd      Vsh
FragmentShader:                 dd      Fsh

PixelFormatDescriptor:          dw      0
                                dw      0
                                dd      PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER
                                db      0                               ; = PFD_TYPE_RGBA
                                db      32                              ; color buffer bpp
                                db      0
                                db      0
                                db      0
                                db      0
                                db      0
                                db      0
                                db      0
                                db      0
                                db      0
                                db      0
                                db      0
                                db      0
                                db      0
                                db      32                              ; depth buffer

devicemode:                     times   CCHDEVICENAME db 0              ; dmDeviceName
                                dw      0                               ; dmSpecVersion
                                dw      0                               ; dmDriverVersion
                                dw      124                             ; dmSize
                                dw      0                               ; dmDriverExtra
                                dd      DM_PELSWIDTH | DM_PELSHEIGHT    ; dmFields
                                dw      0                               ; dmOrientation
                                dw      0                               ; dmPaperSize
                                dw      0                               ; dmPaperLength
                                dw      0                               ; dmPaperWidth
                                dw      0                               ; dmScale
                                dw      0                               ; dmCopies
                                dw      0                               ; dmDefaultSource
                                dw      0                               ; dmPrintQuality
                                dw      0                               ; dmColor
                                dw      0                               ; dmDuplex
                                dw      0                               ; dmYResolution
                                dw      0                               ; dmTTOption
                                dw      0                               ; dmCollate  70
                                times   CCHFORMNAME db 0                ; dmFormName 102
                                dw      0                               ; dmLogPixels
                                dd      0                               ; dmBitsPerPel
                                dd      SCREENX                         ; dmPelsWidth
                                dd      SCREENY                         ; dmPelsHeight
                                dd      0                               ; dmDisplayFlags
                                dd      0                               ; dmDisplayFrequency

Vsh:                            db      "void main()"
                                db      "{"
                                db      "gl_Position=gl_Vertex;"
                                db      "}"
                                db      0

Fsh:                            db      "void main()"
                                db      "{"
                                db      "gl_FragColor=1;"
                                db      "}"
                                db      0

ClassName:                      db      "edit", 0

table_dlls:                     db      "user32", 0
API_CreateWindowEx:             db      "CreateWindowExA", 0
                                %ifdef DEBUG
API_ShowWindow:                 db      "ShowWindow", 0
                                %else
API_SetCursor:                  db      "SetCursor", 0
                                %endif
API_GetAsyncKeyState:           db      "GetAsyncKeyState", 0
API_GetDC:                      db      "GetDC", 0
API_ChangedisplaySettings:      db      "ChangeDisplaySettingsA", 0
                                %ifdef DEBUG
API_PeekMessage:                db      "PeekMessageA", 0
API_TranslateMessage:           db      "TranslateMessage", 0
                                %endif
                                db      "opengl32", 0
API_wglCreateContext:           db      "wglCreateContext", 0
API_wglMakeCurrent:             db      "wglMakeCurrent", 0
API_wglGetProcAddress:          db      "wglGetProcAddress", 0
API_glRecti:                    db      "glRecti", 0
                                db      "gdi32", 0
API_ChoosePixelFormat:          db      "ChoosePixelFormat", 0
API_SetPixelFormat:             db      "SetPixelFormat", 0
API_SwapBuffers:                db      "SwapBuffers", 0

API_glCreateShader:             db      "glCreateShader", 0
API_glCreateProgram:            db      "glCreateProgram", 0
API_glShaderSource:             db      "glShaderSource", 0
API_glCompileShader:            db      "glCompileShader", 0
API_glAttachShader:             db      "glAttachShader", 0
API_glLinkProgram:              db      "glLinkProgram", 0
API_glUseProgram:               db      "glUseProgram", 0

                                ; Note: the packer strips any 0 located
                                ; at the end of the file (including the flt above)
                                ; this can eventually be used as a bss section

; ------------------------------------------------------
