// Just ps1.1 rendering path, not complete effect.
// See wings.fx

#ifdef ENABLE_PS11_PATH


SPosColorTex vsMain11( SPosTanspTex i ) {
	SPosColorTex o;
	o.pos = mul( i.pos, mWVP );
	
	float3 n = mul( i.normal, (float3x3)mWorld );
	o.color = saturate( dot( n, -vLightDir ) ) + fLightAmbient;

	o.uv = i.uv;
	o.uv.x *= 2;
	return o;
}

half4 psMain11( SPosColorTex i ) : COLOR
{
	half4 col = tex2D( smpBase, i.uv );
	col.rgb *= i.color;
	col.a *= fAlpha;
	return col;
}

// Blur factor pass
#include "blur_11FFpath.fx"

technique tecPS11
< bool backToFront = true; >
{
	pass PBase {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain11();
		ZWriteEnable = False;
		AlphaBlendEnable = True;
		SrcBlend = One;
		DestBlend = InvSrcAlpha;
	}
	pass PBlur {
		BLUR11_PASS
		AlphaBlendEnable = False;
	}
	pass PLast {
		BLUR_RESTORE
	}
}

#endif
