//
// Wings rendering with translucency and iridescence.
// As presented by N.Tatarchuk, C.Brennan in "ShaderX^2"
//
// ps2.0 - 2 pass, bump-map, translucency, iridescence
// ps1.1/FFP - 2 pass, plain texturing
// 

#include "_lib.fx"

float4x4	mWorld;
float4x4	mWorldView;
float4x4	mWVP;

texture tBase;
texture tNormal;
texture tGradient;

float	fAlpha;

sampler2D smpBase = sampler_state {
	Texture = (tBase);
    MipFilter = Linear;	MinFilter = Linear; MagFilter = Linear;
    AddressU = Wrap; AddressV = Wrap;
};
sampler2D smpNormal = sampler_state {
	Texture = (tNormal);
    MipFilter = Linear;	MinFilter = Linear; MagFilter = Linear;
    AddressU = Wrap; AddressV = Wrap;
};
sampler1D smpGradient = sampler_state {
	Texture = (tGradient);
    MipFilter = Linear;	MinFilter = Linear; MagFilter = Linear;
    AddressU = Mirror; AddressV = Mirror;
};


#include "wings_20path.fx"
#include "wings_11path.fx"
#include "wings_FFpath.fx"
