// Just ps1.1 rendering path, not complete effect.
// See terrain.fx

#ifdef ENABLE_PS11_PATH

// 1st pass: mix, three layers (one discarded)

SPosTex4 vsMain11a( SPosTex4 i ) {
	SPosTex4 o;
	o.pos = mul( i.pos, mWVP );
	o.uv[0] = i.uv[0]; // mix
	o.uv[1] = i.uv[2] * 290; // detail1
	o.uv[2] = i.uv[2] * 320; // detail2
	o.uv[3] = i.uv[3]; // base
	return o;
}

half4 psMain11a( SPosTex4 i ) : COLOR
{
	half4 mix = tex2D( smpMix, i.uv[0] );
	half4 col;
	col.rgb = tex2D( smpBody, i.uv[3] );
	col.rgb = lerp( col.rgb, tex2D( smpBase0, i.uv[2] ), mix.b );
	col.rgb = lerp( col.rgb, tex2D( smpBase1, i.uv[1] ), mix.g );
	col.a = 1;
	return col;
}

// 2nd pass: lightmap + dof

SPosTexBlurc vsMain11b( SPosTex4 i ) {
	SPosTexBlurc o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv[1]; // lmap
	o.blur = gBlurFactor( i.pos, mWorldView );
	return o;
}

half4 psMain11b( SPosTexBlurc i ) : COLOR
{
	half4 lmap = tex2D( smpLightMap, i.uv );
	return half4( lmap.rgb, i.blur.a );
}

technique tecPS11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11a();
		PixelShader = compile ps_1_1 psMain11a();
	}
	pass P1 {
		VertexShader = compile vs_1_1 vsMain11b();
		PixelShader = compile ps_1_1 psMain11b();
		AlphaBlendEnable = True;
		SrcBlend = Zero;
		DestBlend = SrcColor;
	}
	pass PLast {
		AlphaBlendEnable = False;
	}
}

#endif
