// Just ps2.0 rendering path, not complete effect.
// See fur.fx

#ifdef ENABLE_PS20_PATH

float fExtrude : register(c20);
half  fCut : register(c0);

SPosTexWorldNV vsShell20( SPosNormalTex i ) {
	SPosTexWorldNV o;
	i.pos.xyz += i.normal * fExtrude * fFurShell;
	float3 pos = mul( i.pos, mWorld );
	o.n = normalize( mul( i.normal, (float3x3)mWorld ) );
	o.pos = mul( float4(pos,1), mViewProj );
	o.uv = i.uv;
	o.v = normalize( vEye - pos );
	return o;
}

half4 psShell20( SPosTexWorldNV i ) : COLOR
{
	half4 col = tex2D( smpShell, i.uv );

	// light hairs
	half3 tol = -vLightDir;
	half2 luv;
	luv.x = dot( tol, i.n ) * 0.5 + 0.5; // L.T
	luv.y = dot( i.v, i.n ) * 0.5 + 0.5; // V.T
	half4 diffspec = tex2D( smpFurLUT, luv );
	col.rgb *= diffspec.r;
	col.rgb += diffspec.g;
	
	// shadow backsides
	const half ambient = 0.40;
	half diff = saturate( saturate( dot( tol, i.n ) + 0.2 ) * 2 + ambient );
	col.rgb *= diff;
	
	col.rgb *= 1 - saturate( col.a - fCut ); // fake fur darkening for deeper shells
	col.a = 1 - saturate( (fCut - col.a)*4 );
	
	return col;
}

VertexShader vshShell20 = compile vs_1_1 vsShell20();
PixelShader pshShell20 = compile ps_2_0 psShell20();


technique tecPS20
< bool backToFront = true; >
{
    pass PShell1 {
        VertexShader = <vshShell20>;
        PixelShader = <pshShell20>;
		VertexShaderConstant[20] = (1);
		PixelShaderConstant[0] = (80.0/255.0);
		AlphaTestEnable = True;
		AlphaRef = 80;
		AlphaFunc = Greater;
		AlphaBlendEnable = True;
		ZWriteEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
		ColorWriteEnable = Red | Green | Blue;
    }
    pass PShell2 {
        VertexShader = (vshShell20);
        PixelShader = (pshShell20);
		VertexShaderConstant[20] = (2);
		PixelShaderConstant[0] = (90.0/255.0);
		AlphaRef = 90;
    }
    pass PShell3 {
        VertexShader = (vshShell20);
        PixelShader = (pshShell20);
		VertexShaderConstant[20] = (4);
		PixelShaderConstant[0] = (110.0/255.0);
		AlphaRef = 110;
    }
    pass PShell4 {
        VertexShader = (vshShell20);
        PixelShader = (pshShell20);
		VertexShaderConstant[20] = (6);
		PixelShaderConstant[0] = (130.0/255.0);
		AlphaRef = 130;
    }
    pass PShell5 {
        VertexShader = (vshShell20);
        PixelShader = (pshShell20);
		VertexShaderConstant[20] = (8);
		PixelShaderConstant[0] = (150.0/255.0);
		AlphaRef = 150;
    }
    pass PShell6 {
        VertexShader = (vshShell20);
        PixelShader = (pshShell20);
		VertexShaderConstant[20] = (10);
		PixelShaderConstant[0] = (170.0/255.0);
		AlphaRef = 170;
    }
    pass PShell7 {
        VertexShader = (vshShell20);
        PixelShader = (pshShell20);
		VertexShaderConstant[20] = (12);
		PixelShaderConstant[0] = (190.0/255.0);
		AlphaRef = 190;
    }
	pass PLast {
		ColorWriteEnable = Red | Green | Blue | Alpha;
		AlphaBlendEnable = False;
		AlphaTestEnable = False;
		ZWriteEnable = True;
	}
}

#endif
