//
// Composite Depth-of-Field using two blurred images and framebuffer.
// As presented by M.Kawase in GDC2003, "Frame Buffer Postprocessing Effects"
//
// ps2.0, ps1.1
// ps1.4 - use 1 blurred RT only, ps1.1 seems to be a driver bug on DX8 Radeons
// FFP - dummy
// 

#include "_lib.fx"
  
texture		tBase;
texture		tBlur1;
texture		tBlur2;

// x=0.5/texwidth, y=0.5/texheight
float4	vFixUV;

sampler smpBase = sampler_state {
    Texture   = (tBase);
    MipFilter = None;	MinFilter = Point; MagFilter = Point;
    AddressU = Clamp; AddressV = Clamp;
};
sampler smpBlur1 = sampler_state {
    Texture   = (tBlur1);
    MipFilter = None;	MinFilter = Linear; MagFilter = Linear;
    AddressU = Clamp; AddressV = Clamp;
};
sampler smpBlur2 = sampler_state {
    Texture   = (tBlur2);
    MipFilter = None;	MinFilter = Linear; MagFilter = Linear;
    AddressU = Clamp; AddressV = Clamp;
};


SPosTex3 vsMain( SPosTex i )
{
    SPosTex3 o;
	o.pos = billboardpos( i.pos );
	o.uv[0] = i.uv + vFixUV.xy*0.5;
	o.uv[1] = i.uv + vFixUV.xy;
	o.uv[2] = i.uv + vFixUV.xy;
	return o;
}

#ifdef ENABLE_PS20_PATH

half4 psMain20( SPosTex3 i ) : COLOR
{
	half ca = tex2D( smpBase, i.uv[0] ).a;
	half3 cblur1 = tex2D( smpBlur1, i.uv[1] );
	half3 cblur2 = tex2D( smpBlur2, i.uv[2] );
	half a;
	if( ca > 0.5 )
		a = saturate( ca * 0.25 + 0.75 );
	else
		a = saturate( ca * 1.5 );
	half factor = saturate( ca * 1.5 - 0.75 );
	half3 blur = lerp( cblur1, cblur2, factor );
	return half4( blur, a );
}

technique tec20 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = compile ps_2_0 psMain20();

		ZEnable = False;
		ZWriteEnable = False;
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
	pass PLast {
		ZEnable = True;
		ZWriteEnable = True;
		AlphaBlendEnable = False;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}

#endif


half4 psMain14( SPosTex3 i ) : COLOR
{
	half4 cblur = tex2D( smpBlur1, i.uv[1] );
	cblur.a *= 0.9;
	return cblur;
}

technique tec14 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = compile ps_1_4 psMain14();

		ZEnable = False;
		ZWriteEnable = False;
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
	pass PLast {
		ZEnable = True;
		ZWriteEnable = True;
		AlphaBlendEnable = False;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}


#ifdef ENABLE_PS11_PATH

half4 psMain11( SPosTex3 i ) : COLOR
{
	half ca = tex2D( smpBase, i.uv[0] ).a;
	half3 cblur1 = tex2D( smpBlur1, i.uv[1] );
	half3 cblur2 = tex2D( smpBlur2, i.uv[2] );
	half a = (ca*2-1) * ((ca>0.5) ? 0.15 : 0.75);
	a += 0.75;
	half factor = saturate( (ca*2-1) * 0.75 );
	half3 blur = lerp( cblur1, cblur2, factor );
	return half4( blur, a );
}

technique tec11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain();
		PixelShader = compile ps_1_1 psMain11();

		ZEnable = False;
		ZWriteEnable = False;
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
	pass PLast {
		ZEnable = True;
		ZWriteEnable = True;
		AlphaBlendEnable = False;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}

#endif

technique tecFFP {
	pass PLast {
	}
}
