// various global (not per-object) parameters are here
#ifndef __SHARED_FX
#define __SHARED_FX

#include "_defines.fx"


shared float	fTime;


// --------------------------------------------------------------------------
// camera

shared float4x4	mView;
shared float4x4	mProjection;
shared float4x4	mViewProj;
shared float3	vEye;
shared float	fFocalDist;
shared float	fBlurOffset = 0.0;

// --------------------------------------------------------------------------
// light

shared float3	vLightDir;
static float	fLightDiffuse = 0.5;
static float	fLightO = 0.5;
static float	fLightAmbient = 0.1;
static float	fLightK = 16;
static float	fShadow = 0.6;

// --------------------------------------------------------------------------
// shared textures

// Shared textures crash 2004 Beta3 :(
//shared texture tFurLUT;


// --------------------------------------------------------------------------


// cull params: CW=2 (should be default), CCW=3 (for reflected, etc.)
shared int		iCull = 2;


shared float4x4	mViewTexProj;

shared static float4x4 mIdentity = float4x4(
	1,0,0,0,
	0,1,0,0,
	0,0,1,0,
	0,0,0,1 );
shared static float4x4 mSphereMap = float4x4(
	0.4,0,  0, 0,
	0, -0.4,0, 0,
	0,  0.0,0, 0,
	0.5,0.5,0, 0 );


#endif
