#ifndef _VU0_H_
#define _VU0_H_


typedef struct {
  int32 alpha, beta, gamma, fog;
  int32 tx, ty, tz, tw;
  int32 sx, sy, sz, sw;
} VU0_TRNSFRM_TABLE;

typedef struct {
  int32 x,y,z,w;
} __attribute__((aligned(16))) VERTEX_I32, VERTEX0, VERTEX4, VERTEX12, VERTEX15;

typedef struct {
  float x,y,z,w;
} __attribute__((aligned(16))) VERTEX_F32;


extern void vu0_setup_gcc(VU0_TRNSFRM_TABLE *tt);
extern void vu0_normal_i12( VERTEX_F32 *coord_out, VERTEX12 *coord_in );

extern void vu0_transform_i4( VERTEX4 *coord_out, VERTEX4 *coord_in );
extern void vu0_transform_ipol_i4( VERTEX4 *coord_out, VERTEX4 *coord_in_a, VERTEX4 *coord_in_b, float fade );

extern void vu0_transform_i12( VERTEX4 *coord_out, VERTEX12 *coord_in );
extern void vu0_transform_ipol_i12( VERTEX4 *coord_out, VERTEX12 *coord_in_a, VERTEX12 *coord_in_b, float fade );


#endif
