#include <tamtypes.h>
#include <defines.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <kernel.h>

// npm lib includes
#include <fileio.h>

// local includes
#include "main.h"
#include "icon.h"
#include "index.h"
#include "display.h"
#include "npm_libmc.h"



ICON_SYS ico_sys __attribute__((aligned (16)));
INDEX_ROOT index_root __attribute__((aligned (16)));
INDEX_SUB_HEAD index_sub_head __attribute__((aligned (16)));

char buf[MAX_COPY_SPACE] __attribute__((aligned (128)));
uint32 fofs;




// read index to update list of host files (index_root)
int index_read()
{
    int fh;
    int rv;
    int size;


    fh = npmOpen(FILENAME_INDEX, O_RDONLY);
    if(fh < 0) return(-1);

    //k_WaitSema(display_sema_data);

    size = npmRead(fh, &index_root, sizeof(index_root));
    npmClose(fh);

    if(size < 0) {rv=-2; goto exit;}
    size -= sizeof(INDEX_ROOT_HEAD);
    if(size < 0) {rv=-3; goto exit;}
    if(size != (int)(index_root.head.entries * sizeof(INDEX_ROOT_ENTRY))) {rv=-4; goto exit;}
    if(index_root.head.id != INDEX_ID) {rv=-5; goto exit;}

    rv = 0;
exit:
    if(rv < 0) index_root.head.entries = 0;
    //k_SignalSema(display_sema_data);
    return(rv);
}



int index_write()
{
    int fh;
    int size;


    index_root.head.id = INDEX_ID;

    size = sizeof(INDEX_ROOT_HEAD) + index_root.head.entries * sizeof(INDEX_ROOT_ENTRY);
    fh = npmOpen(FILENAME_INDEX, O_WRONLY|O_CREAT);
    if(fh < 0) return(-1);
    if(npmWrite(fh, &index_root, size) < size) {
        npmClose(fh);
        return(-2);
    }
    npmClose(fh);

    return(0);
}






// write mc directory to file
int _index_add_dir(int port, char *name, int fh)
{
    INDEX_SUB_ENTRY ise;
    mc_dirent files[MAX_ENTRIES_SUB];
    int rv,mh;
    int i,j, s,k;


    if(_mc_chdir(port, name) < 0) return(-1);       // savegame doesnt exist?

    i = _mc_getdir(port, files, MAX_ENTRIES_SUB);
    if(i < 0) {rv=-2; goto exit;}

    for(j=0; j<i; j++) {
        dbgmsg(("%d: \"%s\", attr=0%Xh, size=%d\n", j+1, files[j].name, files[j].attr, files[j].size));

        if(files[j].name[0] == 0) goto next_one;
        if(files[j].name[0] == '.' && files[j].name[1] == 0) goto next_one;
        if(files[j].name[0] == '.' && files[j].name[1] == '.' && files[j].name[2] == 0) goto next_one;

        strncpy(ise.name, files[j].name, MAX_FILENAME_SPACE);
  k_FlushCache(0);
        ise.attr = files[j].attr;
        ise.size = files[j].size;
  k_FlushCache(0);

        if(npmWrite(fh, &ise, sizeof(ise)) < sizeof(ise)) {rv=-3; goto exit;}
        fofs += sizeof(ise);
        index_sub_head.entries++;


        // directory or file??
        if((files[j].attr&MCATTR_SUBDIR) != 0) {

            rv = _index_add_dir(port, name, fh);
            if(rv < 0) goto exit;

            // write subdir terminator
            memset(&ise, 0, sizeof(ise));
            if(npmWrite(fh, &ise, sizeof(ise)) < sizeof(ise)) {rv=-4; goto exit;}
            fofs += sizeof(ise);
            index_sub_head.entries++;

        } else {

            if(stricmp(files[j].name, "icon.sys") == 0) index_sub_head.fofs_sys = fofs;
            if((ico_sys.loaded != 0)&&(stricmp(files[j].name, ico_sys.icon[0]) == 0)) index_sub_head.fofs_ico = fofs;

            // open mc file
            mh = _mc_open(port, files[j].name, O_RDONLY);
            if(mh < 0) {rv=-5; goto exit;}

            // copy loop
            s = files[j].size;
            while(s > 0) {
                k = s;
                if(k > MAX_COPY_SPACE) k = MAX_COPY_SPACE;
                s -= k;

                if(_mc_read(mh, buf, k) < k) {_mc_close(mh); rv=-6; goto exit;}
                if(npmWrite(fh, buf, k) < k) {_mc_close(mh); rv=-7; goto exit;}
                fofs += k;
            }

            // close mc file
            if(_mc_close(mh) < 0) {rv=-8; goto exit;}

        }

next_one:
    }

    // write directory terminator
    memset(&ise, 0, sizeof(ise));
    if(npmWrite(fh, &ise, sizeof(ise)) < sizeof(ise)) {rv=-9; goto exit;}
    fofs += sizeof(ise);
    index_sub_head.entries++;

    rv = 0;

exit:
    _mc_chdir(port, "..");
    return(rv);
}



// add directory from memcard
int index_add(int port, char *name, uint8 overwrite)
{
    uint32 index_id;
    int fh;
    int rv;


    // search for duplicated to replace them
    for(index_id=0; index_id<index_root.head.entries; index_id++) {
        if( stricmp(index_root.entry[ index_id ].filename, name) == 0) {
            if(!overwrite) return(-1);
            break;
        }
    }
    if(index_id >= MAX_ENTRIES_ROOT) return(-2);    // too many entries?

    // change directory
    if(_mc_chdir(port, name) < 0) return(-3);       // savegame doesnt exist?

    // try to read icon.sys file, to determine ico and title name
    rv = icon_load_sys("icon.sys", &ico_sys, port);

    // add new entry
    //k_WaitSema(display_sema_data);
    strncpy(index_root.entry[ index_id ].filename, name, MAX_FILENAME_SPACE);
    if(ico_sys.loaded == 0) {
        strncpy(index_root.entry[ index_id ].title[0], name, MAX_TITLE_SPACE);
                index_root.entry[ index_id ].title[1][0] = 0;
    } else {
        strncpy(index_root.entry[ index_id ].title[0], ico_sys.title[0], MAX_TITLE_SPACE);
        strncpy(index_root.entry[ index_id ].title[1], ico_sys.title[1], MAX_TITLE_SPACE);
    }
    //k_SignalSema(display_sema_data);

    // create new file
    memset(&index_sub_head, 0, sizeof(INDEX_SUB_HEAD));
    index_sub_head.id = INDEX_ID;

    sprintf(buf, FILENAME_INDEX_ENTRY, name);
    fh = npmOpen(buf, O_WRONLY|O_CREAT);
    if(fh < 0) {
        _mc_chdir(port, "..");
        return(-4);
    }

    if(npmWrite(fh, &index_sub_head, sizeof(INDEX_SUB_HEAD)) < sizeof(INDEX_SUB_HEAD)) {
        _mc_chdir(port, "..");
        npmClose(fh);
        return(-5);
    }
    fofs = sizeof(INDEX_SUB_HEAD);  // update file offset ptr


    // add directory (afterthat weare inside mc root dir again)
    rv = _index_add_dir(port, ".", fh);
    if(rv < 0) {
        if(rv == -1) _mc_chdir(port, "..");
        npmClose(fh);
        return(rv - 100);
    }


    // rewrite head and close file
    npmLseek(fh, 0, 0);
    if(npmWrite(fh, &index_sub_head, sizeof(INDEX_SUB_HEAD)) < sizeof(INDEX_SUB_HEAD)) {
        npmClose(fh);
        return(-6);
    }
    npmClose(fh);

    // write root entry
    if(index_id >= index_root.head.entries) {
        //k_WaitSema(display_sema_data);
        index_root.head.entries++;
        //index_root_sort();
        //k_SignalSema(display_sema_data);
    }
    rv = index_write();
    if(rv < 0) rv = -7;
    return(rv);
}






int _index_copy_dir(int port, char *name, int fh)
{
    INDEX_SUB_ENTRY ise;
    int rv,mh;
    int s,k;


    dbgmsg(("[%s]\n", name))
    if(_mc_chdir(port, name) < 0) {
        if(_mc_mkdir(port, name) < 0) return(-1);
        if(_mc_chdir(port, name) < 0) return(-2);
    }

    while(1) {
        if(npmRead(fh, &ise, sizeof(INDEX_SUB_ENTRY)) < sizeof(INDEX_SUB_ENTRY)) {rv=-3; goto exit;}
        if(ise.name[0] == 0) break;

        if((ise.attr&MCATTR_SUBDIR) != 0) {

            rv = _index_copy_dir(port, ise.name, fh);
            if(rv < 0) goto exit;

        } else {

            dbgmsg(("\"%s\", %u\n", ise.name, ise.size))

            // open mc file
            mh = _mc_open(port, ise.name, O_WRONLY|O_CREAT);
            if(mh < 0) {rv=-4; goto exit;}

            // copy loop
            s = ise.size;
            while(s > 0) {
                k = s;
                if(k > MAX_COPY_SPACE) k = MAX_COPY_SPACE;
                s -= k;

                if(npmRead(fh, buf, k) < k) {_mc_close(mh); rv=-5; goto exit;}
                if(_mc_write(mh, buf, k) < k) {_mc_close(mh); rv=-6; goto exit;}
            }

            // close mc file
            if(_mc_close(mh) < 0) {rv=-7; goto exit;}

        }
    }

    rv = 0;
exit:
    _mc_chdir(port, "..");
    return(rv);
}



// copy directory to memcard
int index_copy(int port, char *name, uint8 overwrite)
{
    int fh;
    int rv;


    // check if overwrite?
    if(_mc_chdir(port, name) >= 0) {
        _mc_chdir(port, "..");
        if(!overwrite) return(-1);
    }

    // open input
    sprintf(buf, FILENAME_INDEX_ENTRY, name);
    fh = npmOpen(buf, O_RDONLY);
    if(fh < 0) return(-8);

    if((npmRead(fh, &index_sub_head, sizeof(INDEX_SUB_HEAD)) < sizeof(INDEX_SUB_HEAD))||(index_sub_head.id != INDEX_ID)) {
        npmClose(fh);
        return(-9);
    }

    rv = _index_copy_dir(port, name, fh);
    if(rv < 0) {
        npmClose(fh);
        return(rv - 200);
    }

    npmClose(fh);
    return(0);
}



// delete index from list
int index_delete(char *name)
{
    int fh;
    uint32 j;


    // delete file (in our case recreate file)
    sprintf(buf, FILENAME_INDEX_ENTRY, name);
    fh = npmOpen(buf, O_RDONLY);
    if(fh >= 0) npmClose(fh);

    // remove from list
    for(j=0; j<index_root.head.entries; j++) {
        if(stricmp(index_root.entry[ j ].filename, name) == 0) {
            memcpy(&index_root.entry[ j ], &index_root.entry[ j+1 ], sizeof(INDEX_ROOT_ENTRY)*(MAX_ENTRIES_ROOT-1-j));
            index_root.head.entries--;
            return(index_write());
        }
    }

    return(-1);
}