#ifndef _GIF_H_
#define _GIF_H_


#include "defines.h"
#include "gs.h"

//---------------------------------------------------------------------------
typedef uint64 __attribute__((aligned(16))) GIF_PACKET;

#define GIF_AD      0x0e
#define GIF_NOP     0x0f

#define GIF_CHCR    ((volatile uint32 *)(0x1000a000))   // GIF Channel Control Register
#define GIF_MADR    ((volatile uint32 *)(0x1000a010))   // Transfer Address Register
#define GIF_TADR    ((volatile uint32 *)(0x1000a030))   // ...
#define GIF_QWC     ((volatile uint32 *)(0x1000a020))   // Transfer Size Register (in qwords)


//---------------------------------------------------------------------------
// GIF PACKET macros
//---------------------------------------------------------------------------

#define GIF_DECLARE_PACKET(NAME,ITEMS) struct { \
    GIF_PACKET data[(ITEMS)*2+2]; \
    uint32 size; \
    } NAME;

#define GIF_DECLARE_EXTERN_PACKET(NAME,ITEMS) extern struct { \
    GIF_PACKET data[ITEMS*2+2]; \
    uint32 size; \
    } NAME;

#define GIF_BEGIN_PACKET(NAME) { NAME.size = 0; }

#define _GIF_TAG(NLOOP,EOP,PRE,PRIM,FLG,NREG) ( \
    ((uint64)(NLOOP)<< 0)  | \
    ((uint64)(EOP)  << 15) | \
    ((uint64)(PRE)  << 46) | \
    ((uint64)(PRIM) << 47) | \
    ((uint64)(FLG)  << 58) | \
    ((uint64)(NREG) << 60) )

#define GIF_ADD_TAG(NAME,NLOOP,EOP,PRE,PRIM,FLG) { \
    NAME.data[(NAME.size)++] = _GIF_TAG(NLOOP,EOP,PRE,PRIM,FLG,1); \
    NAME.data[(NAME.size)++] = (uint64)GIF_AD; }

#define GIF_ADD_IMG(NAME,QWRS) { \
    NAME.data[(NAME.size)++] = _GIF_TAG(QWRS,1,0,0,2,0); \
    NAME.data[(NAME.size)++] = (uint64)0; }

#define GIF_ADD_DATA(NAME,REG,DAT) { \
    NAME.data[(NAME.size)++] = (uint64)DAT; \
    NAME.data[(NAME.size)++] = (uint64)REG; }

#define GIF_SEND(MADR,QWC) { k_FlushCache(0); gs_send_gif((void*)MADR,(uint32)QWC); }
#define GIF_SEND_PACKET(NAME) GIF_SEND(NAME.data,((NAME.size)+1)/2)


#endif // _GIF_H_
