pico-8 cartridge // http://www.pico-8.com
version 36
__lua__
--pico-patch
--by moonshine

--initialize variables
function _init()
 --enable mouse input
 poke(0x5f2d,0x1)
 --disable automatic btnp repeat 
 poke(0x5f5c,-1)
 frames=0
 buffer=0x8000
 synth_type=0
 note=0
 hold_note=false
 vol_divisor=2000
 selected_op=1
 play=false
 play_frames=0
 loop_point=32
 ui_color=6
end

--synthesis type names
synth_names={"pm","am","ring","additive"}
--instrument parameters
op={
 {vol=15,multi=1,attack=0,decay=5,sustain=2,release=1},
 {vol=15,multi=1,attack=0,decay=5,sustain=2,release=1}
}
--initialize sequencer
note_sequence={} 
for i=0,31 do
 add(note_sequence,"space")
end

--reset note
function reset_note()
 for i=1,#op do
  op[i].attack_vol=op[i].vol
  op[i].decay_vol=op[i].vol
 end
end

--save instrument
function save_instrument()
 sv_data="pico-patch_instrument"
 sv_data..=","..synth_type
 for i=1,#op do
  sv_data..=","..op[i].vol
  sv_data..=","..op[i].multi
  sv_data..=","..op[i].attack
  sv_data..=","..op[i].decay
  sv_data..=","..op[i].sustain
  sv_data..=","..op[i].release
 end
 printh(sv_data,"@clip")
 sv_data=""
end

--load instrument
function load_instrument()
 ld_data=split(stat(4))
 if #ld_data==2+6*#op and ld_data[1]=="pico-patch_instrument" then
  synth_type=ld_data[2]
  for i=1,#op do 
   op[i].vol=ld_data[3+6*(i-1)]
   op[i].multi=ld_data[4+6*(i-1)]
   op[i].attack=ld_data[5+6*(i-1)]
   op[i].decay=ld_data[6+6*(i-1)]
   op[i].sustain=ld_data[7+6*(i-1)]
   op[i].release=ld_data[8+6*(i-1)]
  end
 end
end

--save sequence
function save_sequence()
 sv_data="pico-patch_sequence"
 sv_data..=","..loop_point
 for i=1,#note_sequence do
  sv_data..=","..note_sequence[i]
 end
 printh(sv_data,"@clip")
 sv_data=""
end

--load sequence
function load_sequence()
 ld_data=split(stat(4))
 if #ld_data==#note_sequence+2 and ld_data[1]=="pico-patch_sequence" then
  loop_point=ld_data[2]
  for i=3,#ld_data do
   note_sequence[i-2]=ld_data[i]
  end
 end
end

reset_note()
--update
function _update60()
 --mouse input
 mouse={x=stat(32),y=stat(33),c=stat(34)} 
 --current frequency
 freq=84/(2^(flr(note)/12))
 --interface
 if mouse.c==1 then
  if click==0 then
   --attack
   if flr(mouse.x/4)==2 and flr(mouse.y/6)==4 then 
    op[selected_op].attack=(op[selected_op].attack+1)%16
   --decay
   elseif flr(mouse.x/4)==3 and flr(mouse.y/6)==4 then 
    op[selected_op].decay=(op[selected_op].decay+1)%16
   --sustain
   elseif flr(mouse.x/4)==4 and flr(mouse.y/6)==4 then 
    op[selected_op].sustain=(op[selected_op].sustain+1)%16
   --release
   elseif flr(mouse.x/4)==5 and flr(mouse.y/6)==4 then 
    op[selected_op].release=(op[selected_op].release+1)%16
   --volume
   elseif flr(mouse.x/4)==26 and flr(mouse.y/6)==4 then 
    op[selected_op].vol=(op[selected_op].vol+1)%16
   --frquency multiplication
   elseif flr(mouse.x/4)==29 and flr(mouse.y/6)==4 then 
    op[selected_op].multi=(op[selected_op].multi+1)%16
   --selected operator
   elseif flr(mouse.x/4)>1 and flr(mouse.x/4)<6 and flr(mouse.y/6)==9 then 
    selected_op=(selected_op+1)%(#op+1)
   --synthesis type
   elseif flr(mouse.x/4)>8 and flr(mouse.x/4)<23 and flr(mouse.y/6)==9 then 
    synth_type=(synth_type+1)%#synth_names    
   --save instrument
   elseif (flr(mouse.x/4)==26 or flr(mouse.x/4)==27) and flr(mouse.y/6)==9 then 
    save_instrument()  
   --load instrument
   elseif (flr(mouse.x/4)==28 or flr(mouse.x/4)==29) and flr(mouse.y/6)==9 then 
    load_instrument()  
   --insert space
   elseif mouse.x>1 and mouse.x<98 and (mouse.y==102 or mouse.y==103) then
    note_sequence[flr((mouse.x-2)/3)+1]="space"
   --insert stop 
   elseif mouse.x>1 and mouse.x<98 and (mouse.y==105 or mouse.y==106) then
    note_sequence[flr((mouse.x-2)/3)+1]="stop"
   --play/stop 
   elseif flr(mouse.x/4)>25 and flr(mouse.x/4)<30 and flr(mouse.y/6)==12 then 
    if play then 
     play_frames=0
     hold_note=false
     play=false 
    else
     play=true 
    end
   --loop point
   elseif flr(mouse.x/4)>25 and flr(mouse.x/4)<30 and flr(mouse.y/6)==14 then 
    loop_point=(loop_point+1)%33
    play_frames=0
   --save sequence
   elseif (flr(mouse.x/4)==26 or flr(mouse.x/4)==27) and flr(mouse.y/6)==19 then 
    save_sequence()
   --load sequence
   elseif (flr(mouse.x/4)==28 or flr(mouse.x/4)==29) and flr(mouse.y/6)==19 then 
    load_sequence()
   end
  --insert notes
  elseif mouse.x>1 and mouse.x<98 and mouse.y>63 and mouse.y<100 then
   note_sequence[flr((mouse.x-2)/3)+1]=99-mouse.y
  end
  click=1
 else 
  click=0
 end
 
 --correct selected operator
 if selected_op==0 then selected_op=1 end
 --correct frequency multiplication
 if op[selected_op].multi==0 then op[selected_op].multi=1 end
 --correct sustain 
 if op[selected_op].sustain>op[selected_op].vol then
  op[selected_op].sustain=0
 end
 --correct loop point
 if loop_point==0 then loop_point=1 end
 
 --calculate pcm wave
 while stat(108)<1536 do
  for i=0,64 do
   frames=(frames+1)%freq
   for o=1,#op do
    --attack volume   
    if op[o].attack_vol>0 and op[o].attack>0 then
     op[o].attack_vol-=op[o].attack/vol_divisor
    else
     op[o].attack_vol=0 
    end
    --decay volume
    if op[o].attack_vol==0 then
     if op[o].decay_vol>op[o].sustain and op[o].decay>0 then
      op[o].decay_vol-=op[o].decay/vol_divisor
     elseif hold_note then
      op[o].decay_vol=op[o].sustain
     elseif op[o].decay_vol>0 then
      op[o].decay_vol-=op[o].release/vol_divisor
     else
      op[o].decay_vol=0
     end
    end
   end
   --phase modulation
   if synth_type==0 then
    wave=sin((frames/(freq/op[1].multi))+sin(frames/freq*op[2].multi)*((op[2].decay_vol-op[2].attack_vol)/10))*(op[1].decay_vol-op[1].attack_vol)+128
   --amplitude modulation
   elseif synth_type==1 then
    wave=sin(frames/(freq/op[1].multi))*(op[1].decay_vol-op[1].attack_vol)*(sin(frames/(freq/op[2].multi))+1)*(op[2].decay_vol-op[2].attack_vol)/20+128
   --ring modulation
   elseif synth_type==2 then
    wave=sin(frames/(freq/op[1].multi))*(op[1].decay_vol-op[1].attack_vol)*sin(frames/(freq/op[2].multi))*(op[2].decay_vol-op[2].attack_vol)/10+128 
   --additive
   elseif synth_type==3 then  
    wave=sin(frames/(freq/op[1].multi))*(op[1].decay_vol-op[1].attack_vol)+sin(frames/(freq/op[2].multi))*(op[2].decay_vol-op[2].attack_vol)/5+128
   end
   --pcm output poke
   poke(buffer+i,wave)
  end
  --pcm output 
  serial(0x808,buffer,65)
 end
 
 --note playback
 if play then 
  if play_frames==flr(play_frames/8)*8 then
   if note_sequence[flr(play_frames/8)%loop_point+1]=="stop" then 
    hold_note=false
   elseif note_sequence[flr(play_frames/8)%loop_point+1]!="space" then
    note=note_sequence[flr(play_frames/8)%loop_point+1]
    hold_note=true
    reset_note()
   end
  end
  play_frames+=1
 else
  if btnp(0) then note=(note-1)%36 end
  if btnp(1) then note=(note+1)%36 end
  if btnp(2) then note=(note+12)%36 end
  if btnp(3) then note=(note-12)%36 end
  if btnp(4) then reset_note() end
 end
end 

--draw
function _draw()
 cls()
 --oscilloscope view
 line(31,32,96,32,5)
 for x=0,63 do
  line(x+31,128-@(buffer+x)/2-32,x+32,128-@(buffer+x+1)/2-32,7)
 end
 --interface boxes
 rect(2,2,125,14,ui_color)
 rect(2,16,29,48,ui_color)
 rect(31,16,96,48,ui_color)
 rect(98,16,125,48,ui_color)
 rect(2,50,29,62,ui_color)
 rect(31,50,96,62,ui_color)
 rect(98,50,125,62,ui_color)
 rect(98,64,125,106,ui_color)
 rect(2,108,96,125,ui_color)
 rect(98,108,125,125,ui_color)
 --interface text 
 if play then
  play_text="stop"
 else
  play_text="play"
 end
 print("pico-patch",4*11,6*1,ui_color)
 print("adsr",4*2,6*4,ui_color)
 print("v  m",4*26,6*4,ui_color)
 print("op "..selected_op,4*2,6*9,ui_color)
 print("synth:"..synth_names[synth_type+1],4*9,6*9,ui_color)
 print("⬇️⬆️",4*26,6*9,ui_color)
 print(play_text,4*26,6*12,ui_color)
 print("loop\n"..loop_point,4*26,6*14,ui_color)
 print("moonshine 2022",4*5,6*19,ui_color)
 print("⬇️⬆️",4*26,6*19,ui_color)
 --interface bars
 rectfill(8,30,10,30+op[selected_op].attack,ui_color)
 rectfill(12,30,14,30+op[selected_op].decay,ui_color)
 rectfill(16,30,18,30+op[selected_op].sustain,ui_color)  
 rectfill(20,30,22,30+op[selected_op].release,ui_color)
 rectfill(104,30,106,30+op[selected_op].vol,ui_color)
 rectfill(116,30,118,30+op[selected_op].multi,ui_color)
 --sequencer notes
 for i=1,#note_sequence do
  if note_sequence[i]=="space" then
   rectfill((i-1)*3+2,102,(i-1)*3+3,103,ui_color)
  elseif note_sequence[i]=="stop" then
   rectfill((i-1)*3+2,105,(i-1)*3+3,106,ui_color)
  else
   rectfill((i-1)*3+2,(99-note_sequence[i]),(i-1)*3+3,(99-note_sequence[i]),ui_color)
  end
 end
 --mouse cursor
 circfill(mouse.x,mouse.y,1,7)
end
