

#include "funkfilter.h"

/*
//BlendingFactorDest
#define GL_ZERO                           0
#define GL_ONE                            1
#define GL_SRC_COLOR                      0x0300
#define GL_ONE_MINUS_SRC_COLOR            0x0301
#define GL_SRC_ALPHA                      0x0302
#define GL_ONE_MINUS_SRC_ALPHA            0x0303
#define GL_DST_ALPHA                      0x0304
#define GL_ONE_MINUS_DST_ALPHA            0x0305

//BlendingFactorSrc
#define GL_DST_COLOR                      0x0306
#define GL_ONE_MINUS_DST_COLOR            0x0307
#define GL_SRC_ALPHA_SATURATE             0x0308
*/

cFunkFilter::cFunkFilter()
{
	Mode=0;
}

cFunkFilter::~cFunkFilter()
{

}

cFunkFilter::SetGlobalMode(int mode)
{
	glEnable(GL_BLEND);

	switch (mode)
	{
	case FUNKFILTER_OFF:
		glBlendFunc(GL_ONE,GL_ZERO);
		glDisable(GL_BLEND);
		break;
	case FUNKFILTER_INVERT:
		glBlendFunc(GL_ONE_MINUS_DST_COLOR,GL_ONE_MINUS_DST_COLOR);
		break;
	case FUNKFILTER_INVERT2:
		glBlendFunc(GL_ONE_MINUS_DST_COLOR,GL_DST_COLOR);
		break;
	case FUNKFILTER_SOLAR:
		glBlendFunc(GL_ONE_MINUS_SRC_COLOR,GL_ONE_MINUS_DST_COLOR);
		glBlendFunc(GL_ZERO,GL_ONE_MINUS_DST_COLOR);
		break;
	case FUNKFILTER_BURN:
		glBlendFunc(GL_ONE_MINUS_SRC_COLOR,GL_DST_COLOR);
		break;
	case FUNKFILTER_DODGE:
		glBlendFunc(GL_SRC_ALPHA,GL_DST_ALPHA);
		break;
	case FUNKFILTER_LIGHTEN:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		break;
	case FUNKFILTER_LIGHTEN2:
		glBlendFunc(GL_DST_COLOR,GL_ONE_MINUS_DST_COLOR);
		break;
	case FUNKFILTER_ADDITIVE:
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);
		break;
	case FUNKFILTER_ADDITIVE2:
		glBlendFunc(GL_DST_ALPHA,GL_SRC_ALPHA);
		break;
	case FUNKFILTER_ADDITIVE3:
		//glBlendFunc(GL_DST_ALPHA,GL_ONE);
		//glBlendFunc(GL_DST_ALPHA,GL_SRC_COLOR);
		//glBlendFunc(GL_SRC_COLOR,GL_ONE);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);
		break;
	case FUNKFILTER_DARKEN:
		glBlendFunc(GL_ZERO,GL_ONE_MINUS_SRC_COLOR);
		break;
	}
}

cFunkFilter::SetMode(int mode)
{
	Mode=mode;
}

cFunkFilter::SetStrength(float opacity)
{

}

cFunkFilter::Update()
{
}


cFunkFilter::Draw()
{
	SaveGLState(GLSTATE_BLEND);
	SaveGLState(GLSTATE_LIGHTS);
	SaveGLState(GLSTATE_DEPTH);
	glEnable(GL_BLEND);
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);

	SetGlobalMode(Mode);

	glMatrixMode (GL_MODELVIEW);
	glPushMatrix ();
		glLoadIdentity ();
		glMatrixMode (GL_PROJECTION);
		glPushMatrix ();
			glLoadIdentity ();
			glBegin (GL_QUADS);
				//glColor4f(0.5,0.5,0.5,0.5);
				glColor4f(1,1,1,1);
				//glColor4f(0,0,0,1);
				glVertex3i (-0, -1, -1);
				glVertex3i ( 1, -1, -1);
				glVertex3i ( 1,  1, -1);
				glVertex3i (-1,  1, -1);
			glEnd ();
		glPopMatrix ();
		glMatrixMode (GL_MODELVIEW);
	glPopMatrix ();

	RestoreGLState(GLSTATE_DEPTH);
	RestoreGLState(GLSTATE_LIGHTS);
	RestoreGLState(GLSTATE_BLEND);
}

