
#ifndef _CVECTOR
#define _CVECTOR

#include "core.h"

class CVector
{
	public:

		CVector()
		{
			X=0;
			Y=0;
			Z=0;
		}

		float X,Y,Z;

		void SetPos(float x,float y,float z)
		{
			X=x;
			Y=y;
			Z=z;
		}
		
		void Normalise()
		{
			float dist=length3d(0,0,0,X,Y,Z);
			X=X/dist;
			Y=Y/dist;
			Z=Z/dist;
		}

		void Negative()
		{
			X=-X;
			Y=-Y;
			Z=-Z;
		}

		float Length()
		{
			return length3d(0,0,0,X,Y,Z);
		}

		void Absolute()
		{
			X=fabs(X);
			Y=fabs(Y);
			Z=fabs(Z);
		}

		float Distance(CVector *dest)
		{
			return length3d(X,Y,Z,dest->X,dest->Y,dest->Z);
		}

		float Distance(float x,float y,float z)
		{
			return length3d(X,Y,Z,x,y,z);
		}

		void Subtract(CVector *v1,CVector *v2)
		{
			X=(v1->X - v2->X);
			Y=(v1->Y - v2->Y);
			Z=(v1->Z - v2->Z);
		}

	private:
};

#endif _CVECTOR
