; =========================================================================
; singen - a 16 byte sine generator for M68k by superogue / marquee design|
; =========================================================================
	OPT O+,D-,X-

SIZE	equ 256	

	; optional - backup bss address (initialised in a4 on Atari ST) for drawing	
	move.l	a4,a5		; 2b 

	; sine generator (16 bytes)
	moveq	#127,d2		;2b 
singen:
	subq.l	#2,d2		;2b
	move.l	d3,d0		;2b
	move.w	d0,(a4)+	;2b
	sub.w	d0,(SIZE-2,a4)	;4b
	add.l	d2,d3		;2b
	bne.b	singen		;2b

	; init a000 video
	dc.w	$A000	;2
	movem.l	(a0),a1-a4	; 4A3=INTIN, A4=PTSIN

	; draw sine
	move.w #255,d5
drawloop:	
	; read sine value and scale back for plotting
	move.w (a5)+,d6	
	asr.w #6,d6	
	add.w #100,d6		

	; plot pixel
	movem.w	d5/d6,(a4)
	move.w #15,(a3)	
	dc.w $A001	
	dbra d5,drawloop
	
	; wait loop
	bra.s	*

	section bss

sintab  ds.w 256
