; Soda Caustica
; From Magnetic Team
; (C) 2003
;
; By MadAxe and The Punisher
;
; To compile use: Tasm SodaCaus.asm
; and Tlink SodaCaus.obj Goldplay.obj

MASM

.model large

.stack 512h

Procedures:

EXTRN INITIALIZE:FAR	; Inicializa o ModPlayer
EXTRN LOADMODULE:FAR	; Carrega o Mdulo para a Memria
EXTRN STARTPLAYING:FAR	; Faz o Play do Mdulo
EXTRN STOPPLAYING:FAR	; Pra o Mdulo
EXTRN DEALLOC:FAR	; Liberta a Memria Alocada para o Mdulo

EXTRN ASKINIT:FAR

Variables:

EXTRN SOUNDDEVICE:WORD	; Tipo de Placa de Som
EXTRN TIMERSPEED:WORD	; Replay Rate 1193182/Hertz
EXTRN SBDMA:WORD	; DMA da SoundBlaster
EXTRN SBIRQNR:WORD	; IRQ da SoundBlaster
EXTRN SBPORT:WORD	; Porto da SoundBlaster

vgamem equ 0A000h	; Memria do VGA
txtmem equ 0B800h	; Memria do Modo de Texto
regvga equ 013h		; Registo do VGA
regtxt equ 03h		; Registo do Modo de Texto

TXS	equ 8		; Tamanho Horizontal da Fonte do Scroll
TYS	equ 9		; Tamanho Vertical da Fonte do Scroll
NCS equ 59		; Nmero de Carateres da Fonte do Scroll
TXTSCRL equ 1148	; Nmero de Carateres do Scroll

numstardin equ 90	; Nmero de Estrelas do StarField 3D

data1 segment 'far_data'

        filename1 db 'soda01.dat',0
	filename2 db 'soda02.dat',0
	filename3 db 'soda03.dat',0
	filename4 db 'soda04.dat',0
	filename5 db 'soda05.dat',0

	erro1 db 13,10,10,7,'Error Reading Module !',13,10,'$'

	texto db 13,10,13,10,13,10,13,10,13,10,13,10
		  db 13,10,13,10,13,10,13,10,13,10,13,10
		  db 13,10,13,10,'$'
	
	tcode db 0
	
	cardtype db 0
	
	include pal01.inc
	pal02 db 768 dup(?)
	
	include fonte02.inc
	include txt01.inc
	
	scrlcaridx dw 0
	scrlcarfrm db 0
	scrlcarcar db 0
	
	startf dw 0
	dblbuf db TYS*320 dup(0)
	
	include setup.inc
	include endtitle.inc
	
	include stsx.inc
	include stsy.inc
	include stsc.inc
	stsz dw 90 dup(256)
	stx dw 90 dup(0)
	sty dw 90 dup(0)
	stsox dw 90 dup(0)
	stsoy dw 90 dup(0)
	
data1 ends


data2 segment 'far_data'

	include pic01.inc

data2 ends

data3 segment 'far_data'

	include pic02.inc

data3 ends


codigo segment word 'code'
	assume cs:codigo
start:

.386

	mov ah,4Ah		; Reduz o Tamanho da Memria do Programa
	mov bx,190000/16	; EXEFILE / 16 + 2
	int 21h

	mov ax,data1
	mov ds,ax
	assume ds:data1

	call defsetup		; Setup da Placa de Som
	
	mov ax,regvga		; Abre o Modo Grfico VGA (320x200x256)
	int 10h

	call criastar3d
	call printlogo
	call printtitulo
	
	mov scrlcaridx,0	; Definies do Scroll
	mov scrlcarfrm,0
	mov bx,scrlcaridx
	mov al,byte ptr txt01[bx]
	mov scrlcarcar,al
	sub scrlcarcar,32
	
	mov dx,offset filename1	; L o Mdulo 01
	call Loadmodule
	jnc semerro
	
	mov ax,regtxt		; Volta para o Modo de Texto se houver erro
	int 10h
	
	mov ax,0100h		; Mostra o Cursor
	mov cx,0607h
	int 10h

	mov ah,09h		; Se houver erro
	lea dx,erro1		; Imprime uma Mensagem de Erro
	int 21h

	mov ah,4Ch		; Volta para o Ms-Dos se houver erro
	int 21h

semerro:	
	call StartPlaying	; Toca o Mdulo 01
	mov al,01111010b	; Desliga todas as Interrupts Desnecessrias
	out 21h,al


; Loop Principal da Demo
mainloop:

leteclado1:
	call waitforretrace
	call printscroll
	call movestar3d
	
	in  al,60h
	mov tcode,al
	in  al,61h
	or  al,80h
	out 61h,al
	and al,7fh
	out 61h,al
	mov al,20h
	out 20h,al
	
	cmp tcode,1
	je jpfimprograma	; Termina o Programa

	cmp tcode,2
	je lemusica1		; Msica 01

	cmp tcode,3
	je lemusica2		; Msica 02

	cmp tcode,4
	je lemusica3		; Msica 03

	cmp tcode,5
	je lemusica4		; Msica 04

	cmp tcode,6
	je lemusica5		; Msica 05

	jmp leteclado1
	
jpfimprograma:
	jmp fimprograma
	

; L o Mdulo 01
lemusica1:
	mov dx,offset filename1	; L o Mdulo 01
	call lemodulo
	jmp leteclado1


; L o Mdulo02
lemusica2:
	mov dx,offset filename2	; L o Mdulo 02
	call lemodulo
	jmp leteclado1
	
	
; L o Mdulo 03
lemusica3:
	mov dx,offset filename3	; L o Mdulo 03
	call lemodulo
	jmp leteclado1
	
	
; L o Mdulo 04
lemusica4:
	mov dx,offset filename4	; L o Mdulo 04
	call lemodulo
	jmp leteclado1
	
	
; L o Mdulo 05
lemusica5:
	mov dx,offset filename5	; L o Mdulo 05
	call lemodulo
	jmp leteclado1
	

; Termina o Programa e Volta para o Ms-Dos
fimprograma:

	mov al,0		; Liga as Interrupts outra vez
	out 21h,al

	call fadeout

	call StopPlaying	; Pra de Tocar o Mdulo Atual
	call DeAlloc		; Liberta a Memria Alocada para o Mdulo Atual

	mov ah,0ch		; Limpa o Buffer do Teclado
	mov al,0
	int 21h

	mov ax,regtxt		; Volta para o Modo de Texto
	int 10h
	
	mov ax,0100h		; Mostra o Cursor
	mov cx,0607h
	int 10h
	
	mov ah,09h		; Faz 14 Enters
	lea dx,texto
	int 21h
	
	call printendtitle	; Imprime o End Title

	mov ah,4ch		; Volta para o MS-Dos
	int 21h


; Setup da Placa de Som
defsetup proc near
	
	call printsetup	; Imprime o Menu do Setup
	
leteclado2:
	mov ah,01h		; Verifica se alguma tecla  pressionada - Pode ser usado mov ah,11h
    int 16h
	jz leteclado2 	        ; Nenhuma tecla foi pressionada

	mov ah,00h		; Vai buscar qual tecla foi pressionada - Pode ser usado mov ah,10h
	int 16h
	
	cmp al,'1'		; PC Speaker
	je pcspeaker
	
	cmp al,'2'		; SoundBlaster
	je sblaster
	
	cmp al,'3'		; SoundBlaster Pro
	je sblasterpro
	
	jmp leteclado2

pcspeaker:
	mov cardtype,4
	jmp nextdefsetup
	
sblaster:
	mov cardtype,3
	jmp nextdefsetup
	
sblasterpro:
	mov cardtype,6
	
nextdefsetup:
	mov ah,0ch			; Limpa o Buffer do Teclado
	mov al,0              
	int 21h
	
	mov ax,seg SoundDevice
	mov es,ax
	   
	mov ah,0
	mov al,cardtype
	   
	mov es:SoundDevice,ax	; Tipo de Placa de Som
	mov es:TimerSpeed,49	; 24 kHz (1193182/24000=49)
	mov es:SBIRQNR,7	; IRQ 7
	mov es:SBPORT,220h	; Port 220h

	call Initialize		; Inicializa a Placa de Som

	ret
	
defsetup endp


; L o Mdulo a partir de um Ficheiro e Toca-o
lemodulo proc near

	mov al,0		; Liga as Interrupts outra vez
	out 21h,al
	
	call StopPlaying	; Pra de Tocar o Mdulo Atual
	call DeAlloc		; Liberta a Memria Alocada para o Mdulo Atual

	call Loadmodule		; L o novo Mdulo
	jnc NoError
	
	mov ax,regtxt		; Volta para o Modo de Texto se houver erro
	int 10h
	
	mov ax,0100h		; Mostra o Cursor
	mov cx,0607h
	int 10h

	mov ah,09h		; Se houver erro
	lea dx,erro1		; Imprime uma Mensagem de Erro
	int 21h

	mov ah,4Ch		; Volta para o Ms-Dos se houver erro
	int 21h
	
NoError:
	mov ah,0ch		; Limpa o Buffer do Teclado
	mov al,0
	int 21h
	
	call StartPlaying	; Toca o novo Mdulo
	mov al,01111010b	; Desliga todas as Interrupts Desnecessrias
	out 21h,al

	ret
	
lemodulo endp


; Apaga o cran
clearscreen proc near

	mov ax,vgamem
	mov es,ax

	xor ax,ax
		
	mov cx,64000
	mov di,0
	
	cld	
	rep stosb

clearscreen endp
		

; Define os Valores RGB	da Palette
setpalette proc near

	mov si,offset pal01	; Define os Valores RGB da Palette com pal01
	mov cx,768
	mov dx,3c8h
	xor al,al
	out dx,al
	mov dx,03C9h
spnextidx:
	mov al,byte ptr[si]
	out dx,al
	inc si
   	loop spnextidx

	mov ax,ds		; Copia a pal01 para a pal02
	mov es,ax
	lea si,pal01
	lea di,pal02
	mov cx,192
	cld
	rep movsd
		
	ret
	
setpalette endp


; Coloca os valores RGB	da Palette pal02 a Zero
zeropalette proc near

	mov ax,ds
	mov es,ax

	lea di,pal02		; Coloca pal02 a Zero
	mov cx,768
	xor ax,ax
	cld
	rep stosb

	mov si,offset pal02	; Define os Valores RGB da Palette com pal02
	mov cx,768
	mov dx,3c8h
	xor al,al
	out dx,al
	mov dx,03C9h
zpnextidx:
	mov al,byte ptr[si]
	out dx,al
	inc si
   	loop zpnextidx

	ret
	
zeropalette endp


; Faz Fade Out  Palette
fadeout proc near

	mov ax,ds
	mov es,ax

	mov dx,63
	
fonextidx3:
	push dx
	call waitforretrace
	
	mov si,offset pal02
	mov di,offset pal02
	mov cx,768
	mov dx,3c8h
	xor al,al
	out dx,al
	mov dx,03C9h
fonextidx:
	mov al,byte ptr[si]
	cmp al,0
	je fonextidx2
	dec al
	mov [di],byte ptr al
fonextidx2:
	out dx,al
	inc si
	inc di
   	loop fonextidx
	
	pop dx
	dec dx
	jnz fonextidx3

	ret
	
fadeout endp


; Faz Fade In  Palette
fadein proc near

	mov ax,ds
	mov es,ax

	mov dx,63
	
finextidx3:
	push dx
	call waitforretrace
	call waitforretrace
		
	mov si,offset pal02
	mov di,offset pal02
	mov bx,offset pal01
	mov cx,768
	mov dx,3c8h
	xor al,al
	out dx,al
	mov dx,03C9h
finextidx:
	mov al,byte ptr[si]
	mov ah,byte ptr[bx]
	cmp al,ah
	je finextidx2
	inc al
	mov [di],byte ptr al
finextidx2:
	out dx,al
	inc si
	inc di
	inc bx
   	loop finextidx
	
	pop dx
	dec dx
	jnz finextidx3

	ret
	
fadein endp


; Espera pelo Vertical Retrace
waitforretrace proc near

	mov dx,03dah
	
retrace:
	in al,dx
	test al,08h
	jnz retrace
	
noretrace:
	in al,dx
	test al,08h
	jz noretrace
	
	ret
   
waitforretrace endp


; Imprime o Logo da Magnetic Team
printlogo proc near

	call clearscreen
	call setpalette
	call zeropalette

	push ds
	mov ax,data2
	mov ds,ax
	assume ds:data2

	mov ax,vgamem
	mov es,ax
	mov cx,16000
	mov si,0
	mov di,0
	rep movsd

	pop ds

	call fadein
	
	mov cx,150
plloop:
	call waitforretrace
	loop plloop
	
	call fadeout
	
	ret

printlogo endp


; Imprime o Ttulo da Demo e o Menu
printtitulo proc near

	call clearscreen
	call setpalette

	push ds
	mov ax,data3
	mov ds,ax
	assume ds:data3

	mov ax,vgamem
	mov es,ax
	mov cx,16000
	mov si,0
	mov di,0
	rep movsd

	pop ds

	ret

printtitulo endp


; Loop Principal do Scroll
printscroll proc near

;	mov ax,data1
;	mov ds,ax
	assume ds:data1

	cmp scrlcarfrm,TXS
	je proxcar
	call copybufferscroll
	call scroll
	call putcarscroll
	inc scrlcarfrm
	
	jmp saiprintscroll
	
proxcar:
	mov scrlcarfrm,0
	inc scrlcaridx
	cmp scrlcaridx,TXTSCRL
	jne proxcar2
	mov scrlcaridx,0
proxcar2:	
	mov bx,scrlcaridx
	mov al,byte ptr txt01[bx]
	mov scrlcarcar,al
	sub scrlcarcar,32
	
saiprintscroll:
	ret
		
printscroll endp


; Imprime o Caracter do Scroll
putcarscroll proc near

	xor ax,ax
	mov al,scrlcarfrm
	mov bx,TYS
	mul bx
	mov cx,ax
	
	xor ax,ax
	mov al,scrlcarcar
	mov bx,TYS
	mul bx
	mov bx,TXS
	mul bx
	add ax,cx
	
	mov startf,ax
	
	mov ax,ds
	mov es,ax
		
	lea si,fonte02
	add si,startf
		
	lea di,dblbuf
	add di,319
	
	mov cx,TYS
loop2:
	lodsb
	mov es:[di],al

	add di,320
	loop loop2
		
	ret

putcarscroll endp


; Copia o Buffer do Scroll para o cran
copybufferscroll proc near

	mov ax,vgamem
	mov es,ax
				
	cld
	mov cx,720
		
	lea si,dblbuf
	mov di,59200
		
	rep movsd
		
	ret

copybufferscroll endp


; o Faz o Scroll
scroll proc near

	mov ax,ds
	mov es,ax
					
	mov cx,720
	lea si,dblbuf
	lea di,dblbuf
	inc si

	cld
	rep movsd
	
	ret
		
scroll endp


; Imprime o Setup
printsetup proc near
	
	mov ax,0100h	; Esconde o Cursor
	mov cx,0800h
	int 10h
	
	mov ax,txtmem
	mov es,ax
				
	cld
	mov cx,1000
		
	lea si,setup
	mov di,0
		
	rep movsd
	
	ret
		
printsetup endp


; Imprime o End Title
printendtitle proc near
	
	mov ax,txtmem
	mov es,ax
				
	cld
	mov cx,560
		
	lea si,endtitle
	mov di,0
		
	rep movsd
	
	ret
		
printendtitle endp


; Cria o Star Field 3D
criastar3d proc near

	mov ax,ds
	mov es,ax
	
	lea si,stsx		; Guarda as definies originais das Estrelas
	lea di,stsox
	mov cx,numstardin
	cld
	rep movsw
	
	lea si,stsy
	lea di,stsoy
	mov cx,numstardin
	cld
	rep movsw
	
	mov cx,numstardin
	mov si,0
loopcs3d:
	mov ax,word ptr stsx[si]
	mov bx,256
	imul bx
	mov bx,word ptr stsz[si]
	idiv bx
	mov bx,150
	add ax,bx
	mov stx[si],ax
	
	mov ax,word ptr stsy[si]
	mov bx,256
	imul bx
	mov bx,word ptr stsz[si]
	idiv bx
	mov bx,100
	add ax,bx
	mov sty[si],ax
	
	inc si
	inc si
	loop loopcs3d
	
	ret

criastar3d endp


; Move o Star Field 3D
movestar3d proc near

	call clearstar3d
	
	mov ax,ds
	mov es,ax

	mov cx,numstardin
	mov si,0
lms3d1:
	mov ax,word ptr stsz[si]
	cmp ax,1
	jge lms3d2

	mov ax,word ptr stsox[si]
	mov word ptr stsx[si],ax
	mov ax,word ptr stsoy[si]
	mov word ptr stsy[si],ax
	mov stsz[si],256
	jmp lms3d3
	
lms3d2:
	sbb word ptr stsz[si],3
	
lms3d3:
	mov ax,word ptr stsx[si]
	mov bx,256
	imul bx
	mov bx,word ptr stsz[si]
	idiv bx
	mov bx,150
	add ax,bx
	mov stx[si],ax
	
	mov ax,word ptr stsy[si]
	mov bx,256
	imul bx
	mov bx,word ptr stsz[si]
	idiv bx
	mov bx,100
	add ax,bx
	mov sty[si],ax
	
	inc si
	inc si
	loop lms3d1
	
	call putstar3d
	
	ret
	
movestar3d endp


; Imprime o Star Field 3D
putstar3d proc near

	mov ax,vgamem
	mov es,ax

	mov cx,numstardin
	mov si,0
lps3d2:
	mov ax,word ptr sty[si]
	cmp ax,1
	jl lps3d3
	cmp ax,199
	jg lps3d3
		
	mov bx,word ptr stx[si]
	cmp bx,1
	jl lps3d3
	cmp bx,319
	jg lps3d3
				
	mov di,320
	mul di
	mov di,ax
	add di,bx
				
	mov al,es:[di]
	test al,al
	jnz lps3d1
	mov al,byte ptr stsc[si]
	mov es:[di],al
	jmp lps3d1

lps3d3:
	xor ax,ax
	mov word ptr stsz[si],ax

lps3d1:
	inc si
	inc si
	loop lps3d2
		
	ret
	
putstar3d endp 


; Apaga o Star Field 3D
clearstar3d proc near

	mov ax,vgamem
	mov es,ax
		
	mov si,0
	mov cx,numstardin
lcs3d3:
	mov ax,word ptr sty[si]
	cmp ax,1
	jl lcs3d1
	cmp ax,199
	jg lcs3d1
		
	mov bx,word ptr stx[si]
	cmp bx,1
	jl lcs3d1
	cmp bx,319
	jg lcs3d1
				
	mov di,320
	mul di
	mov di,ax
	add di,bx
	
	mov al,byte ptr es:[di]
	cmp al,253
	jz lcs3d2
	cmp al,254
	jz lcs3d2
	cmp al,255
	jnz lcs3d1

lcs3d2:
	xor al,al
	mov es:[di],al

lcs3d1:
	inc si
	inc si

	loop lcs3d3

	ret
	
clearstar3d endp


codigo ends
end start