/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Color;
import org.openrndr.shape.CompositionColor;
import org.openrndr.shape.InheritColor;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.svg.Command;
import org.openrndr.svg.SVGElement;
import org.openrndr.svg.SVGLoaderKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lorg/openrndr/svg/SVGPath;", "Lorg/openrndr/svg/SVGElement;", "()V", "commands", "", "Lorg/openrndr/svg/Command;", "getCommands", "()Ljava/util/List;", "fill", "Lorg/openrndr/shape/CompositionColor;", "getFill", "()Lorg/openrndr/shape/CompositionColor;", "setFill", "(Lorg/openrndr/shape/CompositionColor;)V", "stroke", "getStroke", "setStroke", "strokeWeight", "", "getStrokeWeight", "()Ljava/lang/Double;", "setStrokeWeight", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "compounds", "", "parseDrawAttributes", "", "e", "Lorg/jsoup/nodes/Element;", "shape", "Lorg/openrndr/shape/Shape;", "Companion", "openrndr-svg"})
public final class SVGPath
extends SVGElement {
    @NotNull
    private final List<Command> commands;
    @NotNull
    private CompositionColor fill;
    @NotNull
    private CompositionColor stroke;
    @Nullable
    private Double strokeWeight;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Command> getCommands() {
        return this.commands;
    }

    @NotNull
    public final CompositionColor getFill() {
        return this.fill;
    }

    public final void setFill(@NotNull CompositionColor compositionColor) {
        Intrinsics.checkParameterIsNotNull(compositionColor, "<set-?>");
        this.fill = compositionColor;
    }

    @NotNull
    public final CompositionColor getStroke() {
        return this.stroke;
    }

    public final void setStroke(@NotNull CompositionColor compositionColor) {
        Intrinsics.checkParameterIsNotNull(compositionColor, "<set-?>");
        this.stroke = compositionColor;
    }

    @Nullable
    public final Double getStrokeWeight() {
        return this.strokeWeight;
    }

    public final void setStrokeWeight(@Nullable Double d) {
        this.strokeWeight = d;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SVGPath> compounds() {
        int index;
        int n;
        int n2;
        List compounds = new ArrayList();
        List compoundIndices = new ArrayList();
        Iterable $receiver$iv = this.commands;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void it;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            n = n2;
            Command command = (Command)item$iv;
            index = n;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getOp(), "M") && !Intrinsics.areEqual(it.getOp(), "m")) continue;
            compoundIndices.add(index);
        }
        $receiver$iv = compoundIndices;
        index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            n = n2;
            int it = ((Number)item$iv).intValue();
            index = n;
            boolean bl = false;
            int cs = ((Number)compoundIndices.get(index)).intValue();
            int ce = index + 1 < compoundIndices.size() ? ((Number)compoundIndices.get(index + 1)).intValue() : this.commands.size();
            SVGPath path = new SVGPath();
            path.commands.addAll((Collection<Command>)this.commands.subList(cs, ce));
            if (compoundIndices.size() > 1) {
                path.commands.add(new Command("Z", new double[0]));
            }
            compounds.add(path);
        }
        return compounds;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Shape shape() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object cursor = new Vector2(0.0, 0.0);
        Vector2 anchor = Vector2.copy$default((Vector2)cursor, 0.0, 0.0, 3, null);
        Vector2 relativeControl = new Vector2(0.0, 0.0);
        Iterable iterable = $receiver$iv = (Iterable)this.compounds();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            ShapeContour shapeContour;
            void compound;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            SVGPath sVGPath = (SVGPath)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl = false;
            List segments = new ArrayList();
            boolean closed = false;
            Iterable $receiver$iv2 = compound.commands;
            block36: for (Object element$iv : $receiver$iv2) {
                Command command = (Command)element$iv;
                boolean bl2 = false;
                switch (command.getOp()) {
                    case "M": {
                        Object object3;
                        Object object2;
                        Object point;
                        cursor = command.vector(0, 1);
                        anchor = cursor;
                        List<Vector2> allPoints = command.vectors();
                        int n4 = 1;
                        int n5 = allPoints.size();
                        while (n4 < n5) {
                            void i;
                            point = allPoints.get((int)i);
                            object2 = segments;
                            object3 = new Segment((Vector2)cursor, (Vector2)point);
                            object2.add(object3);
                            cursor = point;
                            ++i;
                        }
                        continue block36;
                    }
                    case "m": {
                        Object object3;
                        Object object2;
                        Object point;
                        List<Vector2> allPoints = command.vectors();
                        cursor = ((Vector2)cursor).plus(command.vector(0, 1));
                        anchor = cursor;
                        int n6 = allPoints.size();
                        for (int i = 1; i < n6; ++i) {
                            point = allPoints.get(i);
                            object2 = segments;
                            object3 = new Segment((Vector2)cursor, ((Vector2)cursor).plus((Vector2)point));
                            object2.add(object3);
                            cursor = ((Vector2)cursor).plus((Vector2)point);
                        }
                        continue block36;
                    }
                    case "L": {
                        Object object2;
                        Object point;
                        List<Vector2> allPoints = command.vectors();
                        for (Vector2 point2 : allPoints) {
                            point = segments;
                            object2 = new Segment((Vector2)cursor, point2);
                            point.add(object2);
                            cursor = point2;
                        }
                        continue block36;
                    }
                    case "l": {
                        Object target2;
                        Object object3;
                        Object object2;
                        List<Vector2> allPoints = command.vectors();
                        for (Vector2 point : allPoints) {
                            target2 = ((Vector2)cursor).plus(point);
                            object2 = segments;
                            object3 = new Segment((Vector2)cursor, (Vector2)target2);
                            object2.add(object3);
                            cursor = target2;
                        }
                        continue block36;
                    }
                    case "h": {
                        Object target2;
                        Object object3;
                        Object object2;
                        int allPoints = 0;
                        int point = command.getOperands().length;
                        while (allPoints < point) {
                            void i;
                            Vector2 startCursor = cursor;
                            target2 = startCursor.plus(new Vector2(command.getOperands()[i], 0.0));
                            object2 = segments;
                            object3 = new Segment((Vector2)cursor, (Vector2)target2);
                            object2.add(object3);
                            cursor = target2;
                            ++i;
                        }
                        continue block36;
                    }
                    case "H": {
                        Object target2;
                        Object object2;
                        int point = command.getOperands().length;
                        for (int i = 0; i < point; ++i) {
                            Vector2 target3 = new Vector2(command.getOperands()[i], ((Vector2)cursor).getY());
                            target2 = segments;
                            object2 = new Segment((Vector2)cursor, target3);
                            target2.add(object2);
                            cursor = target3;
                        }
                        continue block36;
                    }
                    case "v": {
                        Object target2;
                        Object object2;
                        int point = command.getOperands().length;
                        for (int i = 0; i < point; ++i) {
                            Vector2 target4 = ((Vector2)cursor).plus(new Vector2(0.0, command.getOperands()[i]));
                            target2 = segments;
                            object2 = new Segment((Vector2)cursor, target4);
                            target2.add(object2);
                            cursor = target4;
                        }
                        continue block36;
                    }
                    case "V": {
                        Object target2;
                        Object object2;
                        int point = command.getOperands().length;
                        for (int i = 0; i < point; ++i) {
                            Vector2 target5 = new Vector2(((Vector2)cursor).getX(), command.getOperands()[i]);
                            target2 = segments;
                            object2 = new Segment((Vector2)cursor, target5);
                            target2.add(object2);
                            cursor = target5;
                        }
                        continue block36;
                    }
                    case "C": {
                        Segment segment;
                        Object object;
                        Collection<Object> points2;
                        List<Vector2> allPoints = command.vectors();
                        Iterable $receiver$iv3 = CollectionsKt.windowed$default(allPoints, 3, 3, false, 4, null);
                        for (Object element$iv2 : $receiver$iv3) {
                            points2 = (List)element$iv2;
                            boolean bl3 = false;
                            object = segments;
                            segment = new Segment((Vector2)cursor, (Vector2)points2.get(0), (Vector2)points2.get(1), (Vector2)points2.get(2));
                            object.add(segment);
                            cursor = (Vector2)points2.get(2);
                            relativeControl = ((Vector2)points2.get(1)).minus((Vector2)points2.get(2));
                        }
                        continue block36;
                    }
                    case "c": {
                        Segment segment;
                        Object object;
                        Collection<Object> points2;
                        List<Vector2> allPoints = command.vectors();
                        Iterable $receiver$iv4 = CollectionsKt.windowed$default(allPoints, 3, 3, false, 4, null);
                        for (Object element$iv2 : $receiver$iv4) {
                            points2 = (List)element$iv2;
                            boolean bl4 = false;
                            object = segments;
                            segment = new Segment((Vector2)cursor, ((Vector2)cursor).plus((Vector2)points2.get(0)), ((Vector2)cursor).plus((Vector2)points2.get(1)), ((Vector2)cursor).plus((Vector2)points2.get(2)));
                            object.add(segment);
                            relativeControl = ((Vector2)cursor).plus((Vector2)points2.get(1)).minus(((Vector2)cursor).plus((Vector2)points2.get(2)));
                            cursor = ((Vector2)cursor).plus((Vector2)points2.get(2));
                        }
                        continue block36;
                    }
                    case "Q": {
                        List<Vector2> points;
                        Collection<Object> points2;
                        Object object3;
                        List<Vector2> allPoints = command.vectors();
                        if (allPoints.size() % 2 != 0) {
                            throw (Throwable)new RuntimeException("invalid number of operands " + allPoints.size());
                        }
                        int $receiver$iv4 = 0;
                        int target5 = allPoints.size() / 2;
                        while ($receiver$iv4 < target5) {
                            void c;
                            points = allPoints.subList((int)(c * 2), (int)(c * 2 + 2));
                            points2 = segments;
                            object3 = new Segment((Vector2)cursor, points.get(0), points.get(1));
                            points2.add(object3);
                            cursor = points.get(1);
                            relativeControl = points.get(0).minus(points.get(1));
                            ++c;
                        }
                        continue block36;
                    }
                    case "q": {
                        List<Vector2> points;
                        Object object;
                        Object object3;
                        List<Vector2> allPoints = command.vectors();
                        if (allPoints.size() % 2 != 0) {
                            throw (Throwable)new RuntimeException("invalid number of operands " + allPoints.size());
                        }
                        int target5 = allPoints.size() / 2;
                        for (int c = 0; c < target5; ++c) {
                            points = allPoints.subList(c * 2, c * 2 + 2);
                            Vector2 target6 = ((Vector2)cursor).plus(points.get(1));
                            object3 = segments;
                            object = new Segment((Vector2)cursor, ((Vector2)cursor).plus(points.get(0)), target6);
                            object3.add(object);
                            relativeControl = ((Vector2)cursor).plus(points.get(0)).minus(((Vector2)cursor).plus(points.get(1)));
                            cursor = target6;
                        }
                        continue block36;
                    }
                    case "s": {
                        Vector2 reflected = relativeControl.times(-1.0);
                        Vector2 cp0 = ((Vector2)cursor).plus(reflected);
                        Vector2 cp1 = ((Vector2)cursor).plus(command.vector(0, 1));
                        Object target2 = ((Vector2)cursor).plus(command.vector(2, 3));
                        Object object2 = segments;
                        Object object3 = new Segment((Vector2)cursor, cp0, cp1, (Vector2)target2);
                        object2.add(object3);
                        cursor = target2;
                        relativeControl = cp1.minus((Vector2)target2);
                        break;
                    }
                    case "S": {
                        Vector2 reflected = relativeControl.times(-1.0);
                        Vector2 cp0 = ((Vector2)cursor).plus(reflected);
                        Vector2 cp1 = command.vector(0, 1);
                        Object target2 = command.vector(2, 3);
                        Object object2 = segments;
                        Object object3 = new Segment((Vector2)cursor, cp0, cp1, (Vector2)target2);
                        object2.add(object3);
                        cursor = target2;
                        relativeControl = cp1.minus((Vector2)target2);
                        break;
                    }
                    case "Z": 
                    case "z": {
                        if (((Vector2)cursor).minus(anchor).getLength() >= 0.001) {
                            Collection collection3 = segments;
                            Segment segment = new Segment((Vector2)cursor, anchor);
                            collection3.add(segment);
                        }
                        closed = true;
                        break;
                    }
                    default: {
                        throw (Throwable)new RuntimeException("unsupported op: " + command.getOp());
                    }
                }
            }
            ShapeContour it = shapeContour = new ShapeContour(segments, closed);
            boolean bl5 = false;
            ShapeContour shapeContour2 = it;
            collection2.add(shapeContour2);
        }
        List contours = (List)destination$iv$iv;
        return new Shape(contours);
    }

    public final void parseDrawAttributes(@NotNull Element e) {
        Double d;
        Double d2;
        Intrinsics.checkParameterIsNotNull(e, "e");
        if (e.hasAttr("fill")) {
            String string = e.attr("fill");
            Intrinsics.checkExpressionValueIsNotNull(string, "e.attr(\"fill\")");
            this.fill = new Color(SVGLoaderKt.parseColor(string));
        }
        if (e.hasAttr("stroke")) {
            String string = e.attr("stroke");
            Intrinsics.checkExpressionValueIsNotNull(string, "e.attr(\"stroke\")");
            this.stroke = new Color(SVGLoaderKt.parseColor(string));
        }
        String string = e.attr("stroke-width");
        SVGPath sVGPath = this;
        String it = string;
        boolean bl = false;
        String string2 = it;
        Intrinsics.checkExpressionValueIsNotNull(string2, "it");
        CharSequence charSequence = string2;
        if (charSequence.length() == 0) {
            d2 = null;
        } else {
            charSequence = it;
            d2 = Double.parseDouble((String)charSequence);
        }
        sVGPath.strokeWeight = d = d2;
        String string3 = e.attr("style");
        Intrinsics.checkExpressionValueIsNotNull(string3, "e.attr(\"style\")");
        Iterable $receiver$iv = StringsKt.split$default((CharSequence)string3, new String[]{";"}, false, 0, 6, null);
        for (Object element$iv : $receiver$iv) {
            String string4;
            String it2 = (String)element$iv;
            boolean bl2 = false;
            List tokens = StringsKt.split$default((CharSequence)it2, new String[]{":"}, false, 0, 6, null);
            String string5 = string4 = (String)tokens.get(0);
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string6, "(this as java.lang.String).toLowerCase()");
            String string7 = string4 = string6;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String attribute = ((Object)StringsKt.trim((CharSequence)string7)).toString();
            Function0<String> value$ = new Function0<String>(tokens){
                final /* synthetic */ List $tokens;

                @NotNull
                public final String invoke() {
                    String string;
                    if (this.$tokens.size() >= 2) {
                        String string2;
                        String string3 = string2 = (String)this.$tokens.get(1);
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                    } else {
                        string = "";
                    }
                    return string;
                }
                {
                    this.$tokens = list;
                    super(0);
                }
            };
            switch (attribute) {
                case "fill": {
                    this.fill = new Color(SVGLoaderKt.parseColor((String)value$.invoke()));
                    break;
                }
                case "stroke": {
                    this.stroke = new Color(SVGLoaderKt.parseColor((String)value$.invoke()));
                    break;
                }
                case "stroke-width": {
                    Object object = value$.invoke();
                    SVGPath sVGPath2 = this;
                    double d3 = Double.parseDouble((String)object);
                    sVGPath2.strokeWeight = d3;
                }
            }
        }
    }

    public SVGPath() {
        super(null);
        List list;
        SVGPath sVGPath = this;
        sVGPath.commands = list = (List)new ArrayList();
        this.fill = InheritColor.INSTANCE;
        this.stroke = InheritColor.INSTANCE;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/svg/SVGPath$Companion;", "", "()V", "fromSVGPathString", "Lorg/openrndr/svg/SVGPath;", "svgPath", "", "openrndr-svg"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SVGPath fromSVGPathString(@NotNull String svgPath) {
            List<String> list;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(svgPath, "svgPath");
            SVGPath path = new SVGPath();
            Object object = svgPath;
            Object object2 = "(?=[MmZzLlHhVvCcSsQqTtAa])";
            object2 = new Regex((String)object2);
            int n = 0;
            object = ((Regex)object2).split((CharSequence)object, n);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    CharSequence charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$receiver$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List<String> rawCommands = list;
            Pattern numbers = Pattern.compile("[-+]?[0-9]*[.]?[0-9]+(?:[eE][-+]?[0-9]+)?");
            for (String rawCommand : rawCommands) {
                CharSequence bl = rawCommand;
                if (!(bl.length() > 0)) continue;
                Matcher numberMatcher = numbers.matcher(rawCommand);
                List operands = new ArrayList();
                while (numberMatcher.find()) {
                    String string;
                    Intrinsics.checkExpressionValueIsNotNull(numberMatcher.group(), "numberMatcher.group()");
                    List list2 = operands;
                    double d = Double.parseDouble(string);
                    list2.add(d);
                }
                double[] dArray = CollectionsKt.toDoubleArray(operands);
                path.getCommands().add(new Command(String.valueOf(rawCommand.charAt(0)), Arrays.copyOf(dArray, dArray.length)));
            }
            return path;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

