/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.IntVector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J'\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010/\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003H\u0086\u0002J\t\u00100\u001a\u000201H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u001c\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\r\u00a8\u00063"}, d2={"Lorg/openrndr/math/IntVector3;", "Ljava/io/Serializable;", "x", "", "y", "z", "(III)V", "length", "", "getLength", "()D", "squaredLength", "getSquaredLength", "()I", "vector3", "Lorg/openrndr/math/Vector3;", "getVector3", "()Lorg/openrndr/math/Vector3;", "getX", "xx", "Lorg/openrndr/math/IntVector2;", "getXx", "()Lorg/openrndr/math/IntVector2;", "xy", "getXy", "getY", "yx", "getYx", "yy", "getYy", "getZ", "component1", "component2", "component3", "copy", "div", "d", "dot", "right", "equals", "", "other", "", "hashCode", "minus", "v", "plus", "times", "toString", "", "Companion", "openrndr-math"})
public final class IntVector3
implements Serializable {
    private final int x;
    private final int y;
    private final int z;
    @NotNull
    private static final IntVector3 ZERO;
    @NotNull
    private static final IntVector3 UNIT_X;
    @NotNull
    private static final IntVector3 UNIT_Y;
    @NotNull
    private static final IntVector3 UNIT_Z;
    public static final Companion Companion;

    public final double getLength() {
        return Math.sqrt(1.0 * (double)this.x * (double)this.x + (double)(this.y * this.y) + (double)(this.z * this.z));
    }

    public final int getSquaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final int dot(@NotNull IntVector3 right) {
        Intrinsics.checkParameterIsNotNull(right, "right");
        return this.x * right.x + this.y * right.y + this.z * right.z;
    }

    @NotNull
    public final IntVector2 getXy() {
        return new IntVector2(this.x, this.y);
    }

    @NotNull
    public final IntVector2 getYx() {
        return new IntVector2(this.y, this.x);
    }

    @NotNull
    public final IntVector2 getXx() {
        return new IntVector2(this.x, this.x);
    }

    @NotNull
    public final IntVector2 getYy() {
        return new IntVector2(this.y, this.y);
    }

    @NotNull
    public final IntVector3 plus(@NotNull IntVector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new IntVector3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    @NotNull
    public final IntVector3 minus(@NotNull IntVector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new IntVector3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    @NotNull
    public final IntVector3 times(int d) {
        return new IntVector3(this.x * d, this.y * d, this.z * d);
    }

    @NotNull
    public final IntVector3 div(int d) {
        return new IntVector3(this.x / d, this.y / d, this.z / d);
    }

    @NotNull
    public final Vector3 getVector3() {
        return new Vector3(this.x, this.y, this.z);
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public IntVector3(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    static {
        Companion = new Companion(null);
        ZERO = new IntVector3(0, 0, 0);
        UNIT_X = new IntVector3(1, 0, 0);
        UNIT_Y = new IntVector3(0, 1, 0);
        UNIT_Z = new IntVector3(0, 0, 1);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.z;
    }

    @NotNull
    public final IntVector3 copy(int x, int y, int z) {
        return new IntVector3(x, y, z);
    }

    @NotNull
    public static /* synthetic */ IntVector3 copy$default(IntVector3 intVector3, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = intVector3.x;
        }
        if ((n4 & 2) != 0) {
            n2 = intVector3.y;
        }
        if ((n4 & 4) != 0) {
            n3 = intVector3.z;
        }
        return intVector3.copy(n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "IntVector3(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        return (Integer.hashCode(this.x) * 31 + Integer.hashCode(this.y)) * 31 + Integer.hashCode(this.z);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof IntVector3)) break block3;
                IntVector3 intVector3 = (IntVector3)object;
                if (!(this.x == intVector3.x) || !(this.y == intVector3.y) || !(this.z == intVector3.z)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/openrndr/math/IntVector3$Companion;", "", "()V", "UNIT_X", "Lorg/openrndr/math/IntVector3;", "getUNIT_X", "()Lorg/openrndr/math/IntVector3;", "UNIT_Y", "getUNIT_Y", "UNIT_Z", "getUNIT_Z", "ZERO", "getZERO", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final IntVector3 getZERO() {
            return ZERO;
        }

        @NotNull
        public final IntVector3 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final IntVector3 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final IntVector3 getUNIT_Z() {
            return UNIT_Z;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

