/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBufferShadow;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.internal.gl3.BufferWriterGL3;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.ColorBufferGL3Kt;
import org.openrndr.internal.gl3.ColorBufferShadowGL3;
import org.openrndr.internal.gl3.ColorBufferShadowGL3$WhenMappings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016Jx\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152b\b\u0004\u0010\u0017\u001a\\\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u0018H\u0096\b\u00a2\u0006\u0002\u0010!Jx\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00152b\b\u0004\u0010\u0017\u001a\\\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00190\u0018H\u0096\b\u00a2\u0006\u0002\u0010$Jx\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00152b\b\u0004\u0010\u0017\u001a\\\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020'0\u0018H\u0096\b\u00a2\u0006\u0002\u0010(J\u00bd\u0001\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H+0*0\u0015\"\u0004\b\u0000\u0010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u008b\u0001\u0010\u0017\u001a\u0086\u0001\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(0\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(1\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u0002H+0/H\u0016\u00a2\u0006\u0002\u00102Jx\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00152b\b\u0004\u0010\u0017\u001a\\\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\f0\u0018H\u0096\b\u00a2\u0006\u0002\u00105J\u0018\u00106\u001a\u0002072\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\fH\u0016J\b\u00108\u001a\u00020\u0012H\u0016J8\u00109\u001a\u00020\u00122\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J\b\u0010:\u001a\u00020;H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006<"}, d2={"Lorg/openrndr/internal/gl3/ColorBufferShadowGL3;", "Lorg/openrndr/draw/ColorBufferShadow;", "colorBuffer", "Lorg/openrndr/internal/gl3/ColorBufferGL3;", "(Lorg/openrndr/internal/gl3/ColorBufferGL3;)V", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "getColorBuffer", "()Lorg/openrndr/internal/gl3/ColorBufferGL3;", "elementSize", "", "getElementSize", "()I", "size", "getSize", "destroy", "", "download", "mapBoolean", "", "", "mapper", "Lkotlin/Function4;", "", "Lkotlin/ParameterName;", "name", "r", "g", "b", "a", "", "(Lkotlin/jvm/functions/Function4;)[[Z", "mapDouble", "", "(Lkotlin/jvm/functions/Function4;)[[D", "mapFloat", "", "", "(Lkotlin/jvm/functions/Function4;)[[F", "mapIndexed", "", "T", "xrange", "Lkotlin/ranges/IntProgression;", "yrange", "Lkotlin/Function6;", "x", "y", "(Lkotlin/ranges/IntProgression;Lkotlin/ranges/IntProgression;Lkotlin/jvm/functions/Function6;)[Ljava/util/List;", "mapInt", "", "(Lkotlin/jvm/functions/Function4;)[[I", "read", "Lorg/openrndr/color/ColorRGBa;", "upload", "write", "writer", "Lorg/openrndr/draw/BufferWriter;", "openrndr-gl3"})
public final class ColorBufferShadowGL3
implements ColorBufferShadow {
    private final int size;
    private final int elementSize;
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private final ColorBufferGL3 colorBuffer;

    public final int getSize() {
        return this.size;
    }

    public final int getElementSize() {
        return this.elementSize;
    }

    @Override
    @NotNull
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void download() {
        ColorBufferGL3Kt.access$getLogger$p().trace(download.1.INSTANCE);
        this.getColorBuffer().read(this.getBuffer());
    }

    @Override
    public void upload() {
        this.getColorBuffer().write(this.getBuffer());
    }

    @Override
    public void destroy() {
        this.getColorBuffer().destroyShadow();
    }

    @Override
    public void write(int x, int y, double r, double g, double b, double a2) {
        int ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
        int offset2 = (ay * this.getColorBuffer().getEffectiveWidth() + x) * this.getColorBuffer().getFormat().getComponentCount() * this.getColorBuffer().getType().getComponentSize();
        switch (ColorBufferShadowGL3$WhenMappings.$EnumSwitchMapping$0[this.getColorBuffer().getType().ordinal()]) {
            case 1: {
                byte ir = (byte)RangesKt.coerceIn(r * (double)255, 0.0, 255.0);
                byte ig = (byte)RangesKt.coerceIn(g * (double)255, 0.0, 255.0);
                byte ib = (byte)RangesKt.coerceIn(b * (double)255, 0.0, 255.0);
                byte ia = (byte)RangesKt.coerceIn(a2 * (double)255, 0.0, 255.0);
                this.getBuffer().put(offset2, ir);
                this.getBuffer().put(offset2 + 1, ig);
                this.getBuffer().put(offset2 + 2, ib);
                if (this.getColorBuffer().getFormat().getComponentCount() <= 3) break;
                this.getBuffer().put(offset2 + 3, ia);
                break;
            }
            case 2: {
                char ir = (char)RangesKt.coerceIn(r * (double)65535, 0.0, 65535.0);
                char ig = (char)RangesKt.coerceIn(g * (double)65535, 0.0, 65535.0);
                char ib = (char)RangesKt.coerceIn(b * (double)65335, 0.0, 65535.0);
                char ia = (char)RangesKt.coerceIn(a2 * (double)65535, 0.0, 65535.0);
                this.getBuffer().putChar(offset2, ir);
                this.getBuffer().putChar(offset2 + 2, ig);
                this.getBuffer().putChar(offset2 + 4, ib);
                if (this.getColorBuffer().getFormat().getComponentCount() <= 3) break;
                this.getBuffer().putChar(offset2 + 6, ia);
                break;
            }
            case 3: {
                this.getBuffer().putFloat(offset2, (float)r);
                this.getBuffer().putFloat(offset2 + 4, (float)g);
                this.getBuffer().putFloat(offset2 + 8, (float)b);
                if (this.getColorBuffer().getFormat().getComponentCount() <= 3) break;
                this.getBuffer().putFloat(offset2 + 12, (float)a2);
                break;
            }
            default: {
                String string = "support for " + (Object)((Object)this.getColorBuffer().getType());
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
    }

    @Override
    @NotNull
    public boolean[][] mapBoolean(@NotNull Function4<? super Double, ? super Double, ? super Double, ? super Double, Boolean> mapper) {
        int x;
        int n;
        int ay;
        int i$iv;
        int $i$f$mapBoolean = 0;
        Intrinsics.checkParameterIsNotNull(mapper, "mapper");
        int size$iv = this.getColorBuffer().getEffectiveHeight();
        boolean[][] result$iv2 = new boolean[size$iv][];
        int n2 = 0;
        int n3 = result$iv2.length;
        while (n2 < n3) {
            void var8_17 = i$iv;
            int n4 = i$iv++;
            boolean[][] blArrayArray = result$iv2;
            boolean bl = false;
            boolean[] blArray = new boolean[this.getColorBuffer().getEffectiveWidth()];
            blArrayArray[n4] = blArray;
        }
        boolean[][] result2 = result$iv2;
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).rewind();
        Pair<ColorType, ColorFormat> pair = new Pair<ColorType, ColorFormat>(this.getColorBuffer().getType(), this.getColorBuffer().getFormat());
        if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RGBa))) {
            int result$iv2 = 0;
            i$iv = this.getColorBuffer().getEffectiveHeight();
            while (result$iv2 < i$iv) {
                int y;
                ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
                int it = 0;
                n = this.getColorBuffer().getEffectiveWidth();
                while (it < n) {
                    int ir = this.getBuffer().get() & 0xFF;
                    int ig = this.getBuffer().get() & 0xFF;
                    int ib = this.getBuffer().get() & 0xFF;
                    int ia = this.getBuffer().get() & 0xFF;
                    result2[ay][x] = mapper.invoke((Double)((double)ir / 255.0), (Double)((double)ig / 255.0), (Double)((double)ib / 255.0), (Double)((double)ia / 255.0));
                    ++x;
                }
                ++y;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RGB))) {
            i$iv = this.getColorBuffer().getEffectiveHeight();
            for (int y = 0; y < i$iv; ++y) {
                ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
                n = this.getColorBuffer().getEffectiveWidth();
                for (x = 0; x < n; ++x) {
                    int ir = this.getBuffer().get() & 0xFF;
                    int ig = this.getBuffer().get() & 0xFF;
                    int ib = this.getBuffer().get() & 0xFF;
                    result2[ay][x] = mapper.invoke((Double)((double)ir / 255.0), (Double)((double)ig / 255.0), (Double)((double)ib / 255.0), (Double)1.0);
                }
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RGBa))) {
            float fr = this.getBuffer().getFloat();
            float fg = this.getBuffer().getFloat();
            float fb = this.getBuffer().getFloat();
            float fa = this.getBuffer().getFloat();
            mapper.invoke(Double.valueOf(fr), Double.valueOf(fg), Double.valueOf(fb), Double.valueOf(fa));
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RGB))) {
            float fr = this.getBuffer().getFloat();
            float fg = this.getBuffer().getFloat();
            float fb = this.getBuffer().getFloat();
            mapper.invoke(Double.valueOf(fr), Double.valueOf(fg), Double.valueOf(fb), (Double)1.0);
        } else {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        return result2;
    }

    @Override
    @NotNull
    public double[][] mapDouble(@NotNull Function4<? super Double, ? super Double, ? super Double, ? super Double, Double> mapper) {
        int x;
        int n;
        int ay;
        int i$iv;
        int $i$f$mapDouble = 0;
        Intrinsics.checkParameterIsNotNull(mapper, "mapper");
        int size$iv = this.getColorBuffer().getEffectiveHeight();
        double[][] result$iv2 = new double[size$iv][];
        int n2 = 0;
        int n3 = result$iv2.length;
        while (n2 < n3) {
            void var8_17 = i$iv;
            int n4 = i$iv++;
            double[][] dArrayArray = result$iv2;
            boolean bl = false;
            double[] dArray = new double[this.getColorBuffer().getEffectiveWidth()];
            dArrayArray[n4] = dArray;
        }
        double[][] result2 = result$iv2;
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).rewind();
        Pair<ColorType, ColorFormat> pair = new Pair<ColorType, ColorFormat>(this.getColorBuffer().getType(), this.getColorBuffer().getFormat());
        if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RGBa))) {
            int result$iv2 = 0;
            i$iv = this.getColorBuffer().getEffectiveHeight();
            while (result$iv2 < i$iv) {
                int y;
                ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
                int it = 0;
                n = this.getColorBuffer().getEffectiveWidth();
                while (it < n) {
                    int ir = this.getBuffer().get() & 0xFF;
                    int ig = this.getBuffer().get() & 0xFF;
                    int ib = this.getBuffer().get() & 0xFF;
                    int ia = this.getBuffer().get() & 0xFF;
                    result2[ay][x] = ((Number)mapper.invoke((Double)((double)ir / 255.0), (Double)((double)ig / 255.0), (Double)((double)ib / 255.0), (Double)((double)ia / 255.0))).doubleValue();
                    ++x;
                }
                ++y;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RGB))) {
            i$iv = this.getColorBuffer().getEffectiveHeight();
            for (int y = 0; y < i$iv; ++y) {
                ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
                n = this.getColorBuffer().getEffectiveWidth();
                for (x = 0; x < n; ++x) {
                    int ir = this.getBuffer().get() & 0xFF;
                    int ig = this.getBuffer().get() & 0xFF;
                    int ib = this.getBuffer().get() & 0xFF;
                    result2[ay][x] = ((Number)mapper.invoke((Double)((double)ir / 255.0), (Double)((double)ig / 255.0), (Double)((double)ib / 255.0), (Double)1.0)).doubleValue();
                }
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RGBa))) {
            float fr = this.getBuffer().getFloat();
            float fg = this.getBuffer().getFloat();
            float fb = this.getBuffer().getFloat();
            float fa = this.getBuffer().getFloat();
            mapper.invoke(Double.valueOf(fr), Double.valueOf(fg), Double.valueOf(fb), Double.valueOf(fa));
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RGB))) {
            float fr = this.getBuffer().getFloat();
            float fg = this.getBuffer().getFloat();
            float fb = this.getBuffer().getFloat();
            mapper.invoke(Double.valueOf(fr), Double.valueOf(fg), Double.valueOf(fb), (Double)1.0);
        } else {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        return result2;
    }

    @Override
    @NotNull
    public float[][] mapFloat(@NotNull Function4<? super Double, ? super Double, ? super Double, ? super Double, Float> mapper) {
        int x;
        int n;
        int ay;
        int i$iv;
        int $i$f$mapFloat = 0;
        Intrinsics.checkParameterIsNotNull(mapper, "mapper");
        int size$iv = this.getColorBuffer().getEffectiveHeight();
        float[][] result$iv2 = new float[size$iv][];
        int n2 = 0;
        int n3 = result$iv2.length;
        while (n2 < n3) {
            void var8_17 = i$iv;
            int n4 = i$iv++;
            float[][] fArrayArray = result$iv2;
            boolean bl = false;
            float[] fArray = new float[this.getColorBuffer().getEffectiveWidth()];
            fArrayArray[n4] = fArray;
        }
        float[][] result2 = result$iv2;
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).rewind();
        Pair<ColorType, ColorFormat> pair = new Pair<ColorType, ColorFormat>(this.getColorBuffer().getType(), this.getColorBuffer().getFormat());
        if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RGBa))) {
            int result$iv2 = 0;
            i$iv = this.getColorBuffer().getEffectiveHeight();
            while (result$iv2 < i$iv) {
                int y;
                ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
                int it = 0;
                n = this.getColorBuffer().getEffectiveWidth();
                while (it < n) {
                    int ir = this.getBuffer().get() & 0xFF;
                    int ig = this.getBuffer().get() & 0xFF;
                    int ib = this.getBuffer().get() & 0xFF;
                    int ia = this.getBuffer().get() & 0xFF;
                    result2[ay][x] = ((Number)mapper.invoke((Double)((double)ir / 255.0), (Double)((double)ig / 255.0), (Double)((double)ib / 255.0), (Double)((double)ia / 255.0))).floatValue();
                    ++x;
                }
                ++y;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RGB))) {
            i$iv = this.getColorBuffer().getEffectiveHeight();
            for (int y = 0; y < i$iv; ++y) {
                ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
                n = this.getColorBuffer().getEffectiveWidth();
                for (x = 0; x < n; ++x) {
                    int ir = this.getBuffer().get() & 0xFF;
                    int ig = this.getBuffer().get() & 0xFF;
                    int ib = this.getBuffer().get() & 0xFF;
                    result2[ay][x] = ((Number)mapper.invoke((Double)((double)ir / 255.0), (Double)((double)ig / 255.0), (Double)((double)ib / 255.0), (Double)1.0)).floatValue();
                }
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RGBa))) {
            float fr = this.getBuffer().getFloat();
            float fg = this.getBuffer().getFloat();
            float fb = this.getBuffer().getFloat();
            float fa = this.getBuffer().getFloat();
            mapper.invoke(Double.valueOf(fr), Double.valueOf(fg), Double.valueOf(fb), Double.valueOf(fa));
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RGB))) {
            float fr = this.getBuffer().getFloat();
            float fg = this.getBuffer().getFloat();
            float fb = this.getBuffer().getFloat();
            mapper.invoke(Double.valueOf(fr), Double.valueOf(fg), Double.valueOf(fb), (Double)1.0);
        } else {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        return result2;
    }

    @Override
    @NotNull
    public int[][] mapInt(@NotNull Function4<? super Double, ? super Double, ? super Double, ? super Double, Integer> mapper) {
        int x;
        int n;
        int ay;
        int i$iv;
        int $i$f$mapInt = 0;
        Intrinsics.checkParameterIsNotNull(mapper, "mapper");
        int size$iv = this.getColorBuffer().getEffectiveHeight();
        int[][] result$iv2 = new int[size$iv][];
        int n2 = 0;
        int n3 = result$iv2.length;
        while (n2 < n3) {
            void var8_17 = i$iv;
            int n4 = i$iv++;
            int[][] nArrayArray = result$iv2;
            boolean bl = false;
            int[] nArray = new int[this.getColorBuffer().getEffectiveWidth()];
            nArrayArray[n4] = nArray;
        }
        int[][] result2 = result$iv2;
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).rewind();
        Pair<ColorType, ColorFormat> pair = new Pair<ColorType, ColorFormat>(this.getColorBuffer().getType(), this.getColorBuffer().getFormat());
        if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RGBa))) {
            int result$iv2 = 0;
            i$iv = this.getColorBuffer().getEffectiveHeight();
            while (result$iv2 < i$iv) {
                int y;
                ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
                int it = 0;
                n = this.getColorBuffer().getEffectiveWidth();
                while (it < n) {
                    int ir = this.getBuffer().get() & 0xFF;
                    int ig = this.getBuffer().get() & 0xFF;
                    int ib = this.getBuffer().get() & 0xFF;
                    int ia = this.getBuffer().get() & 0xFF;
                    result2[ay][x] = ((Number)mapper.invoke((Double)((double)ir / 255.0), (Double)((double)ig / 255.0), (Double)((double)ib / 255.0), (Double)((double)ia / 255.0))).intValue();
                    ++x;
                }
                ++y;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RGB))) {
            i$iv = this.getColorBuffer().getEffectiveHeight();
            for (int y = 0; y < i$iv; ++y) {
                ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
                n = this.getColorBuffer().getEffectiveWidth();
                for (x = 0; x < n; ++x) {
                    int ir = this.getBuffer().get() & 0xFF;
                    int ig = this.getBuffer().get() & 0xFF;
                    int ib = this.getBuffer().get() & 0xFF;
                    result2[ay][x] = ((Number)mapper.invoke((Double)((double)ir / 255.0), (Double)((double)ig / 255.0), (Double)((double)ib / 255.0), (Double)1.0)).intValue();
                }
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RGBa))) {
            float fr = this.getBuffer().getFloat();
            float fg = this.getBuffer().getFloat();
            float fb = this.getBuffer().getFloat();
            float fa = this.getBuffer().getFloat();
            mapper.invoke(Double.valueOf(fr), Double.valueOf(fg), Double.valueOf(fb), Double.valueOf(fa));
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RGB))) {
            float fr = this.getBuffer().getFloat();
            float fg = this.getBuffer().getFloat();
            float fb = this.getBuffer().getFloat();
            mapper.invoke(Double.valueOf(fr), Double.valueOf(fg), Double.valueOf(fb), (Double)1.0);
        } else {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> List<T>[] mapIndexed(@NotNull IntProgression xrange, @NotNull IntProgression yrange, @NotNull Function6<? super Integer, ? super Integer, ? super Double, ? super Double, ? super Double, ? super Double, ? extends T> mapper) {
        int offset2;
        int ay;
        int y;
        Collection<T> collection;
        List[] listArray;
        int n;
        Intrinsics.checkParameterIsNotNull(xrange, "xrange");
        Intrinsics.checkParameterIsNotNull(yrange, "yrange");
        Intrinsics.checkParameterIsNotNull(mapper, "mapper");
        int size$iv = ColorBufferGL3Kt.access$getSize$p(yrange);
        List[] result$iv2 = new List[size$iv];
        int n2 = 0;
        int n3 = result$iv2.length;
        while (n2 < n3) {
            void i$iv;
            void var9_25 = i$iv;
            n = i$iv++;
            listArray = result$iv2;
            boolean bl = false;
            collection = new ArrayList();
            listArray[n] = collection;
        }
        List[] result2 = result$iv2;
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).rewind();
        this.getBuffer().order(ByteOrder.nativeOrder());
        Pair<ColorType, ColorFormat> pair = new Pair<ColorType, ColorFormat>(this.getColorBuffer().getType(), this.getColorBuffer().getFormat());
        if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RGBa))) {
            boolean result$iv2 = false;
            Iterator iterator2 = ((Iterable)yrange).iterator();
            while (iterator2.hasNext()) {
                void $receiver$iv$iv;
                void $receiver$iv;
                int iy;
                y = ((IntIterator)iterator2).nextInt();
                ay = this.getColorBuffer().getFlipV() ? iy : result2.length - 1 - iy;
                offset2 = y * this.getColorBuffer().getEffectiveWidth() * 4 + xrange.getFirst() * 4;
                Iterable $i$f$Array = xrange;
                n = ay;
                listArray = result2;
                void var12_39 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator iterator3 = $receiver$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    void x;
                    int item$iv$iv;
                    int n4 = item$iv$iv = ((IntIterator)iterator3).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    int ir = this.getBuffer().get(offset2) & 0xFF;
                    int ig = this.getBuffer().get(offset2 + 1) & 0xFF;
                    int ib = this.getBuffer().get(offset2 + 2) & 0xFF;
                    int ia = this.getBuffer().get(offset2 + 3) & 0xFF;
                    offset2 += xrange.getStep() * 4;
                    T t = mapper.invoke((int)x, y, (double)ir / 255.0, (double)ig / 255.0, (double)ib / 255.0, (double)ia / 255.0);
                    collection.add(t);
                }
                collection = (List)destination$iv$iv;
                listArray[n] = collection;
                ++iy;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RGB))) {
            int iy = 0;
            Iterator iterator4 = ((Iterable)yrange).iterator();
            while (iterator4.hasNext()) {
                y = ((IntIterator)iterator4).nextInt();
                ay = this.getColorBuffer().getFlipV() ? iy : result2.length - 1 - iy;
                offset2 = y * this.getColorBuffer().getEffectiveWidth() * 3 + xrange.getFirst() * 3;
                Iterable $receiver$iv = xrange;
                n = ay;
                listArray = result2;
                Iterable $receiver$iv$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator iterator5 = $receiver$iv$iv.iterator();
                while (iterator5.hasNext()) {
                    int item$iv$iv;
                    int x = item$iv$iv = ((IntIterator)iterator5).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    int ir = this.getBuffer().get(offset2) & 0xFF;
                    int ig = this.getBuffer().get(offset2 + 1) & 0xFF;
                    int ib = this.getBuffer().get(offset2 + 2) & 0xFF;
                    offset2 += xrange.getStep() * 3;
                    T t = mapper.invoke(x, y, (double)ir / 255.0, (double)ig / 255.0, (double)ib / 255.0, 1.0);
                    collection.add(t);
                }
                collection = (List)destination$iv$iv;
                listArray[n] = collection;
                ++iy;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.RG))) {
            int iy = 0;
            Iterator iterator6 = ((Iterable)yrange).iterator();
            while (iterator6.hasNext()) {
                y = ((IntIterator)iterator6).nextInt();
                ay = this.getColorBuffer().getFlipV() ? iy : result2.length - 1 - iy;
                offset2 = y * this.getColorBuffer().getEffectiveWidth() * 2 + xrange.getFirst() * 3;
                Iterable $receiver$iv = xrange;
                n = ay;
                listArray = result2;
                Iterable $receiver$iv$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator iterator7 = $receiver$iv$iv.iterator();
                while (iterator7.hasNext()) {
                    int item$iv$iv;
                    int x = item$iv$iv = ((IntIterator)iterator7).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    int ir = this.getBuffer().get(offset2) & 0xFF;
                    int ig = this.getBuffer().get(offset2 + 1) & 0xFF;
                    offset2 += xrange.getStep() * 2;
                    T t = mapper.invoke(x, y, (double)ir / 255.0, (double)ig / 255.0, 0.0, 1.0);
                    collection.add(t);
                }
                collection = (List)destination$iv$iv;
                listArray[n] = collection;
                ++iy;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.UINT8, ColorFormat.R))) {
            int iy = 0;
            Iterator iterator8 = ((Iterable)yrange).iterator();
            while (iterator8.hasNext()) {
                y = ((IntIterator)iterator8).nextInt();
                ay = this.getColorBuffer().getFlipV() ? iy : result2.length - 1 - iy;
                offset2 = y * this.getColorBuffer().getEffectiveWidth() * 2 + xrange.getFirst() * 3;
                Iterable $receiver$iv = xrange;
                n = ay;
                listArray = result2;
                Iterable $receiver$iv$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator iterator9 = $receiver$iv$iv.iterator();
                while (iterator9.hasNext()) {
                    int item$iv$iv;
                    int x = item$iv$iv = ((IntIterator)iterator9).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    int ir = this.getBuffer().get(offset2) & 0xFF;
                    offset2 += xrange.getStep() * 1;
                    T t = mapper.invoke(x, y, (double)ir / 255.0, 0.0, 0.0, 1.0);
                    collection.add(t);
                }
                collection = (List)destination$iv$iv;
                listArray[n] = collection;
                ++iy;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.R))) {
            int iy = 0;
            Iterator iterator10 = ((Iterable)yrange).iterator();
            while (iterator10.hasNext()) {
                y = ((IntIterator)iterator10).nextInt();
                ay = this.getColorBuffer().getFlipV() ? iy : result2.length - 1 - iy;
                offset2 = y * this.getColorBuffer().getEffectiveWidth() * 4 + xrange.getFirst() * 4;
                Iterable $receiver$iv = xrange;
                n = ay;
                listArray = result2;
                Iterable $receiver$iv$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator iterator11 = $receiver$iv$iv.iterator();
                while (iterator11.hasNext()) {
                    int item$iv$iv;
                    int x = item$iv$iv = ((IntIterator)iterator11).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    float ir = this.getBuffer().getFloat(offset2);
                    offset2 += xrange.getStep() * 4;
                    T t = mapper.invoke(x, y, Double.valueOf(ir), 0.0, 0.0, 1.0);
                    collection.add(t);
                }
                collection = (List)destination$iv$iv;
                listArray[n] = collection;
                ++iy;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RG))) {
            int iy = 0;
            Iterator iterator12 = ((Iterable)yrange).iterator();
            while (iterator12.hasNext()) {
                y = ((IntIterator)iterator12).nextInt();
                ay = this.getColorBuffer().getFlipV() ? iy : result2.length - 1 - iy;
                offset2 = y * this.getColorBuffer().getEffectiveWidth() * 8 + xrange.getFirst() * 8;
                Iterable $receiver$iv = xrange;
                n = ay;
                listArray = result2;
                Iterable $receiver$iv$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator iterator13 = $receiver$iv$iv.iterator();
                while (iterator13.hasNext()) {
                    int item$iv$iv;
                    int x = item$iv$iv = ((IntIterator)iterator13).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    float ir = this.getBuffer().getFloat(offset2);
                    float ig = this.getBuffer().getFloat(offset2 + 4);
                    offset2 += xrange.getStep() * 8;
                    T t = mapper.invoke(x, y, Double.valueOf(ir), Double.valueOf(ig), 0.0, 1.0);
                    collection.add(t);
                }
                collection = (List)destination$iv$iv;
                listArray[n] = collection;
                ++iy;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RGB))) {
            int iy = 0;
            Iterator iterator14 = ((Iterable)yrange).iterator();
            while (iterator14.hasNext()) {
                y = ((IntIterator)iterator14).nextInt();
                ay = this.getColorBuffer().getFlipV() ? iy : result2.length - 1 - iy;
                offset2 = y * this.getColorBuffer().getEffectiveWidth() * 12 + xrange.getFirst() * 12;
                Iterable $receiver$iv = xrange;
                n = ay;
                listArray = result2;
                Iterable $receiver$iv$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator iterator15 = $receiver$iv$iv.iterator();
                while (iterator15.hasNext()) {
                    int item$iv$iv;
                    int x = item$iv$iv = ((IntIterator)iterator15).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    float ir = this.getBuffer().getFloat(offset2);
                    float ig = this.getBuffer().getFloat(offset2 + 4);
                    float ib = this.getBuffer().getFloat(offset2 + 8);
                    offset2 += xrange.getStep() * 12;
                    T t = mapper.invoke(x, y, Double.valueOf(ir), Double.valueOf(ig), Double.valueOf(ib), 1.0);
                    collection.add(t);
                }
                collection = (List)destination$iv$iv;
                listArray[n] = collection;
                ++iy;
            }
        } else if (Intrinsics.areEqual(pair, new Pair<ColorType, ColorFormat>(ColorType.FLOAT32, ColorFormat.RGBa))) {
            int iy = 0;
            Iterator iterator16 = ((Iterable)yrange).iterator();
            while (iterator16.hasNext()) {
                y = ((IntIterator)iterator16).nextInt();
                ay = this.getColorBuffer().getFlipV() ? iy : result2.length - 1 - iy;
                offset2 = y * this.getColorBuffer().getEffectiveWidth() * 16 + xrange.getFirst() * 16;
                Iterable $receiver$iv = xrange;
                n = ay;
                listArray = result2;
                Iterable $receiver$iv$iv = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator iterator17 = $receiver$iv$iv.iterator();
                while (iterator17.hasNext()) {
                    int item$iv$iv;
                    int x = item$iv$iv = ((IntIterator)iterator17).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    float ir = this.getBuffer().getFloat(offset2);
                    float ig = this.getBuffer().getFloat(offset2 + 4);
                    float ib = this.getBuffer().getFloat(offset2 + 8);
                    float ia = this.getBuffer().getFloat(offset2 + 12);
                    offset2 += xrange.getStep() * 16;
                    T t = mapper.invoke(x, y, Double.valueOf(ir), Double.valueOf(ig), Double.valueOf(ib), Double.valueOf(ia));
                    collection.add(t);
                }
                collection = (List)destination$iv$iv;
                listArray[n] = collection;
                ++iy;
            }
        } else {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        return result2;
    }

    @Override
    @NotNull
    public ColorRGBa read(int x, int y) {
        ColorRGBa colorRGBa;
        int componentCount2 = this.getColorBuffer().getFormat().getComponentCount();
        int ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
        int offset2 = (ay * this.getColorBuffer().getEffectiveWidth() + x) * this.getColorBuffer().getFormat().getComponentCount() * this.getColorBuffer().getType().getComponentSize();
        switch (ColorBufferShadowGL3$WhenMappings.$EnumSwitchMapping$1[this.getColorBuffer().getType().ordinal()]) {
            case 1: {
                int ir = this.getBuffer().get(offset2) & 0xFF;
                int ig = componentCount2 >= 2 ? this.getBuffer().get(offset2 + 1) & 0xFF : 0;
                int ib = componentCount2 >= 3 ? this.getBuffer().get(offset2 + 2) & 0xFF : 0;
                int ia = componentCount2 >= 4 ? this.getBuffer().get(offset2 + 3) & 0xFF : 255;
                colorRGBa = new ColorRGBa((double)ir / 255.0, (double)ig / 255.0, (double)ib / 255.0, (double)ia / 255.0, null, 16, null);
                break;
            }
            case 2: {
                int ir = this.getBuffer().get(offset2) & 0xFFFF;
                int ig = componentCount2 >= 2 ? this.getBuffer().get(offset2 + 1) & 0xFFFF : 0;
                int ib = componentCount2 >= 3 ? this.getBuffer().get(offset2 + 2) & 0xFFFF : 0;
                int ia = componentCount2 >= 4 ? this.getBuffer().get(offset2 + 3) & 0xFFFF : 255;
                colorRGBa = new ColorRGBa((double)ir / 65535.0, (double)ig / 65535.0, (double)ib / 65535.0, (double)ia / 65535.0, null, 16, null);
                break;
            }
            case 3: {
                float fr = this.getBuffer().getFloat(offset2);
                float fg = componentCount2 >= 2 ? this.getBuffer().getFloat(offset2 + 4) : 0.0f;
                float fb = componentCount2 >= 3 ? this.getBuffer().getFloat(offset2 + 8) : 0.0f;
                float fa = componentCount2 >= 4 ? this.getBuffer().getFloat(offset2 + 12) : 1.0f;
                colorRGBa = new ColorRGBa(fr, fg, fb, fa, null, 16, null);
                break;
            }
            default: {
                String string = "support for " + (Object)((Object)this.getColorBuffer().getType());
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return colorRGBa;
    }

    @Override
    @NotNull
    public BufferWriter writer() {
        return new BufferWriterGL3(this.getBuffer(), 0, 2, null);
    }

    @Override
    @NotNull
    public ColorBufferGL3 getColorBuffer() {
        return this.colorBuffer;
    }

    public ColorBufferShadowGL3(@NotNull ColorBufferGL3 colorBuffer) {
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        this.colorBuffer = colorBuffer;
        this.size = this.getColorBuffer().getWidth() * this.getColorBuffer().getHeight();
        this.elementSize = this.getColorBuffer().getFormat().getComponentCount() * this.getColorBuffer().getType().getComponentSize();
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(this.elementSize * this.size);
        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "BufferUtils.createByteBuffer(elementSize * size)");
        this.buffer = byteBuffer;
    }

    @Override
    public void write(int x, int y, float r, float g, float b, float a2) {
        ColorBufferShadow.DefaultImpls.write(this, x, y, r, g, b, a2);
    }

    @Override
    public void write(int x, int y, @NotNull ColorRGBa color) {
        Intrinsics.checkParameterIsNotNull(color, "color");
        ColorBufferShadow.DefaultImpls.write(this, x, y, color);
    }

    @Override
    @NotNull
    public <T> List<T> flatMapIndexed(@NotNull IntProgression xrange, @NotNull IntProgression yrange, @NotNull Function6<? super Integer, ? super Integer, ? super Double, ? super Double, ? super Double, ? super Double, ? extends T> mapper) {
        Intrinsics.checkParameterIsNotNull(xrange, "xrange");
        Intrinsics.checkParameterIsNotNull(yrange, "yrange");
        Intrinsics.checkParameterIsNotNull(mapper, "mapper");
        return ColorBufferShadow.DefaultImpls.flatMapIndexed(this, xrange, yrange, mapper);
    }

    @Override
    @NotNull
    public ColorRGBa get(int x, int y) {
        return ColorBufferShadow.DefaultImpls.get(this, x, y);
    }

    @Override
    public void set(int x, int y, @NotNull ColorRGBa c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        ColorBufferShadow.DefaultImpls.set(this, x, y, c);
    }
}

