/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BlendMode;
import org.openrndr.draw.DepthTestPass;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.Filter;
import org.openrndr.draw.Shader;
import org.openrndr.draw.ShaderWatcher;
import org.openrndr.draw.ShaderWatcherBuilder;
import org.openrndr.draw.ShaderWatcherKt;
import org.openrndr.draw.StencilTest;
import org.openrndr.draw.VertexBuffer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"filterDrawStyle", "Lorg/openrndr/draw/DrawStyle;", "filterQuad", "Lorg/openrndr/draw/VertexBuffer;", "filterShaderFromCode", "Lorg/openrndr/draw/Shader;", "fragmentShaderCode", "", "filterShaderFromUrl", "url", "filterWatcherFromUrl", "Lorg/openrndr/draw/ShaderWatcher;", "openrndr-core"})
public final class FilterKt {
    private static final DrawStyle filterDrawStyle;
    private static VertexBuffer filterQuad;

    @NotNull
    public static final Shader filterShaderFromUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        URL uRL = new URL(url);
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes(uRL);
        return FilterKt.filterShaderFromCode(new String(byArray, charset));
    }

    @NotNull
    public static final ShaderWatcher filterWatcherFromUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        return ShaderWatcherKt.shaderWatcher((Function1<? super ShaderWatcherBuilder, Unit>)new Function1<ShaderWatcherBuilder, Unit>(url){
            final /* synthetic */ String $url;

            public final void invoke(@NotNull ShaderWatcherBuilder $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                $receiver.setVertexShaderCode(Filter.Companion.getFilterVertexCode());
                $receiver.setFragmentShaderUrl(this.$url);
            }
            {
                this.$url = string;
                super(1);
            }
        });
    }

    @NotNull
    public static final Shader filterShaderFromCode(@NotNull String fragmentShaderCode) {
        Intrinsics.checkParameterIsNotNull(fragmentShaderCode, "fragmentShaderCode");
        return Shader.Companion.createFromCode(Filter.Companion.getFilterVertexCode(), fragmentShaderCode);
    }

    static {
        DrawStyle drawStyle;
        DrawStyle $receiver = drawStyle = new DrawStyle(null, null, null, null, null, 0.0, false, null, null, false, null, null, null, false, null, null, null, null, null, null, null, 0x1FFFFF, null);
        boolean bl = false;
        $receiver.setBlendMode(BlendMode.REPLACE);
        $receiver.setDepthWrite(false);
        $receiver.setDepthTestPass(DepthTestPass.ALWAYS);
        $receiver.getStencil().setStencilTest(StencilTest.DISABLED);
        filterDrawStyle = drawStyle;
    }

    public static final /* synthetic */ VertexBuffer access$getFilterQuad$p() {
        return filterQuad;
    }

    public static final /* synthetic */ void access$setFilterQuad$p(VertexBuffer vertexBuffer) {
        filterQuad = vertexBuffer;
    }

    public static final /* synthetic */ DrawStyle access$getFilterDrawStyle$p() {
        return filterDrawStyle;
    }
}

