/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorHSLa;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLCHABa;
import org.openrndr.color.ColorLCHUVa;
import org.openrndr.color.ColorLUVa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorRGBa$WhenMappings;
import org.openrndr.color.ColorXYZa;
import org.openrndr.color.Linearity;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 ;2\u00020\u0001:\u0002;<B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J;\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0003J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020/J\u0010\u00100\u001a\u0002012\b\b\u0002\u0010.\u001a\u00020/J\u0010\u00102\u001a\u0002032\b\b\u0002\u0010.\u001a\u00020/J\u0010\u00104\u001a\u0002052\b\b\u0002\u0010.\u001a\u00020/J\u0006\u00106\u001a\u00020\u0000J\u0006\u00107\u001a\u00020\u0000J\t\u00108\u001a\u000209H\u00d6\u0001J\u0006\u0010:\u001a\u00020/R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006="}, d2={"Lorg/openrndr/color/ColorRGBa;", "", "r", "", "g", "b", "a", "linearity", "Lorg/openrndr/color/Linearity;", "(DDDDLorg/openrndr/color/Linearity;)V", "getA", "()D", "alphaMultiplied", "getAlphaMultiplied", "()Lorg/openrndr/color/ColorRGBa;", "getB", "getG", "getLinearity", "()Lorg/openrndr/color/Linearity;", "maxValue", "getMaxValue", "minValue", "getMinValue", "getR", "saturated", "getSaturated", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "opacify", "opacity", "shade", "toHSLa", "Lorg/openrndr/color/ColorHSLa;", "toHSVa", "Lorg/openrndr/color/ColorHSVa;", "toLABa", "Lorg/openrndr/color/ColorLABa;", "ref", "Lorg/openrndr/color/ColorXYZa;", "toLCHABa", "Lorg/openrndr/color/ColorLCHABa;", "toLCHUVa", "Lorg/openrndr/color/ColorLCHUVa;", "toLUVa", "Lorg/openrndr/color/ColorLUVa;", "toLinear", "toSRGB", "toString", "", "toXYZa", "Companion", "Component", "openrndr-color"})
public final class ColorRGBa {
    private final double r;
    private final double g;
    private final double b;
    private final double a;
    @NotNull
    private final Linearity linearity;
    @NotNull
    private static final ColorRGBa PINK;
    @NotNull
    private static final ColorRGBa BLACK;
    @NotNull
    private static final ColorRGBa WHITE;
    @NotNull
    private static final ColorRGBa RED;
    @NotNull
    private static final ColorRGBa BLUE;
    @NotNull
    private static final ColorRGBa GREEN;
    @NotNull
    private static final ColorRGBa YELLOW;
    @NotNull
    private static final ColorRGBa GRAY;
    @NotNull
    private static final ColorRGBa TRANSPARENT;
    public static final Companion Companion;

    @NotNull
    public final ColorRGBa opacify(double opacity) {
        return new ColorRGBa(this.r, this.g, this.b, this.a * opacity, null, 16, null);
    }

    @NotNull
    public final ColorRGBa shade(double shade) {
        return new ColorRGBa(this.r * shade, this.g * shade, this.b * shade, this.a, null, 16, null);
    }

    @NotNull
    public final ColorRGBa getSaturated() {
        return new ColorRGBa(RangesKt.coerceIn(this.r, 0.0, 1.0), RangesKt.coerceIn(this.g, 0.0, 1.0), RangesKt.coerceIn(this.b, 0.0, 1.0), RangesKt.coerceIn(this.a, 0.0, 1.0), null, 16, null);
    }

    @NotNull
    public final ColorRGBa getAlphaMultiplied() {
        return new ColorRGBa(this.r * this.a, this.g * this.a, this.b * this.a, this.a, null, 16, null);
    }

    public final double getMinValue() {
        return Math.min(Math.min(this.r, this.g), this.b);
    }

    public final double getMaxValue() {
        return Math.max(Math.max(this.r, this.g), this.b);
    }

    @NotNull
    public final ColorHSVa toHSVa() {
        return ColorHSVa.Companion.fromRGBa(this.toSRGB());
    }

    @NotNull
    public final ColorHSLa toHSLa() {
        return ColorHSLa.Companion.fromRGBa(this.toSRGB());
    }

    @NotNull
    public final ColorXYZa toXYZa() {
        return ColorXYZa.Companion.fromRGBa(this.toLinear());
    }

    @NotNull
    public final ColorLABa toLABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        return ColorLABa.Companion.fromRGBa(this.toLinear(), ref);
    }

    @NotNull
    public static /* synthetic */ ColorLABa toLABa$default(ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorRGBa.toLABa(colorXYZa);
    }

    @NotNull
    public final ColorLUVa toLUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        return ColorLUVa.Companion.fromRGBa(this.toLinear(), ref);
    }

    @NotNull
    public static /* synthetic */ ColorLUVa toLUVa$default(ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorRGBa.toLUVa(colorXYZa);
    }

    @NotNull
    public final ColorLCHABa toLCHABa(@NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        return this.toXYZa().toLABa(ref).toLCHABa();
    }

    @NotNull
    public static /* synthetic */ ColorLCHABa toLCHABa$default(ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorRGBa.toLCHABa(colorXYZa);
    }

    @NotNull
    public final ColorLCHUVa toLCHUVa(@NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        return this.toLUVa(ref).toLCHUVa();
    }

    @NotNull
    public static /* synthetic */ ColorLCHUVa toLCHUVa$default(ColorRGBa colorRGBa, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        return colorRGBa.toLCHUVa(colorXYZa);
    }

    @NotNull
    public final ColorRGBa toLinear() {
        ColorRGBa colorRGBa;
        toLinear.1 t$ = toLinear.1.INSTANCE;
        switch (ColorRGBa$WhenMappings.$EnumSwitchMapping$0[this.linearity.ordinal()]) {
            case 1: {
                colorRGBa = new ColorRGBa(t$.invoke(this.r), t$.invoke(this.g), t$.invoke(this.b), this.a, Linearity.LINEAR);
                break;
            }
            case 2: 
            case 3: {
                colorRGBa = new ColorRGBa(t$.invoke(this.r), t$.invoke(this.g), t$.invoke(this.b), this.a, Linearity.ASSUMED_LINEAR);
                break;
            }
            case 4: 
            case 5: {
                colorRGBa = this;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return colorRGBa;
    }

    @NotNull
    public final ColorRGBa toSRGB() {
        ColorRGBa colorRGBa;
        toSRGB.1 t$ = toSRGB.1.INSTANCE;
        switch (ColorRGBa$WhenMappings.$EnumSwitchMapping$1[this.linearity.ordinal()]) {
            case 1: {
                colorRGBa = new ColorRGBa(t$.invoke(this.r), t$.invoke(this.g), t$.invoke(this.b), this.a, Linearity.SRGB);
                break;
            }
            case 2: 
            case 3: {
                colorRGBa = new ColorRGBa(t$.invoke(this.r), t$.invoke(this.g), t$.invoke(this.b), this.a, Linearity.ASSUMED_SRGB);
                break;
            }
            case 4: 
            case 5: {
                colorRGBa = this;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return colorRGBa;
    }

    public final double getR() {
        return this.r;
    }

    public final double getG() {
        return this.g;
    }

    public final double getB() {
        return this.b;
    }

    public final double getA() {
        return this.a;
    }

    @NotNull
    public final Linearity getLinearity() {
        return this.linearity;
    }

    public ColorRGBa(double r, double g, double b, double a2, @NotNull Linearity linearity) {
        Intrinsics.checkParameterIsNotNull((Object)linearity, "linearity");
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a2;
        this.linearity = linearity;
    }

    public /* synthetic */ ColorRGBa(double d, double d2, double d3, double d4, Linearity linearity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        if ((n & 0x10) != 0) {
            linearity = Linearity.UNKNOWN;
        }
        this(d, d2, d3, d4, linearity);
    }

    static {
        Companion = new Companion(null);
        PINK = Companion.fromHex(16761035);
        BLACK = new ColorRGBa(0.0, 0.0, 0.0, 1.0, null, 16, null);
        WHITE = new ColorRGBa(1.0, 1.0, 1.0, 1.0, null, 16, null);
        RED = new ColorRGBa(1.0, 0.0, 0.0, 1.0, null, 16, null);
        BLUE = new ColorRGBa(0.0, 0.0, 1.0, 0.0, null, 24, null);
        GREEN = new ColorRGBa(0.0, 1.0, 0.0, 0.0, null, 24, null);
        YELLOW = new ColorRGBa(1.0, 1.0, 0.0, 0.0, null, 24, null);
        GRAY = new ColorRGBa(0.5, 0.5, 0.5, 0.0, null, 24, null);
        TRANSPARENT = new ColorRGBa(0.0, 0.0, 0.0, 0.0, null, 16, null);
    }

    public final double component1() {
        return this.r;
    }

    public final double component2() {
        return this.g;
    }

    public final double component3() {
        return this.b;
    }

    public final double component4() {
        return this.a;
    }

    @NotNull
    public final Linearity component5() {
        return this.linearity;
    }

    @NotNull
    public final ColorRGBa copy(double r, double g, double b, double a2, @NotNull Linearity linearity) {
        Intrinsics.checkParameterIsNotNull((Object)linearity, "linearity");
        return new ColorRGBa(r, g, b, a2, linearity);
    }

    @NotNull
    public static /* synthetic */ ColorRGBa copy$default(ColorRGBa colorRGBa, double d, double d2, double d3, double d4, Linearity linearity, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorRGBa.r;
        }
        if ((n & 2) != 0) {
            d2 = colorRGBa.g;
        }
        if ((n & 4) != 0) {
            d3 = colorRGBa.b;
        }
        if ((n & 8) != 0) {
            d4 = colorRGBa.a;
        }
        if ((n & 0x10) != 0) {
            linearity = colorRGBa.linearity;
        }
        return colorRGBa.copy(d, d2, d3, d4, linearity);
    }

    @NotNull
    public String toString() {
        return "ColorRGBa(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + ", linearity=" + (Object)((Object)this.linearity) + ")";
    }

    public int hashCode() {
        Linearity linearity = this.linearity;
        return (((Double.hashCode(this.r) * 31 + Double.hashCode(this.g)) * 31 + Double.hashCode(this.b)) * 31 + Double.hashCode(this.a)) * 31 + (linearity != null ? ((Object)((Object)linearity)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorRGBa)) break block3;
                ColorRGBa colorRGBa = (ColorRGBa)object;
                if (Double.compare(this.r, colorRGBa.r) != 0 || Double.compare(this.g, colorRGBa.g) != 0 || Double.compare(this.b, colorRGBa.b) != 0 || Double.compare(this.a, colorRGBa.a) != 0 || !Intrinsics.areEqual((Object)this.linearity, (Object)colorRGBa.linearity)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/color/ColorRGBa$Component;", "", "(Ljava/lang/String;I)V", "R", "G", "B", "a", "openrndr-color"})
    public static final class Component
    extends Enum<Component> {
        public static final /* enum */ Component R;
        public static final /* enum */ Component G;
        public static final /* enum */ Component B;
        public static final /* enum */ Component a;
        private static final /* synthetic */ Component[] $VALUES;

        static {
            Component[] componentArray = new Component[4];
            Component[] componentArray2 = componentArray;
            componentArray[0] = R = new Component();
            componentArray[1] = G = new Component();
            componentArray[2] = B = new Component();
            componentArray[3] = a = new Component();
            $VALUES = componentArray;
        }

        public static Component[] values() {
            return (Component[])$VALUES.clone();
        }

        public static Component valueOf(String string) {
            return Enum.valueOf(Component.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/openrndr/color/ColorRGBa$Companion;", "", "()V", "BLACK", "Lorg/openrndr/color/ColorRGBa;", "getBLACK", "()Lorg/openrndr/color/ColorRGBa;", "BLUE", "getBLUE", "GRAY", "getGRAY", "GREEN", "getGREEN", "PINK", "getPINK", "RED", "getRED", "TRANSPARENT", "getTRANSPARENT", "WHITE", "getWHITE", "YELLOW", "getYELLOW", "fromHex", "hex", "", "fromVector", "vector", "Lorg/openrndr/math/Vector3;", "alpha", "", "Lorg/openrndr/math/Vector4;", "openrndr-color"})
    public static final class Companion {
        @NotNull
        public final ColorRGBa fromHex(int hex) {
            int r = (hex & 0xFF0000) >> 16;
            int g = (hex & 0xFF00) >> 8;
            int b = hex & 0xFF;
            return new ColorRGBa((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, 1.0, Linearity.SRGB);
        }

        @NotNull
        public final ColorRGBa getPINK() {
            return PINK;
        }

        @NotNull
        public final ColorRGBa getBLACK() {
            return BLACK;
        }

        @NotNull
        public final ColorRGBa getWHITE() {
            return WHITE;
        }

        @NotNull
        public final ColorRGBa getRED() {
            return RED;
        }

        @NotNull
        public final ColorRGBa getBLUE() {
            return BLUE;
        }

        @NotNull
        public final ColorRGBa getGREEN() {
            return GREEN;
        }

        @NotNull
        public final ColorRGBa getYELLOW() {
            return YELLOW;
        }

        @NotNull
        public final ColorRGBa getGRAY() {
            return GRAY;
        }

        @NotNull
        public final ColorRGBa getTRANSPARENT() {
            return TRANSPARENT;
        }

        @NotNull
        public final ColorRGBa fromVector(@NotNull Vector3 vector, double alpha) {
            Intrinsics.checkParameterIsNotNull(vector, "vector");
            return new ColorRGBa(vector.getX(), vector.getY(), vector.getZ(), alpha, null, 16, null);
        }

        @NotNull
        public static /* synthetic */ ColorRGBa fromVector$default(Companion companion, Vector3 vector3, double d, int n, Object object) {
            if ((n & 2) != 0) {
                d = 1.0;
            }
            return companion.fromVector(vector3, d);
        }

        @NotNull
        public final ColorRGBa fromVector(@NotNull Vector4 vector) {
            Intrinsics.checkParameterIsNotNull(vector, "vector");
            return new ColorRGBa(vector.getX(), vector.getY(), vector.getZ(), vector.getW(), null, 16, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

