/*
 * Decompiled with CFR 0.152.
 */
package org.jouvieje.libloader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdesktop.applet.util.JNLPAppletLauncher;
import org.jouvieje.libloader.LibLoaderJNI;
import org.jouvieje.libloader.LibraryConfig;
import org.jouvieje.libloader.PlatformLibrary;

public final class LibLoader {
    public static final int PLATFORM_WINDOWS = 1;
    public static final int PLATFORM_LINUX = 2;
    public static final int PLATFORM_MAC = 3;
    public static final int PLATFORM_SOLARIS = 4;
    private static final String NOT_RECOGNIZED = "Unrecognized platform";
    private static final String x64 = "64";
    private static final String lib = "lib";
    private static final String dll = ".dll";
    private static final String so = ".so";
    private static final String jnilib = ".jnilib";
    public static boolean DEBUG = false;
    private static boolean librariesLoaded = false;
    private static int platform = -1;
    private static boolean platform64 = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected static boolean isLibLoaderLibsLoaded() {
        String[] libLoaderName;
        if (!librariesLoaded && LibLoader.getPlatform() == 2 && LibLoader.loadWithSystem((libLoaderName = LibLoader.isPlatform64Bits() ? new String[]{"LibLoader64", "libLibLoader64.so"} : new String[]{"LibLoader", "libLibLoader.so"})[0], libLoaderName[1])) {
            librariesLoaded = true;
        }
        return librariesLoaded;
    }

    public static int getPlatform() {
        if (platform == -1) {
            boolean bits64;
            String osName = LibLoader.getProperty("os.name").toLowerCase();
            String osArch = LibLoader.getProperty("os.arch");
            LibLoader.log("os.name: " + osName);
            LibLoader.log("os.arch: " + osArch);
            boolean bl = bits64 = osArch.indexOf(x64) != -1;
            if (osName.startsWith("win")) {
                platform = 1;
            } else if (osName.startsWith("linux") || osName.startsWith("freebsd") || osName.startsWith("sunos")) {
                platform = 2;
            } else if (osName.startsWith("mac")) {
                platform = 3;
            } else if (osName.startsWith("Solaris") || osName.startsWith("SunOS")) {
                platform = 4;
                if (osArch.indexOf("sparcv9") != -1) {
                    bits64 = true;
                }
            } else {
                throw new RuntimeException(NOT_RECOGNIZED);
            }
            platform64 = bits64;
        }
        return platform;
    }

    public static boolean isPlatform64Bits() {
        LibLoader.getPlatform();
        return platform64;
    }

    public static boolean isWindowsCE() {
        String osName = LibLoader.getProperty("os.name").toLowerCase();
        return osName.indexOf("ce") != -1;
    }

    private static String getProperty(final String prop) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(prop);
            }
        });
    }

    private static boolean exists(final File file) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
    }

    public static boolean loadLibrary(String libraryName, boolean libLoaderFirst) {
        return LibLoader.loadLibrary(LibLoader.defaultPlatformSpecificConfig(libraryName), libLoaderFirst);
    }

    private static LibraryConfig defaultPlatformSpecificConfig(String libraryName) {
        String libLibraryName = libraryName.startsWith(lib) ? libraryName : lib + libraryName;
        LibraryConfig libConfig = new LibraryConfig();
        libConfig.windowsLibraries = new PlatformLibrary(libraryName, String.valueOf(libraryName) + dll);
        libConfig.windows64Libraries = new PlatformLibrary(String.valueOf(libraryName) + x64, String.valueOf(libraryName) + x64 + dll);
        libConfig.linuxLibraries = new PlatformLibrary(libraryName, String.valueOf(libLibraryName) + so);
        libConfig.linux64Libraries = new PlatformLibrary(String.valueOf(libraryName) + x64, String.valueOf(libLibraryName) + x64 + so);
        libConfig.macLibraries = new PlatformLibrary(libraryName, String.valueOf(libLibraryName) + jnilib);
        return libConfig;
    }

    public static boolean loadLibrary(LibraryConfig libConfig, boolean libLoaderFirst) {
        switch (LibLoader.getPlatform()) {
            case 1: {
                if (LibLoader.isPlatform64Bits() ? LibLoader.loadLibrary(libConfig.windows64Libraries, libLoaderFirst) : LibLoader.loadLibrary(libConfig.windowsLibraries, libLoaderFirst)) {
                    return true;
                }
                if (!LibLoader.loadLibrary(libConfig.windowsCeLibraries, libLoaderFirst)) break;
                return true;
            }
            case 2: {
                if (!(LibLoader.isPlatform64Bits() ? LibLoader.loadLibrary(libConfig.linux64Libraries, libLoaderFirst) : LibLoader.loadLibrary(libConfig.linuxLibraries, libLoaderFirst))) break;
                return true;
            }
            case 3: {
                if (!LibLoader.loadLibrary(libConfig.macLibraries, libLoaderFirst)) break;
                return true;
            }
        }
        return false;
    }

    private static boolean loadLibrary(PlatformLibrary library, boolean libLoaderFirst) {
        return library != null && LibLoader.loadLibrary(library.libraryName, library.libraryFullName, libLoaderFirst);
    }

    public static boolean loadLibrary(String libraryName, String libraryFullName, boolean libLoaderFirst) {
        LibLoader.checkDebug();
        if (libLoaderFirst) {
            LibLoader.log("loadWithLibLoader");
            if (LibLoader.loadWithLibLoader(libraryName, libraryFullName)) {
                return true;
            }
            LibLoader.log("loadWithSystem");
            if (LibLoader.loadWithSystem(libraryName, libraryFullName)) {
                return true;
            }
        } else {
            LibLoader.log("loadWithSystem");
            if (LibLoader.loadWithSystem(libraryName, libraryFullName)) {
                return true;
            }
            LibLoader.log("loadWithLibLoader");
            if (LibLoader.loadWithLibLoader(libraryName, libraryFullName)) {
                return true;
            }
        }
        return false;
    }

    private static boolean loadWithSystem(final String libraryName, final String fullLibraryName) {
        Vector libraryPaths = new Vector();
        LibLoader.findLibraryPathes(libraryPaths, fullLibraryName);
        LibLoader.extractLibrary(libraryPaths, fullLibraryName);
        LibLoader.findSystemPathes(libraryPaths);
        Iterator i = libraryPaths.iterator();
        while (i.hasNext()) {
            final String path = (String)i.next();
            final File file = new File(path, fullLibraryName);
            if (!LibLoader.exists(file)) {
                LibLoader.log("NOT_FOUND=" + path + " / " + fullLibraryName);
                continue;
            }
            LibLoader.log("TRY=" + file.getAbsolutePath());
            Boolean res = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        System.load(file.getAbsolutePath());
                        LibLoader.log("LOADED=" + fullLibraryName + " | FROM=" + path);
                        return Boolean.TRUE;
                    }
                    catch (Throwable t) {
                        LibLoader.log("ERROR=" + t.getMessage());
                        return Boolean.FALSE;
                    }
                }
            });
            if (res != Boolean.TRUE) continue;
            return true;
        }
        Boolean res = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    LibLoader.log("TRY=" + libraryName);
                    System.loadLibrary(libraryName);
                    LibLoader.log("LOADED=" + libraryName);
                    return Boolean.TRUE;
                }
                catch (Throwable t) {
                    LibLoader.log("ERROR=" + t.getMessage());
                    return Boolean.FALSE;
                }
            }
        });
        if (res == Boolean.TRUE) {
            return true;
        }
        boolean useAppletLauncher = Boolean.valueOf(LibLoader.getProperty("sun.jnlp.applet.launcher"));
        return useAppletLauncher && (res = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    JNLPAppletLauncher.DEBUG = DEBUG;
                    JNLPAppletLauncher.VERBOSE = DEBUG;
                    JNLPAppletLauncher.loadLibrary(libraryName, null);
                    LibLoader.log("LOADED=" + libraryName + " FROM applet launcher");
                    return Boolean.TRUE;
                }
                catch (Throwable t) {
                    LibLoader.log("ERROR=" + t.getMessage());
                    LibLoader.log(t);
                    return Boolean.FALSE;
                }
            }
        })) == Boolean.TRUE;
    }

    private static boolean loadWithLibLoader(final String libraryName, String fullLibraryName) throws UnsatisfiedLinkError {
        if (!LibLoader.isLibLoaderLibsLoaded()) {
            return false;
        }
        Vector libraryPaths = new Vector();
        LibLoader.findLibraryPathes(libraryPaths, fullLibraryName);
        LibLoader.extractLibrary(libraryPaths, fullLibraryName);
        LibLoader.findSystemPathes(libraryPaths);
        Iterator i = libraryPaths.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            File file = new File(path, fullLibraryName);
            if (!LibLoader.exists(file)) {
                LibLoader.log("NOT_FOUND: " + path + " / " + fullLibraryName);
                continue;
            }
            LibLoader.log("TRY: " + file.getAbsolutePath());
            long handle = LibLoaderJNI.dlopen(file.getAbsolutePath().getBytes(), 258);
            if (handle == 0L) {
                LibLoader.log("ERROR: " + LibLoaderJNI.dlerror());
                continue;
            }
            LibLoader.log(String.valueOf(fullLibraryName) + " loaded from " + path + " [handle=0x" + Long.toHexString(handle) + "]");
            LibLoaderJNI.dlerror();
            return true;
        }
        boolean useAppletLauncher = Boolean.valueOf(LibLoader.getProperty("sun.jnlp.applet.launcher"));
        if (useAppletLauncher) {
            JNLPAppletLauncher.DEBUG = DEBUG;
            JNLPAppletLauncher.VERBOSE = DEBUG;
            Boolean res = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        JNLPAppletLauncher.loadLibrary(libraryName, new JNLPAppletLauncher.LibraryLoader(this){
                            final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void loadLibrary(String fullLibraryName) throws UnsatisfiedLinkError {
                                long handle = 0L;
                                try {
                                    LibLoader.access$0("    DlOpen: " + fullLibraryName);
                                    handle = LibLoader.access$2(fullLibraryName);
                                }
                                catch (Throwable t) {
                                    handle = 0L;
                                    LibLoader.access$0("    ERROR: " + LibLoaderJNI.dlerror());
                                    LibLoader.access$1(t);
                                }
                                if (handle == 0L) {
                                    throw new UnsatisfiedLinkError();
                                }
                            }
                        });
                        return Boolean.TRUE;
                    }
                    catch (Throwable t) {
                        LibLoader.log(t);
                        return Boolean.FALSE;
                    }
                }
            });
            return res;
        }
        return false;
    }

    private static long openLibrary(String fullPath) {
        if (!LibLoader.isLibLoaderLibsLoaded()) {
            return 0L;
        }
        long handle = LibLoaderJNI.dlopen(fullPath.getBytes(), 258);
        if (handle == 0L) {
            LibLoader.log("ERROR: " + LibLoaderJNI.dlerror());
        } else {
            LibLoader.log("Library successfully loaded from " + fullPath + " [handle=0x" + Long.toHexString(handle) + "]");
        }
        LibLoaderJNI.dlerror();
        return handle;
    }

    private static void closeLibrary(long handle) {
        if (!LibLoader.isLibLoaderLibsLoaded() || handle == 0L) {
            return;
        }
        int error = LibLoaderJNI.dlclose(handle);
        if (error != 0) {
            LibLoader.log("Fail to close library.");
            String s2 = LibLoaderJNI.dlerror();
            LibLoader.log("ERROR: " + s2);
            throw new UnsatisfiedLinkError(s2);
        }
        LibLoader.log("Library sucessfully closed.");
    }

    private static void findSystemPathes(Vector libraryPathes) {
        LibLoader.addSystemPathes(libraryPathes, LibLoader.getProperty("java.library.path"));
        LibLoader.addSystemPathes(libraryPathes, LibLoader.getProperty("org.lwjgl.librarypath"));
    }

    private static void addSystemPathes(Vector libraryPathes, String pathes) {
        if (pathes != null) {
            StringTokenizer tokens = new StringTokenizer(pathes, File.pathSeparator);
            while (tokens.hasMoreTokens()) {
                libraryPathes.add(tokens.nextToken());
            }
        }
    }

    private static void findLibraryPathes(Vector libraryPathes, String fullName) {
        File file = new File(fullName);
        if (file.isAbsolute()) {
            File folder = !file.isDirectory() ? file.getParentFile() : file;
            libraryPathes.add(folder.getAbsoluteFile());
        }
    }

    private static void extractLibrary(Vector libraryPathes, String fullName) {
        String extractionDir = LibLoader.extractLibraryFromClasspath(fullName);
        if (extractionDir != null) {
            libraryPathes.add(extractionDir);
        }
    }

    private static String extractLibraryFromClasspath(final String fullName) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    String pathInJar = "/" + fullName;
                    LibLoader.log("Opening for reading: " + pathInJar);
                    InputStream is = new LibLoader().getClass().getResourceAsStream(pathInJar);
                    if (is == null) {
                        LibLoader.log("Re-Opening for reading: " + pathInJar);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.jouvieje.libloader.LibLoader");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((is = clazz.getResourceAsStream(pathInJar)) == null) {
                            LibLoader.log("Re-Re-Opening for reading: " + pathInJar);
                            Class<?> clazz2 = class$1;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$1 = Class.forName("java.lang.Class");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            is = clazz2.getResourceAsStream(pathInJar);
                        }
                    }
                    if (is != null) {
                        LibLoader.log("Open succeed.");
                        String destDir = String.valueOf(LibLoader.getProperty("java.io.tmpdir")) + File.separator + "LibLoader" + File.separator;
                        File dir = new File(destDir);
                        LibLoader.log("Creating destination : " + destDir);
                        dir.mkdirs();
                        File fileOut = new File(dir, fullName);
                        try {
                            BufferedInputStream in = new BufferedInputStream(is);
                            LibLoader.log("Opening output");
                            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileOut));
                            LibLoader.log("Writting to output");
                            byte[] readBuffer = new byte[8192];
                            int bytesRead = 0;
                            while ((bytesRead = is.read(readBuffer)) > 0) {
                                out.write(readBuffer, 0, bytesRead);
                            }
                            LibLoader.log("Closing files");
                            in.close();
                            out.close();
                            LibLoader.log("Extraction succeed");
                            return destDir;
                        }
                        catch (Throwable t) {
                            LibLoader.log(t);
                            if (LibLoader.exists(fileOut)) {
                                return destDir;
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LibLoader.log(t);
                }
                return null;
            }
        });
    }

    private static void checkDebug() {
        boolean forceDebug;
        String property;
        if (!DEBUG && (property = LibLoader.getProperty("org.jouvieje.libloader.debug")) != null && (forceDebug = Boolean.valueOf(property).booleanValue())) {
            DEBUG = true;
        }
    }

    private static void log(String s2) {
        if (DEBUG) {
            System.out.println(s2);
        }
    }

    private static void log(Throwable t) {
        if (DEBUG) {
            t.printStackTrace();
        }
    }

    static /* synthetic */ long access$2(String string) {
        return LibLoader.openLibrary(string);
    }
}

